/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lex.lapapp;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.text.BreakIterator;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JTextArea;

public class TextAreaLabel
extends JTextArea {
    private static final String copyright_notice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 2003, 2008.  All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String[] inputLines;
    private String[] textLines;
    private int panelWidth = 100;
    private int panelHeight = 100;

    public TextAreaLabel() {
    }

    public TextAreaLabel(String[] stringArray) {
        this.inputLines = stringArray;
    }

    public TextAreaLabel(String string) {
        this.inputLines = new String[1];
        this.inputLines[0] = string;
    }

    public TextAreaLabel(String string, int n, int n2, int n3) {
        super(string, n, n2);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.panelWidth, this.panelHeight);
    }

    private String[] getTextLines() {
        if (this.inputLines == null) {
            return null;
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        Locale locale = this.getLocale();
        int n = this.panelWidth;
        Vector<String> vector = new Vector<String>();
        int n2 = this.inputLines.length;
        for (int i = 0; i < n2; ++i) {
            String string = this.inputLines[i];
            BreakIterator breakIterator = BreakIterator.getLineInstance(locale);
            breakIterator.setText(string);
            int n3 = breakIterator.first();
            int n4 = breakIterator.next();
            int n5 = 0;
            StringBuffer stringBuffer = new StringBuffer("");
            int n6 = 0;
            while (n4 != -1) {
                String string2 = string.substring(n3, n4);
                n6 = fontMetrics.stringWidth(string2);
                if (n5 + n6 > n) {
                    vector.addElement(stringBuffer.toString());
                    stringBuffer = new StringBuffer(string2);
                    n5 = n6;
                } else {
                    stringBuffer.append(string2);
                    n5 += n6;
                }
                n3 = n4;
                n4 = breakIterator.next();
            }
            vector.addElement(stringBuffer.toString());
        }
        vector.trimToSize();
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void paint(Graphics graphics) {
        if (this.textLines == null) {
            this.reformat();
            this.revalidate();
            this.repaint();
        } else if (this.textLines != null) {
            int n = this.textLines.length;
            int n2 = 0;
            int n3 = 0;
            int n4 = this.getFontMetrics(this.getFont()).getHeight();
            for (int i = 0; i < n; ++i) {
                graphics.setColor(this.getForeground());
                graphics.drawString(this.textLines[i], n2, n3 += n4);
            }
        }
    }

    private void reformat() {
        if (this.textLines == null || this.panelWidth != this.getSize().width || this.panelHeight != this.getSize().height) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            if (fontMetrics != null) {
                this.panelWidth = this.getSize().width;
                this.textLines = this.getTextLines();
                this.panelHeight = this.textLines.length * fontMetrics.getHeight();
            } else {
                this.textLines = null;
            }
            this.revalidate();
            this.repaint();
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.reformat();
    }

    public void setText(String[] stringArray) {
        this.inputLines = stringArray;
        this.textLines = null;
        this.reformat();
    }

    public void setText(String string) {
        String[] stringArray = new String[]{string};
        this.setText(stringArray);
    }
}

