/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.shared;

import com.ibm.oti.shared.SharedClassCacheInfo;
import com.ibm.oti.util.Msg;
import java.util.ArrayList;
import java.util.List;

public class SharedClassUtilities {
    public static final int NO_FLAGS = 0;
    public static final int PERSISTENCE_DEFAULT = 0;
    public static final int PERSISTENT = 1;
    public static final int NONPERSISTENT = 2;
    public static final int DESTROYED_ALL_CACHE = 0;
    public static final int DESTROYED_NONE = -1;
    public static final int DESTROY_FAILED_CURRENT_GEN_CACHE = -2;
    public static final int DESTROY_FAILED_OLDER_GEN_CACHE = -3;
    private static final int SHARED_CLASSES_UTILITIES_DISABLED = -255;

    private static native void init();

    private static native int getSharedCacheInfoImpl(String var0, int var1, boolean var2, List<SharedClassCacheInfo> var3);

    private static native int destroySharedCacheImpl(String var0, int var1, String var2, boolean var3);

    public static List<SharedClassCacheInfo> getSharedCacheInfo(String cacheDir, int flags, boolean useCommandLineValues) {
        if (flags != 0) {
            throw new IllegalArgumentException(Msg.getString("K0553", "\"flags\""));
        }
        ArrayList<SharedClassCacheInfo> arrayList = new ArrayList<SharedClassCacheInfo>();
        int retVal = SharedClassUtilities.getSharedCacheInfoImpl(cacheDir, flags, useCommandLineValues, arrayList);
        if (-1 == retVal) {
            return null;
        }
        if (-255 == retVal) {
            throw new IllegalStateException(Msg.getString("K0557"));
        }
        return arrayList;
    }

    public static int destroySharedCache(String cacheDir, int persistence, String cacheName, boolean useCommandLineValues) {
        int retVal = -1;
        if (!useCommandLineValues && persistence != 0 && persistence != 1 && persistence != 2) {
            throw new IllegalArgumentException(Msg.getString("K0553", "\"persistence\""));
        }
        retVal = SharedClassUtilities.destroySharedCacheImpl(cacheDir, persistence, cacheName, useCommandLineValues);
        if (-255 == retVal) {
            throw new IllegalStateException(Msg.getString("K0557"));
        }
        return retVal;
    }

    static {
        SharedClassUtilities.init();
    }
}

