/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.vm;

import com.ibm.oti.vm.ORBBase;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import sun.misc.Unsafe;
import sun.reflect.CallerSensitive;

public class ORBVMHelpers {
    static Unsafe unsafe = ORBVMHelpers.createUnsafe();

    static Unsafe createUnsafe() {
        return (Unsafe)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return Unsafe.getUnsafe();
                }
                catch (Throwable t) {
                    return null;
                }
            }
        });
    }

    @CallerSensitive
    public static native ClassLoader LatestUserDefinedLoader();

    private static native boolean is32Bit();

    private static native int getNumBitsInReferenceField();

    private static native int getNumBytesInReferenceField();

    private static native int getNumBitsInDescriptionWord();

    private static native int getNumBytesInDescriptionWord();

    private static native int getNumBytesInJ9ObjectHeader();

    private static native int getJ9ClassFromClass32(Class var0);

    private static native int getTotalInstanceSizeFromJ9Class32(int var0);

    private static native int getInstanceDescriptionFromJ9Class32(int var0);

    private static native int getDescriptionWordFromPtr32(int var0);

    private static native long getJ9ClassFromClass64(Class var0);

    private static native long getTotalInstanceSizeFromJ9Class64(long var0);

    private static native long getInstanceDescriptionFromJ9Class64(long var0);

    private static native long getDescriptionWordFromPtr64(long var0);

    public static int getNumSlotsInObject(Class currentClass) {
        int numSlotsInObject;
        int numBytesInReferenceField = ORBVMHelpers.getNumBytesInReferenceField();
        if (ORBVMHelpers.is32Bit()) {
            int j9clazz = ORBVMHelpers.getJ9ClassFromClass32(currentClass);
            int instanceSize = ORBVMHelpers.getTotalInstanceSizeFromJ9Class32(j9clazz);
            numSlotsInObject = instanceSize / 4;
        } else {
            long j9clazz = ORBVMHelpers.getJ9ClassFromClass64(currentClass);
            long instanceSize = ORBVMHelpers.getTotalInstanceSizeFromJ9Class64(j9clazz);
            numSlotsInObject = (int)instanceSize / 4;
            if (instanceSize > 0x1FFFFFFFL) {
                numSlotsInObject = -1;
            }
        }
        return numSlotsInObject;
    }

    public static int getSlotIndex(Field field) {
        int bytesInHeader = ORBVMHelpers.getNumBytesInJ9ObjectHeader();
        int numBytesInReferenceField = ORBVMHelpers.getNumBytesInReferenceField();
        int index = (unsafe.fieldOffset(field) - bytesInHeader) / 4;
        return index;
    }

    public static void vmDeepCopy(Object srcObj, Object dest, Class currentClass, ClassLoader targetCL, int[] destOffsets, Class[] declaredType, ORBBase orbi, Map map, Class itsType) throws Exception {
        int numSlotsInObject;
        int numBitsInWord = ORBVMHelpers.getNumBitsInDescriptionWord();
        int bytesInHeader = ORBVMHelpers.getNumBytesInJ9ObjectHeader();
        int numBytesInReferenceField = ORBVMHelpers.getNumBytesInReferenceField();
        int j9clazz = 0;
        int instanceSize = 0;
        int descriptorPtr = 0;
        long j9clazz64 = 0L;
        long instanceSize64 = 0L;
        long descriptorPtr64 = 0L;
        if (ORBVMHelpers.is32Bit()) {
            j9clazz = ORBVMHelpers.getJ9ClassFromClass32(currentClass);
            instanceSize = ORBVMHelpers.getTotalInstanceSizeFromJ9Class32(j9clazz);
            descriptorPtr = ORBVMHelpers.getInstanceDescriptionFromJ9Class32(j9clazz);
            numSlotsInObject = instanceSize / numBytesInReferenceField;
        } else {
            j9clazz64 = ORBVMHelpers.getJ9ClassFromClass64(currentClass);
            instanceSize64 = ORBVMHelpers.getTotalInstanceSizeFromJ9Class64(j9clazz64);
            descriptorPtr64 = ORBVMHelpers.getInstanceDescriptionFromJ9Class64(j9clazz64);
            numSlotsInObject = (int)instanceSize64 / numBytesInReferenceField;
        }
        int countSlots = 0;
        int descriptorWord = 0;
        long descriptorWord64 = 0L;
        int bitIndex = 0;
        if (ORBVMHelpers.isDescriptorPointerTagged(descriptorPtr, descriptorPtr64)) {
            ++bitIndex;
            if (ORBVMHelpers.is32Bit()) {
                descriptorWord = descriptorPtr >> 1;
            } else {
                descriptorWord64 = descriptorPtr64 >> 1;
            }
        } else if (ORBVMHelpers.is32Bit()) {
            descriptorWord = ORBVMHelpers.getDescriptionWordFromPtr32(descriptorPtr);
        } else {
            descriptorWord64 = ORBVMHelpers.getDescriptionWordFromPtr64(descriptorPtr64);
        }
        int srcIndex = 0;
        while (numSlotsInObject > 0) {
            int destIndex = destOffsets[srcIndex];
            int nextDestIndex = -1;
            if (ORBVMHelpers.getNumBytesInReferenceField() == 8 && srcIndex + 1 < destOffsets.length) {
                nextDestIndex = destOffsets[srcIndex + 1];
            }
            Class type = declaredType[srcIndex];
            if (destIndex >= 0 || nextDestIndex >= 0) {
                if (ORBVMHelpers.isDescriptorPointerTagged(descriptorWord, descriptorWord64)) {
                    Object fieldValue = unsafe.getObject(srcObj, bytesInHeader + countSlots * numBytesInReferenceField);
                    if (fieldValue != null) {
                        Object result = orbi.quickCopyIfPossible(fieldValue, type, targetCL, map, itsType);
                        if (result != null) {
                            if (destIndex >= 0) {
                                unsafe.putObject(dest, bytesInHeader + destIndex * 4, result);
                            }
                            if (++countSlots >= numSlotsInObject) break;
                            if (bitIndex == numBitsInWord - 1) {
                                if (ORBVMHelpers.is32Bit()) {
                                    descriptorPtr += ORBVMHelpers.getNumBytesInDescriptionWord();
                                } else {
                                    descriptorPtr64 += (long)ORBVMHelpers.getNumBytesInDescriptionWord();
                                }
                                bitIndex = 0;
                                if (ORBVMHelpers.is32Bit()) {
                                    descriptorWord = ORBVMHelpers.getDescriptionWordFromPtr32(descriptorPtr);
                                } else {
                                    descriptorWord64 = ORBVMHelpers.getDescriptionWordFromPtr64(descriptorPtr64);
                                }
                            } else {
                                if (ORBVMHelpers.is32Bit()) {
                                    descriptorWord >>= 1;
                                } else {
                                    descriptorWord64 >>= 1;
                                }
                                ++bitIndex;
                            }
                            if (ORBVMHelpers.getNumBytesInReferenceField() == 8) {
                                srcIndex += 2;
                                continue;
                            }
                            ++srcIndex;
                            continue;
                        }
                        fieldValue = orbi.deepCopyIfRequired(fieldValue, type, targetCL, map, type);
                        if (destIndex >= 0) {
                            unsafe.putObject(dest, bytesInHeader + destIndex * 4, fieldValue);
                        }
                    }
                } else if (ORBVMHelpers.getNumBytesInReferenceField() != 8) {
                    unsafe.putInt(dest, bytesInHeader + destIndex * numBytesInReferenceField, unsafe.getInt(srcObj, bytesInHeader + countSlots * numBytesInReferenceField));
                } else {
                    if (destIndex >= 0) {
                        unsafe.putInt(dest, bytesInHeader + destIndex * 4, unsafe.getInt(srcObj, bytesInHeader + countSlots * numBytesInReferenceField));
                    }
                    if (nextDestIndex >= 0) {
                        unsafe.putInt(dest, bytesInHeader + nextDestIndex * 4, unsafe.getInt(srcObj, bytesInHeader + countSlots * numBytesInReferenceField + 4));
                    }
                }
            }
            if (++countSlots >= numSlotsInObject) break;
            if (bitIndex == numBitsInWord - 1) {
                if (ORBVMHelpers.is32Bit()) {
                    descriptorPtr += ORBVMHelpers.getNumBytesInDescriptionWord();
                } else {
                    descriptorPtr64 += (long)ORBVMHelpers.getNumBytesInDescriptionWord();
                }
                bitIndex = 0;
                if (ORBVMHelpers.is32Bit()) {
                    descriptorWord = ORBVMHelpers.getDescriptionWordFromPtr32(descriptorPtr);
                } else {
                    descriptorWord64 = ORBVMHelpers.getDescriptionWordFromPtr64(descriptorPtr64);
                }
            } else {
                if (ORBVMHelpers.is32Bit()) {
                    descriptorWord >>= 1;
                } else {
                    descriptorWord64 >>= 1;
                }
                ++bitIndex;
            }
            if (ORBVMHelpers.getNumBytesInReferenceField() == 8) {
                srcIndex += 2;
                continue;
            }
            ++srcIndex;
        }
    }

    private static boolean isDescriptorPointerTagged(int descriptorPtr, long descriptorPtr64) {
        return ORBVMHelpers.is32Bit() ? (descriptorPtr & 1) == 1 : (descriptorPtr64 & 1L) == 1L;
    }
}

