/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.ObjectStreamField;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Comparator;
import java.util.Formatter;
import java.util.Locale;
import java.util.regex.Pattern;
import sun.misc.Hashing;

public final class String
implements Serializable,
Comparable<String>,
CharSequence {
    private static final long serialVersionUID = -6849794470754667710L;
    public static final Comparator<String> CASE_INSENSITIVE_ORDER = new CaseInsensitiveComparator();
    private static final char[] ascii;
    private static String[] stringArray;
    private static final int stringArraySize = 10;
    static boolean enableCopy;
    private final char[] value;
    private final int offset;
    private final int count;
    private int hashCode;
    private int hashCode32;
    private static int seed;
    private static char[] startCombiningAbove;
    private static char[] endCombiningAbove;
    private static final char[] upperValues;
    private static final ObjectStreamField[] serialPersistentFields;

    private static native int getSeed();

    public String() {
        this.value = new char[0];
        this.offset = 0;
        this.count = 0;
    }

    private String(String s, char c) {
        if (s == null) {
            s = "null";
        }
        this.offset = 0;
        this.value = new char[s.count + 1];
        this.count = s.count + 1;
        System.arraycopy((Object)s.value, s.offset, (Object)this.value, 0, s.count);
        this.value[s.count] = c;
    }

    public String(byte[] data) {
        this(data, 0, data.length);
    }

    @Deprecated
    public String(byte[] data, int high) {
        this(data, high, 0, data.length);
    }

    public String(byte[] data, int start, int length) {
        if (start < 0 || 0 > length || length > data.length - start) {
            throw new StringIndexOutOfBoundsException();
        }
        this.offset = 0;
        this.value = StringCoding.decode((byte[])data, (int)start, (int)length);
        this.count = this.value.length;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public String(byte[] data, int high, int start, int length) {
        if (data == null) throw new NullPointerException();
        if (start < 0 || 0 > length || length > data.length - start) throw new StringIndexOutOfBoundsException();
        this.offset = 0;
        this.value = new char[length];
        this.count = length;
        high <<= 8;
        for (int i = 0; i < this.count; ++i) {
            this.value[i] = (char)(high + (data[start++] & 0xFF));
        }
    }

    public String(byte[] data, int start, int length, String encoding) throws UnsupportedEncodingException {
        if (encoding == null) {
            throw new NullPointerException();
        }
        if (start < 0 || 0 > length || length > data.length - start) {
            throw new StringIndexOutOfBoundsException();
        }
        this.offset = 0;
        this.value = StringCoding.decode((String)encoding, (byte[])data, (int)start, (int)length);
        this.count = this.value.length;
    }

    public String(byte[] data, String encoding) throws UnsupportedEncodingException {
        this(data, 0, data.length, encoding);
    }

    public String(char[] data) {
        this(data, 0, data.length);
    }

    public String(char[] data, int start, int length) {
        if (start >= 0 && 0 <= length && length <= data.length - start) {
            this.offset = 0;
            this.value = new char[length];
            this.count = length;
            try {
                System.arraycopy((Object)data, start, (Object)this.value, 0, this.count);
            }
            catch (IndexOutOfBoundsException e) {
                throw new StringIndexOutOfBoundsException();
            }
        } else {
            throw new StringIndexOutOfBoundsException();
        }
    }

    String(int start, int length, char[] data) {
        this.value = data;
        this.offset = start;
        this.count = length;
    }

    public String(String string) {
        if (enableCopy && string.count != string.value.length) {
            if (string.count == 0) {
                this.offset = 0;
                this.value = ascii;
                this.count = 0;
            } else if (string.count == 1 && string.value[string.offset] < '\u0080') {
                this.offset = string.value[string.offset];
                this.value = ascii;
                this.count = 1;
            } else {
                this.offset = 0;
                this.value = new char[string.count];
                System.arraycopy((Object)string.value, string.offset, (Object)this.value, 0, string.count);
                this.count = string.count;
            }
        } else {
            this.offset = string.offset;
            this.value = string.value;
            this.count = string.count;
            this.hashCode = string.hashCode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String(StringBuffer stringbuffer) {
        this.offset = 0;
        StringBuffer stringBuffer = stringbuffer;
        synchronized (stringBuffer) {
            this.value = stringbuffer.shareValue();
            this.count = stringbuffer.length();
        }
    }

    private String(String s1, String s2) {
        if (s1 == null) {
            s1 = "null";
        }
        if (s2 == null) {
            s2 = "null";
        }
        int len = s1.count + s2.count;
        this.value = new char[len];
        this.offset = 0;
        System.arraycopy((Object)s1.value, s1.offset, (Object)this.value, 0, s1.count);
        System.arraycopy((Object)s2.value, s2.offset, (Object)this.value, s1.count, s2.count);
        this.count = len;
    }

    private String(String s1, String s2, String s3) {
        if (s1 == null) {
            s1 = "null";
        }
        if (s2 == null) {
            s2 = "null";
        }
        if (s3 == null) {
            s3 = "null";
        }
        int len = s1.count + s2.count + s3.count;
        this.value = new char[len];
        this.offset = 0;
        System.arraycopy((Object)s1.value, s1.offset, (Object)this.value, 0, s1.count);
        System.arraycopy((Object)s2.value, s2.offset, (Object)this.value, s1.count, s2.count);
        System.arraycopy((Object)s3.value, s3.offset, (Object)this.value, s1.count + s2.count, s3.count);
        this.count = len;
    }

    private String(String s1, int v1) {
        int res;
        int quot;
        if (s1 == null) {
            s1 = "null";
        }
        int len2 = 1;
        int i = v1;
        while ((i /= 10) != 0) {
            ++len2;
        }
        if (v1 >= 0) {
            quot = -v1;
        } else {
            ++len2;
            quot = v1;
        }
        int len = s1.count + len2;
        this.value = new char[len];
        int index = len - 1;
        do {
            res = quot / 10;
            int rem = quot - res * 10;
            this.value[index] = (char)(48 - rem);
            --index;
        } while ((quot = res) != 0);
        if (v1 < 0) {
            this.value[index] = 45;
        }
        this.offset = 0;
        System.arraycopy((Object)s1.value, s1.offset, (Object)this.value, 0, s1.count);
        this.count = len;
    }

    private String(int v1, String s1, int v2, String s2, String s3) {
        int rem;
        int res;
        int quot2;
        int quot;
        if (s1 == null) {
            s1 = "null";
        }
        if (s2 == null) {
            s2 = "null";
        }
        if (s3 == null) {
            s3 = "null";
        }
        int len2 = 1;
        int i = v1;
        while ((i /= 10) != 0) {
            ++len2;
        }
        if (v1 >= 0) {
            quot = -v1;
        } else {
            ++len2;
            quot = v1;
        }
        int len3 = 1;
        int i2 = v2;
        while ((i2 /= 10) != 0) {
            ++len3;
        }
        if (v2 >= 0) {
            quot2 = -v2;
        } else {
            ++len3;
            quot2 = v2;
        }
        int len = s1.count + len2 + len3 + s2.count + s3.count;
        this.value = new char[len];
        int start = len - s3.count;
        System.arraycopy((Object)s3.value, s3.offset, (Object)this.value, start, s3.count);
        System.arraycopy((Object)s2.value, s2.offset, (Object)this.value, start -= s2.count, s2.count);
        int index = start - 1;
        do {
            res = quot2 / 10;
            rem = quot2 - res * 10;
            this.value[index] = (char)(48 - rem);
            --index;
        } while ((quot2 = res) != 0);
        if (v2 < 0) {
            this.value[index--] = 45;
        }
        start = index + 1 - s1.count;
        System.arraycopy((Object)s1.value, s1.offset, (Object)this.value, start, s1.count);
        index = start - 1;
        do {
            res = quot / 10;
            rem = quot - res * 10;
            this.value[index] = (char)(48 - rem);
            --index;
        } while ((quot = res) != 0);
        if (v1 < 0) {
            this.value[index] = 45;
        }
        this.offset = 0;
        this.count = len;
    }

    private static String cachedConstantString(String s1, String s2, int index) {
        if (index < 10) {
            if (stringArray[index] == null) {
                String.stringArray[index] = new String(s1, s2);
            }
        } else {
            return new String(s1, s2);
        }
        return stringArray[index];
    }

    @Override
    public char charAt(int index) {
        if (0 <= index && index < this.count) {
            return this.value[this.offset + index];
        }
        throw new StringIndexOutOfBoundsException();
    }

    @Override
    public int compareTo(String string) {
        int o1 = this.offset;
        int o2 = string.offset;
        int end = this.offset + (this.count < string.count ? this.count : string.count);
        char[] target = string.value;
        while (o1 < end) {
            int result;
            if ((result = this.value[o1++] - target[o2++]) == 0) continue;
            return result;
        }
        return this.count - string.count;
    }

    private char compareValue(char ch) {
        if (ch < '\u0080' && 'A' <= ch && ch <= 'Z') {
            return (char)(ch + 32);
        }
        return Character.toLowerCase(Character.toUpperCase(ch));
    }

    public int compareToIgnoreCase(String string) {
        int o1 = this.offset;
        int o2 = string.offset;
        int end = this.offset + (this.count < string.count ? this.count : string.count);
        char[] target = string.value;
        while (o1 < end) {
            int result;
            char c2;
            char c1;
            if ((c1 = this.value[o1++]) == (c2 = target[o2++]) || (result = (c1 = this.compareValue(c1)) - (c2 = this.compareValue(c2))) == 0) continue;
            return result;
        }
        return this.count - string.count;
    }

    public String concat(String string) {
        if (string.count > 0) {
            char[] buffer = new char[this.count + string.count];
            if (this.count > 0) {
                System.arraycopy((Object)this.value, this.offset, (Object)buffer, 0, this.count);
            }
            System.arraycopy((Object)string.value, string.offset, (Object)buffer, this.count, string.count);
            return new String(0, buffer.length, buffer);
        }
        return this;
    }

    public static String copyValueOf(char[] data) {
        return new String(data, 0, data.length);
    }

    public static String copyValueOf(char[] data, int start, int length) {
        return new String(data, start, length);
    }

    public boolean endsWith(String suffix) {
        return this.regionMatches(this.count - suffix.count, suffix, 0, suffix.count);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof String) {
            String s = (String)object;
            if (this.count != s.count || this.hashCode != 0 && s.hashCode != 0 && this.hashCode != s.hashCode) {
                return false;
            }
            return this.regionMatches(0, s, 0, this.count);
        }
        return false;
    }

    public boolean equalsIgnoreCase(String string) {
        if (string == this) {
            return true;
        }
        if (string == null || this.count != string.count) {
            return false;
        }
        int o1 = this.offset;
        int o2 = string.offset;
        int end = this.offset + this.count;
        char[] target = string.value;
        while (o1 < end) {
            char c2;
            char c1;
            if ((c1 = this.value[o1++]) == (c2 = target[o2++]) || this.toUpperCase(c1) == this.toUpperCase(c2) || this.toLowerCase(c1) == this.toLowerCase(c2)) continue;
            return false;
        }
        return true;
    }

    public byte[] getBytes() {
        return StringCoding.encode((char[])this.value, (int)this.offset, (int)this.count);
    }

    @Deprecated
    public void getBytes(int start, int end, byte[] data, int index) {
        if (0 <= start && start <= end && end <= this.count) {
            end += this.offset;
            try {
                for (int i = this.offset + start; i < end; ++i) {
                    data[index++] = (byte)this.value[i];
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new StringIndexOutOfBoundsException();
            }
        } else {
            throw new StringIndexOutOfBoundsException();
        }
    }

    public byte[] getBytes(String encoding) throws UnsupportedEncodingException {
        if (encoding == null) {
            throw new NullPointerException();
        }
        return StringCoding.encode((String)encoding, (char[])this.value, (int)this.offset, (int)this.count);
    }

    public void getChars(int start, int end, char[] buffer, int index) {
        if (0 > start || start > end || end > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        System.arraycopy((Object)this.value, start + this.offset, (Object)buffer, index, end - start);
    }

    void getChars(char[] buffer, int index) {
        System.arraycopy((Object)this.value, this.offset, (Object)buffer, index, this.count);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int hash = 0;
            int end = this.offset + this.count;
            for (int i = this.offset; i < end; ++i) {
                hash = (hash << 5) - hash + this.value[i];
            }
            this.hashCode = hash;
        }
        return this.hashCode;
    }

    int hash32() {
        if (this.hashCode32 == 0) {
            this.hashCode32 = Hashing.murmur3_32((int)seed, (char[])this.value, (int)this.offset, (int)this.count);
        }
        return this.hashCode32;
    }

    public int indexOf(int c) {
        return this.indexOf(c, 0);
    }

    public int indexOf(int c, int start) {
        block4: {
            block5: {
                if (start >= this.count) break block4;
                if (start < 0) {
                    start = 0;
                }
                if (c < 0 || c > 65535) break block5;
                for (int i = this.offset + start; i < this.offset + this.count; ++i) {
                    if (this.value[i] != c) continue;
                    return i - this.offset;
                }
                break block4;
            }
            if (c > 0x10FFFF) break block4;
            for (int i = start; i < this.count; ++i) {
                int codePoint = this.codePointAt(i);
                if (codePoint == c) {
                    return i;
                }
                if (codePoint < 65536) continue;
                ++i;
            }
        }
        return -1;
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String subString, int start) {
        int subCount;
        if (start < 0) {
            start = 0;
        }
        if ((subCount = subString.count) > 0) {
            if (subCount + start > this.count) {
                return -1;
            }
            char[] target = subString.value;
            int subOffset = subString.offset;
            char firstChar = target[subOffset];
            int end = subOffset + subCount;
            while (true) {
                int i;
                if ((i = this.indexOf(firstChar, start)) == -1 || subCount + i > this.count) {
                    return -1;
                }
                int o1 = this.offset + i;
                int o2 = subOffset;
                while (++o2 < end && this.value[++o1] == target[o2]) {
                }
                if (o2 == end) {
                    return i;
                }
                start = i + 1;
            }
        }
        return start < this.count ? start : this.count;
    }

    public native String intern();

    public int lastIndexOf(int c) {
        return this.lastIndexOf(c, this.count - 1);
    }

    public int lastIndexOf(int c, int start) {
        block4: {
            block5: {
                if (start < 0) break block4;
                if (start >= this.count) {
                    start = this.count - 1;
                }
                if (c < 0 || c > 65535) break block5;
                for (int i = this.offset + start; i >= this.offset; --i) {
                    if (this.value[i] != c) continue;
                    return i - this.offset;
                }
                break block4;
            }
            if (c > 0x10FFFF) break block4;
            for (int i = start; i >= 0; --i) {
                int codePoint = this.codePointAt(i);
                if (codePoint == c) {
                    return i;
                }
                if (codePoint < 65536) continue;
                --i;
            }
        }
        return -1;
    }

    public int lastIndexOf(String string) {
        return this.lastIndexOf(string, this.count);
    }

    public int lastIndexOf(String subString, int start) {
        int subCount = subString.count;
        if (subCount <= this.count && start >= 0) {
            if (subCount > 0) {
                if (start > this.count - subCount) {
                    start = this.count - subCount;
                }
                char[] target = subString.value;
                int subOffset = subString.offset;
                char firstChar = target[subOffset];
                int end = subOffset + subCount;
                while (true) {
                    int i;
                    if ((i = this.lastIndexOf(firstChar, start)) == -1) {
                        return -1;
                    }
                    int o1 = this.offset + i;
                    int o2 = subOffset;
                    while (++o2 < end && this.value[++o1] == target[o2]) {
                    }
                    if (o2 == end) {
                        return i;
                    }
                    start = i - 1;
                }
            }
            return start < this.count ? start : this.count;
        }
        return -1;
    }

    @Override
    public int length() {
        return this.count;
    }

    public boolean regionMatches(int thisStart, String string, int start, int length) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (start < 0 || string.count - start < length) {
            return false;
        }
        if (thisStart < 0 || this.count - thisStart < length) {
            return false;
        }
        if (length <= 0) {
            return true;
        }
        int o1 = this.offset + thisStart;
        int o2 = string.offset + start;
        for (int i = 0; i < length; ++i) {
            if (this.value[o1 + i] == string.value[o2 + i]) continue;
            return false;
        }
        return true;
    }

    public boolean regionMatches(boolean ignoreCase, int thisStart, String string, int start, int length) {
        if (!ignoreCase) {
            return this.regionMatches(thisStart, string, start, length);
        }
        if (string != null) {
            if (thisStart < 0 || length > this.count - thisStart) {
                return false;
            }
            if (start < 0 || length > string.count - start) {
                return false;
            }
            start += string.offset;
            int end = (thisStart += this.offset) + length;
            char[] target = string.value;
            while (thisStart < end) {
                char c2;
                char c1;
                if ((c1 = this.value[thisStart++]) == (c2 = target[start++]) || this.toUpperCase(c1) == this.toUpperCase(c2) || this.toLowerCase(c1) == this.toLowerCase(c2)) continue;
                return false;
            }
            return true;
        }
        throw new NullPointerException();
    }

    public String replace(char oldChar, char newChar) {
        int index = this.indexOf(oldChar, 0);
        if (index == -1) {
            return this;
        }
        char[] buffer = new char[this.count];
        System.arraycopy((Object)this.value, this.offset, (Object)buffer, 0, this.count);
        do {
            buffer[index++] = newChar;
        } while ((index = this.indexOf(oldChar, index)) != -1);
        return new String(0, this.count, buffer);
    }

    public boolean startsWith(String prefix) {
        return this.startsWith(prefix, 0);
    }

    public boolean startsWith(String prefix, int start) {
        return this.regionMatches(start, prefix, 0, prefix.count);
    }

    public String substring(int start) {
        if (start == 0) {
            return this;
        }
        if (0 <= start && start <= this.count) {
            return new String(this.offset + start, this.count - start, this.value);
        }
        throw new StringIndexOutOfBoundsException(start);
    }

    public String substring(int start, int end) {
        if (start == 0 && end == this.count) {
            return this;
        }
        if (0 <= start && start <= end && end <= this.count) {
            return new String(this.offset + start, end - start, this.value);
        }
        throw new StringIndexOutOfBoundsException();
    }

    public char[] toCharArray() {
        char[] buffer = new char[this.count];
        System.arraycopy((Object)this.value, this.offset, (Object)buffer, 0, this.count);
        return buffer;
    }

    public String toLowerCase() {
        return this.toLowerCase(Locale.getDefault());
    }

    private int toLowerCase(int codePoint) {
        if (codePoint < 128) {
            if (65 <= codePoint && codePoint <= 90) {
                return codePoint + 32;
            }
            return codePoint;
        }
        return Character.toLowerCase(codePoint);
    }

    private int toUpperCase(int codePoint) {
        if (codePoint < 128) {
            if (97 <= codePoint && codePoint <= 122) {
                return codePoint - 32;
            }
            return codePoint;
        }
        return Character.toUpperCase(codePoint);
    }

    public String toLowerCase(Locale locale) {
        String language = locale.getLanguage();
        for (int o = 0; o < this.count; ++o) {
            int codePoint = this.value[this.offset + o];
            if (codePoint >= 55296 && codePoint <= 56319) {
                codePoint = this.codePointAt(o);
            }
            if (codePoint != this.toLowerCase(codePoint)) {
                StringBuilder builder = new StringBuilder(this.count);
                builder.append(this.value, this.offset, o);
                if (!("tr".equals(language) || "az".equals(language) || "lt".equals(language))) {
                    while (o < this.count) {
                        codePoint = this.value[this.offset + o];
                        if (codePoint >= 55296 && codePoint <= 56319) {
                            codePoint = this.codePointAt(o);
                        }
                        if (codePoint == 931) {
                            builder.append(this.convertSigma(o));
                        } else {
                            builder.appendCodePoint(this.toLowerCase(codePoint));
                        }
                        if (codePoint >= 65536) {
                            ++o;
                        }
                        ++o;
                    }
                } else if ("lt".equals(language)) {
                    while (o < this.count) {
                        codePoint = this.codePointAt(o);
                        if (codePoint == 931) {
                            builder.append(this.convertSigma(o));
                        } else if (codePoint == 73 || codePoint == 74 || codePoint == 302) {
                            int nextPoint;
                            builder.append(codePoint == 302 ? (char)'\u012f' : (char)(codePoint + 32));
                            if (o + 1 < this.count && String.isCombiningAbove(nextPoint = this.codePointAt(o + 1))) {
                                builder.append('\u0307');
                            }
                        } else if (codePoint == 204) {
                            builder.append('i');
                            builder.append('\u0307');
                            builder.append('\u0300');
                        } else if (codePoint == 205) {
                            builder.append('i');
                            builder.append('\u0307');
                            builder.append('\u0301');
                        } else if (codePoint == 296) {
                            builder.append('i');
                            builder.append('\u0307');
                            builder.append('\u0303');
                        } else {
                            builder.appendCodePoint(this.toLowerCase(codePoint));
                        }
                        if (codePoint >= 65536) {
                            ++o;
                        }
                        ++o;
                    }
                } else {
                    while (o < this.count) {
                        codePoint = this.codePointAt(o);
                        if (codePoint == 931) {
                            builder.append(this.convertSigma(o));
                        } else if (codePoint == 73) {
                            boolean dotAbove = o + 1 < this.count && this.charAt(o + 1) == '\u0307';
                            builder.append(dotAbove ? (char)'i' : '\u0131');
                            if (dotAbove) {
                                ++o;
                            }
                        } else {
                            builder.appendCodePoint(this.toLowerCase(codePoint));
                        }
                        if (codePoint >= 65536) {
                            ++o;
                        }
                        ++o;
                    }
                }
                return builder.toString();
            }
            if (codePoint < 65536) continue;
            ++o;
        }
        return this;
    }

    private static int binarySearchRange(char[] data, char c) {
        char value = '\u0000';
        int low = 0;
        int mid = -1;
        int high = data.length - 1;
        while (low <= high) {
            mid = low + high >> 1;
            value = data[mid];
            if (c > value) {
                low = mid + 1;
                continue;
            }
            if (c == value) {
                return mid;
            }
            high = mid - 1;
        }
        return mid - (c < value ? 1 : 0);
    }

    private static boolean isCombiningAbove(int codePoint) {
        if (codePoint < 65535) {
            int index = String.binarySearchRange(startCombiningAbove, (char)codePoint);
            return index >= 0 && endCombiningAbove[index] >= codePoint;
        }
        return codePoint >= 119173 && codePoint <= 119177 || codePoint >= 119210 && codePoint <= 119213;
    }

    private boolean isWordPart(int codePoint) {
        return codePoint == 837 || this.isWordStart(codePoint);
    }

    private boolean isWordStart(int codePoint) {
        int type = Character.getType(codePoint);
        return type >= 1 && type <= 3 || codePoint >= 688 && codePoint <= 696 || codePoint >= 704 && codePoint <= 705 || codePoint >= 736 && codePoint <= 740 || codePoint == 890 || codePoint >= 8544 && codePoint <= 8575 || codePoint >= 7468 && codePoint <= 7521;
    }

    private char convertSigma(int pos) {
        if (pos == 0 || !this.isWordStart(this.codePointBefore(pos)) || pos + 1 < this.count && this.isWordPart(this.codePointAt(pos + 1))) {
            return '\u03c3';
        }
        return '\u03c2';
    }

    @Override
    public String toString() {
        return this;
    }

    public String toUpperCase() {
        return this.toUpperCase(Locale.getDefault());
    }

    private int upperIndex(int ch) {
        int index = -1;
        if (ch <= 1415) {
            if (ch == 223) {
                index = 0;
            } else if (ch <= 329) {
                if (ch == 329) {
                    index = 1;
                }
            } else if (ch <= 496) {
                if (ch == 496) {
                    index = 2;
                }
            } else if (ch <= 912) {
                if (ch == 912) {
                    index = 3;
                }
            } else if (ch <= 944) {
                if (ch == 944) {
                    index = 4;
                }
            } else if (ch <= 1415 && ch == 1415) {
                index = 5;
            }
        } else if (ch >= 7830) {
            if (ch <= 7834) {
                index = 6 + ch - 7830;
            } else if (ch >= 8016 && ch <= 8188) {
                index = "\u000b\u0000\f\u0000\r\u0000\u000e\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f !\"#$%&'()*+,-./0123456789:;<=>\u0000\u0000?@A\u0000BC\u0000\u0000\u0000\u0000D\u0000\u0000\u0000\u0000\u0000EFG\u0000HI\u0000\u0000\u0000\u0000J\u0000\u0000\u0000\u0000\u0000KL\u0000\u0000MN\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000OPQ\u0000RS\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000TUV\u0000WX\u0000\u0000\u0000\u0000Y".value[ch - 8016];
                if (index == 0) {
                    index = -1;
                }
            } else if (ch >= 64256) {
                if (ch <= 64262) {
                    index = 90 + ch - 64256;
                } else if (ch >= 64275 && ch <= 64279) {
                    index = 97 + ch - 64275;
                }
            }
        }
        return index;
    }

    public String toUpperCase(Locale locale) {
        String language = locale.getLanguage();
        boolean turkishAzeri = "tr".equals(language) || "az".equals(language);
        boolean lithuanian = "lt".equals(language);
        StringBuilder builder = null;
        for (int o = 0; o < this.count; ++o) {
            int codePoint = this.value[this.offset + o];
            if (codePoint >= 55296 && codePoint <= 56319) {
                codePoint = this.codePointAt(o);
            }
            int index = -1;
            if (codePoint >= 223 && codePoint <= 64279) {
                index = this.upperIndex(codePoint);
            }
            if (index == -1) {
                int upper;
                int n = upper = !turkishAzeri || codePoint != 105 ? this.toUpperCase(codePoint) : 304;
                if (codePoint != upper) {
                    if (builder == null) {
                        builder = new StringBuilder(this.count);
                        builder.append(this.value, this.offset, o);
                    }
                    builder.appendCodePoint(upper);
                } else if (builder != null) {
                    builder.appendCodePoint(codePoint);
                }
                if (lithuanian && codePoint <= 7883 && o + 1 < this.count && this.charAt(o + 1) == '\u0307' && "ij\u012f\u0268\u0456\u0458\u1e2d\u1ecb".indexOf(codePoint, 0) != -1) {
                    ++o;
                }
            } else {
                if (builder == null) {
                    builder = new StringBuilder(this.count + this.count / 6 + 2);
                    builder.append(this.value, this.offset, o);
                }
                int target = index * 3;
                char val = upperValues[target];
                builder.append(val);
                val = upperValues[target + 1];
                builder.append(val);
                val = upperValues[target + 2];
                if (val != '\u0000') {
                    builder.append(val);
                }
            }
            if (codePoint < 65536) continue;
            ++o;
        }
        if (builder == null) {
            return this;
        }
        builder.trimToSize();
        return builder.toString();
    }

    public String trim() {
        int start;
        int last;
        int end = last = this.offset + this.count - 1;
        for (start = this.offset; start <= end && this.value[start] <= ' '; ++start) {
        }
        while (end >= start && this.value[end] <= ' ') {
            --end;
        }
        if (start == this.offset && end == last) {
            return this;
        }
        return new String(start, end - start + 1, this.value);
    }

    public static String valueOf(char[] data) {
        return new String(data, 0, data.length);
    }

    public static String valueOf(char[] data, int start, int length) {
        return new String(data, start, length);
    }

    public static String valueOf(char value) {
        String s = value < '\u0080' ? new String(value, 1, ascii) : new String(0, 1, new char[]{value});
        s.hashCode = value;
        return s;
    }

    public static String valueOf(double value) {
        return Double.toString(value);
    }

    public static String valueOf(float value) {
        return Float.toString(value);
    }

    public static String valueOf(int value) {
        return Integer.toString(value);
    }

    public static String valueOf(long value) {
        return Long.toString(value);
    }

    public static String valueOf(Object value) {
        return value != null ? value.toString() : "null";
    }

    public static String valueOf(boolean value) {
        return value ? "true" : "false";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contentEquals(StringBuffer strbuf) {
        StringBuffer stringBuffer = strbuf;
        synchronized (stringBuffer) {
            int size = strbuf.length();
            if (this.count != size) {
                return false;
            }
            return this.regionMatches(0, new String(0, size, strbuf.getValue()), 0, size);
        }
    }

    public boolean matches(String expr) {
        return Pattern.matches(expr, this);
    }

    public String replaceAll(String expr, String substitute) {
        return Pattern.compile(expr).matcher(this).replaceAll(substitute);
    }

    public String replaceFirst(String expr, String substitute) {
        return Pattern.compile(expr).matcher(this).replaceFirst(substitute);
    }

    public String[] split(String regex) {
        return Pattern.compile(regex).split(this);
    }

    public String[] split(String regex, int max) {
        return Pattern.compile(regex).split(this, max);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.substring(start, end);
    }

    private static int indexOf(String haystackString, String needleString, int cache, int md2, char lastChar) {
        char[] haystack = haystackString.value;
        int haystackOffset = haystackString.offset;
        int haystackLength = haystackString.count;
        char[] needle = needleString.value;
        int needleOffset = needleString.offset;
        int needleLength = needleString.count;
        int needleLengthMinus1 = needleLength - 1;
        int haystackEnd = haystackOffset + haystackLength;
        int i = haystackOffset + needleLengthMinus1;
        block0: while (i < haystackEnd) {
            if (lastChar == haystack[i]) {
                for (int j = 0; j < needleLengthMinus1; ++j) {
                    if (needle[j + needleOffset] == haystack[i + j - needleLengthMinus1]) continue;
                    int skip = 1;
                    int result = 0;
                    result = (cache & '\u0001' << haystack[i]) == 0 ? 0 : 1;
                    i += Math.max(md2, skip += --result & j);
                    continue block0;
                }
                return i - needleLengthMinus1 - haystackOffset;
            }
            int result = 0;
            result = (cache & '\u0001' << haystack[i]) == 0 ? 0 : 1;
            i += --result & needleLengthMinus1;
            ++i;
        }
        return -1;
    }

    public String(int[] data, int start, int length) {
        if (start >= 0 && 0 <= length && length <= data.length - start) {
            int size = 0;
            for (int i = start; i < start + length; ++i) {
                int codePoint = data[i];
                if (codePoint < 0) {
                    throw new IllegalArgumentException();
                }
                if (codePoint < 65536) {
                    ++size;
                    continue;
                }
                if (codePoint <= 0x10FFFF) {
                    size += 2;
                    continue;
                }
                throw new IllegalArgumentException();
            }
            this.offset = 0;
            this.value = new char[size];
            this.count = size;
            int j = 0;
            for (int i = start; i < start + length; ++i) {
                int codePoint = data[i];
                if (codePoint < 65536) {
                    this.value[j++] = (char)codePoint;
                    continue;
                }
                this.value[j++] = (char)(55296 + ((codePoint -= 65536) >> 10));
                this.value[j++] = (char)(56320 + (codePoint & 0x3FF));
            }
        } else {
            throw new StringIndexOutOfBoundsException();
        }
    }

    public String(StringBuilder sBuilder) {
        this.offset = 0;
        this.value = sBuilder.shareValue();
        this.count = sBuilder.length();
    }

    public int codePointAt(int index) {
        if (index >= 0 && index < this.count) {
            char low;
            char high = this.value[this.offset + index];
            if (index + 1 < this.count && high >= '\ud800' && high <= '\udbff' && (low = this.value[this.offset + index + 1]) >= '\udc00' && low <= '\udfff') {
                return 65536 + (high - 55296 << 10) + (low - 56320);
            }
            return high;
        }
        throw new StringIndexOutOfBoundsException(index);
    }

    public int codePointBefore(int index) {
        if (index > 0 && index <= this.count) {
            char high;
            char low = this.value[this.offset + index - 1];
            if (index > 1 && low >= '\udc00' && low <= '\udfff' && (high = this.value[this.offset + index - 2]) >= '\ud800' && high <= '\udbff') {
                return 65536 + (high - 55296 << 10) + (low - 56320);
            }
            return low;
        }
        throw new StringIndexOutOfBoundsException(index);
    }

    public int codePointCount(int start, int end) {
        if (start >= 0 && start <= end && end <= this.count) {
            int count = 0;
            int last = this.offset + end;
            for (int i = this.offset + start; i < last; ++i) {
                char low;
                char high = this.value[i];
                if (i + 1 < last && high >= '\ud800' && high <= '\udbff' && (low = this.value[i + 1]) >= '\udc00' && low <= '\udfff') {
                    ++i;
                }
                ++count;
            }
            return count;
        }
        throw new IndexOutOfBoundsException();
    }

    public int offsetByCodePoints(int start, int codePointCount) {
        if (start >= 0 && start <= this.count) {
            int index = start;
            if (codePointCount == 0) {
                return start;
            }
            if (codePointCount > 0) {
                for (int i = 0; i < codePointCount; ++i) {
                    char low;
                    if (index == this.count) {
                        throw new IndexOutOfBoundsException();
                    }
                    char high = this.value[this.offset + index];
                    if (index + 1 < this.count && high >= '\ud800' && high <= '\udbff' && (low = this.value[this.offset + index + 1]) >= '\udc00' && low <= '\udfff') {
                        ++index;
                    }
                    ++index;
                }
            } else {
                for (int i = codePointCount; i < 0; ++i) {
                    char high;
                    if (index < 1) {
                        throw new IndexOutOfBoundsException();
                    }
                    char low = this.value[this.offset + index - 1];
                    if (index > 1 && low >= '\udc00' && low <= '\udfff' && (high = this.value[this.offset + index - 2]) >= '\ud800' && high <= '\udbff') {
                        --index;
                    }
                    --index;
                }
            }
            return index;
        }
        throw new IndexOutOfBoundsException();
    }

    public boolean contentEquals(CharSequence buffer) {
        if (this.count != buffer.length()) {
            return false;
        }
        for (int i = 0; i < this.count; ++i) {
            if (this.value[this.offset + i] == buffer.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(CharSequence sequence) {
        int subCount = sequence.length();
        if (subCount > this.count) {
            return false;
        }
        int start = 0;
        if (subCount > 0) {
            if (subCount + start > this.count) {
                return false;
            }
            int subOffset = 0;
            char firstChar = sequence.charAt(subOffset);
            while (true) {
                int i;
                if ((i = this.indexOf(firstChar, start)) == -1 || subCount + i > this.count) {
                    return false;
                }
                int o1 = this.offset + i;
                int o2 = subOffset;
                while (++o2 < subCount && this.value[++o1] == sequence.charAt(o2)) {
                }
                if (o2 == subCount) {
                    return true;
                }
                start = i + 1;
            }
        }
        return true;
    }

    public String replace(CharSequence sequence1, CharSequence sequence2) {
        int firstIndex;
        if (sequence2 == null) {
            throw new NullPointerException();
        }
        int sequence1Length = sequence1.length();
        if (sequence1Length == 0) {
            StringBuilder result = new StringBuilder((this.count + 1) * sequence2.length());
            result.append(sequence2);
            for (int i = 0; i < this.count; ++i) {
                result.append(this.charAt(i));
                result.append(sequence2);
            }
            return result.toString();
        }
        StringBuilder result = new StringBuilder();
        char first = sequence1.charAt(0);
        int start = 0;
        int copyStart = 0;
        while (start < this.count && (firstIndex = this.indexOf(first, start)) != -1) {
            boolean found = true;
            if (sequence1.length() > 1) {
                if (firstIndex + sequence1Length > this.count) break;
                for (int i = 1; i < sequence1Length; ++i) {
                    if (this.charAt(firstIndex + i) == sequence1.charAt(i)) continue;
                    found = false;
                    break;
                }
            }
            if (found) {
                result.append(this.substring(copyStart, firstIndex));
                result.append(sequence2);
                copyStart = start = firstIndex + sequence1Length;
                continue;
            }
            start = firstIndex + 1;
        }
        if (result.length() == 0 && copyStart == 0) {
            return this;
        }
        result.append(this.substring(copyStart));
        return result.toString();
    }

    public static String format(String format, Object ... args) {
        Formatter formatter = new Formatter();
        formatter.format(format, args);
        return formatter.toString();
    }

    public static String format(Locale locale, String format, Object ... args) {
        Formatter formatter = new Formatter(locale);
        formatter.format(format, args);
        return formatter.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    public String(byte[] data, Charset aCharset) {
        this(data, 0, data.length, aCharset);
    }

    public String(byte[] data, int start, int length, Charset aCharset) {
        if (aCharset == null) {
            throw new NullPointerException();
        }
        if (start < 0 || 0 > length || length > data.length - start) {
            throw new StringIndexOutOfBoundsException();
        }
        this.offset = 0;
        this.value = StringCoding.decode((Charset)aCharset, (byte[])data, (int)start, (int)length);
        this.count = this.value.length;
    }

    public byte[] getBytes(Charset aCharset) {
        return StringCoding.encode((Charset)aCharset, (char[])this.value, (int)this.offset, (int)this.count);
    }

    static {
        stringArray = new String[10];
        ascii = new char[128];
        for (int i = 0; i < ascii.length; ++i) {
            String.ascii[i] = (char)i;
        }
        seed = Hashing.murmur3_32((int)String.getSeed(), (char[])ascii, (int)0, (int)ascii.length);
        startCombiningAbove = "\u0300\u033d\u0346\u034a\u0350\u0357\u0363\u0483\u0592\u0597\u059c\u05a8\u05ab\u05af\u05c4\u0610\u0653\u0657\u06d6\u06df\u06e4\u06e7\u06eb\u0730\u0732\u0735\u073a\u073d\u073f\u0743\u0745\u0747\u0749\u0951\u0953\u0f82\u0f86\u17dd\u193a\u20d0\u20d4\u20db\u20e1\u20e7\u20e9\ufe20".value;
        endCombiningAbove = "\u0314\u0344\u0346\u034c\u0352\u0357\u036f\u0486\u0595\u0599\u05a1\u05a9\u05ac\u05af\u05c4\u0615\u0654\u0658\u06dc\u06e2\u06e4\u06e8\u06ec\u0730\u0733\u0736\u073a\u073d\u0741\u0743\u0745\u0747\u074a\u0951\u0954\u0f83\u0f87\u17dd\u193a\u20d1\u20d7\u20dc\u20e1\u20e7\u20e9\ufe23".value;
        upperValues = "SS\u0000\u02bcN\u0000J\u030c\u0000\u0399\u0308\u0301\u03a5\u0308\u0301\u0535\u0552\u0000H\u0331\u0000T\u0308\u0000W\u030a\u0000Y\u030a\u0000A\u02be\u0000\u03a5\u0313\u0000\u03a5\u0313\u0300\u03a5\u0313\u0301\u03a5\u0313\u0342\u1f08\u0399\u0000\u1f09\u0399\u0000\u1f0a\u0399\u0000\u1f0b\u0399\u0000\u1f0c\u0399\u0000\u1f0d\u0399\u0000\u1f0e\u0399\u0000\u1f0f\u0399\u0000\u1f08\u0399\u0000\u1f09\u0399\u0000\u1f0a\u0399\u0000\u1f0b\u0399\u0000\u1f0c\u0399\u0000\u1f0d\u0399\u0000\u1f0e\u0399\u0000\u1f0f\u0399\u0000\u1f28\u0399\u0000\u1f29\u0399\u0000\u1f2a\u0399\u0000\u1f2b\u0399\u0000\u1f2c\u0399\u0000\u1f2d\u0399\u0000\u1f2e\u0399\u0000\u1f2f\u0399\u0000\u1f28\u0399\u0000\u1f29\u0399\u0000\u1f2a\u0399\u0000\u1f2b\u0399\u0000\u1f2c\u0399\u0000\u1f2d\u0399\u0000\u1f2e\u0399\u0000\u1f2f\u0399\u0000\u1f68\u0399\u0000\u1f69\u0399\u0000\u1f6a\u0399\u0000\u1f6b\u0399\u0000\u1f6c\u0399\u0000\u1f6d\u0399\u0000\u1f6e\u0399\u0000\u1f6f\u0399\u0000\u1f68\u0399\u0000\u1f69\u0399\u0000\u1f6a\u0399\u0000\u1f6b\u0399\u0000\u1f6c\u0399\u0000\u1f6d\u0399\u0000\u1f6e\u0399\u0000\u1f6f\u0399\u0000\u1fba\u0399\u0000\u0391\u0399\u0000\u0386\u0399\u0000\u0391\u0342\u0000\u0391\u0342\u0399\u0391\u0399\u0000\u1fca\u0399\u0000\u0397\u0399\u0000\u0389\u0399\u0000\u0397\u0342\u0000\u0397\u0342\u0399\u0397\u0399\u0000\u0399\u0308\u0300\u0399\u0308\u0301\u0399\u0342\u0000\u0399\u0308\u0342\u03a5\u0308\u0300\u03a5\u0308\u0301\u03a1\u0313\u0000\u03a5\u0342\u0000\u03a5\u0308\u0342\u1ffa\u0399\u0000\u03a9\u0399\u0000\u038f\u0399\u0000\u03a9\u0342\u0000\u03a9\u0342\u0399\u03a9\u0399\u0000FF\u0000FI\u0000FL\u0000FFIFFLST\u0000ST\u0000\u0544\u0546\u0000\u0544\u0535\u0000\u0544\u053b\u0000\u054e\u0546\u0000\u0544\u053d\u0000".value;
        serialPersistentFields = new ObjectStreamField[0];
    }

    private static final class CaseInsensitiveComparator
    implements Comparator<String>,
    Serializable {
        static final long serialVersionUID = 8575799808933029326L;

        private CaseInsensitiveComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            return o1.compareToIgnoreCase(o2);
        }
    }
}

