/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.ConstantDoubleHandle;
import java.lang.invoke.ConstantFloatHandle;
import java.lang.invoke.ConstantIntHandle;
import java.lang.invoke.ConstantLongHandle;
import java.lang.invoke.ConstantObjectHandle;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.ThunkTable;

abstract class ConstantHandle
extends MethodHandle {
    private static final ThunkTable _thunkTable = new ThunkTable();

    ConstantHandle(MethodType type, String name, int kind) {
        super(type, null, name, kind, null);
    }

    ConstantHandle(ConstantHandle originalHandle, MethodType newType) {
        super(originalHandle, newType);
    }

    @Override
    protected final ThunkTable thunkTable() {
        return _thunkTable;
    }

    public static ConstantHandle get(Class<?> constantType, Object constantValue) {
        MethodType methodType = MethodType.methodType(constantType);
        if (!constantType.isPrimitive()) {
            return new ConstantObjectHandle(methodType, constantValue);
        }
        char charValue = '\u0000';
        if (constantValue instanceof Character) {
            charValue = ((Character)constantValue).charValue();
        }
        if (constantType == Double.TYPE) {
            double value = constantValue instanceof Number ? ((Number)constantValue).doubleValue() : (double)charValue;
            return new ConstantDoubleHandle(methodType, value);
        }
        if (constantType == Long.TYPE) {
            long value = constantValue instanceof Number ? ((Number)constantValue).longValue() : (long)charValue;
            return new ConstantLongHandle(methodType, value);
        }
        if (constantType == Float.TYPE) {
            float value = constantValue instanceof Number ? ((Number)constantValue).floatValue() : (float)charValue;
            return new ConstantFloatHandle(methodType, value);
        }
        int value = constantValue instanceof Number ? ((Number)constantValue).intValue() : (constantValue instanceof Boolean ? ((Boolean)constantValue != false ? 1 : 0) : (int)charValue);
        return new ConstantIntHandle(methodType, value);
    }
}

