/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.Comparator;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

abstract class FieldHandle
extends MethodHandle {
    final Class<?> fieldClass;
    final int final_modifiers;

    FieldHandle(MethodType type, Class<?> referenceClass, String fieldName, Class fieldClass, int kind, Class<?> accessClass) throws IllegalAccessException, NoSuchFieldException {
        super(type, referenceClass, fieldName, kind, null);
        this.fieldClass = fieldClass;
        this.defc = this.finishFieldInitialization(accessClass);
        this.final_modifiers = this.rawModifiers;
    }

    FieldHandle(MethodType type, Field field, int kind, boolean isStatic) throws IllegalAccessException {
        super(type, field.getDeclaringClass(), field.getName(), kind, field.getModifiers(), null);
        this.fieldClass = field.getType();
        assert (isStatic == Modifier.isStatic(field.getModifiers()));
        boolean succeed = FieldHandle.setVMSlotAndRawModifiersFromField(this, field);
        if (!succeed) {
            throw new IllegalAccessException();
        }
        this.final_modifiers = this.rawModifiers;
    }

    FieldHandle(FieldHandle originalHandle, MethodType newType) {
        super(originalHandle, newType);
        this.fieldClass = originalHandle.fieldClass;
        this.final_modifiers = this.rawModifiers;
    }

    final Class<?> finishFieldInitialization(Class<?> accessClass) throws IllegalAccessException, NoSuchFieldException {
        String signature = MethodType.getBytecodeStringName(this.fieldClass);
        try {
            return this.lookupField(this.definingClass, this.name, signature, this.kind, accessClass);
        }
        catch (NoSuchFieldError e) {
            throw new NoSuchFieldException(e.getMessage());
        }
        catch (LinkageError e) {
            throw (IllegalAccessException)new IllegalAccessException(e.getMessage()).initCause(e);
        }
    }

    final void compareWithField(FieldHandle left, Comparator c) {
        c.compareStructuralParameter(left.definingClass, this.definingClass);
        c.compareStructuralParameter(left.vmSlot, this.vmSlot);
    }
}

