/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.Comparator;
import java.lang.invoke.ILGenMacros;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.PassThroughHandle;
import java.lang.invoke.ThunkKey;
import java.lang.invoke.ThunkKeyWithObject;
import java.lang.invoke.ThunkTable;
import java.lang.invoke.ThunkTuple;

final class GuardWithTestHandle
extends PassThroughHandle {
    final MethodHandle guard;
    final MethodHandle trueTarget;
    final MethodHandle falseTarget;
    private static final ThunkTable _thunkTable = new ThunkTable();

    protected GuardWithTestHandle(MethodHandle guard, MethodHandle trueTarget, MethodHandle falseTarget, MethodHandle equivalent) {
        super(equivalent, "GuardWithTestHandle", guard.type());
        this.guard = guard;
        this.trueTarget = trueTarget;
        this.falseTarget = falseTarget;
    }

    GuardWithTestHandle(GuardWithTestHandle originalHandle, MethodType newType) {
        super(originalHandle, newType);
        this.guard = originalHandle.guard;
        this.trueTarget = originalHandle.trueTarget;
        this.falseTarget = originalHandle.falseTarget;
    }

    public static GuardWithTestHandle get(MethodHandle guard, MethodHandle trueTarget, MethodHandle falseTarget, MethodHandle equivalent) {
        return new GuardWithTestHandle(guard, trueTarget, falseTarget, equivalent);
    }

    @Override
    protected final ThunkTable thunkTable() {
        return _thunkTable;
    }

    @Override
    protected final ThunkTuple computeThunks(Object guardType) {
        return this.thunkTable().get(new ThunkKeyWithObject(ThunkKey.computeThunkableType(this.type()), guardType));
    }

    private static native int numGuardArgs();

    @MethodHandle.FrameIteratorSkip
    private final int invokeExact_thunkArchetype_X(int argPlaceholder) {
        if (ILGenMacros.isShareableThunk()) {
            this.undoCustomizationLogic(this.guard, this.trueTarget, this.falseTarget);
        }
        if (!ILGenMacros.isCustomThunk()) {
            this.doCustomizationLogic();
        }
        if (ILGenMacros.invokeExact_Z(this.guard, ILGenMacros.firstN(GuardWithTestHandle.numGuardArgs(), argPlaceholder))) {
            return ILGenMacros.invokeExact_X(this.trueTarget, argPlaceholder);
        }
        return ILGenMacros.invokeExact_X(this.falseTarget, argPlaceholder);
    }

    @Override
    MethodHandle cloneWithNewType(MethodType newType) {
        return new GuardWithTestHandle(this, newType);
    }

    @Override
    final void compareWith(MethodHandle right, Comparator c) {
        if (right instanceof GuardWithTestHandle) {
            ((GuardWithTestHandle)right).compareWithGuardWithTest(this, c);
        } else {
            c.fail();
        }
    }

    final void compareWithGuardWithTest(GuardWithTestHandle left, Comparator c) {
        c.compareChildHandle(left.guard, this.guard);
        c.compareChildHandle(left.trueTarget, this.trueTarget);
        c.compareChildHandle(left.falseTarget, this.falseTarget);
    }
}

