/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.trace.format.api;

import com.ibm.jvm.trace.format.api.Component;
import com.ibm.jvm.trace.format.api.Message;
import com.ibm.jvm.trace.format.api.TraceContext;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;

public final class MessageFile {
    TraceContext context;
    private static HashMap library = new HashMap();
    private File dataFile;
    private int readers = 0;
    private BufferedReader reader;
    private String formatName;
    protected float verMod = 0.0f;
    private HashMap messages = new HashMap();
    private HashMap componentList = new HashMap();
    private final String fromDATFile = ".definedInDatFile";
    private boolean processingDATFile = false;
    int counter = 0;
    String savedComponentName = "not_a_component";
    Component savedComponent = null;

    public HashMap getStatistics() {
        HashMap stats = new HashMap();
        for (Object mKey : this.messages.keySet()) {
            Message msg = (Message)this.messages.get(mKey);
            if (msg == null) continue;
            stats.put(mKey, msg.getStatistics());
        }
        for (Object cKey : this.componentList.keySet()) {
            Component comp = (Component)this.componentList.get(cKey);
            if (comp == null) continue;
            int id = 0;
            for (id = 0; id < comp.messageList.size(); ++id) {
                Message msg = (Message)comp.messageList.get(id);
                if (msg == null) continue;
                stats.put(comp.getName() + "." + id, msg.getStatistics());
            }
        }
        return stats;
    }

    private void initialize(TraceContext context, InputStream stream) throws IOException {
        this.context = context;
        this.reader = new BufferedReader(new InputStreamReader(stream));
        this.read();
    }

    private MessageFile(TraceContext context, File file) throws IOException {
        this.formatName = file.getName();
        this.initialize(context, new FileInputStream(file));
    }

    private MessageFile(TraceContext context, InputStream stream) throws IOException {
        this.initialize(context, stream);
    }

    public float getVersion() {
        return this.verMod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read() throws IOException {
        this.readHeader(this.reader.readLine());
        this.processingDATFile = true;
        try {
            String line = this.reader.readLine();
            if ((double)this.verMod >= 5.0) {
                while (line != null && line.length() != 0) {
                    this.addMessage_50(line);
                    line = this.reader.readLine();
                }
            } else {
                while (line != null) {
                    this.addMessage_12(line);
                    line = this.reader.readLine();
                }
            }
        }
        finally {
            this.processingDATFile = false;
        }
    }

    private void failParse(String description, String badLine) throws IOException {
        this.context.error(this, "File: '" + this.formatName + "' bad.  Reason: " + description + "Contents:  <" + badLine + ">");
        throw new IOException(description);
    }

    private void readHeader(String messageLine) throws IOException {
        int firstSpace = messageLine.indexOf(" ");
        if (firstSpace != -1) {
            this.failParse("Trace format file '" + this.formatName + "' header malformed.", messageLine);
        }
        try {
            this.verMod = Float.valueOf(messageLine).floatValue();
        }
        catch (Exception e) {
            if (messageLine.equals("dg")) {
                this.failParse("Trace format file '" + this.formatName + "' obsolete, no version number.", "");
            }
            this.failParse("Trace format file '" + this.formatName + "' appears to be corrupted.", messageLine);
        }
    }

    protected void addMessage(String messageLine) {
        this.addMessage_12(messageLine);
    }

    private void addMessage_50(String messageLine) {
        int period;
        int firstSpace = messageLine.indexOf(" ");
        int secondSpace = messageLine.indexOf(" ", firstSpace + 1);
        int thirdSpace = messageLine.indexOf(" ", secondSpace + 1);
        int fourthSpace = messageLine.indexOf(" ", thirdSpace + 1);
        int fifthSpace = messageLine.indexOf(" ", fourthSpace + 1);
        int sixthSpace = messageLine.indexOf(" ", fifthSpace + 1);
        String componentName = null;
        int tpNumber = -1;
        String symbol = null;
        String msg = null;
        componentName = new String(messageLine.substring(0, firstSpace));
        if (this.verMod >= 5.1f && (period = componentName.indexOf(46)) != -1) {
            String compName = componentName.substring(0, period);
            String tpNum = componentName.substring(period + 1);
            tpNumber = Integer.parseInt(tpNum);
            componentName = compName;
        }
        if (!componentName.equals(this.savedComponentName)) {
            this.savedComponentName = componentName;
            this.savedComponent = (Component)this.componentList.get(componentName);
            if (this.savedComponent == null) {
                this.savedComponent = new Component(componentName);
                this.componentList.put(componentName, this.savedComponent);
                this.messages.put(componentName + ".definedInDatFile", null);
                this.savedComponent.setBase(0);
            }
            this.counter = 0;
        }
        int id = this.counter++;
        if (tpNumber >= 0 && id != tpNumber) {
            throw new Error("tpNumber doesn't match the counter");
        }
        int type = Integer.parseInt(messageLine.substring(firstSpace + 1, secondSpace));
        int level = Integer.parseInt(messageLine.substring(thirdSpace + 1, fourthSpace));
        symbol = messageLine.substring(fifthSpace + 1, sixthSpace);
        msg = messageLine.substring(sixthSpace + 2, messageLine.length() - 1);
        Message message = new Message(type, msg, id, level, componentName, symbol, this.context);
        this.savedComponent.addMessage(message, id);
    }

    private void addMessage_12(String messageLine) {
        int firstSpace = messageLine.indexOf(" ");
        int secondSpace = messageLine.indexOf(" ", firstSpace + 1);
        int thirdSpace = messageLine.indexOf(" ", secondSpace + 1);
        String componentName = null;
        String symbol = null;
        String msg = null;
        int id = Integer.parseInt(messageLine.substring(0, firstSpace), 16);
        int type = Integer.parseInt(messageLine.substring(firstSpace + 1, secondSpace));
        int level = 1;
        if (this.verMod < 1.2f) {
            symbol = messageLine.substring(secondSpace + 1, thirdSpace);
            msg = messageLine.substring(thirdSpace + 2, messageLine.length() - 1);
        } else {
            int fourthSpace = messageLine.indexOf(" ", thirdSpace + 1);
            int fifthSpace = messageLine.indexOf(" ", fourthSpace + 1);
            int sixthSpace = messageLine.indexOf(" ", fifthSpace + 1);
            level = Integer.parseInt(messageLine.substring(thirdSpace + 1, fourthSpace));
            symbol = messageLine.substring(fifthSpace + 1, sixthSpace);
            msg = messageLine.substring(sixthSpace + 2, messageLine.length() - 1);
        }
        Message message = new Message(type, msg, id, level, componentName, symbol, this.context);
        this.messages.put(new Integer(id), message);
    }

    protected Message getMessageFromID(int id) {
        if ((double)this.verMod >= 5.0) {
            this.context.error(this, "Trying to retrieve an old style message (0x" + Long.toString(id) + ") from 5.0 or newer message file");
            return null;
        }
        return (Message)this.messages.get(new Integer(id));
    }

    protected synchronized Message getMessageFromID(String compName, int id) {
        Message message;
        if ((double)this.verMod < 5.0) {
            this.context.error(this, "Trying to retrieve a new style message (" + compName + "." + id + ") from 1.1 or older message file");
            return null;
        }
        Component component = (Component)this.componentList.get(compName);
        if (component != null) {
            message = component.getMessageByID(id);
        } else {
            String messageKey = new String(compName + "." + id);
            message = (Message)this.messages.get(messageKey);
        }
        if (message == null) {
            if (this.componentIsFromDATFile(compName)) {
                this.context.error(this, compName + "." + id + " not in dat file: corrupted trace point or dat file mismatch against source VM.");
                message = new Message(14, "This tracepoint's format string was not available in dat file.", id, -1, compName, " ", this.context);
            } else {
                message = compName.equals("ApplicationTrace") ? new Message(13, "%s", id, -1, compName, "%s", this.context) : new Message(13, "raw parameter data [%.*s]", id, -1, compName, "%s", this.context);
            }
            if (component != null && id >= 0) {
                component.addMessage(message, id);
            } else {
                String msg = new String(compName + "." + id);
                this.messages.put(msg, message);
            }
        }
        return message;
    }

    public boolean componentIsFromDATFile(String componentName) {
        return this.messages != null && this.messages.containsKey(componentName + ".definedInDatFile");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageFile getMessageFile(InputStream stream, TraceContext context) throws IOException {
        MessageFile messageFile;
        HashMap hashMap = library;
        synchronized (hashMap) {
            if (library.containsKey(stream)) {
                messageFile = (MessageFile)library.get(stream);
            } else {
                messageFile = new MessageFile(context, stream);
                library.put(stream, messageFile);
            }
            ++messageFile.readers;
        }
        return messageFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageFile getMessageFile(File file, TraceContext context) throws IOException {
        MessageFile messageFile;
        file = file.getCanonicalFile();
        HashMap hashMap = library;
        synchronized (hashMap) {
            if (library.containsKey(file)) {
                messageFile = (MessageFile)library.get(file);
            } else {
                messageFile = new MessageFile(context, file);
                library.put(file, messageFile);
            }
            ++messageFile.readers;
        }
        return messageFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release() {
        HashMap hashMap = library;
        synchronized (hashMap) {
            --this.readers;
            if (this.readers == 0) {
                library.remove(this.dataFile);
            }
        }
    }
}

