/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import sun.misc.Unsafe;

public class ThreadLocalRandom
extends Random {
    private static final long multiplier = 25214903917L;
    private static final long addend = 11L;
    private static final long mask = 0xFFFFFFFFFFFFL;
    private static final int PROBE_INCREMENT = 1640531527;
    private static final AtomicLong seedGenerator = new AtomicLong(1269533684904616924L);
    private static final AtomicInteger probeGenerator = new AtomicInteger(-401635769);
    private static final ThreadLocal<Double> nextLocalGaussian = new ThreadLocal();
    boolean initialized = true;
    static final ThreadLocalRandom instance = new ThreadLocalRandom();
    private static final long serialVersionUID = -5851777807851030925L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("rnd", Long.TYPE), new ObjectStreamField("initialized", Boolean.TYPE), new ObjectStreamField("pad0", Long.TYPE), new ObjectStreamField("pad1", Long.TYPE), new ObjectStreamField("pad2", Long.TYPE), new ObjectStreamField("pad3", Long.TYPE), new ObjectStreamField("pad4", Long.TYPE), new ObjectStreamField("pad5", Long.TYPE), new ObjectStreamField("pad6", Long.TYPE), new ObjectStreamField("pad7", Long.TYPE)};
    private static final Unsafe UNSAFE;
    private static final long SEED;
    private static final long PROBE;
    private static final long SECONDARY;

    private ThreadLocalRandom() {
    }

    static final void localInit() {
        long l;
        long l2;
        int n;
        int n2 = probeGenerator.getAndAdd(1640531527);
        int n3 = n = n2 == 0 ? 1 : n2;
        while (!seedGenerator.compareAndSet(l2 = seedGenerator.get(), l = l2 * 181783497276652981L)) {
        }
        long l3 = l ^ (long)n << 32 ^ System.nanoTime();
        Thread thread = Thread.currentThread();
        UNSAFE.putLong(thread, SEED, l3);
        UNSAFE.putInt(thread, PROBE, n);
    }

    public static ThreadLocalRandom current() {
        if (UNSAFE.getInt(Thread.currentThread(), PROBE) == 0) {
            ThreadLocalRandom.localInit();
        }
        return instance;
    }

    @Override
    public void setSeed(long l) {
        if (this.initialized) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    protected int next(int n) {
        Thread thread = Thread.currentThread();
        long l = UNSAFE.getLong(thread, SEED) * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        UNSAFE.putLong(thread, SEED, l);
        return (int)(l >>> 48 - n);
    }

    @Override
    public int nextInt(int n, int n2) {
        if (n >= n2) {
            throw new IllegalArgumentException();
        }
        return this.nextInt(n2 - n) + n;
    }

    @Override
    public long nextLong(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("n must be positive");
        }
        long l2 = 0L;
        while (l >= Integer.MAX_VALUE) {
            long l3;
            int n = this.next(2);
            long l4 = l >>> 1;
            long l5 = l3 = (n & 2) == 0 ? l4 : l - l4;
            if ((n & 1) == 0) {
                l2 += l - l3;
            }
            l = l3;
        }
        return l2 + (long)this.nextInt((int)l);
    }

    @Override
    public long nextLong(long l, long l2) {
        if (l >= l2) {
            throw new IllegalArgumentException();
        }
        return this.nextLong(l2 - l) + l;
    }

    @Override
    public double nextDouble(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("n must be positive");
        }
        return this.nextDouble() * d;
    }

    @Override
    public double nextDouble(double d, double d2) {
        if (d >= d2) {
            throw new IllegalArgumentException();
        }
        return this.nextDouble() * (d2 - d) + d;
    }

    @Override
    public double nextGaussian() {
        double d;
        double d2;
        double d3;
        Double d4 = nextLocalGaussian.get();
        if (d4 != null) {
            nextLocalGaussian.set(null);
            return d4;
        }
        while ((d3 = (d2 = 2.0 * this.nextDouble() - 1.0) * d2 + (d = 2.0 * this.nextDouble() - 1.0) * d) >= 1.0 || d3 == 0.0) {
        }
        double d5 = StrictMath.sqrt(-2.0 * StrictMath.log(d3) / d3);
        nextLocalGaussian.set(new Double(d * d5));
        return d2 * d5;
    }

    static final int getProbe() {
        return UNSAFE.getInt(Thread.currentThread(), PROBE);
    }

    static final int advanceProbe(int n) {
        n ^= n << 13;
        n ^= n >>> 17;
        n ^= n << 5;
        UNSAFE.putInt(Thread.currentThread(), PROBE, n);
        return n;
    }

    static final int nextSecondarySeed() {
        Thread thread = Thread.currentThread();
        int n = UNSAFE.getInt(thread, SECONDARY);
        if (n != 0) {
            n ^= n << 13;
            n ^= n >>> 17;
            n ^= n << 5;
        } else {
            ThreadLocalRandom.localInit();
            n = (int)UNSAFE.getLong(thread, SEED);
            if (n == 0) {
                n = 1;
            }
        }
        UNSAFE.putInt(thread, SECONDARY, n);
        return n;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("rnd", UNSAFE.getLong(Thread.currentThread(), SEED));
        putField.put("initialized", true);
        putField.put("pad0", 0L);
        putField.put("pad1", 0L);
        putField.put("pad2", 0L);
        putField.put("pad3", 0L);
        putField.put("pad4", 0L);
        putField.put("pad5", 0L);
        putField.put("pad6", 0L);
        putField.put("pad7", 0L);
        objectOutputStream.writeFields();
    }

    private Object readResolve() {
        return ThreadLocalRandom.current();
    }

    static {
        try {
            UNSAFE = Unsafe.getUnsafe();
            Class<Thread> clazz = Thread.class;
            SEED = UNSAFE.objectFieldOffset(clazz.getDeclaredField("threadLocalRandomSeed"));
            PROBE = UNSAFE.objectFieldOffset(clazz.getDeclaredField("threadLocalRandomProbe"));
            SECONDARY = UNSAFE.objectFieldOffset(clazz.getDeclaredField("threadLocalRandomSecondarySeed"));
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }
}

