/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders;

import com.ibm.dtfj.addressspace.DumpReaderAddressSpace;
import com.ibm.dtfj.addressspace.IAbstractAddressSpace;
import com.ibm.dtfj.corereaders.DumpReader;
import com.ibm.dtfj.corereaders.ICoreFileReader;
import com.ibm.dtfj.corereaders.J9RASReader;
import com.ibm.dtfj.corereaders.MemoryRange;
import java.io.IOException;

public abstract class CoreReaderSupport
implements ICoreFileReader {
    private DumpReader _reader;
    private IAbstractAddressSpace _addressSpace = null;
    protected J9RASReader _j9rasReader = null;

    protected abstract MemoryRange[] getMemoryRangesAsArray();

    protected abstract boolean isLittleEndian();

    protected abstract boolean is64Bit();

    public CoreReaderSupport(DumpReader reader) {
        this._reader = reader;
    }

    protected int coreReadInt() throws IOException {
        return this._reader.readInt();
    }

    protected void coreSeek(long position) throws IOException {
        this._reader.seek(position);
    }

    protected long coreReadLong() throws IOException {
        return this._reader.readLong();
    }

    protected long coreReadAddress() throws IOException {
        return this._reader.readAddress();
    }

    protected short coreReadShort() throws IOException {
        return this._reader.readShort();
    }

    protected byte coreReadByte() throws IOException {
        return this._reader.readByte();
    }

    protected byte[] coreReadBytes(int n) throws IOException {
        return this._reader.readBytes(n);
    }

    public IAbstractAddressSpace getAddressSpace() {
        if (null == this._addressSpace) {
            MemoryRange[] ranges = this.getMemoryRangesAsArray();
            this._addressSpace = null == ranges ? null : new DumpReaderAddressSpace(ranges, this._reader, this.isLittleEndian(), this.is64Bit());
        }
        if (this._addressSpace != null) {
            this._j9rasReader = new J9RASReader(this._addressSpace, this.is64Bit());
        }
        return this._addressSpace;
    }

    public boolean isTruncated() {
        return false;
    }

    protected long coreGetPosition() throws IOException {
        return this._reader.getPosition();
    }

    protected boolean coreCheckOffset(long location) throws IOException {
        boolean canRead;
        long currentPos = this.coreGetPosition();
        try {
            this.coreSeek(location);
            this.coreReadByte();
            canRead = true;
        }
        catch (IOException ioe) {
            canRead = false;
        }
        this.coreSeek(currentPos);
        return canRead;
    }

    public void releaseResources() throws IOException {
        this._reader.releaseResources();
    }
}

