/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders;

import com.ibm.dtfj.corereaders.Builder;
import com.ibm.dtfj.corereaders.ClosingFileReader;
import com.ibm.dtfj.corereaders.CoreReaderSupport;
import com.ibm.dtfj.corereaders.CorruptCoreException;
import com.ibm.dtfj.corereaders.DumpReader;
import com.ibm.dtfj.corereaders.ICoreFileReader;
import com.ibm.dtfj.corereaders.LittleEndianDumpReader;
import com.ibm.dtfj.corereaders.MemoryAccessException;
import com.ibm.dtfj.corereaders.MemoryRange;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.imageio.stream.ImageInputStream;

public class NewElfDump
extends CoreReaderSupport {
    private static final int ELF_NOTE_HEADER_SIZE = 12;
    private static final int EI_NIDENT = 16;
    private static final int ELF_PRARGSZ = 80;
    private static final int ELFCLASS32 = 1;
    private static final int ELFCLASS64 = 2;
    private static final int ELFDATA2LSB = 1;
    private static final int ELFDATA2MSB = 2;
    private static final int ARCH_IA32 = 3;
    private static final int ARCH_PPC32 = 20;
    private static final int ARCH_PPC64 = 21;
    private static final int ARCH_S390 = 22;
    private static final int ARCH_IA64 = 50;
    private static final int ARCH_AMD64 = 62;
    private static final int DT_NULL = 0;
    private static final int DT_STRTAB = 5;
    private static final int DT_SONAME = 14;
    private static final int DT_DEBUG = 21;
    private static final int NT_PRSTATUS = 1;
    private static final int NT_PRPSINFO = 3;
    private static final int NT_AUXV = 6;
    private static final int AT_NULL = 0;
    private static final int AT_ENTRY = 9;
    private static final int AT_PLATFORM = 15;
    private static final int AT_HWCAP = 16;
    private static final String SYSTEM_PROP_EXECUTABLE = "com.ibm.dtfj.corereaders.executable";
    private List _memoryRanges = new ArrayList();
    private Set _additionalFileNames = new HashSet();
    private long _platformIdAddress = 0L;
    private ElfFile _file;
    private boolean _isLittleEndian;
    private boolean _is64Bit;
    private boolean _verbose;
    private static final long SHT_STRTAB = 3L;

    private Object readProcess(DataEntry entry, Builder builder, Object addressSpace, List threads) throws IOException, CorruptCoreException, MemoryAccessException {
        this._file.seek(entry.offset);
        this._file.readByte();
        this._file.readByte();
        this._file.readByte();
        this._file.readByte();
        this._file.seek(entry.offset + this._file.padToWordBoundary(4L));
        this._file.readElfWord();
        this.readUID();
        this.readUID();
        long elfPID = (long)this._file.readInt() & 0xFFFFFFFFL;
        this._file.readInt();
        this._file.readInt();
        this._file.readInt();
        this._file.seek(entry.offset + entry.size - 96L);
        this._file.readBytes(16);
        String dumpCommandLine = new String(this._file.readBytes(80), "ASCII").trim();
        Properties environment = this.getEnvironmentVariables(builder);
        String alternateCommandLine = "";
        if (null != environment) {
            alternateCommandLine = environment.getProperty("IBM_JAVA_COMMAND_LINE", "");
        }
        String commandLine = dumpCommandLine.length() >= alternateCommandLine.length() ? dumpCommandLine : alternateCommandLine;
        int space = commandLine.indexOf(" ");
        String executable = commandLine;
        if (0 < space) {
            executable = executable.substring(0, space);
        }
        String pid = Long.toString(elfPID);
        Object failingThread = threads.get(0);
        if (null != this._j9rasReader) {
            boolean didFork = true;
            try {
                long rasPID = this._j9rasReader.getProcessID();
                if (elfPID != rasPID) {
                    pid = Long.toString(rasPID);
                } else {
                    didFork = false;
                }
            }
            catch (UnsupportedOperationException use) {
                // empty catch block
            }
            if (didFork) {
                try {
                    long tid = this._j9rasReader.getThreadID();
                    failingThread = builder.buildThread(Long.toString(tid), Collections.EMPTY_LIST.iterator(), Collections.EMPTY_LIST.iterator(), Collections.EMPTY_LIST.iterator(), new Properties(), 0);
                    threads.add(0, failingThread);
                }
                catch (UnsupportedOperationException uoe) {
                    // empty catch block
                }
            }
        }
        return this.buildProcess(builder, addressSpace, pid, commandLine, this.getEnvironmentVariables(builder), failingThread, threads.iterator(), executable);
    }

    private Object buildProcess(Builder builder, Object addressSpace, String pid, String commandLine, Properties environmentVariables, Object currentThread, Iterator threads, String executableName) throws IOException, MemoryAccessException {
        List modules = this.readModules(builder, addressSpace, executableName);
        Iterator libraries = modules.iterator();
        Object executable = null;
        if (libraries.hasNext()) {
            executable = libraries.next();
        }
        return builder.buildProcess(addressSpace, pid, commandLine, environmentVariables, currentThread, threads, executable, libraries, this._file.addressSize());
    }

    private List readModules(Builder builder, Object addressSpace, String executableName) throws IOException, MemoryAccessException {
        ArrayList<Object> modules = new ArrayList<Object>();
        String overrideExecutableName = System.getProperty(SYSTEM_PROP_EXECUTABLE);
        ClosingFileReader file = overrideExecutableName == null ? this._findFileInPath(builder, executableName, System.getProperty("java.class.path", ".")) : this._findFileInPath(builder, overrideExecutableName, System.getProperty("java.class.path", "."));
        if (null != file) {
            ElfFile executable = this.elfFileFrom(file);
            if (null != executable) {
                ProgramHeaderEntry dynamic = null;
                Iterator iter = executable.programHeaderEntries();
                while (null == dynamic && iter.hasNext()) {
                    ProgramHeaderEntry entry = (ProgramHeaderEntry)iter.next();
                    if (!entry.isDynamic()) continue;
                    dynamic = entry;
                }
                if (null != dynamic) {
                    List symbols = this.readSymbolsFrom(builder, addressSpace, executable, dynamic.virtualAddress);
                    long imageStart = dynamic.virtualAddress;
                    if (this.isValidAddress(imageStart)) {
                        Iterator sections = this._buildModuleSections(builder, addressSpace, executable, dynamic.virtualAddress);
                        Properties properties = executable.getProperties();
                        modules.add(builder.buildModule(executableName, properties, sections, symbols.iterator(), imageStart));
                        modules.addAll(this.readLibrariesAt(builder, addressSpace, imageStart));
                        this._additionalFileNames.add(executableName);
                    }
                }
            } else {
                builder.setExecutableUnavailable("Executable file \"" + executableName + "\" not found");
            }
        } else {
            builder.setExecutableUnavailable("File \"" + executableName + "\" not found");
            if (this._verbose) {
                System.err.println("Warning: executable " + executableName + " not found, unable to collect libraries." + " Please retry with jextract -f option.");
            }
        }
        for (Object e : this._file._programHeaderEntries) {
            ProgramHeaderEntry entry = (ProgramHeaderEntry)e;
            if (!entry.isLoadable()) continue;
            try {
                ElfFile moduleFile = null;
                moduleFile = this._is64Bit ? new Elf64File(this._file._reader, entry.fileOffset) : new Elf32File(this._file._reader, entry.fileOffset);
                String soname = moduleFile.getSONAME();
                if (soname == null || "lib.so".equals(soname)) continue;
                this._additionalFileNames.add(soname);
            }
            catch (Exception ex) {}
        }
        return modules;
    }

    private ClosingFileReader _findFileInPath(Builder builder, String filename, String path) {
        ClosingFileReader file = null;
        try {
            file = builder.openFile(filename);
        }
        catch (IOException e) {
            Iterator components = NewElfDump._componentsSeparatedBy(path, ":").iterator();
            while (null == file && components.hasNext()) {
                String component = (String)components.next();
                try {
                    file = builder.openFile(component + "/" + filename);
                }
                catch (IOException e2) {}
            }
        }
        return file;
    }

    private static List _componentsSeparatedBy(String path, String separator) {
        Vector<String> list = new Vector<String>();
        while (null != path) {
            int index = path.indexOf(separator);
            if (index >= 0) {
                String component = path.substring(0, index);
                list.add(component);
                path = path.substring(index + 1);
                continue;
            }
            path = null;
        }
        return list;
    }

    private Iterator _buildModuleSections(Builder builder, Object addressSpace, ElfFile executable, long loadedBaseAddress) throws IOException {
        SectionHeaderEntry entry;
        Vector<Object> sections = new Vector<Object>();
        Iterator shentries = executable.sectionHeaderEntries();
        byte[] strings = null;
        while (shentries.hasNext()) {
            entry = (SectionHeaderEntry)shentries.next();
            if (3L != entry._type) continue;
            executable.seek(entry.offset);
            byte[] attempt = executable.readBytes((int)entry.size);
            String peak = this.stringFromBytesAt(attempt, entry._name);
            if (peak != null) {
                if (!peak.equals(".shstrtab")) continue;
                strings = attempt;
                break;
            }
            if (!this._verbose) continue;
            System.err.println("\tError reading section header name at file offset=0x" + Long.toHexString(entry.offset));
        }
        shentries = executable.sectionHeaderEntries();
        while (shentries.hasNext()) {
            entry = (SectionHeaderEntry)shentries.next();
            String name = "";
            if (null != strings && (name = this.stringFromBytesAt(strings, entry._name)) == null) {
                if (this._verbose) {
                    System.err.println("\tError reading section header name at file offset=0x" + Long.toHexString(entry.offset));
                }
                name = "";
            }
            Object section = builder.buildModuleSection(addressSpace, name, loadedBaseAddress + entry.offset, loadedBaseAddress + entry.offset + entry.size);
            sections.add(section);
        }
        return sections.iterator();
    }

    private boolean isValidAddress(long address) {
        Iterator iter = this._file.programHeaderEntries();
        while (iter.hasNext()) {
            ProgramHeaderEntry element = (ProgramHeaderEntry)iter.next();
            if (!element.contains(address)) continue;
            return true;
        }
        return false;
    }

    private boolean isValidAddressInProcess(long address) {
        Iterator iter = this._file.programHeaderEntries();
        while (iter.hasNext()) {
            ProgramHeaderEntry element = (ProgramHeaderEntry)iter.next();
            if (!element.validInProcess(address)) continue;
            return true;
        }
        return false;
    }

    private List readLibrariesAt(Builder builder, Object addressSpace, long imageStart) throws MemoryAccessException, IOException {
        long address;
        long tag;
        ArrayList<Object> libraries = new ArrayList<Object>();
        this.seekToAddress(imageStart);
        do {
            tag = this._file.readElfWord();
            address = this._file.readElfWord();
            if (!this._verbose || tag >= 0L && tag <= 33L || tag >= 0x60000000L && tag <= 0x6FFFFFFFL || tag >= 0x70000000L && tag <= Integer.MAX_VALUE) continue;
            System.err.println("Error reading dynamic section. Invalid tag value '0x" + Long.toHexString(tag));
        } while (tag != 0L && tag != 21L);
        if (tag != 21L) {
            return libraries;
        }
        this.seekToAddress(address);
        this._file.readElfWord();
        long next = this._file.readElfWord();
        while (0L != next) {
            this.seekToAddress(next);
            long loadedBaseAddress = this._file.readElfWord();
            long nameAddress = this._file.readElfWord();
            this._file.readElfWord();
            next = this._file.readElfWord();
            if (0L == loadedBaseAddress) continue;
            MemoryRange range = this.memoryRangeFor(loadedBaseAddress);
            Properties properties = new Properties();
            List<Object> symbols = new ArrayList<Object>();
            String name = this.readStringAt(nameAddress);
            Iterator sections = new Vector().iterator();
            if (null == range || range.getVirtualAddress() != loadedBaseAddress || null == name || name.length() <= 0 || !name.startsWith("/")) continue;
            try {
                ClosingFileReader file = builder.openFile(name);
                if (null != file) {
                    if (this._verbose) {
                        System.err.println("Reading library file " + name);
                    }
                    ElfFile library = this.elfFileFrom(file);
                    if (!range.isInCoreFile()) {
                        range.setLibraryReader(library._reader);
                    }
                    this._additionalFileNames.add(name);
                    if (null != library) {
                        symbols = this.readSymbolsFrom(builder, addressSpace, library, loadedBaseAddress);
                        properties = library.getProperties();
                        sections = this._buildModuleSections(builder, addressSpace, library, loadedBaseAddress);
                    } else {
                        symbols.add(builder.buildCorruptData(addressSpace, "unable to find module " + name, loadedBaseAddress));
                    }
                }
            }
            catch (FileNotFoundException exc) {
                // empty catch block
            }
            libraries.add(builder.buildModule(name, properties, sections, symbols.iterator(), loadedBaseAddress));
        }
        return libraries;
    }

    private MemoryRange memoryRangeFor(long address) {
        Iterator ranges = this._memoryRanges.iterator();
        MemoryRange match = null;
        while (null == match && ranges.hasNext()) {
            MemoryRange range = (MemoryRange)ranges.next();
            if (!range.contains(address)) continue;
            match = range;
        }
        return match;
    }

    private void seekToAddress(long address) throws IOException {
        ProgramHeaderEntry matchedEntry = null;
        Iterator iter = this._file.programHeaderEntries();
        while (iter.hasNext()) {
            ProgramHeaderEntry element = (ProgramHeaderEntry)iter.next();
            if (!element.contains(address)) continue;
            assert (null == matchedEntry) : "Multiple mappings for the same address";
            matchedEntry = element;
        }
        if (null == matchedEntry) {
            throw new IOException("No ProgramHeaderEntry found for address");
        }
        this.coreSeek(matchedEntry.fileOffset + (address - matchedEntry.virtualAddress));
    }

    private List readSymbolsFrom(Builder builder, Object addressSpace, ElfFile file, long baseAddress) throws IOException {
        ArrayList symbols = new ArrayList();
        Iterator iter = file.sectionHeaderEntries();
        while (iter.hasNext()) {
            SectionHeaderEntry entry = (SectionHeaderEntry)iter.next();
            if (!entry.isSymbolTable()) continue;
            symbols.addAll(this.readSymbolsFrom(builder, addressSpace, file, entry, baseAddress));
        }
        return symbols;
    }

    private List readSymbolsFrom(Builder builder, Object addressSpace, ElfFile file, SectionHeaderEntry entry, long baseAddress) throws IOException {
        ArrayList<Object> symbols = new ArrayList<Object>();
        SectionHeaderEntry stringTable = file.sectionHeaderEntryAt((int)entry.link);
        file.seek(stringTable.offset);
        byte[] strings = file.readBytes((int)stringTable.size);
        Iterator iter = file.readSymbolsAt(entry);
        while (iter.hasNext()) {
            Symbol sym = (Symbol)iter.next();
            if (!sym.isFunction()) continue;
            String name = this.stringFromBytesAt(strings, sym.name);
            if (name != null) {
                if (sym.value == 0L) continue;
                symbols.add(builder.buildSymbol(addressSpace, name, baseAddress + sym.value));
                continue;
            }
            if (!this._verbose) continue;
            System.err.println("\tError reading section header name at file offset=0x" + Long.toHexString(stringTable.offset));
        }
        return symbols;
    }

    private String stringFromBytesAt(byte[] stringTableBytes, long offset) {
        int startOffset;
        if (offset < 0L || offset >= (long)stringTableBytes.length) {
            if (this._verbose) {
                System.err.println("\tError in string table offset, value=0x" + Long.toHexString(offset));
            }
            return null;
        }
        int endOffset = startOffset = (int)offset;
        for (endOffset = startOffset; endOffset < stringTableBytes.length; ++endOffset) {
            if (stringTableBytes[endOffset] >= 128) {
                if (this._verbose) {
                    System.err.println("\tError in string table. Non ASCII character encountered.");
                }
                return null;
            }
            if (stringTableBytes[endOffset] == 0) break;
        }
        if (stringTableBytes[endOffset] != 0) {
            if (this._verbose) {
                System.err.println("\tError in string table. The string is not terminated.");
            }
            return null;
        }
        try {
            String result = new String(stringTableBytes, startOffset, endOffset - startOffset, "ASCII");
            return result;
        }
        catch (UnsupportedEncodingException exception) {
            System.err.println("Error (UnsupportedEncodingException) converting string table characters. The core file is invalid and the results may unpredictable");
        }
        catch (IndexOutOfBoundsException exception) {
            System.err.println("Error (IndexOutOfBoundsException) converting string table characters. The core file is invalid and the results may unpredictable");
        }
        return null;
    }

    private Properties getEnvironmentVariables(Builder builder) throws MemoryAccessException, IOException {
        long environmentAddress = builder.getEnvironmentAddress();
        if (0L == environmentAddress) {
            return null;
        }
        ArrayList<Address> addresses = new ArrayList<Address>();
        this.seekToAddress(environmentAddress);
        Address address = this._file.readElfWordAsAddress();
        try {
            this.seekToAddress(address.asAddress());
            address = this._file.readElfWordAsAddress();
            while (!address.isNil()) {
                addresses.add(address);
                address = this._file.readElfWordAsAddress();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        Properties environment = new Properties();
        for (Address variable : addresses) {
            StringBuffer buffer = new StringBuffer();
            try {
                this.seekToAddress(variable.asAddress());
            }
            catch (IOException e) {
                continue;
            }
            byte b = this.coreReadByte();
            while (0 != b) {
                buffer.append(new String(new byte[]{b}, "ASCII"));
                b = this.coreReadByte();
            }
            String pair = buffer.toString();
            int equal = pair.indexOf(61);
            if (equal == -1) continue;
            String key = pair.substring(0, equal);
            String value = pair.substring(equal + 1);
            environment.put(key, value);
        }
        return environment;
    }

    private long readUID() throws IOException {
        return this._file.readUID();
    }

    private Object readThread(DataEntry entry, Builder builder, Object addressSpace) throws IOException, MemoryAccessException {
        this._file.seek(entry.offset);
        int signalNumber = this._file.readInt();
        this._file.readInt();
        this._file.readInt();
        this._file.readShort();
        this._file.readShort();
        this._file.readElfWord();
        this._file.readElfWord();
        long pid = (long)this._file.readInt() & 0xFFFFFFFFL;
        this._file.readInt();
        this._file.readInt();
        this._file.readInt();
        long utimeSec = this._file.readElfWord();
        long utimeUSec = this._file.readElfWord();
        long stimeSec = this._file.readElfWord();
        long stimeUSec = this._file.readElfWord();
        this._file.readElfWord();
        this._file.readElfWord();
        this._file.readElfWord();
        this._file.readElfWord();
        Map registers = this._file.readRegisters(builder, addressSpace);
        Properties properties = new Properties();
        properties.setProperty("Thread user time secs", Long.toString(utimeSec));
        properties.setProperty("Thread user time usecs", Long.toString(utimeUSec));
        properties.setProperty("Thread sys time secs", Long.toString(stimeSec));
        properties.setProperty("Thread sys time usecs", Long.toString(stimeUSec));
        return this.buildThread(builder, addressSpace, String.valueOf(pid), registers, properties, signalNumber);
    }

    private Object buildThread(Builder builder, Object addressSpace, String pid, Map registers, Properties properties, int signalNumber) throws MemoryAccessException, IOException {
        ArrayList<Object> frames = new ArrayList<Object>();
        ArrayList<Object> sections = new ArrayList<Object>();
        long stackPointer = this._file.getStackPointerFrom(registers).asAddress();
        long basePointer = this._file.getBasePointerFrom(registers).asAddress();
        long instructionPointer = this._file.getInstructionPointerFrom(registers).asAddress();
        long previousBasePointer = 0L;
        if (0L == instructionPointer || !this.isValidAddressInProcess(instructionPointer)) {
            instructionPointer = this._file.getLinkRegisterFrom(registers).asAddress();
        }
        if (0L != instructionPointer && 0L != basePointer && this.isValidAddressInProcess(instructionPointer) && this.isValidAddressInProcess(stackPointer)) {
            MemoryRange range = this.memoryRangeFor(stackPointer);
            sections.add(builder.buildStackSection(addressSpace, range.getVirtualAddress(), range.getVirtualAddress() + range.getSize()));
            frames.add(builder.buildStackFrame(addressSpace, basePointer, instructionPointer));
            try {
                while (range.contains(basePointer) && basePointer != previousBasePointer) {
                    previousBasePointer = basePointer;
                    this.seekToAddress(basePointer);
                    basePointer = this.coreReadAddress();
                    instructionPointer = this.coreReadAddress();
                    frames.add(builder.buildStackFrame(addressSpace, basePointer, instructionPointer));
                }
            }
            catch (IOException e) {
                frames.add(builder.buildCorruptData(addressSpace, "Linux ELF core dump corruption detected during native stack frame walk", basePointer));
            }
        }
        return builder.buildThread(pid, this.registersAsList(builder, registers).iterator(), sections.iterator(), frames.iterator(), properties, signalNumber);
    }

    private List registersAsList(Builder builder, Map registers) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Map.Entry entry : registers.entrySet()) {
            Address value = (Address)entry.getValue();
            list.add(builder.buildRegister((String)entry.getKey(), value.asNumber()));
        }
        return list;
    }

    private NewElfDump(ElfFile file, DumpReader reader, boolean isLittleEndian, boolean is64Bit, boolean verbose) {
        super(reader);
        this._file = file;
        this._isLittleEndian = isLittleEndian;
        this._is64Bit = is64Bit;
        this._verbose = verbose;
        Iterator iter = this._file.programHeaderEntries();
        while (iter.hasNext()) {
            ProgramHeaderEntry entry = (ProgramHeaderEntry)iter.next();
            MemoryRange range = entry.asMemoryRange();
            if (null == range) continue;
            this._memoryRanges.add(range);
        }
    }

    private ElfFile elfFileFrom(ClosingFileReader file) throws IOException {
        DumpReader reader;
        ElfFile result;
        file.seek(0L);
        byte[] signature = new byte[16];
        file.readFully(signature);
        if (-1 != new String(signature).toLowerCase().indexOf("elf") && (result = NewElfDump.fileForClass(signature[4], reader = NewElfDump.readerForEndianess(signature[5], signature[4], file))).getClass().isInstance(this._file)) {
            return result;
        }
        return null;
    }

    private static DumpReader readerForEndianess(byte endianess, byte clazz, ImageInputStream stream) throws IOException {
        boolean is64Bit;
        boolean bl = is64Bit = 2 == clazz;
        if (!is64Bit && 1 != clazz) {
            throw new IOException("Unexpected class flag " + clazz + " detected in ELF file.");
        }
        if (1 == endianess) {
            return new LittleEndianDumpReader(stream, is64Bit);
        }
        if (2 == endianess) {
            return new DumpReader(stream, is64Bit);
        }
        throw new IOException("Unknown endianess flag " + endianess + " in ELF core file");
    }

    private static ElfFile fileForClass(byte clazz, DumpReader reader) throws IOException {
        if (1 == clazz) {
            return new Elf32File(reader);
        }
        if (2 == clazz) {
            return new Elf64File(reader);
        }
        throw new IOException("Unexpected class flag " + clazz + " detected in ELF file.");
    }

    public void extract(Builder builder) {
        try {
            DataEntry entry;
            Object addressSpace = builder.buildAddressSpace("ELF Address Space", 0);
            ArrayList<Object> threads = new ArrayList<Object>();
            Iterator iter = this._file.threadEntries();
            while (iter.hasNext()) {
                DataEntry entry2 = (DataEntry)iter.next();
                threads.add(this.readThread(entry2, builder, addressSpace));
            }
            ArrayList<Object> processes = new ArrayList<Object>();
            Iterator iter2 = this._file.processEntries();
            while (iter2.hasNext()) {
                entry = (DataEntry)iter2.next();
                processes.add(this.readProcess(entry, builder, addressSpace, threads));
            }
            iter2 = this._file.auxiliaryVectorEntries();
            while (iter2.hasNext()) {
                entry = (DataEntry)iter2.next();
                this.readAuxiliaryVector(entry);
            }
            builder.setOSType("ELF");
            builder.setCPUType(this._file._arch.toString());
            builder.setCPUSubType(this.readStringAt(this._platformIdAddress));
        }
        catch (IOException e) {
        }
        catch (MemoryAccessException e) {
        }
        catch (CorruptCoreException corruptCoreException) {
            // empty catch block
        }
    }

    private void readAuxiliaryVector(DataEntry entry) throws IOException {
        this._file.seek(entry.offset);
        if (0L != entry.size) {
            long type = this._file.readElfWord();
            while (0L != type) {
                if (15L == type) {
                    this._platformIdAddress = this._file.readElfWord();
                } else if (9L == type) {
                    this._file.readElfWord();
                } else if (16L == type) {
                    this._file.readElfWord();
                } else {
                    this._file.readElfWord();
                }
                type = this._file.readElfWord();
            }
        }
    }

    private String readStringAt(long address) throws IOException {
        String toReturn = null;
        if (this.isValidAddress(address)) {
            StringBuffer buf = new StringBuffer();
            this.seekToAddress(address);
            byte b = this.coreReadByte();
            long i = 1L;
            while (0 != b) {
                buf.append(new String(new byte[]{b}, "ASCII"));
                b = this.coreReadByte();
                ++i;
            }
            toReturn = buf.toString();
        }
        return toReturn;
    }

    public static boolean isSupportedDump(ImageInputStream stream) throws IOException {
        stream.seek(0L);
        byte[] signature = new byte[16];
        stream.readFully(signature);
        return -1 != new String(signature).toLowerCase().indexOf("elf");
    }

    public static ICoreFileReader dumpFromFile(ImageInputStream stream, boolean verbose) throws IOException {
        assert (NewElfDump.isSupportedDump(stream));
        stream.seek(0L);
        byte[] signature = new byte[16];
        stream.readFully(signature);
        boolean isLittleEndian = 1 == signature[5];
        boolean is64Bit = 2 == signature[4];
        DumpReader reader = NewElfDump.readerForEndianess(signature[5], signature[4], stream);
        ElfFile file = NewElfDump.fileForClass(signature[4], reader);
        return new NewElfDump(file, reader, isLittleEndian, is64Bit, verbose);
    }

    public Iterator getAdditionalFileNames() {
        return this._additionalFileNames.iterator();
    }

    protected MemoryRange[] getMemoryRangesAsArray() {
        return this._memoryRanges.toArray(new MemoryRange[this._memoryRanges.size()]);
    }

    protected boolean isLittleEndian() {
        return this._isLittleEndian;
    }

    protected boolean is64Bit() {
        return this._is64Bit;
    }

    private static abstract class Address {
        private long _value;

        private Address(long value) {
            this._value = value;
        }

        long getValue() {
            return this._value;
        }

        abstract Address add(long var1);

        boolean isNil() {
            return 0L == this.getValue();
        }

        abstract Number asNumber();

        abstract long asAddress();

        abstract Address nil();
    }

    private static class Address31
    extends Address32 {
        Address31(int value) {
            super(value);
        }

        long asAddress() {
            int address = Integer.MAX_VALUE & (int)this.getValue();
            return address;
        }
    }

    private static class Address32
    extends Address {
        Address32(int value) {
            super((long)value & 0xFFFFFFFFL);
        }

        Address add(long offset) {
            long result = this.getValue() + offset;
            return new Address32((int)result);
        }

        Number asNumber() {
            return new Integer((int)this.getValue());
        }

        long asAddress() {
            return this.getValue();
        }

        Address nil() {
            return new Address32(0);
        }
    }

    private static class Address64
    extends Address {
        Address64(long value) {
            super(value);
        }

        Address add(long offset) {
            return new Address64(this.getValue() + offset);
        }

        Number asNumber() {
            return new Long(this.getValue());
        }

        long asAddress() {
            return this.getValue();
        }

        Address nil() {
            return new Address64(0L);
        }
    }

    private static interface Arch {
        public Map readRegisters(ElfFile var1, Builder var2, Object var3) throws IOException;

        public long readUID(ElfFile var1) throws IOException;

        public Address getStackPointerFrom(Map var1);

        public Address getBasePointerFrom(Map var1);

        public Address getInstructionPointerFrom(Map var1);

        public Address getLinkRegisterFrom(Map var1);
    }

    private static class ArchAMD64
    implements Arch {
        private ArchAMD64() {
        }

        public Map readRegisters(ElfFile file, Builder builder, Object addressSpace) throws IOException {
            int i;
            String[] names1 = new String[]{"r15", "r14", "r13", "r12", "rbp", "rbx", "r11", "r10", "r9", "r8", "rax", "rcx", "rdx", "rsi", "rdi"};
            String[] names2 = new String[]{"rip", "cs", "eflags", "rsp", "ss", "fs_base", "gs_base", "ds", "es", "fs", "gs"};
            TreeMap<String, Address64> registers = new TreeMap<String, Address64>();
            for (i = 0; i < names1.length; ++i) {
                registers.put(names1[i], new Address64(file.readLong()));
            }
            file.readLong();
            for (i = 0; i < names2.length; ++i) {
                registers.put(names2[i], new Address64(file.readLong()));
            }
            return registers;
        }

        public Address getStackPointerFrom(Map registers) {
            return (Address)registers.get("rsp");
        }

        public Address getBasePointerFrom(Map registers) {
            return (Address)registers.get("rbp");
        }

        public Address getInstructionPointerFrom(Map registers) {
            return (Address)registers.get("rip");
        }

        public Address getLinkRegisterFrom(Map registers) {
            return new Address64(0L);
        }

        public long readUID(ElfFile file) throws IOException {
            return (long)file.readInt() & 0xFFFFFFFFL;
        }
    }

    private static class ArchIA32
    implements Arch {
        private ArchIA32() {
        }

        public Map readRegisters(ElfFile file, Builder builder, Object addressSpace) throws IOException {
            int i;
            String[] names1 = new String[]{"ebx", "ecx", "edx", "esi", "edi", "ebp", "eax", "ds", "es", "fs", "gs"};
            String[] names2 = new String[]{"eip", "cs", "efl", "esp", "ss"};
            TreeMap<String, Address32> registers = new TreeMap<String, Address32>();
            for (i = 0; i < names1.length; ++i) {
                registers.put(names1[i], new Address32(file.readInt()));
            }
            file.readInt();
            for (i = 0; i < names2.length; ++i) {
                registers.put(names2[i], new Address32(file.readInt()));
            }
            return registers;
        }

        public Address getStackPointerFrom(Map registers) {
            return (Address)registers.get("esp");
        }

        public Address getBasePointerFrom(Map registers) {
            return (Address)registers.get("ebp");
        }

        public Address getInstructionPointerFrom(Map registers) {
            return (Address)registers.get("eip");
        }

        public Address getLinkRegisterFrom(Map registers) {
            return new Address32(0);
        }

        public long readUID(ElfFile file) throws IOException {
            return (long)file.readShort() & 0xFFFFL;
        }
    }

    private static class ArchIA64
    implements Arch {
        private ArchIA64() {
        }

        public Map readRegisters(ElfFile file, Builder builder, Object addressSpace) throws IOException {
            for (int i = 0; i < 32; ++i) {
                file.readLong();
            }
            TreeMap<String, Address64> registers = new TreeMap<String, Address64>();
            registers.put("nat", new Address64(file.readLong()));
            registers.put("pr", new Address64(file.readLong()));
            for (int i = 0; i < 8; ++i) {
                file.readLong();
            }
            String[] names = new String[]{"ip", "cfm", "psr", "rsc", "bsp", "bspstore", "rnat", "ccv", "unat", "fpsr", "pfs", "lc", "ec"};
            for (int i = 0; i < names.length; ++i) {
                registers.put(names[i], new Address64(file.readLong()));
            }
            return registers;
        }

        public Address getStackPointerFrom(Map registers) {
            return new Address64(0L);
        }

        public Address getBasePointerFrom(Map registers) {
            return new Address64(0L);
        }

        public Address getInstructionPointerFrom(Map registers) {
            return new Address64(0L);
        }

        public Address getLinkRegisterFrom(Map registers) {
            return new Address64(0L);
        }

        public long readUID(ElfFile file) throws IOException {
            return (long)file.readInt() & 0xFFFFFFFFL;
        }
    }

    private static class ArchPPC32
    extends ArchPPC64 {
        private ArchPPC32() {
        }

        public Map readRegisters(ElfFile file, Builder builder, Object addressSpace) throws IOException {
            TreeMap<String, Address> registers = new TreeMap<String, Address>();
            for (int i = 0; i < 32; ++i) {
                registers.put("gpr" + i, file.readElfWordAsAddress());
            }
            registers.put("pc", file.readElfWordAsAddress());
            file.readElfWordAsAddress();
            file.readElfWordAsAddress();
            registers.put("ctr", file.readElfWordAsAddress());
            registers.put("lr", file.readElfWordAsAddress());
            registers.put("xer", file.readElfWordAsAddress());
            registers.put("cr", file.readElfWordAsAddress());
            return registers;
        }

        public long readUID(ElfFile file) throws IOException {
            return (long)file.readShort() & 0xFFFFL;
        }
    }

    private static class ArchPPC64
    implements Arch {
        private ArchPPC64() {
        }

        public Map readRegisters(ElfFile file, Builder builder, Object addressSpace) throws IOException {
            TreeMap<String, Address> registers = new TreeMap<String, Address>();
            for (int i = 0; i < 32; ++i) {
                registers.put("gpr" + i, file.readElfWordAsAddress());
            }
            registers.put("pc", file.readElfWordAsAddress());
            file.readElfWordAsAddress();
            file.readElfWordAsAddress();
            registers.put("ctr", file.readElfWordAsAddress());
            registers.put("lr", file.readElfWordAsAddress());
            long l = file.readLong() >> 32 & 0xFFFFFFFFL;
            registers.put("xer", new Address64(l));
            l = file.readLong() >> 32 & 0xFFFFFFFFL;
            registers.put("cr", new Address64(l));
            return registers;
        }

        public Address getStackPointerFrom(Map registers) {
            return (Address)registers.get("gpr1");
        }

        public Address getBasePointerFrom(Map registers) {
            return this.getStackPointerFrom(registers);
        }

        public Address getInstructionPointerFrom(Map registers) {
            return (Address)registers.get("pc");
        }

        public Address getLinkRegisterFrom(Map registers) {
            return (Address)registers.get("lr");
        }

        public long readUID(ElfFile file) throws IOException {
            return (long)file.readInt() & 0xFFFFFFFFL;
        }
    }

    private static class ArchS390
    implements Arch {
        private ArchS390() {
        }

        public Map readRegisters(ElfFile file, Builder builder, Object addressSpace) throws IOException {
            int i;
            TreeMap<String, Address> registers = new TreeMap<String, Address>();
            registers.put("mask", file.readElfWordAsAddress());
            registers.put("addr", file.readElfWordAsAddress());
            for (i = 0; i < 16; ++i) {
                registers.put("gpr" + i, file.readElfWordAsAddress());
            }
            for (i = 0; i < 16; ++i) {
                registers.put("acr" + i, file.readElfWordAsAddress());
            }
            registers.put("origgpr2", file.readElfWordAsAddress());
            registers.put("trap", file.readElfWordAsAddress());
            return registers;
        }

        public Address getStackPointerFrom(Map registers) {
            return (Address)registers.get("gpr15");
        }

        public Address getBasePointerFrom(Map registers) {
            return this.getStackPointerFrom(registers);
        }

        public Address getInstructionPointerFrom(Map registers) {
            return (Address)registers.get("addr");
        }

        public Address getLinkRegisterFrom(Map registers) {
            return this.nil(registers);
        }

        public long readUID(ElfFile file) throws IOException {
            return (long)file.readInt() & 0xFFFFFFFFL;
        }

        private Address nil(Map registers) {
            Address gpr15 = (Address)registers.get("gpr15");
            return gpr15.nil();
        }
    }

    private static class ArchS390_32
    extends ArchS390 {
        private ArchS390_32() {
        }

        public Map readRegisters(ElfFile file, Builder builder, Object addressSpace) throws IOException {
            int i;
            TreeMap<String, Address31> registers = new TreeMap<String, Address31>();
            registers.put("mask", new Address31(file.readInt()));
            registers.put("addr", new Address31(file.readInt()));
            for (i = 0; i < 16; ++i) {
                registers.put("gpr" + i, new Address31(file.readInt()));
            }
            for (i = 0; i < 16; ++i) {
                registers.put("acr" + i, new Address31(file.readInt()));
            }
            registers.put("origgpr2", new Address31(file.readInt()));
            registers.put("trap", new Address31(file.readInt()));
            registers.put("old_ilc", new Address31(file.readInt()));
            return registers;
        }

        private Address readElfWordAsAddress(ElfFile file) throws IOException {
            int address = file.readInt();
            return new Address32(address);
        }

        public long readUID(ElfFile file) throws IOException {
            return (long)file.readShort() & 0xFFFFL;
        }
    }

    private static class DataEntry {
        final long offset;
        final long size;

        DataEntry(long offset, long size) {
            this.offset = offset;
            this.size = size;
        }
    }

    private static class Elf32File
    extends ElfFile {
        protected Arch architectureFor(short s) {
            if (22 == s) {
                return new ArchS390_32();
            }
            return super.architectureFor(s);
        }

        Elf32File(DumpReader reader) throws IOException {
            super(reader);
            this.readFile();
        }

        Elf32File(DumpReader reader, long offset) throws IOException {
            super(reader, offset);
            this.readFile();
        }

        protected ProgramHeaderEntry readProgramHeaderEntry() throws IOException {
            int type = this.readInt();
            long fileOffset = this.unsigned(this.readInt());
            long virtualAddress = this.unsigned(this.readInt());
            long physicalAddress = this.unsigned(this.readInt());
            long fileSize = this.unsigned(this.readInt());
            long memorySize = this.unsigned(this.readInt());
            int flags = this.readInt();
            long alignment = this.unsigned(this.readInt());
            return new ProgramHeaderEntry(type, fileOffset, fileSize, virtualAddress, physicalAddress, memorySize, flags, alignment);
        }

        private long unsigned(int i) {
            return (long)i & 0xFFFFFFFFL;
        }

        protected long padToWordBoundary(long l) {
            return (l + 3L) / 4L * 4L;
        }

        protected long readElfWord() throws IOException {
            return (long)this.readInt() & 0xFFFFFFFFL;
        }

        protected Address readElfWordAsAddress() throws IOException {
            return new Address32(this.readInt());
        }

        int addressSize() {
            return 32;
        }

        Iterator readSymbolsAt(SectionHeaderEntry entry) throws IOException {
            this.seek(entry.offset);
            ArrayList<Symbol> symbols = new ArrayList<Symbol>();
            long count = entry.size / 16L;
            for (long i = 0L; i < count; ++i) {
                long name = (long)this.readInt() & 0xFFFFFFFFL;
                long value = (long)this.readInt() & 0xFFFFFFFFL;
                long size = (long)this.readInt() & 0xFFFFFFFFL;
                byte info = this.readByte();
                byte other = this.readByte();
                int sectionIndex = this.readShort() & 0xFFFF;
                symbols.add(new Symbol(name, value, size, info, other, sectionIndex));
            }
            return symbols.iterator();
        }
    }

    private static class Elf64File
    extends ElfFile {
        Elf64File(DumpReader reader) throws IOException {
            super(reader);
            this.readFile();
        }

        Elf64File(DumpReader reader, long offset) throws IOException {
            super(reader, offset);
            this.readFile();
        }

        protected ProgramHeaderEntry readProgramHeaderEntry() throws IOException {
            int type = this.readInt();
            int flags = this.readInt();
            long fileOffset = this.readLong();
            long virtualAddress = this.readLong();
            long physicalAddress = this.readLong();
            long fileSize = this.readLong();
            long memorySize = this.readLong();
            long alignment = this.readLong();
            return new ProgramHeaderEntry(type, fileOffset, fileSize, virtualAddress, physicalAddress, memorySize, flags, alignment);
        }

        protected long padToWordBoundary(long l) {
            return (l + 7L) / 8L * 8L;
        }

        protected long readElfWord() throws IOException {
            return this.readLong();
        }

        protected Address readElfWordAsAddress() throws IOException {
            return new Address64(this.readLong());
        }

        int addressSize() {
            return 64;
        }

        Iterator readSymbolsAt(SectionHeaderEntry entry) throws IOException {
            this.seek(entry.offset);
            ArrayList<Symbol> symbols = new ArrayList<Symbol>();
            long count = entry.size / 24L;
            for (long i = 0L; i < count; ++i) {
                long name = (long)this.readInt() & 0xFFFFFFFFL;
                byte info = this.readByte();
                byte other = this.readByte();
                int sectionIndex = this.readShort() & 0xFFFF;
                long value = this.readLong();
                long size = this.readLong();
                symbols.add(new Symbol(name, value, size, info, other, sectionIndex));
            }
            return symbols.iterator();
        }
    }

    private static abstract class ElfFile {
        private DumpReader _reader;
        private long _offset = 0L;
        private Arch _arch = null;
        private long _programHeaderOffset = -1L;
        private long _sectionHeaderOffset = -1L;
        private short _programHeaderEntrySize = 0;
        private short _programHeaderCount = 0;
        private short _sectionHeaderEntrySize = 0;
        private short _sectionHeaderCount = 0;
        private List _processEntries = new ArrayList();
        private List _threadEntries = new ArrayList();
        private List _auxiliaryVectorEntries = new ArrayList();
        private List _programHeaderEntries = new ArrayList();
        private List _sectionHeaderEntries = new ArrayList();
        private short _objectType = 0;
        private int _version = 0;
        private int _e_flags = 0;
        private static final short ET_NONE = 0;
        private static final short ET_REL = 1;
        private static final short ET_EXEC = 2;
        private static final short ET_DYN = 3;
        private static final short ET_CORE = 4;
        private static final short ET_NUM = 5;
        private static final int ET_LOOS = 65024;
        private static final int ET_HIOS = 65279;
        private static final int ET_LOPROC = 65280;
        private static final int ET_HIPROC = 65535;

        protected abstract long padToWordBoundary(long var1);

        protected abstract ProgramHeaderEntry readProgramHeaderEntry() throws IOException;

        protected abstract long readElfWord() throws IOException;

        protected abstract Address readElfWordAsAddress() throws IOException;

        ElfFile(DumpReader reader) {
            this._reader = reader;
        }

        ElfFile(DumpReader reader, long offset) {
            this._reader = reader;
            this._offset = offset;
        }

        Iterator processEntries() {
            return this._processEntries.iterator();
        }

        Iterator threadEntries() {
            return this._threadEntries.iterator();
        }

        Iterator auxiliaryVectorEntries() {
            return this._auxiliaryVectorEntries.iterator();
        }

        Iterator programHeaderEntries() {
            return this._programHeaderEntries.iterator();
        }

        Iterator sectionHeaderEntries() {
            return this._sectionHeaderEntries.iterator();
        }

        SectionHeaderEntry sectionHeaderEntryAt(int i) {
            return (SectionHeaderEntry)this._sectionHeaderEntries.get(i);
        }

        protected void readFile() throws IOException {
            this.seek(0L);
            this.readHeader();
            this.readSectionHeader();
            this.readProgramHeader();
        }

        public static boolean isELF(byte[] signature) {
            return 127 == signature[0] && 69 == signature[1] && 76 == signature[2] && 70 == signature[3];
        }

        private void readHeader() throws IOException {
            byte[] signature = this.readBytes(16);
            if (!ElfFile.isELF(signature)) {
                throw new IOException("Missing ELF magic number");
            }
            this._objectType = this.readShort();
            short machineType = this.readShort();
            this._arch = this.architectureFor(machineType);
            this._version = this.readInt();
            this.readElfWord();
            this._programHeaderOffset = this.readElfWord();
            this._sectionHeaderOffset = this.readElfWord();
            this._e_flags = this.readInt();
            this.readShort();
            this._programHeaderEntrySize = this.readShort();
            this._programHeaderCount = this.readShort();
            this._sectionHeaderEntrySize = this.readShort();
            this._sectionHeaderCount = this.readShort();
            this.readShort();
        }

        protected Arch architectureFor(short s) {
            switch (s) {
                case 20: {
                    return new ArchPPC32();
                }
                case 21: {
                    return new ArchPPC64();
                }
                case 50: {
                    return new ArchIA64();
                }
                case 22: {
                    return new ArchS390();
                }
                case 3: {
                    return new ArchIA32();
                }
                case 62: {
                    return new ArchAMD64();
                }
            }
            return null;
        }

        private SectionHeaderEntry readSectionHeaderEntry() throws IOException {
            long name = (long)this.readInt() & 0xFFFFFFFFL;
            long type = (long)this.readInt() & 0xFFFFFFFFL;
            long flags = this.readElfWord();
            long address = this.readElfWord();
            long offset = this.readElfWord();
            long size = this.readElfWord();
            long link = (long)this.readInt() & 0xFFFFFFFFL;
            long info = (long)this.readInt() & 0xFFFFFFFFL;
            return new SectionHeaderEntry(name, type, flags, address, offset, size, link, info);
        }

        private void readSectionHeader() throws IOException {
            for (int i = 0; i < this._sectionHeaderCount; ++i) {
                this.seek(this._sectionHeaderOffset + (long)(i * this._sectionHeaderEntrySize));
                SectionHeaderEntry entry = this.readSectionHeaderEntry();
                this._sectionHeaderEntries.add(entry);
            }
        }

        private void readProgramHeader() throws IOException {
            for (int i = 0; i < this._programHeaderCount; ++i) {
                this.seek(this._programHeaderOffset + (long)(i * this._programHeaderEntrySize));
                this._programHeaderEntries.add(this.readProgramHeaderEntry());
            }
            for (ProgramHeaderEntry entry : this._programHeaderEntries) {
                if (!entry.isNote()) continue;
                this.readNotes(entry);
            }
        }

        private void readNotes(ProgramHeaderEntry entry) throws IOException {
            long offset = entry.fileOffset;
            long limit = offset + entry.fileSize;
            while (offset < limit) {
                offset = this.readNote(offset);
            }
        }

        private long readNote(long offset) throws IOException {
            this.seek(offset);
            long nameLength = this.padToWordBoundary(this.readInt());
            long dataSize = this.readInt();
            long type = this.readInt();
            long dataOffset = offset + 12L + nameLength;
            if (1L == type) {
                this.addThreadEntry(dataOffset, dataSize);
            } else if (3L == type) {
                this.addProcessEntry(dataOffset, dataSize);
            } else if (6L == type) {
                this.addAuxiliaryVectorEntry(dataOffset, dataSize);
            }
            return dataOffset + this.padToWordBoundary(dataSize);
        }

        protected void addProcessEntry(long offset, long size) {
            this._processEntries.add(new DataEntry(offset, size));
        }

        protected void addThreadEntry(long offset, long size) {
            this._threadEntries.add(new DataEntry(offset, size));
        }

        private void addAuxiliaryVectorEntry(long offset, long size) {
            this._auxiliaryVectorEntries.add(new DataEntry(offset, size));
        }

        protected byte readByte() throws IOException {
            return this._reader.readByte();
        }

        protected byte[] readBytes(int n) throws IOException {
            return this._reader.readBytes(n);
        }

        private String readStringAtAddress(long address) throws IOException {
            String toReturn = null;
            StringBuffer buf = new StringBuffer();
            this.seekToAddress(address);
            byte b = this.readByte();
            long i = 1L;
            while (0 != b) {
                buf.append(new String(new byte[]{b}, "ASCII"));
                b = this.readByte();
                ++i;
            }
            toReturn = buf.toString();
            return toReturn;
        }

        protected int readInt() throws IOException {
            return this._reader.readInt();
        }

        protected long readLong() throws IOException {
            return this._reader.readLong();
        }

        protected short readShort() throws IOException {
            return this._reader.readShort();
        }

        protected void seek(long position) throws IOException {
            this._reader.seek(position + this._offset);
        }

        long readUID() throws IOException {
            return this._arch.readUID(this);
        }

        Address getStackPointerFrom(Map registers) {
            return this._arch.getStackPointerFrom(registers);
        }

        Address getBasePointerFrom(Map registers) {
            return this._arch.getBasePointerFrom(registers);
        }

        Address getInstructionPointerFrom(Map registers) {
            return this._arch.getInstructionPointerFrom(registers);
        }

        Address getLinkRegisterFrom(Map registers) {
            return this._arch.getLinkRegisterFrom(registers);
        }

        Map readRegisters(Builder builder, Object addressSpace) throws IOException {
            return this._arch.readRegisters(this, builder, addressSpace);
        }

        abstract Iterator readSymbolsAt(SectionHeaderEntry var1) throws IOException;

        abstract int addressSize();

        public Properties getProperties() {
            Properties props = new Properties();
            props.setProperty("Object file type", this._nameForFileType(this._objectType));
            props.setProperty("Object file version", Integer.toHexString(this._version));
            props.setProperty("Processor-specific flags", Integer.toHexString(this._e_flags));
            return props;
        }

        private String _nameForFileType(short type) {
            String fileType = "Unknown";
            int typeAsInt = 0xFFFF & type;
            if (0 == type) {
                fileType = "No file type";
            } else if (1 == type) {
                fileType = "Relocatable file";
            } else if (2 == type) {
                fileType = "Executable file";
            } else if (3 == type) {
                fileType = "Shared object file";
            } else if (4 == type) {
                fileType = "Core file";
            } else if (5 == type) {
                fileType = "Number of defined types";
            } else if (65024 <= typeAsInt && typeAsInt <= 65279) {
                fileType = "OS-specific (" + Integer.toHexString(typeAsInt) + ")";
            } else if (65280 <= typeAsInt && typeAsInt <= 65535) {
                fileType = "Processor-specific (" + Integer.toHexString(typeAsInt) + ")";
            }
            return fileType;
        }

        private void seekToAddress(long address) throws IOException {
            ProgramHeaderEntry matchedEntry = null;
            Iterator iter = this.programHeaderEntries();
            while (iter.hasNext()) {
                ProgramHeaderEntry element = (ProgramHeaderEntry)iter.next();
                if (!element.contains(address)) continue;
                assert (null == matchedEntry) : "Multiple mappings for the same address";
                matchedEntry = element;
            }
            if (null == matchedEntry) {
                throw new IOException("No ProgramHeaderEntry found for address");
            }
            this.seek(matchedEntry.fileOffset + (address - matchedEntry.virtualAddress));
        }

        public String getSONAME() throws IOException {
            Object e;
            ProgramHeaderEntry entry;
            String soname = null;
            Iterator i$ = this._programHeaderEntries.iterator();
            while (i$.hasNext() && (!(entry = (ProgramHeaderEntry)(e = i$.next())).isDynamic() || (soname = this.readSONAMEFromProgramHeader(entry)) == null)) {
            }
            return soname;
        }

        private String readSONAMEFromProgramHeader(ProgramHeaderEntry entry) throws IOException {
            long tag;
            long imageStart = entry.fileOffset;
            this.seek(imageStart);
            long sonameAddress = -1L;
            long strtabAddress = -1L;
            do {
                tag = this.readElfWord();
                long address = this.readElfWord();
                if (!(tag >= 0L && tag <= 33L || tag >= 0x60000000L && tag <= 0x6FFFFFFFL) && (tag < 0x70000000L || tag > Integer.MAX_VALUE)) break;
                if (tag == 14L) {
                    sonameAddress = address;
                    continue;
                }
                if (tag != 5L) continue;
                strtabAddress = address;
            } while (tag != 0L);
            if (sonameAddress > -1L && strtabAddress > -1L) {
                String soname = this.readStringAtAddress(strtabAddress + sonameAddress);
                return soname;
            }
            return null;
        }
    }

    private static class ProgramHeaderEntry {
        private static final int PT_LOAD = 1;
        private static final int PT_DYNAMIC = 2;
        private static final int PT_NOTE = 4;
        private static final int PF_X = 1;
        private static final int PF_W = 2;
        private int _type;
        final long fileOffset;
        final long fileSize;
        final long virtualAddress;
        final long memorySize;
        private int _flags;

        ProgramHeaderEntry(int type, long fileOffset, long fileSize, long virtualAddress, long physicalAddress, long memorySize, int flags, long alignment) {
            this._type = type;
            this.fileOffset = fileOffset;
            this.fileSize = fileSize;
            this.virtualAddress = virtualAddress;
            this.memorySize = memorySize;
            this._flags = flags;
        }

        boolean isEmpty() {
            return 0L == this.fileSize;
        }

        boolean isDynamic() {
            return 2 == this._type;
        }

        boolean isLoadable() {
            return 1 == this._type;
        }

        boolean isNote() {
            return 4 == this._type;
        }

        MemoryRange asMemoryRange() {
            boolean w = (this._flags & 2) != 0;
            boolean x = (this._flags & 1) != 0;
            return new MemoryRange(this.virtualAddress, this.fileOffset, this.memorySize, 0, false, !w, x, !this.isEmpty());
        }

        boolean validInProcess(long address) {
            return this.virtualAddress <= address && address < this.virtualAddress + this.memorySize;
        }

        boolean contains(long address) {
            return false == this.isEmpty() && this.validInProcess(address);
        }
    }

    private static class SectionHeaderEntry {
        private static final int SHT_SYMTAB = 2;
        private static final int SHT_DYNSYM = 11;
        private long _name;
        private long _type;
        final long offset;
        final long size;
        final long link;

        SectionHeaderEntry(long name, long type, long flags, long address, long offset, long size, long link, long info) {
            this._name = name;
            this._type = type;
            this.offset = offset;
            this.size = size;
            this.link = link;
        }

        boolean isSymbolTable() {
            return 2L == this._type || 11L == this._type;
        }
    }

    private static class Symbol {
        private static final byte STT_FUNC = 2;
        private static final byte ST_TYPE_MASK = 15;
        final long name;
        final long value;
        private byte _info;

        Symbol(long name, long value, long size, byte info, byte other, int sectionIndex) {
            this.name = name;
            this.value = value;
            this._info = info;
        }

        boolean isFunction() {
            return 2 == (this._info & 0xF);
        }
    }
}

