/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.image.j9;

import com.ibm.dtfj.corereaders.ResourceReleaser;
import com.ibm.dtfj.image.j9.IFileLocationResolver;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipExtractionResolver
implements IFileLocationResolver,
ResourceReleaser {
    private ZipFile _container;
    private Map _openFilesByName = new HashMap();
    private List _deletables = new Vector();

    public ZipExtractionResolver(ZipFile zip) {
        this._container = zip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File findFileWithFullPath(String fullPath) throws FileNotFoundException {
        String tempname = "";
        String name = new File(fullPath).getName();
        File knownFile = (File)this._openFilesByName.get(fullPath);
        if (null == knownFile) {
            ZipEntry entry = this._container.getEntry(fullPath);
            if (null == entry) {
                entry = this._container.getEntry(name);
            }
            if (null == entry) {
                throw new FileNotFoundException("No ZIP entry with name: \"" + fullPath + "\"");
            }
            File temp = null;
            InputStream zipContent = null;
            FileOutputStream output = null;
            int size = 0;
            byte[] buffer = new byte[4096];
            try {
                temp = File.createTempFile(name, ".dtfj");
                tempname = temp.getAbsolutePath();
                temp.deleteOnExit();
                this._deletables.add(temp);
            }
            catch (IOException e) {
                FileNotFoundException fnf = new FileNotFoundException("Unable to open temporary file: " + e.getMessage());
                fnf.setStackTrace(e.getStackTrace());
                throw fnf;
            }
            try {
                zipContent = this._container.getInputStream(entry);
                output = new FileOutputStream(temp);
            }
            catch (IOException e) {
                FileNotFoundException fnf = new FileNotFoundException("Unable to locate ZIP entry: " + entry.getName() + " : " + e.getMessage());
                fnf.setStackTrace(e.getStackTrace());
                throw fnf;
            }
            try {
                size = zipContent.read(buffer);
            }
            catch (IOException e) {
                FileNotFoundException fnf = new FileNotFoundException("Unable to read ZIP entry: " + entry.getName() + " : " + e.getMessage());
                fnf.setStackTrace(e.getStackTrace());
                throw fnf;
            }
            boolean deleteAfterClose = false;
            try {
                do {
                    try {
                        output.write(buffer, 0, size);
                    }
                    catch (IOException e) {
                        deleteAfterClose = true;
                        FileNotFoundException fnf = new FileNotFoundException("Unable to write: " + entry.getName() + " to " + tempname + " : " + e.getMessage());
                        fnf.setStackTrace(e.getStackTrace());
                        throw fnf;
                    }
                    try {
                        size = zipContent.read(buffer);
                    }
                    catch (IOException e) {
                        deleteAfterClose = true;
                        FileNotFoundException fnf = new FileNotFoundException("Unable to read ZIP entry: " + entry.getName() + " : " + e.getMessage());
                        fnf.setStackTrace(e.getStackTrace());
                        throw fnf;
                    }
                } while (size > 0);
            }
            finally {
                try {
                    output.close();
                    if (deleteAfterClose) {
                        temp.deleteOnExit();
                        temp.delete();
                    }
                }
                catch (IOException e) {
                    FileNotFoundException fnf = new FileNotFoundException("Unable to close file: " + e.getMessage());
                    fnf.setStackTrace(e.getStackTrace());
                    throw fnf;
                }
            }
            this._openFilesByName.put(fullPath, temp);
            knownFile = temp;
            Logger.getLogger("com.ibm.dtfj.log").fine("Extracted " + fullPath + " to " + temp.getAbsolutePath());
        }
        return knownFile;
    }

    public File decompressCoreFile() throws FileNotFoundException {
        String coreName = this._baseCoreName();
        if (null != coreName) {
            return this.findFileWithFullPath(coreName);
        }
        throw new FileNotFoundException("Couldn't find a file resembling a core file inside the zip");
    }

    private String _baseCoreName() {
        String coreName = null;
        Enumeration<? extends ZipEntry> outer = this._container.entries();
        String zipName = this._container.getName();
        while (null == coreName && outer.hasMoreElements()) {
            ZipEntry outerEntry = outer.nextElement();
            String outerName = outerEntry.getName();
            if (zipName.equals(outerName + ".zip")) {
                coreName = outerName;
                continue;
            }
            ZipEntry innerEntry = this._container.getEntry(outerName + ".xml");
            if (null == innerEntry) continue;
            coreName = outerName;
        }
        return coreName;
    }

    public InputStream decompressMetaDataStream() throws IOException, FileNotFoundException {
        InputStream streamData = null;
        String coreName = this._baseCoreName();
        if (null == coreName) {
            throw new FileNotFoundException("Couldn't find a file resembling a JExtract XML index file inside the zip");
        }
        streamData = this._container.getInputStream(this._container.getEntry(coreName + ".xml"));
        return streamData;
    }

    public void closeOpenFiles() throws IOException {
        if (this._container != null) {
            this._container.close();
        }
    }

    public Iterator getCreatedFiles() {
        return this._deletables.iterator();
    }

    public void releaseResources() throws IOException {
        this.closeOpenFiles();
        Iterator i = this.getCreatedFiles();
        File f = null;
        while (i.hasNext() && (f = (File)i.next()) != null) {
            String logMessage = "ZIP resource " + f.getAbsolutePath() + " ";
            if (f.delete()) {
                logMessage = logMessage + "deleted successfully.";
            } else {
                logMessage = logMessage + "could not be deleted. Marking for deletion at shutdown.";
                f.deleteOnExit();
            }
            Logger.getLogger("com.ibm.dtfj.log").fine(logMessage);
        }
    }
}

