/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.javacore;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.javacore.JCCorruptData;
import com.ibm.dtfj.java.JavaMonitor;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaThread;
import com.ibm.dtfj.java.javacore.JCInvalidArgumentsException;
import com.ibm.dtfj.java.javacore.JCJavaRuntime;
import com.ibm.dtfj.java.javacore.JCJavaThread;
import java.util.Iterator;
import java.util.Vector;

public class JCJavaMonitor
implements JavaMonitor {
    private Vector fEnterWaiters;
    private Vector fNotifyWaiters;
    private String fName;
    private JavaObject fEncompassingObject;
    private final ImagePointer fMonitorPointer;
    private final JCJavaRuntime fRuntime;
    private long fOwner;

    public JCJavaMonitor(JCJavaRuntime javaRuntime, ImagePointer monitorPointer, String name) throws JCInvalidArgumentsException {
        if (monitorPointer == null) {
            throw new JCInvalidArgumentsException("A monitor must have a valid pointer identifier");
        }
        if (javaRuntime == null) {
            throw new JCInvalidArgumentsException("A monitor must be associated with a valid runtime");
        }
        this.fRuntime = javaRuntime;
        this.fMonitorPointer = monitorPointer;
        this.fName = name;
        this.fEncompassingObject = null;
        this.fOwner = -1L;
        this.fEnterWaiters = new Vector();
        this.fNotifyWaiters = new Vector();
        this.fRuntime.addMonitor(this);
    }

    public ImagePointer getID() {
        return this.fMonitorPointer;
    }

    public String getName() throws CorruptDataException {
        if (this.fName == null) {
            String address = Long.toHexString(this.fMonitorPointer.getAddress());
            this.fName = this.fEncompassingObject == null ? "(un-named monitor @0x" + address + ")" : "(un-named monitor @0x" + address + " for object @0x" + Long.toHexString(this.fEncompassingObject.getID().getAddress()) + ")";
        }
        return this.fName;
    }

    public Iterator getEnterWaiters() {
        return this.getThreads(this.fEnterWaiters);
    }

    public Iterator getNotifyWaiters() {
        return this.getThreads(this.fNotifyWaiters);
    }

    private Iterator getThreads(Vector threadIDs) {
        Vector<Object> threads = new Vector<Object>();
        for (ImagePointer pointer : threadIDs) {
            JCJavaThread waitingThread = this.fRuntime.findJavaThread(pointer.getAddress());
            if (waitingThread != null) {
                threads.add(waitingThread);
                continue;
            }
            threads.add(new JCCorruptData("Unknown thread", pointer));
        }
        return threads.iterator();
    }

    public JavaObject getObject() {
        return this.fEncompassingObject;
    }

    public JavaThread getOwner() throws CorruptDataException {
        if (this.fOwner != -1L) {
            JCJavaThread javaThread;
            JCJavaMonitor jm2;
            if (this.fOwner < 65536L && this.fEncompassingObject != null && (jm2 = this.fRuntime.findMonitor(this.fEncompassingObject.getID().getAddress())) != null) {
                try {
                    JavaThread javaThread2 = jm2.getOwner();
                    return javaThread2;
                }
                catch (CorruptDataException corruptDataException) {
                    // empty catch block
                }
            }
            if ((javaThread = this.fRuntime.findJavaThread(this.fOwner)) != null) {
                return javaThread;
            }
            throw new CorruptDataException((CorruptData)new JCCorruptData("No owner for this monitor", this.fMonitorPointer.getAddressSpace().getPointer(this.fOwner)));
        }
        return null;
    }

    public void addEnterWaiter(ImagePointer threadID) {
        if (threadID != null) {
            this.fEnterWaiters.add(threadID);
        }
    }

    public void addNotifyWaiter(ImagePointer threadID) {
        if (threadID != null) {
            this.fNotifyWaiters.add(threadID);
        }
    }

    public void setObject(JavaObject encompassingObject) {
        this.fEncompassingObject = encompassingObject;
    }

    public void setOwner(long javaThread) {
        this.fOwner = javaThread;
    }
}

