/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.parser.j9.section.nativememory;

import com.ibm.dtfj.javacore.parser.framework.tag.LineRule;
import com.ibm.dtfj.javacore.parser.framework.tag.TagParser;
import com.ibm.dtfj.javacore.parser.j9.section.common.CommonPatternMatchers;
import com.ibm.dtfj.javacore.parser.j9.section.nativememory.INativeMemoryTypes;
import com.ibm.dtfj.javacore.parser.j9.section.nativememory.NativeMemoryPatternMatchers;

public class NativeMemoryTagParser
extends TagParser
implements INativeMemoryTypes {
    public NativeMemoryTagParser() {
        super("NATIVEMEMINFO");
    }

    protected void initTagAttributeRules() {
        this.addTag("0MEMUSER", null);
        for (int i = 1; i < T_MEMUSERS.length; ++i) {
            this.addTag(T_MEMUSERS[i], new NativeMemoryUserLineRule(i));
        }
    }

    private static class NativeMemoryUserLineRule
    extends LineRule {
        private final int depth;

        NativeMemoryUserLineRule(int depth) {
            this.depth = depth;
        }

        protected void processLine(String source, int startingOffset) {
            boolean level1WithData;
            this.addToken("nativemem_depth", Integer.toString(this.depth));
            boolean foundPipes = this.consumeUntilFirstMatch(NativeMemoryPatternMatchers.pipes);
            boolean foundCrossMinusMinus = this.consumeUntilFirstMatch(NativeMemoryPatternMatchers.crossminusminus);
            boolean bl = level1WithData = this.depth == 1 && foundPipes;
            if (level1WithData || foundCrossMinusMinus) {
                this.addToken("nativemem_name", NativeMemoryPatternMatchers.categoryName);
                this.consumeUntilFirstMatch(CommonPatternMatchers.colon);
                this.addToken("nativemem_deepbytes", NativeMemoryPatternMatchers.commaDelimitedNumeric);
                this.consumeUntilFirstMatch(NativeMemoryPatternMatchers.bytesAndSeparator);
                this.addToken("nativemem_allocations", NativeMemoryPatternMatchers.commaDelimitedNumeric);
            }
        }
    }
}

