/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.parser.j9.section.stack;

import com.ibm.dtfj.image.ImageModule;
import com.ibm.dtfj.javacore.builder.IImageAddressSpaceBuilder;
import com.ibm.dtfj.javacore.builder.IImageProcessBuilder;
import com.ibm.dtfj.javacore.parser.framework.parser.ParserException;
import com.ibm.dtfj.javacore.parser.j9.IAttributeValueMap;
import com.ibm.dtfj.javacore.parser.j9.SectionParser;
import com.ibm.dtfj.javacore.parser.j9.section.stack.IStackTypes;

public class StackSectionParser
extends SectionParser
implements IStackTypes {
    private IImageAddressSpaceBuilder fImageAddressSpaceBuilder;
    private IImageProcessBuilder fImageProcessBuilder;

    public StackSectionParser() {
        super("Stack");
    }

    protected void topLevelRule() throws ParserException {
        this.fImageAddressSpaceBuilder = this.fImageBuilder.getCurrentAddressSpaceBuilder();
        this.fImageProcessBuilder = this.fImageAddressSpaceBuilder.getCurrentImageProcessBuilder();
        this.parseStackLine();
    }

    private void parseStackLine() throws ParserException {
        IAttributeValueMap results = null;
        while ((results = this.processTagLineOptional("BTTHREADID")) != null) {
            long threadID = results.getLongValue("stack_thread");
            while ((results = this.processTagLineOptional("1BTSTACKENT")) != null) {
                String module = results.getTokenValue("stack_module");
                String routine = results.getTokenValue("stack_routine");
                long address = results.getLongValue("stack_proc_address");
                long routine_address = results.getLongValue("stack_routine_address");
                long offset = results.getLongValue("stack_offset");
                String file = results.getTokenValue("stack_file");
                int line = results.getIntValue("stack_line");
                if (routine_address == -1L && address != -1L && offset != -1L) {
                    routine_address = address - offset;
                } else if (offset == -1L && address != -1L && routine_address != -1L) {
                    offset = address - routine_address;
                } else if (address == -1L && offset != -1L && routine_address != -1L) {
                    address = routine_address + offset;
                }
                String name = module != null ? module : "";
                if (file != null) {
                    name = name + "(" + file;
                    if (line != -1) {
                        name = name + ":" + line;
                    }
                    name = name + ")";
                }
                if (module != null) {
                    ImageModule mod = this.fImageProcessBuilder.addLibrary(module);
                    if (routine != null && address != -1L && offset != -1L && routine_address != -1L) {
                        this.fImageProcessBuilder.addRoutine(mod, routine, routine_address);
                        name = name + "::" + routine + (offset >= 0L ? "+" : "-") + offset;
                    } else if (offset != -1L) {
                        name = name + (offset >= 0L ? "+" : "-") + offset;
                    } else if (address != -1L) {
                        name = name + "::0x" + Long.toHexString(address);
                    }
                } else {
                    name = routine != null ? (offset != -1L ? "::" + routine + (offset >= 0L ? "+" : "-") + offset : "::" + routine) : (address != -1L ? "::0x" + Long.toHexString(address) : null);
                }
                this.fImageProcessBuilder.addImageStackFrame(threadID, name, 0L, address);
            }
        }
    }

    protected void sovOnlyRules(String startingTag) throws ParserException {
    }
}

