/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.phd;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaClassLoader;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.phd.PHDCorruptJavaClass;
import com.ibm.dtfj.phd.PHDImage;
import com.ibm.dtfj.phd.PHDJavaClass;
import com.ibm.dtfj.phd.PHDJavaRuntime;
import com.ibm.dtfj.phd.parser.HeapdumpReader;
import com.ibm.dtfj.phd.parser.PortableHeapDumpListener;
import com.ibm.dtfj.phd.util.LongEnumeration;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.imageio.stream.ImageInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PHDJavaClassLoader
implements JavaClassLoader {
    private final Map<Long, JavaClass> classes = new LinkedHashMap<Long, JavaClass>();
    private final Map<Long, JavaClass> arrayClasses = new LinkedHashMap<Long, JavaClass>();
    long maxAddress = Long.MIN_VALUE;
    long minAddress = Long.MAX_VALUE;
    long maxObjClass;
    int maxObjLen;
    long bitsAddress = 0L;
    long maxClassAddress = Long.MIN_VALUE;
    long minClassAddress = Long.MAX_VALUE;
    int minInstanceSize = Integer.MAX_VALUE;
    private final HashMap<String, JavaClass> classNameCache = new LinkedHashMap<String, JavaClass>();
    private final LinkedHashSet<JavaClass> allClasses = new LinkedHashSet();
    private final HashSet<String> duplicateClassNames = new HashSet();
    private JavaObject obj;
    private long jlo;

    PHDJavaClassLoader(ImageInputStream stream, PHDImage parentImage, ImageAddressSpace space, PHDJavaRuntime runtime) throws IOException {
        HeapdumpReader reader = new HeapdumpReader(stream, parentImage);
        this.processData(reader, parentImage, space, runtime);
    }

    PHDJavaClassLoader(File file, PHDImage parentImage, ImageAddressSpace space, PHDJavaRuntime runtime) throws IOException {
        HeapdumpReader reader = new HeapdumpReader(file, parentImage);
        this.processData(reader, parentImage, space, runtime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processData(HeapdumpReader reader, PHDImage parentImage, final ImageAddressSpace space, final PHDJavaRuntime runtime) throws IOException {
        JavaClass cl1;
        final PHDJavaClassLoader loader = this;
        final int adjustLen = reader.version() == 4 && reader.isJ9() ? 1 : 0;
        final int[] realClasses = new int[1];
        try {
            reader.parse(new PortableHeapDumpListener(){
                long prevAddress;
                PHDJavaClass prevObjClass;

                private void updateSizes(long address) {
                    if (this.prevObjClass != null) {
                        this.prevObjClass.updateSize(this.prevAddress, address);
                    }
                    this.prevObjClass = null;
                    this.prevAddress = address;
                }

                public void classDump(long address, long superAddress, String name, int size, int flags, int hashCode, LongEnumeration refs, boolean isPacked) throws Exception {
                    this.updateSizes(address);
                    PHDJavaClassLoader.this.classes.put(address, new PHDJavaClass.Builder(space, runtime, loader, address, superAddress, name).size(size).flags(flags).hashCode(hashCode).refs(refs).isPacked(isPacked).build());
                    PHDJavaClassLoader.this.updateAddresses(address, size, name);
                    realClasses[0] = realClasses[0] + 1;
                }

                public void objectArrayDump(long address, long classAddress, int flags, int hashCode, LongEnumeration refs, int length, long instanceSize, boolean isPacked, boolean isNativePacked) throws Exception {
                    int refsLen = refs.numberOfElements();
                    int adjustLen2 = Math.min(adjustLen, refsLen);
                    this.updateSizes(address);
                    PHDJavaClassLoader.this.updateAddresses(address, classAddress, length - adjustLen2);
                    long classAddress2 = adjustLen2 == 1 ? refs.nextLong() : 0L;
                    this.genArrayClasses(space, runtime, loader, adjustLen2, classAddress, classAddress2, isPacked);
                }

                public void objectDump(long address, long classAddress, int flags, int hashCode, LongEnumeration refs, boolean isPacked, boolean isNativePacked, long instanceSize) throws Exception {
                    this.updateSizes(address);
                    PHDJavaClassLoader.this.updateAddresses(address, classAddress, -1);
                    this.genObjectClass(space, runtime, loader, classAddress, hashCode, isPacked);
                }

                public void primitiveArrayDump(long address, int type, int length, int flags, int hashCode, long instanceSize) throws Exception {
                    this.updateSizes(address);
                    PHDJavaClassLoader.this.updateAddresses(address, type, length);
                }

                private void genObjectClass(ImageAddressSpace space2, PHDJavaRuntime runtime2, JavaClassLoader loader2, long classAddress, int hashCode, boolean isPacked) {
                    if (!PHDJavaClassLoader.this.classes.containsKey(classAddress)) {
                        PHDJavaClass objClass = new PHDJavaClass.Builder(space2, runtime2, loader2, classAddress, -1L, "]").isPacked(isPacked).build();
                        PHDJavaClassLoader.this.classes.put(classAddress, objClass);
                        PHDJavaClassLoader.this.updateAddresses(classAddress, 100, null);
                    }
                    this.prevObjClass = (PHDJavaClass)PHDJavaClassLoader.this.findClass(classAddress);
                }

                private PHDJavaClass genArrayClass(ImageAddressSpace space2, PHDJavaRuntime runtime2, JavaClassLoader loader2, long classAddress, long sup, String name, boolean isPacked) {
                    int size = 100;
                    PHDJavaClass elemCls = new PHDJavaClass.Builder(space2, runtime2, loader2, classAddress, sup, name).isPacked(isPacked).build();
                    PHDJavaClassLoader.this.classes.put(classAddress, elemCls);
                    PHDJavaClassLoader.this.updateAddresses(classAddress, size, name);
                    return elemCls;
                }

                private void genArrayClasses(ImageAddressSpace space2, PHDJavaRuntime runtime2, JavaClassLoader loader2, int adjustLen2, long classAddress, long classAddress2, boolean isPacked) {
                    if (adjustLen2 == 1) {
                        JavaClass arrayCls;
                        String name;
                        if (!PHDJavaClassLoader.this.classes.containsKey(classAddress2)) {
                            name = "[";
                            arrayCls = this.genArrayClass(space2, runtime2, loader2, classAddress2, PHDJavaClassLoader.this.jlo, name, isPacked);
                        } else {
                            arrayCls = PHDJavaClassLoader.this.findClass(classAddress2);
                        }
                        PHDJavaClassLoader.this.arrayClasses.put(classAddress, arrayCls);
                        if (!PHDJavaClassLoader.this.classes.containsKey(classAddress)) {
                            name = "]";
                            this.genArrayClass(space2, runtime2, loader2, classAddress, -1L, name, isPacked);
                        }
                    } else {
                        PHDJavaClassLoader.this.arrayClasses.put(classAddress, null);
                    }
                }
            });
        }
        catch (EOFException e) {
            this.classes.put(runtime.nextDummyClassAddr(), new PHDCorruptJavaClass("Truncated dump found building class " + realClasses[0], null, e));
        }
        catch (IOException e) {
            this.classes.put(runtime.nextDummyClassAddr(), new PHDCorruptJavaClass("Corrupted dump found building class " + realClasses[0], null, e));
        }
        catch (Exception e) {
            this.classes.put(runtime.nextDummyClassAddr(), new PHDCorruptJavaClass("Building class " + realClasses[0], null, e));
        }
        finally {
            reader.close();
            reader = null;
        }
        this.jlo = 0L;
        JavaClass jco = this.findClassUncached("java/lang/Object");
        if (jco != null) {
            ImagePointer ip = jco.getID();
            if (ip != null) {
                this.jlo = ip.getAddress();
            }
        } else {
            jco = new PHDJavaClass.Builder(space, runtime, loader, 0L, 0L, "java/lang/Object").build();
            this.jlo = runtime.nextDummyClassAddr();
            this.classes.put(this.jlo, jco);
        }
        JavaClass jcl = this.findClassUncached("java/lang/Class");
        if (jcl == null) {
            jcl = new PHDJavaClass.Builder(space, runtime, loader, 0L, this.jlo, "java/lang/Class").build();
            this.classes.put(runtime.nextDummyClassAddr(), jcl);
        }
        for (int i = 0; i < PHDJavaRuntime.arrayTypeName.length; ++i) {
            JavaClass jc = this.findClassUncached(PHDJavaRuntime.arrayTypeName[i]);
            if (jc != null) continue;
            jc = new PHDJavaClass.Builder(space, runtime, loader, 0L, this.jlo, PHDJavaRuntime.arrayTypeName[i]).build();
            this.classes.put(runtime.nextDummyClassAddr(), jc);
        }
        boolean arrayTypeIsArray = true;
        for (Long id : this.arrayClasses.keySet()) {
            cl1 = this.findClass(id);
            if (cl1 == null) continue;
            try {
                if (cl1.isArray()) continue;
                arrayTypeIsArray = false;
            }
            catch (CorruptDataException e) {
                arrayTypeIsArray = false;
            }
        }
        for (Long id : this.arrayClasses.keySet()) {
            JavaClass cl2;
            JavaClass ar2;
            ImagePointer ip;
            JavaClass ar;
            cl1 = this.findClass(id);
            if (cl1 == null) {
                String name = arrayTypeIsArray ? "[" : null;
                long sup = arrayTypeIsArray ? this.jlo : -1L;
                cl1 = new PHDJavaClass.Builder(space, runtime, loader, id, sup, name).build();
                this.classes.put(id, cl1);
            }
            if ((ar = this.arrayClasses.get(id)) != null && (ip = ar.getID()) != null && (ar2 = this.findClass(ip.getAddress())) != null) {
                ar = ar2;
            }
            if (arrayTypeIsArray) {
                cl2 = cl1;
            } else if (ar != null) {
                cl2 = ar;
            } else {
                block31: {
                    try {
                        String name = cl1.getName();
                        String arrayName = this.arrayName(name);
                        Set<JavaClass> s = this.findClasses(arrayName);
                        if (s.size() == 0) {
                            cl2 = new PHDJavaClass.Builder(space, runtime, loader, 0L, this.jlo, arrayName).componentType(cl1).build();
                            break block31;
                        }
                        if (s.size() == 1) {
                            cl2 = s.iterator().next();
                            break block31;
                        }
                        cl2 = null;
                        for (JavaClass cl3 : s) {
                            if (!PHDJavaClass.referencesClass(cl3, cl1)) continue;
                            cl2 = cl3;
                            break;
                        }
                    }
                    catch (CorruptDataException e) {
                        cl2 = new PHDJavaClass.Builder(space, runtime, loader, 0L, this.jlo, "[").componentType(cl1).build();
                    }
                }
                if (cl2 instanceof PHDJavaClass) {
                    ((PHDJavaClass)cl2).setComponentType(cl1);
                }
            }
            this.arrayClasses.put(id, cl2);
        }
        this.initCache();
    }

    JavaClass setArrayType(PHDJavaRuntime runtime, PHDJavaClassLoader from, JavaClass cl1) {
        long addr;
        boolean lookInBootLoader = false;
        JavaClass cl2 = null;
        ImagePointer ip = cl1.getID();
        if (ip != null && this.arrayClasses.containsKey(addr = ip.getAddress()) && (cl2 = this.arrayClasses.get(addr)) == null) {
            block9: {
                try {
                    String name = cl1.getName();
                    String arrayName = this.arrayName(name);
                    Set<JavaClass> s = this.findClasses(arrayName);
                    boolean bl = lookInBootLoader = s.size() == 0;
                    if (lookInBootLoader) {
                        s = from.findClasses(arrayName);
                    }
                    if (s.size() == 0) {
                        cl2 = new PHDJavaClass.Builder(cl1.getID().getAddressSpace(), runtime, this, 0L, this.jlo, arrayName).componentType(cl1).build();
                        break block9;
                    }
                    if (s.size() == 1) {
                        cl2 = s.iterator().next();
                        break block9;
                    }
                    for (JavaClass cl3 : s) {
                        if (cl2 == null) {
                            cl2 = cl3;
                        }
                        if (!(cl3 instanceof PHDJavaClass) || ((PHDJavaClass)cl3).setComponentType(null) != null) continue;
                        cl2 = cl3;
                        break;
                    }
                }
                catch (CorruptDataException e) {
                    cl2 = new PHDJavaClass.Builder(cl1.getID().getAddressSpace(), runtime, this, 0L, this.jlo, "[").componentType(cl1).build();
                }
            }
            if (cl2 instanceof PHDJavaClass) {
                JavaClass c1 = ((PHDJavaClass)cl2).setComponentType(cl1);
            }
            this.arrayClasses.put(addr, cl2);
        }
        return lookInBootLoader ? cl2 : null;
    }

    private String arrayName(String name) {
        String arrayName = name.startsWith("[") ? "[" + name : (name.equals("byte") ? "[B" : (name.equals("short") ? "[S" : (name.equals("int") ? "[I" : (name.equals("long") ? "[J" : (name.equals("boolean") ? "[Z" : (name.equals("char") ? "[C" : (name.equals("float") ? "[F" : (name.equals("double") ? "[D" : "[L" + name + ";"))))))));
        return arrayName;
    }

    PHDJavaClassLoader(JavaObject obj) {
        this.obj = obj;
    }

    public JavaClass findClass(String className) throws CorruptDataException {
        JavaClass jc = this.classNameCache.get(className);
        if (jc == null && (jc = this.findClassUncached(className)) != null) {
            this.classNameCache.put(className, jc);
        }
        return jc;
    }

    JavaClass findClassUncached(String className) {
        for (JavaClass cls : this.classes.values()) {
            try {
                if (!cls.getName().equals(className)) continue;
                return cls;
            }
            catch (CorruptDataException e) {
            }
        }
        for (JavaClass cls : this.arrayClasses.values()) {
            try {
                if (cls == null || !cls.getName().equals(className)) continue;
                return cls;
            }
            catch (CorruptDataException e) {
            }
        }
        return null;
    }

    JavaClass findClassUnique(String className) throws CorruptDataException {
        JavaClass ret = null;
        if (!this.duplicateClassNames.contains(className)) {
            ret = this.classNameCache.get(className);
        }
        return ret;
    }

    private Set<JavaClass> findClasses(String className) {
        LinkedHashSet<JavaClass> ret = new LinkedHashSet<JavaClass>();
        for (JavaClass cls : this.classes.values()) {
            try {
                if (!cls.getName().equals(className)) continue;
                ret.add(cls);
            }
            catch (CorruptDataException e) {}
        }
        return ret;
    }

    void initCache() {
        this.allClasses.clear();
        this.classNameCache.clear();
        for (JavaClass cls : this.classes.values()) {
            this.cacheClass(cls);
        }
        for (JavaClass cls : this.arrayClasses.values()) {
            if (cls == null) continue;
            this.cacheClass(cls);
        }
    }

    private void cacheClass(JavaClass cls) {
        this.allClasses.add(cls);
        try {
            String clsName = cls.getName();
            if (this.classNameCache.containsKey(clsName)) {
                this.duplicateClassNames.add(clsName);
            } else {
                this.classNameCache.put(clsName, cls);
            }
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }

    JavaClass findClass(long id) {
        return this.classes.get(id);
    }

    JavaClass findArrayOfClass(long id) {
        return this.arrayClasses.get(id);
    }

    public Iterator<JavaClass> getCachedClasses() {
        return this.getDefinedClasses();
    }

    public Iterator<JavaClass> getDefinedClasses() {
        return this.allClasses.iterator();
    }

    public JavaObject getObject() throws CorruptDataException {
        if (this.obj != null && this.obj.getID().getAddress() == 0L) {
            return null;
        }
        return this.obj;
    }

    void prepareToMove(PHDJavaClassLoader from, JavaClass j1) {
        long address;
        JavaClass j2;
        this.setLoader(j1);
        ImagePointer ip = j1.getID();
        if (ip != null && (j2 = from.arrayClasses.get(address = ip.getAddress())) != null) {
            this.setLoader(j2);
        }
    }

    private void setLoader(JavaClass j1) {
        if (j1 instanceof PHDJavaClass) {
            PHDJavaClass pjc = (PHDJavaClass)j1;
            pjc.setClassLoader(this);
        }
    }

    void move(PHDJavaClassLoader from, JavaClass j1, long lastDummyClassAddress) {
        ImagePointer ip = j1.getID();
        long address = 0L;
        if (ip != null) {
            address = ip.getAddress();
        } else {
            for (long i = 1L; i <= lastDummyClassAddress; ++i) {
                if (!j1.equals(from.findClass(i))) continue;
                address = i;
                break;
            }
        }
        if (address != 0L) {
            this.classes.put(address, j1);
            from.classes.remove(address);
            if (from.arrayClasses.containsKey(address)) {
                this.arrayClasses.put(address, from.arrayClasses.remove(address));
            }
        }
    }

    private void updateAddresses(long addr, long classAddr, int len) {
        if (addr > this.maxAddress) {
            this.maxObjClass = classAddr;
            this.maxObjLen = len;
        }
        this.maxAddress = Math.max(this.maxAddress, addr);
        this.minAddress = Math.min(this.minAddress, addr);
        this.bitsAddress |= addr;
    }

    private void updateAddresses(long addr, int size, String className) {
        this.maxClassAddress = Math.max(this.maxClassAddress, addr);
        this.minClassAddress = Math.min(this.minClassAddress, addr);
        if (className != null && !className.startsWith("[")) {
            this.minInstanceSize = Math.min(this.minInstanceSize, size);
        }
        this.bitsAddress |= addr;
    }

    public int hashCode() {
        if (this.obj != null) {
            return this.obj.hashCode();
        }
        return (int)(this.minClassAddress ^ this.maxClassAddress);
    }
}

