/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.utils.plugins;

import com.ibm.java.diagnostics.utils.plugins.Entry;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Container
extends Entry {
    private final List<Entry> entries = new ArrayList<Entry>();

    public Container(File file) {
        super(file);
    }

    @Override
    public URL toURL() {
        try {
            return this.file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            this.logger.log(Level.FINE, "Exception thrown when constructing URL from class file name " + this.file.getName());
            return null;
        }
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public void addEntry(Entry entry) {
        this.entries.add(entry);
        entry.setParent(this);
    }

    public <T extends Entry> T getEntry(File file) {
        return (T)this.scanEntries(this, file);
    }

    private Entry scanEntries(Container root, File file) {
        for (Entry entry : root.entries) {
            if (entry.getFile() == null) {
                if (!(entry instanceof Container)) continue;
                return this.scanEntries((Container)entry, file);
            }
            if (!entry.getFile().equals(file)) continue;
            return entry;
        }
        return null;
    }

    public Entry getEntry(Entry entry) {
        return this.scanEntries(this, entry);
    }

    public Entry getEntry(String name) {
        Entry searchFor = new Entry(name);
        return this.scanEntries(this, searchFor);
    }

    private Entry scanEntries(Container root, Entry searchFor) {
        for (Entry entry : root.entries) {
            if (entry instanceof Container) {
                return this.scanEntries((Container)entry, searchFor);
            }
            if (!entry.equals(searchFor)) continue;
            return entry;
        }
        return null;
    }
}

