/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.extract;

import com.ibm.dtfj.addressspace.IAbstractAddressSpace;
import com.ibm.dtfj.corereaders.Builder;
import com.ibm.dtfj.corereaders.ClosingFileReader;
import com.ibm.dtfj.corereaders.Dump;
import com.ibm.dtfj.corereaders.DumpFactory;
import com.ibm.dtfj.corereaders.ICoreFileReader;
import com.ibm.dtfj.corereaders.NewElfDump;
import com.ibm.jvm.j9.dump.extract.JExtractFatalException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Main {
    private String _dumpName = null;
    private File _virtualRootDirectory = null;
    private boolean _verbose;
    private static boolean _throwExceptions;
    private ICoreFileReader _dump = null;
    private static final String J9_LIB_NAME = "j9jextract";
    private static final int ZIP_BUFFER_SIZE = 32768;
    private DummyBuilder _builder;
    private static int JEXTRACT_SUCCESS;
    private static int JEXTRACT_SYNTAX_ERROR;
    private static int JEXTRACT_FILE_ERROR;
    private static int JEXTRACT_NOJVM_ERROR;
    private static int JEXTRACT_ADDRESS_ERROR;
    private static int JEXTRACT_VERSION_ERROR;
    private static int JEXTRACT_INTERNAL_ERROR;

    public static void main(String[] args) {
        String dumpName = null;
        String outputName = null;
        File virtualRootDirectory = null;
        boolean ignoreOptions = false;
        boolean interactive = false;
        boolean verbose = false;
        boolean throwExceptions = false;
        boolean zip = true;
        if (args.length == 0) {
            Main.usageMessage(null, JEXTRACT_SUCCESS);
        }
        for (int i = 0; i < args.length; ++i) {
            if (!ignoreOptions && args[i].startsWith("-")) {
                File file;
                if ("--".equals(args[i])) {
                    ignoreOptions = true;
                    continue;
                }
                if ("-interactive".equals(args[i])) {
                    interactive = true;
                    continue;
                }
                if ("-help".equals(args[i])) {
                    Main.usageMessage(null, JEXTRACT_SUCCESS);
                    continue;
                }
                if ("-f".equals(args[i])) {
                    Main.ensure(++i < args.length && !args[i].startsWith("-"), "Syntax error: -f option specified with no filename following");
                    file = new File(args[i]);
                    Main.ensure(file.exists() && file.canRead(), "File specified using -f option (\"" + args[i] + "\") not found.");
                    System.setProperty("com.ibm.dtfj.corereaders.executable", args[i]);
                    continue;
                }
                if ("-p".equals(args[i])) {
                    Main.ensure(++i < args.length && !args[i].startsWith("-"), "Syntax error: -p option specified but no virtual root directory given");
                    file = new File(args[i]);
                    Main.ensure(file.exists() && file.canRead() && file.isDirectory(), "Virtual directory specified using -p option (\"" + args[i] + "\") does not exist as a readable directory.");
                    virtualRootDirectory = new File(args[i]);
                    continue;
                }
                if (args[i].equals("-v")) {
                    verbose = true;
                    continue;
                }
                if (args[i].equals("-e")) {
                    throwExceptions = true;
                    continue;
                }
                Main.usageMessage("Unrecognized option: " + args[i], JEXTRACT_SYNTAX_ERROR);
                continue;
            }
            if (dumpName == null) {
                dumpName = args[i];
                continue;
            }
            if (outputName == null) {
                outputName = args[i];
                continue;
            }
            Main.usageMessage("Too many file arguments: " + args[i], JEXTRACT_SYNTAX_ERROR);
        }
        Main.ensure(null != dumpName, "No dump file specified");
        Main dumper = new Main(dumpName, virtualRootDirectory, verbose, throwExceptions);
        if (interactive) {
            dumper.runInteractive();
        } else {
            if (zip) {
                dumper.runZip(outputName);
            }
            Main.report("jextract complete.");
        }
    }

    private static void ensure(boolean condition, String errorMessage) {
        if (!condition) {
            Main.usageMessage(errorMessage, JEXTRACT_SYNTAX_ERROR);
        }
    }

    private static void usageMessage(String message, int code) {
        Main.report("Usage: jextract dump_name [output_filename] [options]");
        Main.report(" output filename defaults to dump_name.zip");
        Main.report(" options:");
        Main.report("   -f executable_name override executable name");
        Main.report("   -help              print this usage message");
        Main.report("   -v                 enable verbose output");
        if (_throwExceptions) {
            throw new JExtractFatalException(message, code);
        }
        if (message != null) {
            Main.report(message);
        }
        System.exit(code);
    }

    private static void errorMessage(String message, int code) {
        if (_throwExceptions) {
            throw new JExtractFatalException(message, code);
        }
        if (message != null) {
            Main.report(message);
        }
        System.exit(code);
    }

    private static void errorMessage(String message, int code, Throwable throwable) {
        throwable.printStackTrace();
        if (_throwExceptions) {
            throw new JExtractFatalException(message, code);
        }
        if (message != null) {
            Main.report(message);
        }
        System.exit(code);
    }

    private Main(String dumpName, File virtualRootDirectory, boolean verbose, boolean throwExceptions) {
        this._dumpName = dumpName;
        this._virtualRootDirectory = virtualRootDirectory;
        this._verbose = verbose;
        _throwExceptions = throwExceptions;
        try {
            System.loadLibrary(J9_LIB_NAME);
        }
        catch (SecurityException e) {
            Main.errorMessage("Error. Security permissions don't allow required native library to be loaded.", JEXTRACT_INTERNAL_ERROR);
        }
        catch (UnsatisfiedLinkError e) {
            Main.errorMessage("Error. Native library j9jextract cannot be found. Please check your path.", JEXTRACT_INTERNAL_ERROR);
        }
        catch (Exception e) {
            Main.errorMessage("Error. Unexpected exception occurred loading: j9jextract", JEXTRACT_INTERNAL_ERROR, e);
        }
        Main.report("Loading dump file...");
        File dumpFile = new File(dumpName);
        ClosingFileReader reader = null;
        try {
            reader = new ClosingFileReader(dumpFile);
        }
        catch (FileNotFoundException e) {
            if (!dumpFile.exists()) {
                Main.errorMessage("Error. Could not find dump file: " + dumpName, JEXTRACT_FILE_ERROR);
            } else if (!dumpFile.canRead()) {
                Main.errorMessage("Error. Unable to read dump file (check permission): " + dumpName, JEXTRACT_FILE_ERROR);
            } else {
                Main.errorMessage("Error. Unexpected FileNotFoundException occurred opening: " + dumpName, JEXTRACT_FILE_ERROR, e);
            }
        }
        catch (IOException e) {
            Main.errorMessage(e.getMessage(), JEXTRACT_FILE_ERROR);
        }
        try {
            this._dump = DumpFactory.createDumpForCore(reader, this._verbose);
        }
        catch (Exception e) {
            Main.errorMessage("Error. Unexpected Exception occurred opening: " + dumpName, JEXTRACT_FILE_ERROR, e);
        }
        if (null == this._dump) {
            Main.errorMessage("Error. Dump type not recognised, file: " + dumpName, JEXTRACT_FILE_ERROR);
        }
        if (this._dump.isTruncated()) {
            Main.report("Warning: dump file is truncated. Extracted information may be incomplete.");
        }
        this._builder = new DummyBuilder(this._virtualRootDirectory);
        this._dump.extract(this._builder);
        if (this._dump instanceof NewElfDump && !this._builder.isExecutableAvailable()) {
            long environmentPointer = 0L;
            try {
                environmentPointer = this.getEnvironmentPointer(this._dump.getAddressSpace());
            }
            catch (Throwable t) {
                Main.errorMessage("Error. Unable to locate executable for " + dumpName, JEXTRACT_INTERNAL_ERROR, t);
            }
            if (environmentPointer != 0L) {
                this._builder = new DummyBuilder(this._virtualRootDirectory, environmentPointer);
                try {
                    this._dump = DumpFactory.createDumpForCore(reader, this._verbose);
                }
                catch (IOException e) {
                    Main.errorMessage("Error. Unexpected Exception occurred opening: " + dumpName + " for the second time", JEXTRACT_FILE_ERROR, e);
                }
                this._dump.extract(this._builder);
            }
        }
        Main.report("Read memory image from " + this._dumpName);
    }

    private void runZip(String outputName) {
        ArrayList<String> files = new ArrayList<String>();
        files.add(this._dumpName);
        Iterator iter = this._dump.getAdditionalFileNames();
        while (iter.hasNext()) {
            files.add((String)iter.next());
        }
        try {
            String osName;
            String j9trace;
            String lib_dir = System.getProperty("java.home") + File.separator + "lib" + File.separator;
            String trace = lib_dir + "TraceFormat.dat";
            if (new File(trace).exists()) {
                files.add(trace);
            }
            if (new File(j9trace = lib_dir + "J9TraceFormat.dat").exists()) {
                files.add(j9trace);
            }
            if ((osName = System.getProperty("os.name")) != null && osName.equalsIgnoreCase("AIX")) {
                files.add("libdbx_j9.so");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            Main.createZipFromFileNames(null != outputName ? outputName : this._dumpName.concat(".zip"), files.iterator(), this._builder);
        }
        catch (Exception e) {
            Main.errorMessage(e.getMessage(), JEXTRACT_INTERNAL_ERROR, e);
        }
    }

    private void runInteractive() {
        Main.report("Jextract interactive mode.");
        Main.report("Type '!j9help' for help.");
        Main.report("Type 'quit' to quit.");
        Main.report("(Commands must be prefixed with '!')");
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        IAbstractAddressSpace addressSpace = this._dump.getAddressSpace();
        if (addressSpace == null) {
            Main.report("Error. Address space not found in dump: " + this._dumpName + ". Dump is truncated, corrupted or does not contain a supported JVM.");
            return;
        }
        block4: while (true) {
            try {
                while (true) {
                    Main.report("> ");
                    String command = input.readLine().trim();
                    if ("quit".equalsIgnoreCase(command) || "q".equalsIgnoreCase(command)) break block4;
                    try {
                        this.doCommand(addressSpace, command);
                        continue block4;
                    }
                    catch (Throwable e) {
                        Main.report(e.getMessage());
                        Main.report("Failure detected during command execution, see previous message(s).");
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                Main.report("Error reading input.");
                break;
            }
        }
    }

    private static void report(String message) {
        System.err.println(message);
    }

    private static void createZipFromFileNames(String zipFileName, Iterator fileNames, Builder fileResolver) throws Exception {
        Main.report("Creating archive file: " + zipFileName);
        try {
            HashSet<String> filesInZip = new HashSet<String>();
            ZipOutputStream zip = new ZipOutputStream(new FileOutputStream(zipFileName));
            byte[] buffer = new byte[32768];
            while (fileNames.hasNext()) {
                String name = (String)fileNames.next();
                try {
                    ClosingFileReader in = fileResolver.openFile(name);
                    boolean mvsfile = in.isMVSFile();
                    String absolute = in.getAbsolutePath();
                    if (absolute.equals(new File(name).getAbsolutePath()) || mvsfile) {
                        Main.report("Adding \"" + name + "\"");
                    } else {
                        Main.report("Adding \"" + name + "\" (found at \"" + absolute + "\")");
                    }
                    if (mvsfile) {
                        zip.putNextEntry(new ZipEntry(name));
                        filesInZip.add(name);
                        Main.copy(in, (OutputStream)zip, buffer);
                        continue;
                    }
                    if (filesInZip.contains(absolute)) continue;
                    InputStream fileStream = in.streamFromFile();
                    ZipEntry zipEntry = new ZipEntry(absolute);
                    filesInZip.add(absolute);
                    zipEntry.setTime(new File(absolute).lastModified());
                    zip.putNextEntry(zipEntry);
                    Main.copy(fileStream, (OutputStream)zip, buffer);
                    fileStream.close();
                }
                catch (FileNotFoundException e1) {
                    Main.report("Warning:  Could not find file \"" + name + "\" for inclusion in archive");
                }
                catch (IOException e) {
                    throw new Exception("Failure adding file " + name + " to archive", e);
                }
                finally {
                    zip.closeEntry();
                }
            }
            try {
                zip.close();
            }
            catch (IOException e) {
                throw new Exception("Failure closing archive file (" + zipFileName + ") : " + e.getMessage());
            }
        }
        catch (FileNotFoundException e1) {
            throw new Exception("Could not find archive file to output to: " + e1.getMessage());
        }
    }

    private static void copy(InputStream from, OutputStream to, byte[] buffer) throws IOException {
        int count = from.read(buffer);
        while (count != -1) {
            to.write(buffer, 0, count);
            count = from.read(buffer);
        }
    }

    private static void copy(ClosingFileReader from, OutputStream to, byte[] buffer) throws IOException {
        int count = from.read(buffer);
        while (count != -1) {
            to.write(buffer, 0, count);
            count = from.read(buffer);
        }
    }

    private native long getEnvironmentPointer(IAbstractAddressSpace var1) throws Exception;

    private native void doCommand(IAbstractAddressSpace var1, String var2) throws Exception;

    static {
        JEXTRACT_SUCCESS = 0;
        JEXTRACT_SYNTAX_ERROR = 1;
        JEXTRACT_FILE_ERROR = 2;
        JEXTRACT_NOJVM_ERROR = 3;
        JEXTRACT_ADDRESS_ERROR = 4;
        JEXTRACT_VERSION_ERROR = 5;
        JEXTRACT_INTERNAL_ERROR = 6;
    }

    private static class DummyBuilder
    implements Builder {
        private File _virtualRootDirectory = null;
        private Vector _successfulSearchPaths = new Vector();
        private boolean _executableAvailable = true;
        private final long _environmentPointer;

        public DummyBuilder(File rootDirectory) {
            this(rootDirectory, 0L);
        }

        public DummyBuilder(File rootDirectory, long environment) {
            this._virtualRootDirectory = rootDirectory;
            String jre_bin = System.getProperty("java.home") + File.separator + "bin";
            File javaPath = new File(jre_bin);
            this._successfulSearchPaths.add(javaPath);
            this._environmentPointer = environment;
        }

        public Object buildProcess(Object addressSpace, String pid, String commandLine, Properties environment, Object currentThread, Iterator threads, Object executable, Iterator libraries, int addressSize) {
            return new Object();
        }

        public Object buildAddressSpace(String name, Dump core, int id) {
            return new Object();
        }

        public Object buildRegister(String name, Number value) {
            return new Register(name, value.longValue());
        }

        public Object buildStackSection(Object addressSpace, long stackStart, long stackEnd) {
            return new Object();
        }

        public Object buildThread(String name, Iterator registers, Iterator stackSections, Iterator stackFrames, Properties properties, int signalNumber) {
            return new Object();
        }

        public Object buildModuleSection(Object addressSpace, String name, long imageStart, long imageEnd) {
            return new Object();
        }

        public Object buildModule(String name, Properties properties, Iterator sections, Iterator symbols, long loadAddress) {
            return new Object();
        }

        public long getEnvironmentAddress() {
            return this._environmentPointer;
        }

        public long getValueOfNamedRegister(List registers, String name) {
            for (Register register : registers) {
                if (!name.equals(register.name)) continue;
                return register.value;
            }
            return -1L;
        }

        public Object buildStackFrame(Object addressSpace, long stackBasePointer, long pc) {
            return new Object();
        }

        public ClosingFileReader openFile(String nameOrPath) throws IOException {
            File fileRep = new File(nameOrPath);
            if (null != this._virtualRootDirectory && fileRep.isAbsolute()) {
                fileRep = this.sysFileRelative(this._virtualRootDirectory, fileRep);
            } else if (!fileRep.isAbsolute() && !fileRep.exists()) {
                Iterator paths = this._successfulSearchPaths.iterator();
                String filename = fileRep.getName();
                while (paths.hasNext()) {
                    File path = (File)paths.next();
                    File nextPath = new File(path, filename);
                    if (!nextPath.exists()) continue;
                    ClosingFileReader reader = new ClosingFileReader(nextPath);
                    return reader;
                }
            }
            if (fileRep.exists()) {
                File absolute;
                ClosingFileReader reader = new ClosingFileReader(fileRep);
                File parent = fileRep.getParentFile();
                if (null != parent && !this._successfulSearchPaths.contains(absolute = parent.getAbsoluteFile())) {
                    this._successfulSearchPaths.add(absolute);
                }
                return reader;
            }
            ClosingFileReader zosReader = new ClosingFileReader(fileRep);
            return zosReader;
        }

        private File sysFileRelative(File virtualRoot, File originalPath) {
            File temp = originalPath;
            while (null != temp.getParentFile()) {
                temp = temp.getParentFile();
            }
            File result = originalPath;
            if (originalPath.isAbsolute()) {
                String middle = originalPath.getAbsolutePath().substring(temp.getAbsolutePath().length());
                result = new File(virtualRoot, middle);
            }
            return result;
        }

        public Object buildSymbol(Object addressSpace, String functionName, long relocatedFunctionAddress) {
            return new Object();
        }

        public void setExecutableUnavailable(String description) {
            this._executableAvailable = false;
        }

        public boolean isExecutableAvailable() {
            return this._executableAvailable;
        }

        public Object buildAddressSpace(String name, int id) {
            return new Object();
        }

        public void setOSType(String osType) {
        }

        public void setCPUType(String cpuType) {
        }

        public void setCPUSubType(String subType) {
        }

        public void setCreationTime(long millis) {
        }

        public Object buildCorruptData(Object addressSpace, String message, long address) {
            return new Object();
        }

        private static class Register {
            final String name;
            final long value;

            Register(String name, long value) {
                this.name = name;
                this.value = value;
            }
        }
    }
}

