/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.management;

import com.ibm.lang.management.CpuUtilizationHelper;
import com.ibm.lang.management.DynamicMXBeanImpl;
import com.ibm.lang.management.ManagementUtils;
import com.ibm.lang.management.MemoryUsage;
import com.ibm.lang.management.MemoryUsageRetrievalException;
import com.ibm.lang.management.OperatingSystemMXBean;
import com.ibm.lang.management.OperatingSystemNotificationThread;
import com.ibm.lang.management.ProcessorUsage;
import com.ibm.lang.management.ProcessorUsageRetrievalException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;

public abstract class OperatingSystemMXBeanImpl
extends DynamicMXBeanImpl
implements OperatingSystemMXBean,
NotificationEmitter {
    private NotificationBroadcasterSupport notifier = new NotificationBroadcasterSupport();
    private final CpuUtilizationHelper cpuUtilizationHelper;

    OperatingSystemMXBeanImpl() {
        super(ManagementUtils.createObjectName("java.lang:type=OperatingSystem"));
        if (this.isDLPAREnabled()) {
            OperatingSystemNotificationThread operatingSystemNotificationThread = new OperatingSystemNotificationThread(this);
            operatingSystemNotificationThread.setDaemon(true);
            operatingSystemNotificationThread.setName("OperatingSystemMXBean notification dispatcher");
            operatingSystemNotificationThread.setPriority(6);
            operatingSystemNotificationThread.start();
        }
        this.cpuUtilizationHelper = new CpuUtilizationHelper();
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        if (this.info == null) {
            this.setMBeanInfo(ManagementUtils.getMBeanInfo(java.lang.management.OperatingSystemMXBean.class.getName()));
        }
        return this.info;
    }

    private native boolean isDLPAREnabled();

    @Override
    public String getArch() {
        return System.getProperty("os.arch");
    }

    @Override
    public int getAvailableProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    @Override
    public String getName() {
        return System.getProperty("os.name");
    }

    @Override
    public String getVersion() {
        return System.getProperty("os.version");
    }

    private native long getTotalPhysicalMemoryImpl();

    @Override
    public long getTotalPhysicalMemory() {
        return this.getTotalPhysicalMemoryImpl();
    }

    private native int getProcessingCapacityImpl();

    @Override
    public int getProcessingCapacity() {
        return this.getProcessingCapacityImpl();
    }

    @Override
    public void removeNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws ListenerNotFoundException {
        this.notifier.removeNotificationListener(notificationListener, notificationFilter, object);
    }

    @Override
    public void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws IllegalArgumentException {
        this.notifier.addNotificationListener(notificationListener, notificationFilter, object);
    }

    @Override
    public void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        this.notifier.removeNotificationListener(notificationListener);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[3];
        String[] stringArray = new String[]{"com.ibm.management.processing.capacity.change"};
        mBeanNotificationInfoArray[0] = new MBeanNotificationInfo(stringArray, Notification.class.getName(), "Processing Capacity Notification");
        stringArray = new String[]{"com.ibm.management.total.physical.memory.change"};
        mBeanNotificationInfoArray[1] = new MBeanNotificationInfo(stringArray, Notification.class.getName(), "Total Physical Memory Notification");
        stringArray = new String[]{"com.ibm.management.available.processors.change"};
        mBeanNotificationInfoArray[2] = new MBeanNotificationInfo(stringArray, Notification.class.getName(), "Available Processors Notification");
        return mBeanNotificationInfoArray;
    }

    public void sendNotification(Notification notification) {
        this.notifier.sendNotification(notification);
    }

    private native double getSystemLoadAverageImpl();

    @Override
    public double getSystemLoadAverage() {
        return this.getSystemLoadAverageImpl();
    }

    private native long getProcessCpuTimeImpl();

    @Override
    public long getProcessCpuTime() {
        return this.getProcessCpuTimeImpl();
    }

    @Override
    public long getProcessCpuTimeByNS() {
        return this.getProcessCpuTime() * 100L;
    }

    @Override
    public double getSystemCpuLoad() {
        return this.cpuUtilizationHelper.getSystemCpuLoad();
    }

    private native long getFreePhysicalMemorySizeImpl();

    @Override
    public long getFreePhysicalMemorySize() {
        return this.getFreePhysicalMemorySizeImpl();
    }

    private native long getProcessVirtualMemorySizeImpl();

    @Override
    public long getProcessVirtualMemorySize() {
        return this.getProcessVirtualMemorySizeImpl();
    }

    private native long getProcessPrivateMemorySizeImpl();

    @Override
    public long getProcessPrivateMemorySize() {
        return this.getProcessPrivateMemorySizeImpl();
    }

    private native long getProcessPhysicalMemorySizeImpl();

    @Override
    public long getProcessPhysicalMemorySize() {
        return this.getProcessPhysicalMemorySizeImpl();
    }

    @Override
    public abstract double getProcessCpuLoad();

    @Override
    public abstract long getFreeSwapSpaceSize();

    @Override
    public abstract long getTotalSwapSpaceSize();

    @Override
    public abstract ProcessorUsage retrieveTotalProcessorUsage(ProcessorUsage var1) throws NullPointerException, ProcessorUsageRetrievalException;

    @Override
    public abstract ProcessorUsage retrieveTotalProcessorUsage() throws ProcessorUsageRetrievalException;

    @Override
    public abstract ProcessorUsage[] retrieveProcessorUsage(ProcessorUsage[] var1) throws NullPointerException, ProcessorUsageRetrievalException, IllegalArgumentException;

    @Override
    public abstract ProcessorUsage[] retrieveProcessorUsage() throws ProcessorUsageRetrievalException;

    @Override
    public abstract MemoryUsage retrieveMemoryUsage(MemoryUsage var1) throws NullPointerException, MemoryUsageRetrievalException;

    @Override
    public abstract MemoryUsage retrieveMemoryUsage() throws MemoryUsageRetrievalException;
}

