/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.management;

import com.ibm.lang.management.AvailableProcessorsNotificationInfo;
import com.ibm.lang.management.ManagementUtils;
import com.ibm.lang.management.OperatingSystemMXBeanImpl;
import com.ibm.lang.management.OperatingSystemNotificationThreadShutdown;
import com.ibm.lang.management.ProcessingCapacityNotificationInfo;
import com.ibm.lang.management.TotalPhysicalMemoryNotificationInfo;
import javax.management.Notification;

class OperatingSystemNotificationThread
extends Thread {
    private final OperatingSystemMXBeanImpl osBean;

    public OperatingSystemNotificationThread(OperatingSystemMXBeanImpl operatingSystemMXBeanImpl) {
        this.osBean = operatingSystemMXBeanImpl;
    }

    @Override
    public void run() {
        OperatingSystemNotificationThreadShutdown operatingSystemNotificationThreadShutdown = new OperatingSystemNotificationThreadShutdown(this);
        try {
            Runtime.getRuntime().addShutdownHook(operatingSystemNotificationThreadShutdown);
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        this.processNotificationLoop();
    }

    private native void processNotificationLoop();

    private void dispatchNotificationHelper(int n, long l, long l2) {
        if (n == 1) {
            AvailableProcessorsNotificationInfo availableProcessorsNotificationInfo = new AvailableProcessorsNotificationInfo((int)l);
            Notification notification = new Notification("com.ibm.management.available.processors.change", "java.lang:type=OperatingSystem", l2);
            notification.setUserData(ManagementUtils.toAvailableProcessorsNotificationInfoCompositeData(availableProcessorsNotificationInfo));
            this.osBean.sendNotification(notification);
        } else if (n == 2) {
            ProcessingCapacityNotificationInfo processingCapacityNotificationInfo = new ProcessingCapacityNotificationInfo((int)l);
            Notification notification = new Notification("com.ibm.management.processing.capacity.change", "java.lang:type=OperatingSystem", l2);
            notification.setUserData(ManagementUtils.toProcessingCapacityNotificationInfoCompositeData(processingCapacityNotificationInfo));
            this.osBean.sendNotification(notification);
        } else if (n == 3) {
            TotalPhysicalMemoryNotificationInfo totalPhysicalMemoryNotificationInfo = new TotalPhysicalMemoryNotificationInfo(l);
            Notification notification = new Notification("com.ibm.management.total.physical.memory.change", "java.lang:type=OperatingSystem", l2);
            notification.setUserData(ManagementUtils.toTotalPhysicalMemoryNotificationInfoCompositeData(totalPhysicalMemoryNotificationInfo));
            this.osBean.sendNotification(notification);
        }
    }
}

