/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.management;

import com.ibm.lang.management.DynamicMXBeanImpl;
import com.ibm.lang.management.ManagementUtils;
import java.lang.management.LockInfo;
import java.lang.management.ManagementPermission;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import javax.management.MBeanInfo;

public final class ThreadMXBeanImpl
extends DynamicMXBeanImpl
implements ThreadMXBean {
    private static ThreadMXBeanImpl instance = new ThreadMXBeanImpl();
    private static Boolean isThreadCpuTimeEnabled = null;
    private static Boolean isThreadCpuTimeSupported = null;

    ThreadMXBeanImpl() {
        super(ManagementUtils.createObjectName("java.lang:type=Threading"));
        this.setMBeanInfo(null);
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        if (this.info == null) {
            this.setMBeanInfo(ManagementUtils.getMBeanInfo(ThreadMXBean.class.getName()));
        }
        return this.info;
    }

    static ThreadMXBeanImpl getInstance() {
        return instance;
    }

    private native long[] findMonitorDeadlockedThreadsImpl();

    @Override
    public long[] findMonitorDeadlockedThreads() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ManagementPermission("monitor"));
        }
        return this.findMonitorDeadlockedThreadsImpl();
    }

    private native long[] getAllThreadIdsImpl();

    @Override
    public long[] getAllThreadIds() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ManagementPermission("monitor"));
        }
        return this.getAllThreadIdsImpl();
    }

    @Override
    public long getCurrentThreadCpuTime() {
        long l = -1L;
        if (this.isCurrentThreadCpuTimeSupported()) {
            if (this.isThreadCpuTimeEnabled()) {
                l = this.getThreadCpuTimeImpl(Thread.currentThread().getId());
            }
        } else {
            throw new UnsupportedOperationException("CPU time measurement is not supported on this virtual machine.");
        }
        return l;
    }

    @Override
    public long getCurrentThreadUserTime() {
        long l = -1L;
        if (this.isCurrentThreadCpuTimeSupported()) {
            if (this.isThreadCpuTimeEnabled()) {
                l = this.getThreadUserTimeImpl(Thread.currentThread().getId());
            }
        } else {
            throw new UnsupportedOperationException("CPU time measurement is not supported on this virtual machine.");
        }
        return l;
    }

    private native int getDaemonThreadCountImpl();

    @Override
    public int getDaemonThreadCount() {
        return this.getDaemonThreadCountImpl();
    }

    private native int getPeakThreadCountImpl();

    @Override
    public int getPeakThreadCount() {
        return this.getPeakThreadCountImpl();
    }

    private native int getThreadCountImpl();

    @Override
    public int getThreadCount() {
        return this.getThreadCountImpl();
    }

    private native long getThreadCpuTimeImpl(long var1);

    @Override
    public long getThreadCpuTime(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("Thread id must be greater than 0.");
        }
        long l2 = -1L;
        if (this.isThreadCpuTimeSupported()) {
            if (this.isThreadCpuTimeEnabled()) {
                l2 = this.getThreadCpuTimeImpl(l);
            }
        } else {
            throw new UnsupportedOperationException("CPU time measurement is not supported on this virtual machine.");
        }
        return l2;
    }

    @Override
    public ThreadInfo getThreadInfo(long l) {
        return this.getThreadInfo(l, 0);
    }

    @Override
    public ThreadInfo[] getThreadInfo(long[] lArray) {
        return this.getThreadInfo(lArray, 0);
    }

    @Override
    public ThreadInfo[] getThreadInfo(long[] lArray, int n) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ManagementPermission("monitor"));
        }
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] > 0L) continue;
            throw new IllegalArgumentException("Thread id must be greater than 0.");
        }
        if (n < 0) {
            throw new IllegalArgumentException("maxDepth value cannot be negative.");
        }
        return this.getMultiThreadInfoImpl(lArray, n, false, false);
    }

    @Override
    public ThreadInfo[] getThreadInfo(long[] lArray, boolean bl, boolean bl2) {
        if (bl && !this.isObjectMonitorUsageSupported()) {
            throw new UnsupportedOperationException("Monitoring of object monitors is not supported on this virtual machine");
        }
        if (bl2 && !this.isSynchronizerUsageSupported()) {
            throw new UnsupportedOperationException("Monitoring of ownable synchronizer usage is not supported on this virtual machine");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ManagementPermission("monitor"));
        }
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] > 0L) continue;
            throw new IllegalArgumentException("Thread id must be greater than 0.");
        }
        return this.getMultiThreadInfoImpl(lArray, Integer.MAX_VALUE, bl, bl2);
    }

    @Override
    public ThreadInfo getThreadInfo(long l, int n) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ManagementPermission("monitor"));
        }
        if (l <= 0L) {
            throw new IllegalArgumentException("Thread id must be greater than 0.");
        }
        if (n < 0) {
            throw new IllegalArgumentException("maxDepth value cannot be negative.");
        }
        return this.getThreadInfoImpl(l, n);
    }

    private native Thread getThreadByIdImpl(long var1);

    private native ThreadInfo getThreadInfoImpl(long var1, int var3);

    private native LockInfo[] getLockedSynchronizers(long var1);

    private native MonitorInfo[] getLockedMonitors(long var1);

    private native long getThreadUserTimeImpl(long var1);

    @Override
    public long getThreadUserTime(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("Thread id must be greater than 0.");
        }
        long l2 = -1L;
        if (this.isThreadCpuTimeSupported()) {
            if (this.isThreadCpuTimeEnabled()) {
                l2 = this.getThreadUserTimeImpl(l);
            }
        } else {
            throw new UnsupportedOperationException("CPU time measurement is not supported on this virtual machine.");
        }
        return l2;
    }

    private native long getTotalStartedThreadCountImpl();

    @Override
    public long getTotalStartedThreadCount() {
        return this.getTotalStartedThreadCountImpl();
    }

    private native boolean isCurrentThreadCpuTimeSupportedImpl();

    @Override
    public boolean isCurrentThreadCpuTimeSupported() {
        return this.isCurrentThreadCpuTimeSupportedImpl();
    }

    private native boolean isThreadContentionMonitoringEnabledImpl();

    @Override
    public boolean isThreadContentionMonitoringEnabled() {
        if (!this.isThreadContentionMonitoringSupported()) {
            throw new UnsupportedOperationException("Thread contention monitoring is not supported on this virtual machine.");
        }
        return this.isThreadContentionMonitoringEnabledImpl();
    }

    private native boolean isThreadContentionMonitoringSupportedImpl();

    @Override
    public boolean isThreadContentionMonitoringSupported() {
        return this.isThreadContentionMonitoringSupportedImpl();
    }

    private native boolean isThreadCpuTimeEnabledImpl();

    @Override
    public boolean isThreadCpuTimeEnabled() {
        if (!this.isThreadCpuTimeSupported() && !this.isCurrentThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException("Thread CPU timing is not supported on this virtual machine.");
        }
        if (isThreadCpuTimeEnabled == null) {
            isThreadCpuTimeEnabled = this.isThreadCpuTimeEnabledImpl();
        }
        return isThreadCpuTimeEnabled;
    }

    private native boolean isThreadCpuTimeSupportedImpl();

    @Override
    public boolean isThreadCpuTimeSupported() {
        if (isThreadCpuTimeSupported == null) {
            isThreadCpuTimeSupported = this.isThreadCpuTimeSupportedImpl();
        }
        return isThreadCpuTimeSupported;
    }

    private native void resetPeakThreadCountImpl();

    @Override
    public void resetPeakThreadCount() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ManagementPermission("control"));
        }
        this.resetPeakThreadCountImpl();
    }

    private native void setThreadContentionMonitoringEnabledImpl(boolean var1);

    @Override
    public void setThreadContentionMonitoringEnabled(boolean bl) {
        if (!this.isThreadContentionMonitoringSupported()) {
            throw new UnsupportedOperationException("Thread contention monitoring is not supported on this virtual machine.");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ManagementPermission("control"));
        }
        this.setThreadContentionMonitoringEnabledImpl(bl);
    }

    private native void setThreadCpuTimeEnabledImpl(boolean var1);

    @Override
    public void setThreadCpuTimeEnabled(boolean bl) {
        if (!this.isThreadCpuTimeSupported() && !this.isCurrentThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException("Thread CPU timing is not supported on this virtual machine.");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ManagementPermission("control"));
        }
        this.setThreadCpuTimeEnabledImpl(bl);
        isThreadCpuTimeEnabled = bl;
    }

    @Override
    public boolean isObjectMonitorUsageSupported() {
        return this.isObjectMonitorUsageSupportedImpl();
    }

    private native boolean isObjectMonitorUsageSupportedImpl();

    @Override
    public boolean isSynchronizerUsageSupported() {
        return this.isSynchronizerUsageSupportedImpl();
    }

    private native boolean isSynchronizerUsageSupportedImpl();

    @Override
    public long[] findDeadlockedThreads() {
        if (!this.isSynchronizerUsageSupported()) {
            throw new UnsupportedOperationException("Monitoring of ownable synchronizer usage is not supported on this virtual machine");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ManagementPermission("monitor"));
        }
        return this.findDeadlockedThreadsImpl();
    }

    private native long[] findDeadlockedThreadsImpl();

    @Override
    public ThreadInfo[] dumpAllThreads(boolean bl, boolean bl2) {
        if (bl && !this.isObjectMonitorUsageSupported()) {
            throw new UnsupportedOperationException("Monitoring of object monitors is not supported on this virtual machine");
        }
        if (bl2 && !this.isSynchronizerUsageSupported()) {
            throw new UnsupportedOperationException("Monitoring of ownable synchronizer usage is not supported on this virtual machine");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ManagementPermission("monitor"));
        }
        return this.dumpAllThreadsImpl(bl, bl2);
    }

    private native ThreadInfo[] dumpAllThreadsImpl(boolean var1, boolean var2);

    private native ThreadInfo[] getMultiThreadInfoImpl(long[] var1, int var2, boolean var3, boolean var4);
}

