/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.mbean;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

public class HCSslSocketFactory {
    private static HCSslSocketFactory defaultSocketFactory = null;
    private static String keystoreName = "";
    private static String keystorePassword = "";
    private static String certificatePassword = "";

    public static void setSSLValues(String string, String string2, String string3) {
        keystoreName = string;
        keystorePassword = string2;
        certificatePassword = string3;
    }

    public static synchronized HCSslSocketFactory getDefaultSocketFactory() {
        if (defaultSocketFactory == null) {
            defaultSocketFactory = new HCSslSocketFactory();
        }
        return defaultSocketFactory;
    }

    public Socket createSocket(String string, int n) throws IOException {
        SSLSocket sSLSocket = null;
        FileInputStream fileInputStream = new FileInputStream(new File(keystoreName));
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("IBMX509");
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(fileInputStream, keystorePassword.toCharArray());
            keyManagerFactory.init(keyStore, certificatePassword.toCharArray());
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("IBMX509");
            trustManagerFactory.init(keyStore);
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            sSLContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
            SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
            sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(string, n);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException(noSuchAlgorithmException);
        }
        catch (KeyStoreException keyStoreException) {
            throw new IOException(keyStoreException);
        }
        catch (CertificateException certificateException) {
            throw new IOException(certificateException);
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            throw new IOException(unrecoverableKeyException);
        }
        catch (KeyManagementException keyManagementException) {
            throw new IOException(keyManagementException);
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
        return sSLSocket;
    }
}

