/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.api.classes.impl;

import com.ibm.java.diagnostics.common.datamodel.data.Data;
import com.ibm.java.diagnostics.common.datamodel.data.DataPointBuilder;
import com.ibm.java.diagnostics.healthcenter.JVMLabels;
import com.ibm.java.diagnostics.healthcenter.api.classes.ClassHistogramData;
import com.ibm.java.diagnostics.healthcenter.api.classes.ClassLoadData;
import com.ibm.java.diagnostics.healthcenter.api.classes.ClassesData;
import com.ibm.java.diagnostics.healthcenter.api.classes.impl.ClassHistogramDataImpl;
import com.ibm.java.diagnostics.healthcenter.api.classes.impl.ClassLoadDataImpl;
import com.ibm.java.diagnostics.healthcenter.api.impl.HealthCenterDataImpl;
import com.ibm.java.diagnostics.healthcenter.classes.ClassHistogramLabels;
import com.ibm.java.diagnostics.healthcenter.classes.ClassesLabels;
import com.ibm.java.diagnostics.healthcenter.classes.datamodel.ClassHistogramDataPointImpl;
import com.ibm.java.diagnostics.healthcenter.classes.datamodel.ClassLoadingDataPointImpl;
import java.util.Date;
import javax.management.Notification;

public class ClassesDataImpl
extends HealthCenterDataImpl
implements ClassesData {
    private Notification classesLoadedNotify;
    private Notification classHistogramNotify;

    public ClassesDataImpl(Data data) {
        super(data);
    }

    @Override
    public ClassLoadData[] getClassesLoaded() {
        Data data = this.getJvmData().getTopLevelData(JVMLabels.CLASSES);
        ClassLoadData[] classLoadDataArray = new ClassLoadData[]{};
        DataPointBuilder[] dataPointBuilderArray = null;
        if (data != null && (dataPointBuilderArray = this.getEventData(data, ClassesLabels.LOADED_CLASSES)) != null) {
            classLoadDataArray = new ClassLoadData[dataPointBuilderArray.length];
            int n = 0;
            for (DataPointBuilder dataPointBuilder : dataPointBuilderArray) {
                ClassLoadingDataPointImpl classLoadingDataPointImpl = (ClassLoadingDataPointImpl)dataPointBuilder;
                classLoadDataArray[n] = new ClassLoadDataImpl(classLoadingDataPointImpl.getRawX(), classLoadingDataPointImpl.getClassLoadingEvent().getClassName(), classLoadingDataPointImpl.getClassLoadingEvent().wasCachedInSharedClasses());
                ++n;
            }
        }
        return classLoadDataArray;
    }

    @Override
    protected String getRecommendationLabel() {
        this.getJvmData();
        return ClassesLabels.RECOMMENDATION_LABEL;
    }

    @Override
    protected String getSubsystemLabel() {
        return JVMLabels.CLASSES;
    }

    @Override
    public ClassHistogramData[] getClassHistogram() {
        Data data = this.getJvmData().getTopLevelData(JVMLabels.CLASSES);
        ClassHistogramData[] classHistogramDataArray = new ClassHistogramData[]{};
        DataPointBuilder[] dataPointBuilderArray = null;
        if (data != null && (dataPointBuilderArray = this.getEventData(data, ClassHistogramLabels.CLASS_LIST)) != null) {
            classHistogramDataArray = new ClassHistogramData[dataPointBuilderArray.length];
            int n = 0;
            for (DataPointBuilder dataPointBuilder : dataPointBuilderArray) {
                ClassHistogramDataPointImpl classHistogramDataPointImpl = (ClassHistogramDataPointImpl)dataPointBuilder;
                classHistogramDataArray[n] = new ClassHistogramDataImpl(classHistogramDataPointImpl.getRawX(), classHistogramDataPointImpl.getComment(), classHistogramDataPointImpl.getCount(), classHistogramDataPointImpl.getSize());
                ++n;
            }
        }
        return classHistogramDataArray;
    }

    @Override
    public void startNotifying() {
        this.startNotifying(this.DEFAULT_NOTIFICATION);
    }

    @Override
    public void startNotifying(long l) {
        new Updater(l).start();
    }

    static /* synthetic */ long access$000(ClassesDataImpl classesDataImpl) {
        return classesDataImpl.DEFAULT_NOTIFICATION;
    }

    private class Updater
    extends Thread {
        private Date classesLoadedTime;
        private Date classHistogramTime;
        long count = 0L;
        long delay = ClassesDataImpl.access$000(ClassesDataImpl.this);

        public Updater(long l) {
            if (l >= ClassesDataImpl.this.DEFAULT_NOTIFICATION) {
                this.delay = l;
            }
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        this.classesLoadedTime = new Date();
                        this.classHistogramTime = new Date();
                        if (ClassesDataImpl.this.getClassesLoaded() != null && ClassesDataImpl.this.getClassesLoaded().length > 0 && ClassesDataImpl.this.getClassesLoaded()[ClassesDataImpl.this.getClassesLoaded().length - 1].getTime() != this.classesLoadedTime.getTime()) {
                            ClassesDataImpl.this.classesLoadedNotify = new Notification(null, ClassesDataImpl.this, this.count++);
                            ClassesDataImpl.this.classesLoadedNotify.setUserData("com.ibm.java.diagnostics.healthcenter.api.classes.LoadedClassesData");
                            ClassesDataImpl.this.sendNotification(ClassesDataImpl.this.classesLoadedNotify);
                        }
                        if (ClassesDataImpl.this.getClassHistogram() != null && ClassesDataImpl.this.getClassHistogram().length > 0 && ClassesDataImpl.this.getClassHistogram()[ClassesDataImpl.this.getClassHistogram().length - 1].getTime() != this.classHistogramTime.getTime()) {
                            ClassesDataImpl.this.classHistogramNotify = new Notification(null, ClassesDataImpl.this, this.count++);
                            ClassesDataImpl.this.classHistogramNotify.setUserData("com.ibm.java.diagnostics.healthcenter.api.classes.ClassHistogramData");
                            ClassesDataImpl.this.sendNotification(ClassesDataImpl.this.classHistogramNotify);
                        }
                        Thread.sleep(this.delay);
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread thread = Thread.currentThread();
                    thread.getUncaughtExceptionHandler().uncaughtException(thread, interruptedException);
                    continue;
                }
                break;
            }
        }
    }
}

