/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.api.factory;

import com.ibm.java.diagnostics.common.datamodel.exceptions.JavaDiagnosticsException;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.DataCollectionLevel;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HCLaunchMBean;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenterOptionHandler;
import com.ibm.java.diagnostics.healthcenter.api.ConnectionProperties;
import com.ibm.java.diagnostics.healthcenter.api.HealthCenter;
import com.ibm.java.diagnostics.healthcenter.api.HealthCenterException;
import com.ibm.java.diagnostics.healthcenter.api.HealthCenterJMXException;
import com.ibm.java.diagnostics.healthcenter.api.HealthCenterPreferences;
import com.ibm.java.diagnostics.healthcenter.api.HealthCenterSSLException;
import com.ibm.java.diagnostics.healthcenter.api.factory.Messages;
import com.ibm.java.diagnostics.healthcenter.api.impl.HealthCenterDefaultPreferences;
import com.ibm.java.diagnostics.healthcenter.api.impl.HealthCenterImpl;
import com.ibm.java.diagnostics.healthcenter.connection.AgentConnection;
import com.ibm.java.diagnostics.healthcenter.connection.ConnectionDataBuilder;
import com.ibm.java.diagnostics.healthcenter.connection.ConnectionType;
import com.ibm.java.diagnostics.healthcenter.connection.HealthCenterConnectionException;
import com.ibm.java.diagnostics.healthcenter.impl.jmx.JMXAgentConnection;
import com.ibm.java.diagnostics.healthcenter.impl.jmx.JMXAgentConnectionManager;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.MarshallerImpl;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.connection.AgentConnectionImpl;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.connection.ConnectionDataFactoryImpl;
import com.ibm.java.diagnostics.healthcenter.impl.mqtt.MQTTAgentConnection;
import com.ibm.java.diagnostics.healthcenter.impl.mqtt.MQTTAgentConnectionManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;

public class HealthCenterFactory {
    private static long memoryRestrictionSize = HealthCenterDefaultPreferences.getDefaultMaxMemoryUse();
    private static boolean memoryRestrictionEnabled = HealthCenterDefaultPreferences.getDefaultMemoryRestrictionEnabled();

    private static HealthCenter localConnect() throws HealthCenterException {
        if (!Boolean.getBoolean("com.ibm.java.diagnostics.healthcenter.running")) {
            HealthCenterFactory.loadAgent();
        }
        MarshallerImpl marshallerImpl = new MarshallerImpl();
        HealthCenterPreferences healthCenterPreferences = new HealthCenterPreferences();
        healthCenterPreferences.setMemoryRestriction(memoryRestrictionSize * 1024L * 1024L);
        healthCenterPreferences.setMemoryRestictionEnabled(memoryRestrictionEnabled);
        boolean bl = false;
        ConnectionDataBuilder connectionDataBuilder = new ConnectionDataFactoryImpl().createConnectionData();
        bl = connectionDataBuilder.connect(marshallerImpl);
        if (!bl) {
            throw new HealthCenterException(Messages.getString("HealthCenterFactory.cannot.connect.inprocess"));
        }
        return new HealthCenterImpl(marshallerImpl, healthCenterPreferences);
    }

    private static void loadAgent() {
        HealthCenterOptionHandler healthCenterOptionHandler = new HealthCenterOptionHandler(new String[0]);
        healthCenterOptionHandler.setDataCollectionLevel(DataCollectionLevel.INPROCESS);
        HCLaunchMBean hCLaunchMBean = new HCLaunchMBean(healthCenterOptionHandler);
        hCLaunchMBean.startMBeanServer(0, 0);
    }

    public static HealthCenter connect(File file) throws HealthCenterException, FileNotFoundException {
        boolean bl = false;
        if (!file.exists() || !file.isFile()) {
            throw new FileNotFoundException(file.toString());
        }
        MarshallerImpl marshallerImpl = new MarshallerImpl();
        HealthCenterPreferences healthCenterPreferences = new HealthCenterPreferences();
        healthCenterPreferences.setMemoryRestriction(memoryRestrictionSize * 1024L * 1024L);
        healthCenterPreferences.setMemoryRestictionEnabled(memoryRestrictionEnabled);
        ConnectionDataBuilder connectionDataBuilder = new ConnectionDataFactoryImpl().createConnectionData(file);
        healthCenterPreferences.isMemoryRestictionEnabled();
        bl = connectionDataBuilder.connect(marshallerImpl);
        if (!bl) {
            throw new HealthCenterException();
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            throw new HealthCenterException();
        }
        while (!marshallerImpl.isQueueEmpty()) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                throw new HealthCenterException();
            }
        }
        marshallerImpl.triggerPostProcess();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            throw new HealthCenterException();
        }
        while (!marshallerImpl.isQueueEmpty()) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                throw new HealthCenterException();
            }
        }
        return new HealthCenterImpl(marshallerImpl, healthCenterPreferences);
    }

    public static HealthCenter connect(ConnectionProperties connectionProperties) throws HealthCenterException, HealthCenterJMXException, HealthCenterSSLException {
        if (connectionProperties != null && connectionProperties.getPort() == 0) {
            return HealthCenterFactory.localConnect();
        }
        return HealthCenterFactory.connect(connectionProperties, true);
    }

    public static HealthCenter connect(ConnectionProperties connectionProperties, boolean bl) throws HealthCenterException, HealthCenterJMXException, HealthCenterSSLException {
        MarshallerImpl marshallerImpl = new MarshallerImpl();
        HealthCenterPreferences healthCenterPreferences = new HealthCenterPreferences();
        if (connectionProperties != null) {
            block13: {
                if (connectionProperties.getPort() == 0) {
                    return HealthCenterFactory.localConnect();
                }
                com.ibm.java.diagnostics.healthcenter.impl.marshalling.connection.ConnectionProperties connectionProperties2 = null;
                try {
                    connectionProperties2 = new com.ibm.java.diagnostics.healthcenter.impl.marshalling.connection.ConnectionProperties(connectionProperties.getHostname(), connectionProperties.getPort(), bl);
                }
                catch (JavaDiagnosticsException javaDiagnosticsException) {
                    throw new HealthCenterException(javaDiagnosticsException.toString());
                }
                if (connectionProperties2 != null) {
                    healthCenterPreferences.setMemoryRestriction(memoryRestrictionSize * 1024L * 1024L);
                    healthCenterPreferences.setMemoryRestictionEnabled(memoryRestrictionEnabled);
                    HealthCenterFactory.initialise(connectionProperties, connectionProperties2);
                    ConnectionDataFactoryImpl connectionDataFactoryImpl = new ConnectionDataFactoryImpl();
                    ConnectionDataBuilder connectionDataBuilder = null;
                    try {
                        try {
                            connectionDataBuilder = connectionDataFactoryImpl.createConnectionData(connectionProperties2);
                        }
                        catch (NullPointerException nullPointerException) {
                            throw new HealthCenterException(Messages.getString("HealthCenterFactory_connection_failed"));
                        }
                        boolean bl2 = connectionDataBuilder.connect(marshallerImpl);
                        if (bl2 || !connectionProperties.isJMXConnection()) break block13;
                        JMXAgentConnectionManager jMXAgentConnectionManager = new JMXAgentConnectionManager(connectionProperties2);
                        JMXAgentConnection jMXAgentConnection = null;
                        try {
                            jMXAgentConnection = jMXAgentConnectionManager.getHealthCenterAgentForPort(connectionProperties2.getPort());
                            if (jMXAgentConnection.isSecurityEnabled()) {
                                String string = Messages.getString("HealthCenterFactory_jmx_auth_required");
                                String string2 = MessageFormat.format(string, connectionProperties2.getDisplayableHostName(), connectionProperties2.getPort());
                                throw new HealthCenterJMXException(string2);
                            }
                            if (jMXAgentConnection.isSSLProbablyUsed()) {
                                String string = Messages.getString("HealthCenterFactory_ssl_auth_required");
                                String string3 = MessageFormat.format(string, connectionProperties2.getDisplayableHostName(), connectionProperties2.getPort());
                                throw new HealthCenterSSLException(string3);
                            }
                        }
                        catch (HealthCenterConnectionException healthCenterConnectionException) {
                            throw new HealthCenterException(healthCenterConnectionException.toString());
                        }
                    }
                    catch (HealthCenterConnectionException healthCenterConnectionException) {
                        throw new HealthCenterException(healthCenterConnectionException.toString());
                    }
                }
            }
            return new HealthCenterImpl(marshallerImpl, healthCenterPreferences);
        }
        throw new HealthCenterException();
    }

    public static HealthCenter connect(ConnectionProperties connectionProperties, String string) throws HealthCenterException, HealthCenterJMXException, HealthCenterSSLException {
        MarshallerImpl marshallerImpl = new MarshallerImpl();
        HealthCenterPreferences healthCenterPreferences = new HealthCenterPreferences();
        if (connectionProperties != null) {
            block13: {
                if (connectionProperties.getPort() == 0) {
                    return HealthCenterFactory.localConnect();
                }
                com.ibm.java.diagnostics.healthcenter.impl.marshalling.connection.ConnectionProperties connectionProperties2 = null;
                try {
                    connectionProperties2 = new com.ibm.java.diagnostics.healthcenter.impl.marshalling.connection.ConnectionProperties(connectionProperties.getHostname(), connectionProperties.getPort(), false);
                }
                catch (JavaDiagnosticsException javaDiagnosticsException) {
                    throw new HealthCenterException(javaDiagnosticsException.toString());
                }
                if (connectionProperties2 != null) {
                    healthCenterPreferences.setMemoryRestriction(memoryRestrictionSize * 1024L * 1024L);
                    healthCenterPreferences.setMemoryRestictionEnabled(memoryRestrictionEnabled);
                    HealthCenterFactory.initialise(connectionProperties, connectionProperties2);
                    ConnectionDataFactoryImpl connectionDataFactoryImpl = new ConnectionDataFactoryImpl();
                    ConnectionDataBuilder connectionDataBuilder = null;
                    try {
                        try {
                            connectionDataBuilder = connectionDataFactoryImpl.createConnectionData(connectionProperties2, string);
                        }
                        catch (NullPointerException nullPointerException) {
                            throw new HealthCenterException(Messages.getString("HealthCenterFactory_connection_failed"));
                        }
                        boolean bl = connectionDataBuilder.connect(marshallerImpl);
                        if (bl || !connectionProperties.isJMXConnection()) break block13;
                        JMXAgentConnectionManager jMXAgentConnectionManager = new JMXAgentConnectionManager(connectionProperties2);
                        JMXAgentConnection jMXAgentConnection = null;
                        try {
                            jMXAgentConnection = jMXAgentConnectionManager.getHealthCenterAgentForPort(connectionProperties2.getPort());
                            if (jMXAgentConnection.isSecurityEnabled()) {
                                String string2 = Messages.getString("HealthCenterFactory_jmx_auth_required");
                                String string3 = MessageFormat.format(string2, connectionProperties2.getDisplayableHostName(), connectionProperties2.getPort());
                                throw new HealthCenterJMXException(string3);
                            }
                            if (jMXAgentConnection.isSSLProbablyUsed()) {
                                String string4 = Messages.getString("HealthCenterFactory_ssl_auth_required");
                                String string5 = MessageFormat.format(string4, connectionProperties2.getDisplayableHostName(), connectionProperties2.getPort());
                                throw new HealthCenterSSLException(string5);
                            }
                        }
                        catch (HealthCenterConnectionException healthCenterConnectionException) {
                            throw new HealthCenterException(healthCenterConnectionException.toString());
                        }
                    }
                    catch (HealthCenterConnectionException healthCenterConnectionException) {
                        throw new HealthCenterException(healthCenterConnectionException.toString());
                    }
                }
            }
            return new HealthCenterImpl(marshallerImpl, healthCenterPreferences);
        }
        throw new HealthCenterException();
    }

    private static void initialise(ConnectionProperties connectionProperties, com.ibm.java.diagnostics.healthcenter.impl.marshalling.connection.ConnectionProperties connectionProperties2) {
        if (connectionProperties.isMQTTConnection()) {
            if (connectionProperties.isUseMQTTAuth()) {
                connectionProperties2.setAuthentication(connectionProperties.getMqttUsername(), connectionProperties.getMqttPassword());
                connectionProperties2.setAuthenticationEnabled(connectionProperties.isUseMQTTAuth());
            }
            connectionProperties2.setConnectionType(ConnectionType.MQTT);
        }
        if (connectionProperties.isJMXConnection()) {
            if (connectionProperties.isUseJXMAuth()) {
                connectionProperties2.setAuthentication(connectionProperties.getJmxUsername(), connectionProperties.getJmxPassword());
                connectionProperties2.setAuthenticationEnabled(connectionProperties.isUseJXMAuth());
            }
            if (connectionProperties.isUseSSLAuth()) {
                if (connectionProperties.getSSLTruststoreCertificatePassword() == null) {
                    connectionProperties.setSSLTruststoreCertificatePassword(connectionProperties.getSSLTruststorePassword());
                }
                connectionProperties2.setSSLvalues(connectionProperties.getSSLTruststoreLocation(), connectionProperties.getSSLTruststorePassword(), connectionProperties.getSSLTruststoreCertificatePassword());
                connectionProperties2.setSSLEnabled(connectionProperties.isUseSSLAuth());
            }
            connectionProperties2.setConnectionType(ConnectionType.JMX);
        }
    }

    public static int[] scanForPort(ConnectionProperties connectionProperties, int n, boolean bl) throws HealthCenterException {
        Object object;
        com.ibm.java.diagnostics.healthcenter.impl.marshalling.connection.ConnectionProperties connectionProperties2;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        try {
            connectionProperties2 = new com.ibm.java.diagnostics.healthcenter.impl.marshalling.connection.ConnectionProperties(connectionProperties.getHostname(), connectionProperties.getPort(), false);
        }
        catch (HealthCenterConnectionException healthCenterConnectionException) {
            throw new HealthCenterException(healthCenterConnectionException.toString());
        }
        int n2 = connectionProperties.getPort();
        if (connectionProperties2 != null) {
            int n3;
            AgentConnectionImpl agentConnectionImpl;
            if (connectionProperties.isJMXConnection()) {
                object = new JMXAgentConnectionManager(connectionProperties2);
                agentConnectionImpl = null;
                for (n3 = 0; n3 < n; ++n3) {
                    try {
                        agentConnectionImpl = ((JMXAgentConnectionManager)object).getHealthCenterAgentForPort(n2);
                    }
                    catch (HealthCenterConnectionException healthCenterConnectionException) {
                        throw new HealthCenterException(healthCenterConnectionException.toString());
                    }
                    if (agentConnectionImpl != null) {
                        arrayList.add(n2);
                        if (bl) break;
                    }
                    ++n2;
                }
            }
            if (connectionProperties.isMQTTConnection()) {
                object = new MQTTAgentConnectionManager(connectionProperties2);
                agentConnectionImpl = null;
                for (n3 = 0; n3 < n; ++n3) {
                    try {
                        agentConnectionImpl = (MQTTAgentConnection)((MQTTAgentConnectionManager)object).getHealthCenterAgentForPort(n2);
                    }
                    catch (HealthCenterConnectionException healthCenterConnectionException) {
                        throw new HealthCenterException(healthCenterConnectionException.toString());
                    }
                    if (agentConnectionImpl != null) {
                        arrayList.add(n2);
                        if (bl) break;
                    }
                    ++n2;
                }
            }
        }
        object = new int[arrayList.size()];
        int n4 = 0;
        for (Integer n5 : arrayList) {
            object[n4] = n5;
            ++n4;
        }
        return object;
    }

    public static String[] scanForAgents(ConnectionProperties connectionProperties, int n) throws HealthCenterException {
        Object object;
        Iterator iterator;
        Object object2;
        com.ibm.java.diagnostics.healthcenter.impl.marshalling.connection.ConnectionProperties connectionProperties2;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            connectionProperties2 = new com.ibm.java.diagnostics.healthcenter.impl.marshalling.connection.ConnectionProperties(connectionProperties.getHostname(), connectionProperties.getPort(), false);
        }
        catch (HealthCenterConnectionException healthCenterConnectionException) {
            throw new HealthCenterException(healthCenterConnectionException.toString());
        }
        if (connectionProperties2 != null) {
            Object object3;
            if (connectionProperties.isJMXConnection()) {
                object2 = new JMXAgentConnectionManager(connectionProperties2);
                object3 = null;
                try {
                    object3 = (JMXAgentConnection)((JMXAgentConnectionManager)object2).getHealthCenterAgent();
                }
                catch (HealthCenterConnectionException healthCenterConnectionException) {
                    throw new HealthCenterException(healthCenterConnectionException.toString());
                }
                if (object3 != null) {
                    arrayList.add(((AgentConnectionImpl)object3).getDescription());
                }
            }
            if (connectionProperties.isMQTTConnection()) {
                object2 = new MQTTAgentConnectionManager(connectionProperties2);
                object3 = null;
                try {
                    object3 = ((MQTTAgentConnectionManager)object2).getHealthCenterAgentsForPort(connectionProperties2.getPort(), n);
                }
                catch (HealthCenterConnectionException healthCenterConnectionException) {
                    throw new HealthCenterException(healthCenterConnectionException.toString());
                }
                if (object3 != null) {
                    iterator = object3.iterator();
                    while (iterator.hasNext()) {
                        object = (AgentConnection)iterator.next();
                        arrayList.add(object.getDescription());
                    }
                }
            }
        }
        object2 = new String[arrayList.size()];
        int n2 = 0;
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object2[n2] = object = (String)iterator.next();
            ++n2;
        }
        return object2;
    }

    public static void setMemoryRestrictionSize(long l) {
        memoryRestrictionSize = l;
    }

    public static void setMemoryRestictionEnabled(boolean bl) {
        memoryRestrictionEnabled = bl;
    }
}

