/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.api.impl;

import com.ibm.java.diagnostics.common.datamodel.data.Data;
import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.DataPointBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.axes.XDataAxis;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.AxisPairImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.XDataAxisImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.converters.UnitLabels;
import com.ibm.java.diagnostics.common.datamodel.impl.data.DataPointImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.data.RootDataImpl;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.healthcenter.JVMLabels;
import com.ibm.java.diagnostics.healthcenter.api.HealthCenter;
import com.ibm.java.diagnostics.healthcenter.api.HealthCenterPreferences;
import com.ibm.java.diagnostics.healthcenter.api.classes.ClassesData;
import com.ibm.java.diagnostics.healthcenter.api.classes.impl.ClassesDataImpl;
import com.ibm.java.diagnostics.healthcenter.api.cpu.CpuData;
import com.ibm.java.diagnostics.healthcenter.api.cpu.impl.CpuDataImpl;
import com.ibm.java.diagnostics.healthcenter.api.environment.EnvironmentData;
import com.ibm.java.diagnostics.healthcenter.api.environment.impl.EnvironmentDataImpl;
import com.ibm.java.diagnostics.healthcenter.api.gc.GCData;
import com.ibm.java.diagnostics.healthcenter.api.gc.impl.GCDataImpl;
import com.ibm.java.diagnostics.healthcenter.api.io.IOData;
import com.ibm.java.diagnostics.healthcenter.api.io.impl.IODataImpl;
import com.ibm.java.diagnostics.healthcenter.api.locking.LockingData;
import com.ibm.java.diagnostics.healthcenter.api.locking.impl.LockingDataImpl;
import com.ibm.java.diagnostics.healthcenter.api.methodtrace.MethodTraceData;
import com.ibm.java.diagnostics.healthcenter.api.methodtrace.impl.MethodTraceDataImpl;
import com.ibm.java.diagnostics.healthcenter.api.nativememory.NativeMemoryData;
import com.ibm.java.diagnostics.healthcenter.api.nativememory.impl.NativeMemoryDataImpl;
import com.ibm.java.diagnostics.healthcenter.api.profiling.ProfilingData;
import com.ibm.java.diagnostics.healthcenter.api.profiling.impl.ProfilingDataImpl;
import com.ibm.java.diagnostics.healthcenter.api.threads.ThreadsData;
import com.ibm.java.diagnostics.healthcenter.api.threads.impl.ThreadsDataImpl;
import com.ibm.java.diagnostics.healthcenter.api.vmcontrol.VMControl;
import com.ibm.java.diagnostics.healthcenter.api.vmcontrol.impl.VMControlImpl;
import com.ibm.java.diagnostics.healthcenter.connection.ConnectionData;
import com.ibm.java.diagnostics.healthcenter.impl.datatruncation.DataPurgingJob;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.MarshallerImpl;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.PostProcessingJob;
import com.ibm.java.diagnostics.healthcenter.marshaller.HealthCenterJob;
import java.io.File;
import java.io.IOException;
import java.util.Date;

public class HealthCenterImpl
implements HealthCenter {
    private NativeMemoryData cachedMemoryData = null;
    private GCData cachedGCData = null;
    private CpuData cachedCpuData = null;
    private EnvironmentData cachedEnvData = null;
    private VMControl cachedVMControl = null;
    private IOData cachedIOData = null;
    private ClassesData cachedClassesData = null;
    private ProfilingData cachedProfilingData = null;
    private ThreadsData cachedThreadData = null;
    private LockingData cachedLockingData = null;
    private MethodTraceData cachedMethodTraceData = null;
    private static int MS_PER_MINUTE = 60000;
    private static int MS_PER_SECONDS = 1000;
    protected MarshallerImpl marshaller;
    private HealthCenterPreferences prefs;
    private Data connectionData = null;

    @Override
    public IOData getIOData() {
        if (this.cachedIOData == null && this.doesDataExist(JVMLabels.IO)) {
            this.cachedIOData = new IODataImpl(this.marshaller.getData(null));
        }
        return this.cachedIOData;
    }

    public HealthCenterImpl(MarshallerImpl marshallerImpl, HealthCenterPreferences healthCenterPreferences) {
        this.marshaller = marshallerImpl;
        this.prefs = healthCenterPreferences;
    }

    @Override
    public LockingData getLockingData() {
        if (this.cachedLockingData == null && this.doesDataExist(JVMLabels.LOCKING)) {
            this.cachedLockingData = new LockingDataImpl(this.marshaller.getData(null));
        }
        return this.cachedLockingData;
    }

    @Override
    public CpuData getCpuData() {
        if (this.cachedCpuData == null && this.doesDataExist(JVMLabels.CPU)) {
            this.cachedCpuData = new CpuDataImpl(this.marshaller.getData(null));
        }
        return this.cachedCpuData;
    }

    @Override
    public ClassesData getClassesData() {
        if (this.cachedClassesData == null && this.doesDataExist(JVMLabels.CLASSES)) {
            this.cachedClassesData = new ClassesDataImpl(this.marshaller.getData(null));
        }
        return this.cachedClassesData;
    }

    @Override
    public GCData getGCData() {
        if (this.cachedGCData == null && this.doesDataExist(JVMLabels.GARBAGE_COLLECTION)) {
            this.cachedGCData = new GCDataImpl(this.marshaller.getData(null));
        }
        return this.cachedGCData;
    }

    @Override
    public NativeMemoryData getNativeMemoryData() {
        if (this.cachedMemoryData == null && this.doesDataExist(JVMLabels.MEMORY)) {
            this.cachedMemoryData = new NativeMemoryDataImpl(this.marshaller.getData(null));
        }
        return this.cachedMemoryData;
    }

    @Override
    public EnvironmentData getEnvironmentData() {
        if (this.cachedEnvData == null && this.doesDataExist(JVMLabels.ENVIRONMENT)) {
            this.cachedEnvData = new EnvironmentDataImpl(this.marshaller.getData(null));
        }
        return this.cachedEnvData;
    }

    @Override
    public ThreadsData getThreadsData() {
        if (this.cachedThreadData == null && this.doesDataExist(JVMLabels.THREADS)) {
            this.cachedThreadData = new ThreadsDataImpl(this.marshaller.getData(null));
        }
        return this.cachedThreadData;
    }

    @Override
    public VMControl getVMControl() {
        if (this.cachedVMControl == null && this.doesDataExist(JVMLabels.ENVIRONMENT)) {
            this.cachedVMControl = new VMControlImpl(this.marshaller);
        }
        return this.cachedVMControl;
    }

    @Override
    public ProfilingData getProfilingData() {
        if (this.cachedProfilingData == null) {
            this.cachedProfilingData = new ProfilingDataImpl(this.marshaller.getData(null));
        }
        return this.cachedProfilingData;
    }

    private boolean doesDataExist(String string) {
        Data data = null;
        data = this.marshaller.getData(null);
        if (data != null) {
            return data.getTopLevelData(string) != null;
        }
        return false;
    }

    @Override
    public void setTimeThreshold(int n) {
        this.setTimeThresholds(n, 0);
    }

    @Override
    public void setTimeThresholds(int n, int n2) {
        DataBuilder dataBuilder = (DataBuilder)this.marshaller.getData(null);
        DataPointBuilder dataPointBuilder = dataBuilder.getEarliestOverallXAxisValue();
        if (dataPointBuilder != null) {
            DataPointImpl dataPointImpl;
            double d;
            double d2 = dataPointBuilder.getRawX();
            XDataAxis xDataAxis = dataPointBuilder.getXAxis();
            AxisPairImpl axisPairImpl = new AxisPairImpl(dataPointBuilder.getXAxis(), dataPointBuilder.getYAxis());
            if (n > 0) {
                d = d2 + (double)(n * MS_PER_MINUTE);
                dataPointImpl = new DataPointImpl(0, d, 0.0, axisPairImpl);
                xDataAxis.setMinimumBound(dataPointImpl);
            }
            if (n2 > 0) {
                d = d2 + (double)(n2 * MS_PER_MINUTE);
                dataPointImpl = new DataPointImpl(0, d, 0.0, axisPairImpl);
                xDataAxis.setMaximumBound(dataPointImpl);
            }
        }
    }

    @Override
    public void setFineGrainTimeThresholds(int n, int n2) {
        DataBuilder dataBuilder = (DataBuilder)this.marshaller.getData(null);
        DataPointBuilder dataPointBuilder = dataBuilder.getEarliestOverallXAxisValue();
        if (dataPointBuilder != null) {
            DataPointImpl dataPointImpl;
            double d;
            double d2 = dataPointBuilder.getRawX();
            XDataAxis xDataAxis = dataPointBuilder.getXAxis();
            AxisPairImpl axisPairImpl = new AxisPairImpl(dataPointBuilder.getXAxis(), dataPointBuilder.getYAxis());
            if (n > 0) {
                d = d2 + (double)n;
                dataPointImpl = new DataPointImpl(0, d, 0.0, axisPairImpl);
                xDataAxis.setMinimumBound(dataPointImpl);
            }
            if (n2 > 0) {
                d = d2 + (double)n2;
                dataPointImpl = new DataPointImpl(0, d, 0.0, axisPairImpl);
                xDataAxis.setMaximumBound(dataPointImpl);
            }
        }
    }

    @Override
    public void clearTimeThresholds() {
        DataBuilder dataBuilder = (DataBuilder)this.marshaller.getData(null);
        DataPointBuilder dataPointBuilder = dataBuilder.getEarliestOverallXAxisValue();
        if (dataPointBuilder != null) {
            XDataAxisImpl xDataAxisImpl = (XDataAxisImpl)dataPointBuilder.getXAxis();
            xDataAxisImpl.clearMinimumBound();
            xDataAxisImpl.clearMaximumBound();
        }
    }

    @Override
    public HealthCenterPreferences getPreferences() {
        return this.prefs;
    }

    @Override
    public void saveData(File file) throws IOException {
        if (file.isDirectory()) {
            this.marshaller.saveBackingHCD(file.getCanonicalPath() + File.separator + "healthcenter");
        } else {
            this.marshaller.saveBackingHCD(file.getCanonicalPath());
        }
    }

    @Override
    public MethodTraceData getMethodTraceData() {
        if (this.cachedMethodTraceData == null && this.doesDataExist(JVMLabels.METHODTRACE)) {
            this.cachedMethodTraceData = new MethodTraceDataImpl(this.marshaller.getData(null));
        }
        return this.cachedMethodTraceData;
    }

    @Override
    public long getAmountOfDataReceived() {
        Data data;
        if (this.connectionData == null && (data = this.marshaller.getData(null)) != null) {
            this.connectionData = data.getTopLevelData(JVMLabels.CONNECTION);
        }
        if (this.connectionData != null && this.connectionData instanceof ConnectionData) {
            return ((ConnectionData)this.connectionData).getAmountOfDataReceived();
        }
        return 0L;
    }

    @Override
    public Date getLastUpdated() {
        Data data;
        if (this.connectionData == null && (data = this.marshaller.getData(null)) != null) {
            this.connectionData = data.getTopLevelData(JVMLabels.CONNECTION);
        }
        if (this.connectionData != null && this.connectionData instanceof ConnectionData) {
            return ((ConnectionData)this.connectionData).getLastUpdated();
        }
        return null;
    }

    @Override
    public boolean isConnectionAlive() {
        Data data;
        if (this.connectionData == null && (data = this.marshaller.getData(null)) != null) {
            this.connectionData = data.getTopLevelData(JVMLabels.CONNECTION);
        }
        if (this.connectionData != null && this.connectionData instanceof ConnectionData) {
            return ((ConnectionData)this.connectionData).isConnectionAlive();
        }
        return false;
    }

    @Override
    public void endMonitoring() {
        MarshallerImpl.destroyMarshaller(false);
    }

    @Override
    public void resetData() {
        Data data = this.marshaller.getData(null);
        if (data instanceof DataBuilder) {
            DataBuilder dataBuilder = (DataBuilder)data;
            OutputProperties outputProperties = this.marshaller.getOutputProperties(null);
            DataPointBuilder dataPointBuilder = dataBuilder.getLargestOverallXAxisValue();
            if (dataPointBuilder != null) {
                HealthCenterJob healthCenterJob;
                XDataAxis xDataAxis = dataPointBuilder.getXAxis();
                xDataAxis.setMinimumBound(dataPointBuilder);
                if (dataBuilder instanceof RootDataImpl) {
                    healthCenterJob = new PostProcessingJob((RootDataImpl)dataBuilder, outputProperties, this.marshaller);
                    this.marshaller.addJobToQueue(healthCenterJob);
                }
                healthCenterJob = new DataPurgingJob(dataBuilder, dataPointBuilder.getX(UnitLabels.MILLISECONDS) + 1.0, UnitLabels.MILLISECONDS);
                this.marshaller.addJobToQueue(healthCenterJob);
            }
        }
    }

    @Override
    public Date getEarliestMonitoredDataTime() {
        Data data = this.marshaller.getData(null);
        if (data instanceof DataBuilder) {
            DataBuilder dataBuilder = (DataBuilder)data;
            return new Date((long)dataBuilder.getEarliestOverallXAxisValue().getRawX());
        }
        return null;
    }

    @Override
    public Date getLatestMonitoredDataTime() {
        Data data = this.marshaller.getData(null);
        if (data instanceof DataBuilder) {
            DataBuilder dataBuilder = (DataBuilder)data;
            if (null == dataBuilder || null == dataBuilder.getLargestOverallXAxisValue()) {
                return null;
            }
            return new Date((long)dataBuilder.getLargestOverallXAxisValue().getRawX());
        }
        return null;
    }
}

