/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.api.io.impl;

import com.ibm.java.diagnostics.common.datamodel.data.Data;
import com.ibm.java.diagnostics.common.datamodel.data.DataPointBuilder;
import com.ibm.java.diagnostics.healthcenter.JVMLabels;
import com.ibm.java.diagnostics.healthcenter.api.CountData;
import com.ibm.java.diagnostics.healthcenter.api.impl.CountDataImpl;
import com.ibm.java.diagnostics.healthcenter.api.impl.HealthCenterDataImpl;
import com.ibm.java.diagnostics.healthcenter.api.io.FileData;
import com.ibm.java.diagnostics.healthcenter.api.io.IOData;
import com.ibm.java.diagnostics.healthcenter.api.io.impl.FileDataImpl;
import com.ibm.java.diagnostics.healthcenter.io.IOLabels;
import java.util.Date;
import javax.management.Notification;

public class IODataImpl
extends HealthCenterDataImpl
implements IOData {
    private Notification fileCloseEventsNotify;
    private Notification fileOpenEventsNotify;
    private Notification openFileCountNotify;

    public IODataImpl(Data data) {
        super(data);
    }

    @Override
    public FileData[] getFileCloseEvents() {
        return this.getFileData(IOLabels.FILE_CLOSE);
    }

    @Override
    public FileData[] getFileOpenEvents() {
        return this.getFileData(IOLabels.FILE_OPEN);
    }

    private FileData[] getFileData(String string) {
        Data data = this.getJvmData().getTopLevelData(JVMLabels.IO);
        FileData[] fileDataArray = new FileData[]{};
        DataPointBuilder[] dataPointBuilderArray = null;
        if (data != null && (dataPointBuilderArray = this.getEventData(data, string)) != null) {
            fileDataArray = new FileData[dataPointBuilderArray.length];
            int n = 0;
            for (DataPointBuilder dataPointBuilder : dataPointBuilderArray) {
                fileDataArray[n] = new FileDataImpl(dataPointBuilder.getRawX(), dataPointBuilder.getComment());
                ++n;
            }
        }
        return fileDataArray;
    }

    @Override
    public CountData[] getOpenFileCount() {
        Data data = this.getJvmData().getTopLevelData(JVMLabels.IO);
        CountData[] countDataArray = new CountData[]{};
        DataPointBuilder[] dataPointBuilderArray = null;
        if (data != null && (dataPointBuilderArray = this.getEventData(data, IOLabels.STILL_OPEN)) != null) {
            countDataArray = new CountData[dataPointBuilderArray.length];
            int n = 0;
            for (DataPointBuilder dataPointBuilder : dataPointBuilderArray) {
                countDataArray[n] = new CountDataImpl(dataPointBuilder.getRawX(), (long)dataPointBuilder.getRawY());
                ++n;
            }
        }
        return countDataArray;
    }

    @Override
    protected String getRecommendationLabel() {
        return IOLabels.RECOMMENDATION_LABEL;
    }

    @Override
    protected String getSubsystemLabel() {
        return JVMLabels.IO;
    }

    @Override
    public void startNotifying() {
        this.startNotifying(this.DEFAULT_NOTIFICATION);
    }

    @Override
    public void startNotifying(long l) {
        new Updater(l).start();
    }

    static /* synthetic */ long access$000(IODataImpl iODataImpl) {
        return iODataImpl.DEFAULT_NOTIFICATION;
    }

    private class Updater
    extends Thread {
        private Date fileCloseEventsTime;
        private Date fileOpenEventsTime;
        private Date openFileCountTime;
        long count = 0L;
        long delay = IODataImpl.access$000(IODataImpl.this);

        public Updater(long l) {
            if (l >= IODataImpl.this.DEFAULT_NOTIFICATION) {
                this.delay = l;
            }
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        this.fileCloseEventsTime = new Date();
                        this.fileOpenEventsTime = new Date();
                        this.openFileCountTime = new Date();
                        if (IODataImpl.this.getFileCloseEvents() != null && IODataImpl.this.getFileCloseEvents().length > 0 && IODataImpl.this.getFileCloseEvents()[IODataImpl.this.getFileCloseEvents().length - 1].getTime() != this.fileCloseEventsTime.getTime()) {
                            IODataImpl.this.fileCloseEventsNotify = new Notification(null, IODataImpl.this, this.count++);
                            IODataImpl.this.fileCloseEventsNotify.setUserData("com.ibm.java.diagnostics.healthcenter.api.io.FileCloseEventsData");
                            IODataImpl.this.sendNotification(IODataImpl.this.fileCloseEventsNotify);
                        }
                        if (IODataImpl.this.getFileOpenEvents() != null && IODataImpl.this.getFileOpenEvents().length > 0 && IODataImpl.this.getFileOpenEvents()[IODataImpl.this.getFileOpenEvents().length - 1].getTime() != this.fileOpenEventsTime.getTime()) {
                            IODataImpl.this.fileOpenEventsNotify = new Notification(null, IODataImpl.this, this.count++);
                            IODataImpl.this.fileOpenEventsNotify.setUserData("com.ibm.java.diagnostics.healthcenter.api.io.FileOpenEventsData");
                            IODataImpl.this.sendNotification(IODataImpl.this.fileOpenEventsNotify);
                        }
                        if (IODataImpl.this.getOpenFileCount() != null && IODataImpl.this.getOpenFileCount().length > 0 && IODataImpl.this.getOpenFileCount()[IODataImpl.this.getOpenFileCount().length - 1].getTime() != this.openFileCountTime.getTime()) {
                            IODataImpl.this.openFileCountNotify = new Notification(null, IODataImpl.this, this.count++);
                            IODataImpl.this.openFileCountNotify.setUserData("com.ibm.java.diagnostics.healthcenter.api.io.OpenFileCountData");
                            IODataImpl.this.sendNotification(IODataImpl.this.openFileCountNotify);
                        }
                        Thread.sleep(this.delay);
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread thread = Thread.currentThread();
                    thread.getUncaughtExceptionHandler().uncaughtException(thread, interruptedException);
                    continue;
                }
                break;
            }
        }
    }
}

