/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.classes;

import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.SubsystemDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TwoDimensionalDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.axes.AxisPair;
import com.ibm.java.diagnostics.common.datamodel.data.axes.XDataAxis;
import com.ibm.java.diagnostics.common.datamodel.data.axes.YDataAxis;
import com.ibm.java.diagnostics.common.datamodel.factory.DataFactory;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.AxisUtil;
import com.ibm.java.diagnostics.common.datamodel.impl.data.TwoDimensionalDataImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.progress.ProgressIndicatorImpl;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.extensions.parsers.LineParser;
import com.ibm.java.diagnostics.common.extensions.parsers.ProgressIndicator;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.classes.ClassHistogramLabels;
import com.ibm.java.diagnostics.healthcenter.classes.ClassesTracePointHandler;
import com.ibm.java.diagnostics.healthcenter.classes.datamodel.ClassHistogramDataPointImpl;
import com.ibm.java.diagnostics.healthcenter.gc.parser.constants.GCAxes;
import com.ibm.java.diagnostics.healthcenter.sources.DynamicSource;
import java.util.logging.Logger;

public class ClassHistogramParser
implements LineParser {
    private static final String CLASSNAME = ClassHistogramParser.class.getName();
    private static final Logger TRACE = LogFactory.getTrace(ClassHistogramParser.class);
    private static final DataFactory factory = DataFactory.getFactory();
    private AxisPair numberAxisPair = null;
    private static final String HEADER = "classhistogramreport";
    private static final String CLASS_EYE_CATCHER = "@@chd@@";
    private static final String HEAPUSED = "heapused";
    private static final String DELIMITER = ",";
    private double reportTimeMillis = 0.0;
    private double currentReportTime = 0.0;

    @Override
    public ProgressIndicator parse(DynamicSource dynamicSource, String[] stringArray, DataBuilder dataBuilder, OutputProperties outputProperties) {
        TRACE.entering(CLASSNAME, "parse");
        if (this.numberAxisPair == null) {
            XDataAxis xDataAxis = AxisUtil.prepareXAxis(outputProperties);
            YDataAxis yDataAxis = GCAxes.prepareBytesAxis(outputProperties);
            this.numberAxisPair = factory.createAxisPair(xDataAxis, yDataAxis);
        }
        if (this.populateHistogramData(dataBuilder, stringArray)) {
            TRACE.exiting(CLASSNAME, "parse");
            return new ProgressIndicatorImpl(stringArray.length, stringArray.length);
        }
        TRACE.exiting(CLASSNAME, "parse");
        return ProgressIndicatorImpl.NOT_INTERESTED_PROGRESS;
    }

    private boolean populateHistogramData(DataBuilder dataBuilder, String[] stringArray) {
        boolean bl = false;
        long l = 0L;
        for (String string : stringArray) {
            String[] stringArray2;
            if (string.startsWith(HEADER)) {
                bl = true;
                stringArray2 = string.split(DELIMITER);
                if (stringArray2.length == 3) {
                    this.reportTimeMillis = new Double(stringArray2[2]);
                    bl = true;
                }
            }
            if (string.startsWith(HEAPUSED) && (stringArray2 = string.split(DELIMITER)).length == 2) {
                l = new Long(stringArray2[1]);
                bl = true;
            }
            if (!string.startsWith(CLASS_EYE_CATCHER) || (stringArray2 = string.split(DELIMITER)).length != 4) continue;
            String string2 = stringArray2[1];
            if (string2.endsWith(";")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            long l2 = 0L;
            long l3 = 0L;
            try {
                l2 = new Long(stringArray2[2]);
                l3 = new Long(stringArray2[3]);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("number format exception " + numberFormatException.toString());
            }
            SubsystemDataBuilder subsystemDataBuilder = this.getClassHistogramData(dataBuilder);
            this.createHistogramDetailsDataPoint(subsystemDataBuilder, this.reportTimeMillis, string2, l2, l3);
            bl = true;
        }
        return bl;
    }

    private void createHistogramDetailsDataPoint(DataBuilder dataBuilder, double d, String string, long l, long l2) {
        String string2 = ClassHistogramLabels.CLASS_LIST;
        DataBuilder dataBuilder2 = dataBuilder.getData(string2);
        if (dataBuilder2 == null) {
            dataBuilder2 = new TwoDimensionalDataImpl(string2, this.numberAxisPair);
            dataBuilder.addData(dataBuilder2);
        }
        ClassHistogramDataPointImpl classHistogramDataPointImpl = new ClassHistogramDataPointImpl(0, d, string, l, l2, this.numberAxisPair);
        ((TwoDimensionalDataBuilder)dataBuilder2).addDataPointBuilder(classHistogramDataPointImpl);
    }

    private SubsystemDataBuilder getClassHistogramData(DataBuilder dataBuilder) {
        ClassesTracePointHandler classesTracePointHandler = new ClassesTracePointHandler();
        return classesTracePointHandler.getClassesData(dataBuilder);
    }
}

