/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.impl.marshalling;

import com.ibm.java.diagnostics.common.datamodel.data.Data;
import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.DataListener;
import com.ibm.java.diagnostics.common.datamodel.exceptions.JavaDiagnosticsException;
import com.ibm.java.diagnostics.common.datamodel.impl.data.RootDataImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.properties.OutputPropertiesImpl;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputPropertiesChangedEvent;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputPropertiesListener;
import com.ibm.java.diagnostics.common.extensions.parsers.ByteParser;
import com.ibm.java.diagnostics.common.extensions.parsers.FileParser;
import com.ibm.java.diagnostics.common.extensions.parsers.LineParser;
import com.ibm.java.diagnostics.common.extensions.parsers.Parser;
import com.ibm.java.diagnostics.common.extensions.postprocessing.PostProcessor;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.JVMData;
import com.ibm.java.diagnostics.healthcenter.impl.datatruncation.DataSeedingThread;
import com.ibm.java.diagnostics.healthcenter.impl.datatruncation.DataStoragePreferenceHelper;
import com.ibm.java.diagnostics.healthcenter.impl.datatruncation.DataTruncationJob;
import com.ibm.java.diagnostics.healthcenter.impl.datatruncation.DataTruncationThread;
import com.ibm.java.diagnostics.healthcenter.impl.extensions.ParserRegistry;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.OutputPropertiesFacade;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.ParsingJob;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.PostProcessingJob;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.PostProcessorThread;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.data.JVMDataImpl;
import com.ibm.java.diagnostics.healthcenter.impl.slicer.ByteSlicerImpl;
import com.ibm.java.diagnostics.healthcenter.impl.slicer.FileSlicerImpl;
import com.ibm.java.diagnostics.healthcenter.impl.slicer.LineSlicerImpl;
import com.ibm.java.diagnostics.healthcenter.impl.slicer.SlicerImpl;
import com.ibm.java.diagnostics.healthcenter.marshaller.HealthCenterJob;
import com.ibm.java.diagnostics.healthcenter.marshalling.Marshaller;
import com.ibm.java.diagnostics.healthcenter.marshalling.data.events.GCEventImpl;
import com.ibm.java.diagnostics.healthcenter.marshalling.util.Messages;
import com.ibm.java.diagnostics.healthcenter.sources.Slicer;
import com.ibm.java.diagnostics.healthcenter.sources.Source;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;

public class MarshallerImpl
implements Marshaller,
OutputPropertiesListener {
    private static final String GET_DATA_SET_METHOD = Messages.getString("MarshallerImpl.1");
    private static final String UNDERSCORE = "_";
    private String HEALTHCENTER_FILENAME = "healthcenter";
    static final String HEALTHCENTER_FILE_EXTENSION = ".hcd";
    private final String className = this.getClass().getName();
    private static MarshallerImpl marshallerInstance = null;
    private static int count = 0;
    private static int TRUNCATION_INTERVAL = 5;
    private static RootDataImpl previousData = null;
    private RootDataImpl data;
    private OutputPropertiesImpl outputProperties;
    private List<Slicer> slicers;
    private Queue<HealthCenterJob> workQueue;
    private Thread queueThread;
    private static final Logger TRACE = LogFactory.getTrace(MarshallerImpl.class);
    private int hcdcount = 1;
    private File[] hcdFiles;
    private int hcdFileIndex = 0;
    private Object queueLock = new Object();
    private Object sourceLock = new Object();
    private PostProcessorThread postProcessorThread;
    private DataTruncationThread dataTruncationThread;
    private DataSeedingThread dataSeedingThread;
    private GCEventImpl gcEI;
    private volatile boolean active = true;
    private final OutputProperties outputPropertiesFacade;
    private DataStoragePreferenceHelper helper;
    private List<PostProcessor> incrementalPostProcessors = new ArrayList<PostProcessor>();
    private PostProcessor[] postProcessorChain = null;

    @Override
    public GCEventImpl getGCEvent() {
        return this.gcEI;
    }

    @Override
    public List<PostProcessor> getIncrementalPostProcessors() {
        return this.incrementalPostProcessors;
    }

    @Override
    public PostProcessor[] getPostProcessorChain() {
        return this.postProcessorChain;
    }

    @Override
    public void setIncrementalPostProcessors(List<PostProcessor> list) {
        this.incrementalPostProcessors = list;
    }

    @Override
    public void setPostProcessorChain(PostProcessor[] postProcessorArray) {
        this.postProcessorChain = postProcessorArray;
    }

    public MarshallerImpl() {
        this.gcEI = new GCEventImpl();
        this.helper = new DataStoragePreferenceHelper();
        this.hcdFiles = new File[this.helper.getMaxHCD()];
        this.slicers = new ArrayList<Slicer>();
        this.data = previousData == null ? new JVMDataImpl(Messages.getString("MarshallerImpl.2")) : previousData;
        this.outputProperties = new OutputPropertiesImpl(this.data);
        this.outputProperties.addListener(this);
        marshallerInstance = this;
        this.outputPropertiesFacade = new OutputPropertiesFacade();
        if (this.workQueue == null) {
            this.workQueue = new ConcurrentLinkedQueue<HealthCenterJob>();
        }
        this.postProcessorThread = new PostProcessorThread(this, this.data, this.outputProperties);
        this.postProcessorThread.start();
        this.dataTruncationThread = new DataTruncationThread(this);
        this.dataTruncationThread.start();
        this.dataSeedingThread = new DataSeedingThread(this, this.outputProperties);
        this.dataSeedingThread.start();
        String string = Messages.getString("MarshallerImpl.4");
        this.queueThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (MarshallerImpl.this.active) {
                    try {
                        if (!MarshallerImpl.this.workQueue.isEmpty()) {
                            MarshallerImpl.this.runNextJob();
                        }
                        Queue queue = MarshallerImpl.this.workQueue;
                        synchronized (queue) {
                            try {
                                if (MarshallerImpl.this.workQueue.isEmpty()) {
                                    MarshallerImpl.this.workQueue.wait();
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                    catch (Exception exception) {
                        TRACE.log(Level.WARNING, Messages.getString("MarshallerImpl.3"), exception);
                        exception.printStackTrace();
                    }
                }
            }
        }, string);
        this.queueThread.start();
        this.triggerPostProcess();
    }

    @Override
    public boolean save(String string) throws IOException {
        return this.createZipOfSources(string);
    }

    @Override
    public boolean save() throws IOException {
        return this.save(this.HEALTHCENTER_FILENAME);
    }

    @Override
    public Data getData(DataListener dataListener) {
        TRACE.entering(this.className, GET_DATA_SET_METHOD);
        if (this.data != null) {
            this.data.addDataListener(dataListener);
        }
        TRACE.exiting(this.className, GET_DATA_SET_METHOD);
        return this.data;
    }

    @Override
    public void removeDataListener(DataListener dataListener) {
        if (this.data != null) {
            this.data.removeDataListener(dataListener);
        }
    }

    @Override
    public OutputProperties getOutputProperties(OutputPropertiesListener outputPropertiesListener) {
        this.outputProperties.addListener(outputPropertiesListener);
        return this.outputPropertiesFacade;
    }

    @Override
    public void removeOutputPropertiesListener(OutputPropertiesListener outputPropertiesListener) {
        this.outputProperties.removeListener(outputPropertiesListener);
    }

    @Override
    public void blockUntilParsingCompleted(int n) {
        boolean bl = true;
        while (bl) {
            bl = false;
            List<Slicer> list = this.getSlicers();
            for (Slicer slicer : list) {
                if (slicer == null) continue;
                boolean bl2 = slicer.isEnabled() && slicer.isUnseenSourceAvailable();
                bl = bl || bl2;
            }
        }
    }

    @Override
    public void addSource(Source source) {
        Parser[] parserArray;
        for (Parser parser : parserArray = ParserRegistry.getInstance().instantiateParsers()) {
            SlicerImpl slicerImpl = null;
            try {
                Parser parser2;
                if (parser instanceof ByteParser) {
                    parser2 = (ByteParser)parser;
                    slicerImpl = new ByteSlicerImpl(source, (ByteParser)parser2, (Marshaller)this);
                } else if (parser instanceof FileParser) {
                    parser2 = (FileParser)parser;
                    slicerImpl = new FileSlicerImpl(source, (FileParser)parser2, (Marshaller)this);
                } else if (parser instanceof LineParser) {
                    parser2 = (LineParser)parser;
                    slicerImpl = new LineSlicerImpl(source, (LineParser)parser2, (Marshaller)this);
                } else {
                    TRACE.warning(MessageFormat.format(Messages.getString("MarshallerImpl.9"), parser.toString()));
                }
            }
            catch (JavaDiagnosticsException javaDiagnosticsException) {
                TRACE.warning(Messages.getString("MarshallerImpl.10"));
                javaDiagnosticsException.printStackTrace();
            }
            if (slicerImpl == null) continue;
            this.addJobToQueue(new AddingSlicerToSourceJob(source, slicerImpl));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Source> getSources() {
        HashSet<Source> hashSet = new HashSet<Source>();
        Object object = this.sourceLock;
        synchronized (object) {
            for (Slicer slicer : this.slicers) {
                hashSet.add(slicer.getSource());
            }
        }
        return hashSet;
    }

    @Override
    public void addToQueue(Slicer slicer) {
        ParsingJob parsingJob = new ParsingJob(slicer, this.data, this.outputProperties, this.postProcessorThread);
        this.addJobToQueue(parsingJob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addJobToQueue(HealthCenterJob healthCenterJob) {
        Queue<HealthCenterJob> queue = this.getQueueLock();
        synchronized (queue) {
            boolean bl = this.workQueue.offer(healthCenterJob);
            if (!bl) {
                TRACE.warning(MessageFormat.format(Messages.getString("MarshallerImpl.13"), healthCenterJob));
            }
        }
        queue = this.workQueue;
        synchronized (queue) {
            this.workQueue.notify();
        }
    }

    private void runNextJob() {
        if (this.active) {
            if (count > TRUNCATION_INTERVAL) {
                DataTruncationJob dataTruncationJob = null;
                Data data = this.getData(null);
                if (data != null) {
                    dataTruncationJob = new DataTruncationJob((DataBuilder)data);
                    count = 0;
                    dataTruncationJob.run();
                }
            } else {
                HealthCenterJob healthCenterJob = this.workQueue.poll();
                if (healthCenterJob != null) {
                    healthCenterJob.run();
                    ++count;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Slicer> getSlicers() {
        ArrayList<Slicer> arrayList = new ArrayList<Slicer>();
        Object object = this.sourceLock;
        synchronized (object) {
            arrayList.addAll(this.slicers);
        }
        return arrayList;
    }

    @Override
    public void outputPropertiesChanged(OutputPropertiesChangedEvent outputPropertiesChangedEvent) {
        PostProcessingJob postProcessingJob = new PostProcessingJob(this.data, this.outputProperties, this);
        this.addJobToQueue(postProcessingJob);
    }

    @Override
    public void setOutputFolder(String string) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSource(Source source) {
        ArrayList<Slicer> arrayList = new ArrayList<Slicer>();
        Object object = this.sourceLock;
        synchronized (object) {
            for (Slicer slicer : this.slicers) {
                if (slicer.getSource() != source) continue;
                arrayList.add(slicer);
            }
            for (Slicer slicer : arrayList) {
                this.slicers.remove(slicer);
            }
        }
    }

    public static synchronized void destroyMarshaller() {
        MarshallerImpl.destroyMarshaller(true);
    }

    public static synchronized void destroyMarshaller(boolean bl) {
        if (marshallerInstance != null) {
            marshallerInstance.terminate(bl);
            marshallerInstance = null;
            if (bl) {
                ((MarshallerImpl)MarshallerImpl.getMarshaller()).triggerPostProcess();
            }
        }
    }

    private void terminate(boolean bl) {
        this.workQueue = new ConcurrentLinkedQueue<HealthCenterJob>();
        for (Source source : this.getSources()) {
            source.shutdown();
            this.removeSource(source);
        }
        if (this.queueThread != null) {
            this.active = false;
            this.queueThread.interrupt();
            this.queueThread = null;
        }
        if (this.dataTruncationThread != null) {
            this.dataTruncationThread.terminate();
            this.dataTruncationThread = null;
        }
        if (this.dataSeedingThread != null) {
            this.dataSeedingThread.terminate();
            this.dataSeedingThread = null;
        }
        if (this.postProcessorThread != null) {
            this.postProcessorThread.terminate();
            this.postProcessorThread = null;
        }
        if (this.data != null) {
            this.data.clear();
            this.data.forceNotifyListeners();
            ((JVMData)((Object)this.data)).resetCacheValues();
            if (bl) {
                previousData = this.data;
            } else {
                this.data.removeAllDataListeners();
                this.outputProperties.removeListener(this);
                this.outputProperties.removeAllListeners();
                this.data = null;
                this.outputProperties = null;
            }
        }
        for (int i = this.hcdFiles.length; i < this.hcdFiles.length; ++i) {
            if (!this.hcdFiles[i].exists()) continue;
            this.hcdFiles[i].delete();
            this.hcdFiles[i] = null;
        }
        this.hcdFiles = null;
    }

    public static synchronized Marshaller getMarshaller() {
        if (marshallerInstance == null) {
            marshallerInstance = new MarshallerImpl();
        }
        return marshallerInstance;
    }

    @Override
    public Object getQueueLock() {
        return this.queueLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isQueueEmpty() {
        Object object = this.getQueueLock();
        synchronized (object) {
            return this.workQueue.isEmpty();
        }
    }

    public void triggerPostProcess() {
        this.postProcessorThread.triggerPostProcess();
    }

    @Override
    public void setPostprocessingFrequency(int n) {
        this.postProcessorThread.overrideFrequency(n);
    }

    @Override
    public void setCompressingFrequency(int n) {
        this.dataTruncationThread.overrideFrequency(n);
    }

    OutputProperties getRealOutputProperties(OutputPropertiesFacade outputPropertiesFacade) {
        return this.outputProperties;
    }

    @Override
    public void clearCompressingFrequency() {
        this.dataTruncationThread.clearFrequencyOverride();
    }

    @Override
    public void clearPostprocessingFrequency() {
        this.postProcessorThread.clearFrequencyOverride();
    }

    private boolean createZipOfSources(String string) throws IOException {
        boolean bl = false;
        TRACE.fine("Creating zip of sources, filename is " + string);
        Collection collection = this.getSources();
        try {
            File file = File.createTempFile(string + UNDERSCORE + this.hcdcount + UNDERSCORE, HEALTHCENTER_FILE_EXTENSION);
            file.deleteOnExit();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(fileOutputStream));
            for (Source source : collection) {
                InputStream inputStream = source.getBackingStream();
                source.swapBackingFiles();
                if (inputStream != null) {
                    String string2 = source.getName();
                    TRACE.fine("Adding: " + string2 + " to zipfile " + string);
                    this.writeStreamToZipFile(zipOutputStream, string2, inputStream);
                    bl = true;
                }
                source.deleteBackingFile();
            }
            if (bl) {
                zipOutputStream.close();
            }
            if (this.hcdFileIndex == this.helper.getMaxHCD()) {
                this.hcdFileIndex = 0;
            }
            if (this.hcdFiles[this.hcdFileIndex] != null && this.hcdFiles[this.hcdFileIndex].exists() && !this.hcdFiles[this.hcdFileIndex].delete()) {
                TRACE.log(Level.SEVERE, MessageFormat.format(Messages.getString("createZipOfSources.delete.failed"), this.hcdFiles[this.hcdFileIndex]));
            }
            this.hcdFiles[this.hcdFileIndex] = file;
            ++this.hcdFileIndex;
            ++this.hcdcount;
            return true;
        }
        catch (ZipException zipException) {
            TRACE.log(Level.SEVERE, MessageFormat.format(Messages.getString("createZipOfSources.error.writing.zipfile"), string, zipException.getLocalizedMessage()), zipException);
        }
        catch (IOException iOException) {
            TRACE.log(Level.SEVERE, MessageFormat.format(Messages.getString("createZipOfSources.error.writing.zipfile"), string, iOException.getLocalizedMessage()), iOException);
        }
        return false;
    }

    private int writeStreamToZipFile(ZipOutputStream zipOutputStream, String string, InputStream inputStream) throws IOException {
        int n;
        int n2 = 2048;
        byte[] byArray = new byte[n2];
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, n2);
        ZipEntry zipEntry = new ZipEntry(string);
        zipOutputStream.putNextEntry(zipEntry);
        while ((n = ((InputStream)bufferedInputStream).read(byArray, 0, n2)) != -1) {
            zipOutputStream.write(byArray, 0, n);
        }
        ((InputStream)bufferedInputStream).close();
        return n;
    }

    @Override
    public void saveBackingHCD(String string) throws IOException {
        this.save();
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmm");
        String string2 = string.substring(0, string.lastIndexOf(File.separator));
        String string3 = string.substring(string.lastIndexOf(File.separator));
        if (string3.contains(HEALTHCENTER_FILE_EXTENSION)) {
            string3 = string3.substring(0, string3.indexOf(HEALTHCENTER_FILE_EXTENSION, 0));
        }
        for (File file : this.hcdFiles) {
            int n;
            Object object;
            if (file == null) continue;
            String string4 = file.getName();
            StringTokenizer stringTokenizer = new StringTokenizer(string4, UNDERSCORE);
            if (stringTokenizer.countTokens() >= 2) {
                stringTokenizer.nextToken();
                object = stringTokenizer.nextToken();
                string4 = string3 + UNDERSCORE + simpleDateFormat.format(date) + UNDERSCORE + (String)object + HEALTHCENTER_FILE_EXTENSION;
            }
            object = new BufferedInputStream(new FileInputStream(file));
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string2 + string4));
            do {
                if ((n = ((BufferedInputStream)object).read()) == -1) continue;
                bufferedOutputStream.write(n);
            } while (n != -1);
            ((BufferedInputStream)object).close();
            bufferedOutputStream.close();
        }
    }

    private final class AddingSlicerToSourceJob
    implements HealthCenterJob {
        private Source source;
        private Slicer slicer;

        public AddingSlicerToSourceJob(Source source, Slicer slicer) {
            this.source = source;
            this.slicer = slicer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long run() {
            Object object = MarshallerImpl.this.sourceLock;
            synchronized (object) {
                MarshallerImpl.this.slicers.add(this.slicer);
            }
            this.source.addSourceListener(this.slicer);
            MarshallerImpl.this.addToQueue(this.slicer);
            return 0L;
        }

        @Override
        public String getName() {
            return Messages.getString("MarshallerImpl.adding.sources");
        }
    }
}

