/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.impl.marshalling.data;

import com.ibm.java.diagnostics.common.datamodel.data.Data;
import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TableData;
import com.ibm.java.diagnostics.common.datamodel.data.TableDataRow;
import com.ibm.java.diagnostics.common.datamodel.impl.data.RootDataImpl;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.JVMData;
import com.ibm.java.diagnostics.healthcenter.JVMLabels;
import com.ibm.java.diagnostics.healthcenter.connection.ConnectionData;
import com.ibm.java.diagnostics.healthcenter.environment.EnvironmentData;
import com.ibm.java.diagnostics.healthcenter.gc.GCData;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.JMXConnectionDataImpl;
import com.ibm.java.diagnostics.healthcenter.locking.LockingData;
import com.ibm.java.diagnostics.healthcenter.marshalling.util.Messages;
import com.ibm.java.diagnostics.healthcenter.postprocessor.VMLevelChecker;
import com.ibm.java.diagnostics.healthcenter.profiling.ProfilingData;
import java.lang.reflect.UndeclaredThrowableException;
import java.text.MessageFormat;
import java.util.logging.Logger;

public class JVMDataImpl
extends RootDataImpl
implements JVMData {
    private static final Logger TRACE = LogFactory.getTrace(JVMDataImpl.class);
    private boolean isHardRealtimeCacheValue = false;
    private boolean isSoftRealtimeCacheValue = false;
    private boolean realtimeDataAvailable = false;
    private VMLevelChecker vmLevelChecker = null;
    private static final String ENV_JRE_INFO = "Java runtime environment";
    private static final String ENV_VM_NAME = "Name";

    public JVMDataImpl(String string) {
        super(string);
    }

    @Override
    public GCData getGCData() {
        DataBuilder dataBuilder = this.getData(JVMLabels.GARBAGE_COLLECTION);
        if (dataBuilder instanceof GCData) {
            return (GCData)((Object)dataBuilder);
        }
        if (dataBuilder != null) {
            this.handleWrongClass(dataBuilder, GCData.class);
        }
        return null;
    }

    @Override
    public LockingData getLockingData() {
        DataBuilder dataBuilder = this.getData(JVMLabels.LOCKING);
        if (dataBuilder instanceof LockingData) {
            return (LockingData)((Object)dataBuilder);
        }
        if (dataBuilder != null) {
            this.handleWrongClass(dataBuilder, LockingData.class);
        }
        return null;
    }

    @Override
    public ProfilingData getProfilingData() {
        DataBuilder dataBuilder = this.getData(JVMLabels.PROFILING);
        if (dataBuilder instanceof ProfilingData) {
            return (ProfilingData)((Object)dataBuilder);
        }
        if (dataBuilder != null) {
            this.handleWrongClass(dataBuilder, ProfilingData.class);
        }
        return null;
    }

    @Override
    public ConnectionData getConnectionData() {
        DataBuilder dataBuilder = this.getData(JVMLabels.CONNECTION);
        if (dataBuilder instanceof ConnectionData) {
            return (ConnectionData)((Object)dataBuilder);
        }
        if (dataBuilder != null) {
            this.handleWrongClass(dataBuilder, ConnectionData.class);
        }
        return null;
    }

    @Override
    public EnvironmentData getEnvironmentData() {
        DataBuilder dataBuilder = this.getData(JVMLabels.ENVIRONMENT);
        if (dataBuilder instanceof EnvironmentData) {
            return (EnvironmentData)((Object)dataBuilder);
        }
        if (dataBuilder != null) {
            this.handleWrongClass(dataBuilder, EnvironmentData.class);
        }
        return null;
    }

    private void handleWrongClass(Data data, Class<?> clazz) {
        String string = Messages.getString("JVMDataImpl.wrong.class");
        String string2 = MessageFormat.format(string, clazz.getSimpleName(), data.getClass());
        TRACE.fine(string2);
    }

    @Override
    public long getPid() {
        EnvironmentData environmentData = this.getEnvironmentData();
        if (environmentData != null) {
            return environmentData.getPid();
        }
        return 0L;
    }

    public boolean isRealtimeVM() {
        return this.isHardRealtimeVM() || this.isSoftRealtimeVM();
    }

    public boolean isRealtimeVM(String string) {
        return this.isHardRealtimeVM(string) || this.isSoftRealtimeVM(string);
    }

    public boolean isHardRealtimeVM() {
        return this.isHardRealtimeVM(null);
    }

    public boolean enoughDataToDetermineRealtime() {
        return this.realtimeDataAvailable;
    }

    public boolean isHardRealtimeVM(String string) {
        Data data;
        ConnectionData connectionData;
        if (this.realtimeDataAvailable) {
            return this.isHardRealtimeCacheValue;
        }
        if (string != null) {
            this.vmLevelChecker = new VMLevelChecker(string);
            if (this.vmLevelChecker.isVMRealtime() && !this.vmLevelChecker.isVMSoftRealtime()) {
                this.isHardRealtimeCacheValue = true;
                this.isSoftRealtimeCacheValue = false;
                this.realtimeDataAvailable = true;
                return this.isHardRealtimeCacheValue;
            }
        }
        if ((connectionData = this.getConnectionData()) != null && connectionData instanceof JMXConnectionDataImpl) {
            data = (JMXConnectionDataImpl)connectionData;
            try {
                this.isHardRealtimeCacheValue = ((JMXConnectionDataImpl)data).getAgentConnection().getProxy().isHardRealtimeVM();
                this.isSoftRealtimeCacheValue = ((JMXConnectionDataImpl)data).getAgentConnection().getProxy().isSoftRealtimeVM();
                this.realtimeDataAvailable = true;
                return this.isHardRealtimeCacheValue;
            }
            catch (UndeclaredThrowableException undeclaredThrowableException) {
                // empty catch block
            }
        }
        if ((data = this.getEnvironmentData()) != null) {
            this.isHardRealtimeCacheValue = data.isVMHardRealtime();
            this.isSoftRealtimeCacheValue = data.isVMSoftRealtime();
            this.realtimeDataAvailable = true;
        }
        return this.isHardRealtimeCacheValue;
    }

    public boolean isSoftRealtimeVM() {
        return this.isSoftRealtimeVM(null);
    }

    public boolean isSoftRealtimeVM(String string) {
        Data data;
        ConnectionData connectionData;
        if (this.realtimeDataAvailable) {
            return this.isSoftRealtimeCacheValue;
        }
        if (string != null) {
            this.vmLevelChecker = new VMLevelChecker(string);
            if (this.vmLevelChecker.isVMRealtime() && this.vmLevelChecker.isVMSoftRealtime()) {
                this.isHardRealtimeCacheValue = false;
                this.isSoftRealtimeCacheValue = true;
                this.realtimeDataAvailable = true;
                return this.isSoftRealtimeCacheValue;
            }
        }
        if ((connectionData = this.getConnectionData()) != null && connectionData instanceof JMXConnectionDataImpl) {
            data = (JMXConnectionDataImpl)connectionData;
            try {
                this.isHardRealtimeCacheValue = ((JMXConnectionDataImpl)data).getAgentConnection().getProxy().isHardRealtimeVM();
                this.isSoftRealtimeCacheValue = ((JMXConnectionDataImpl)data).getAgentConnection().getProxy().isSoftRealtimeVM();
                this.realtimeDataAvailable = true;
                return this.isSoftRealtimeCacheValue;
            }
            catch (UndeclaredThrowableException undeclaredThrowableException) {
                // empty catch block
            }
        }
        if ((data = this.getEnvironmentData()) != null && data instanceof EnvironmentData) {
            Data data2 = data;
            this.isSoftRealtimeCacheValue = data2.isVMSoftRealtime();
            this.isHardRealtimeCacheValue = data2.isVMHardRealtime();
            this.realtimeDataAvailable = true;
        }
        return this.isSoftRealtimeCacheValue;
    }

    @Override
    public void resetCacheValues() {
        this.isHardRealtimeCacheValue = false;
        this.isSoftRealtimeCacheValue = false;
        this.realtimeDataAvailable = false;
    }

    public boolean isJavaVM() {
        TableDataRow tableDataRow;
        TableData tableData;
        EnvironmentData environmentData = this.getEnvironmentData();
        if (environmentData != null && (tableData = (TableData)environmentData.getData(ENV_JRE_INFO)) != null && (tableDataRow = tableData.get(ENV_VM_NAME)) != null) {
            String string = ((String)tableDataRow.get(1)).toLowerCase();
            return string.contains("java") || string.contains("j9");
        }
        return false;
    }
}

