/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.impl.marshalling.source;

import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.source.JmxSourceImpl;
import com.ibm.java.diagnostics.healthcenter.marshalling.util.Messages;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Logger;

public class DataFileStorage {
    private static final Logger TRACE = LogFactory.getTrace(JmxSourceImpl.class);
    private static final String BACKING_FILE_PREFIX = "healthcenter";
    private static final String TWO = "2";
    private static final String ONE = "1";
    private static final String TMP_SUFFIX = ".tmp";
    private String name;
    private volatile FileOutputStream fos;
    private final Object fosLock = new Object();
    private File file;
    private File backingFile2;
    private File backingFile1;
    private boolean fileOneActive;
    protected final Object fileLock = new Object();

    public DataFileStorage(String string) {
        this.name = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setupFiles() {
        this.file = this.backingFile1 = this.createBackingFile(ONE);
        try {
            Object object = this.fosLock;
            synchronized (object) {
                this.fos = new FileOutputStream(this.file);
            }
            this.fileOneActive = true;
        }
        catch (IOException iOException) {
            TRACE.warning(MessageFormat.format(Messages.getString("JMXSourceImpl.error.creating.file"), this.file.getAbsolutePath(), iOException));
        }
    }

    private String getName() {
        return this.name;
    }

    public FileOutputStream getOutputStream() {
        return this.fos;
    }

    public File createBackingFile(String string) {
        String string2 = BACKING_FILE_PREFIX + this.getName() + string;
        try {
            File file = File.createTempFile(string2, TMP_SUFFIX);
            file.deleteOnExit();
            return file;
        }
        catch (IOException iOException) {
            TRACE.warning(MessageFormat.format(Messages.getString("JMXSourceImpl.error.creating.file"), string2, iOException));
            return null;
        }
    }

    public void deleteBackingFile() {
        if (this.fileOneActive) {
            boolean bl;
            if (this.backingFile2 != null && !(bl = this.backingFile2.delete())) {
                TRACE.warning(MessageFormat.format(Messages.getString("JMXSourceImpl.problem.deleting.file"), this.backingFile2.getAbsolutePath()));
            }
            this.backingFile2 = this.createBackingFile(TWO);
        } else {
            boolean bl = this.backingFile1.delete();
            if (!bl) {
                TRACE.warning(MessageFormat.format(Messages.getString("JMXSourceImpl.problem.deleting.file"), this.backingFile1.getAbsolutePath()));
            }
            this.backingFile1 = this.createBackingFile(ONE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void swapBackingFiles() {
        try {
            Object object = this.fosLock;
            synchronized (object) {
                if (this.fos != null) {
                    this.fos.close();
                }
                this.fos = null;
                if (this.fileOneActive) {
                    boolean bl;
                    if (this.backingFile2 != null && !(bl = this.backingFile2.delete())) {
                        TRACE.warning(MessageFormat.format(Messages.getString("JMXSourceImpl.problem.deleting.file"), this.backingFile2.getAbsolutePath()));
                    }
                    this.file = this.backingFile2 = this.createBackingFile(TWO);
                    this.fileOneActive = false;
                } else {
                    boolean bl = this.backingFile1.delete();
                    if (!bl) {
                        TRACE.warning(MessageFormat.format(Messages.getString("JMXSourceImpl.problem.deleting.file"), this.backingFile1.getAbsolutePath()));
                    }
                    this.file = this.backingFile1 = this.createBackingFile(ONE);
                    this.fileOneActive = true;
                }
                this.fos = new FileOutputStream(this.file);
            }
        }
        catch (IOException iOException) {
            TRACE.warning(MessageFormat.format(Messages.getString("JMXSourceImpl.error.creating.file"), this.file.getAbsolutePath(), iOException));
        }
    }

    public Object getLock() {
        return this.fileLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getBackingStream(byte[] byArray) {
        SequenceInputStream sequenceInputStream = null;
        Vector<InputStream> vector = new Vector<InputStream>();
        Object object = this.fileLock;
        synchronized (object) {
            vector.add(new ByteArrayInputStream(byArray));
            try {
                boolean bl;
                boolean bl2 = this.backingFile1.exists() && this.backingFile1.canRead() && this.backingFile1.length() > 0L;
                boolean bl3 = bl = this.backingFile2 != null && this.backingFile2.exists() && this.backingFile2.canRead() && this.backingFile2.length() > 0L;
                if (this.fileOneActive) {
                    if (bl2) {
                        vector.add(new FileInputStream(this.backingFile1));
                    }
                } else if (bl) {
                    vector.add(new FileInputStream(this.backingFile2));
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                TRACE.warning(MessageFormat.format(Messages.getString("JMXSourceImp.backingfile.exception"), fileNotFoundException));
            }
            Enumeration enumeration = vector.elements();
            sequenceInputStream = new SequenceInputStream(enumeration);
        }
        return sequenceInputStream;
    }

    public long getLength() {
        return this.file.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalShutdown() {
        try {
            Object object = this.fosLock;
            synchronized (object) {
                if (this.fos != null) {
                    this.fos.close();
                    this.fos = null;
                }
            }
        }
        catch (IOException iOException) {
            TRACE.warning(iOException.toString());
        }
        boolean bl = this.backingFile1.delete();
        if (!bl) {
            TRACE.fine(MessageFormat.format(Messages.getString("JMXSourceImpl.problem.deleting.file"), this.backingFile1.getAbsolutePath()));
        }
    }
}

