/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.impl.marshalling.source;

import com.ibm.java.diagnostics.common.datamodel.impl.data.RootDataImpl;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.ProviderModificationException;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenterClientConnectedException;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenterMBean;
import com.ibm.java.diagnostics.healthcenter.connection.ConnectionDataBuilder;
import com.ibm.java.diagnostics.healthcenter.impl.datatruncation.DataStoragePreferenceHelper;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.source.DataFileStorage;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.source.JmxEnablementConfigurationSourceImpl;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.source.SourceImpl;
import com.ibm.java.diagnostics.healthcenter.marshalling.Marshaller;
import com.ibm.java.diagnostics.healthcenter.marshalling.util.Messages;
import com.ibm.java.diagnostics.healthcenter.sources.RequestableSource;
import com.ibm.java.diagnostics.healthcenter.sources.Source;
import com.ibm.java.diagnostics.healthcenter.sources.SourceListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JmxSourceImpl
extends SourceImpl
implements RequestableSource {
    private static final String NEW_SLICER_FILE_SUFFIX = "copy";
    private static final String NEW_SLICER_FILE_PREFIX = "jmx";
    private static final String COMMA = ",";
    private static final String SLEEPING = Messages.getString("JmxSourceAdapter.sleeping");
    private static final String RECEIVED_DATA = Messages.getString("JmxSourceAdapter.received.data");
    private static final String REQUESTING_DATA = Messages.getString("JmxSourceAdapter.requesting.data");
    private static final int SECONDS_TO_MILLIS = 1000;
    private static final Logger TRACE = LogFactory.getTrace(JmxSourceImpl.class);
    private static final int INVALID = -1;
    private DataFileStorage dataFileStorage;
    private int connectionRetriesSoFar = 0;
    private static final int MAX_RETRIES = 5;
    private static final int ERROR_SLEEP_TIME = 30000;
    private Map<String, String> sourceMetaData;
    private HealthCenterMBean proxy;
    private volatile boolean isShutdown = false;
    private int sourceIndex;
    private int sessionId;
    private long updateIntervalInMilliseconds;
    private int expectedBytes;
    private byte[] headerInformation = new byte[0];
    private boolean sourceHeaderRead = false;
    private int sizeOfHeader = 0;
    private DataStoragePreferenceHelper preferences;
    private Marshaller marshaller;

    public JmxSourceImpl(HealthCenterMBean healthCenterMBean, int n, int n2) {
        this(healthCenterMBean, n, n2, null, healthCenterMBean.getLiveSourceDetails(), null);
    }

    public JmxSourceImpl(HealthCenterMBean healthCenterMBean, int n, int n2, ConnectionDataBuilder connectionDataBuilder, List<Map<String, String>> list, Marshaller marshaller) {
        super(list.get(n).get("name"), connectionDataBuilder);
        this.dataFileStorage = new DataFileStorage(list.get(n).get("name"));
        this.dataFileStorage.setupFiles();
        this.marshaller = marshaller;
        this.sessionId = n2;
        this.proxy = healthCenterMBean;
        this.isShutdown = false;
        this.sourceIndex = n;
        this.sourceMetaData = list.get(n);
        this.updateIntervalInMilliseconds = -1L;
        try {
            if (this.getSourceMetaData().get("suggested_update_frequency") != null) {
                this.updateIntervalInMilliseconds = this.getSourceMetaData().get("suggested_update_frequency").equals(Integer.toString(Integer.MAX_VALUE)) ? 0L : (long)(Integer.valueOf(this.getSourceMetaData().get("suggested_update_frequency")) * 1000);
            }
            this.expectedBytes = this.getSourceMetaData().get("max_bytes_to_send") != null ? Integer.valueOf(this.getSourceMetaData().get("max_bytes_to_send")) : Integer.MAX_VALUE;
        }
        catch (NumberFormatException numberFormatException) {
            String string = Messages.getString("JmxSourceImpl.exception.parsing.meta.data");
            String string2 = MessageFormat.format(string, this.getSourceMetaData());
            TRACE.log(Level.WARNING, string2, numberFormatException);
        }
        this.preferences = new DataStoragePreferenceHelper();
        if (this.updateIntervalInMilliseconds == 0L) {
            return;
        }
        JMXSourceUpdateJob jMXSourceUpdateJob = new JMXSourceUpdateJob();
        jMXSourceUpdateJob.start();
    }

    public void triggerImmediateRefresh() {
        JMXSourceImmediateUpdateJob jMXSourceImmediateUpdateJob = new JMXSourceImmediateUpdateJob();
        jMXSourceImmediateUpdateJob.start();
    }

    @Override
    public void internalShutdown() {
        this.isShutdown = true;
        this.connectionRetriesSoFar = 0;
        this.dataFileStorage.internalShutdown();
    }

    @Override
    public void deleteBackingFile() {
        this.dataFileStorage.deleteBackingFile();
    }

    @Override
    public void swapBackingFiles() {
        this.dataFileStorage.swapBackingFiles();
    }

    private boolean createHeaderData(byte[] byArray) {
        if (null == byArray || byArray.length < 1) {
            return false;
        }
        this.refreshMetaData();
        String string = this.getSourceMetaData().get("size_of_header");
        if (string != null) {
            this.sizeOfHeader = Integer.parseInt(string);
            if (this.sizeOfHeader == 0) {
                return false;
            }
            this.headerInformation = new byte[this.sizeOfHeader];
            System.arraycopy(byArray, 0, this.headerInformation, 0, this.sizeOfHeader);
        }
        if (this.getSourceMetaData().get("max_bytes_to_send") != null) {
            this.expectedBytes = Integer.valueOf(this.getSourceMetaData().get("max_bytes_to_send"));
        }
        return true;
    }

    public void refreshMetaData() {
        this.sourceMetaData = this.proxy.getLiveSourceDetails().get(this.sourceIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] receiveJMXData() {
        if (this.isShutdown) {
            return null;
        }
        Map<String, String> map = this.sourceMetaData;
        synchronized (map) {
            try {
                byte[] byArray = this.proxy.getJMXData(this.sourceIndex, this.sessionId);
                if (byArray != null) {
                    this.tellConnectionAboutDataReceived(byArray.length);
                }
                this.connectionRetriesSoFar = 0;
                return byArray;
            }
            catch (HealthCenterClientConnectedException healthCenterClientConnectedException) {
                this.handleHealthCenterConnectionException(healthCenterClientConnectedException);
            }
            catch (NoSuchElementException noSuchElementException) {
                TRACE.log(Level.FINE, noSuchElementException.toString(), noSuchElementException);
            }
            catch (UndeclaredThrowableException undeclaredThrowableException) {
                Throwable throwable = undeclaredThrowableException.getUndeclaredThrowable();
                if (throwable instanceof IOException) {
                    this.handleLostConnection(throwable);
                } else {
                    TRACE.log(Level.WARNING, throwable.toString(), throwable);
                }
            }
            catch (Throwable throwable) {
                TRACE.log(Level.WARNING, throwable.toString(), throwable);
            }
        }
        return null;
    }

    private void handleHealthCenterConnectionException(HealthCenterClientConnectedException healthCenterClientConnectedException) {
        String string = Messages.getString("JmxSourceAdapter.another.client.connected");
        this.tellConnectionAboutError(string, string, healthCenterClientConnectedException);
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeDataToFile(byte[] byArray) throws IOException {
        int n = 0;
        Object object = this.dataFileStorage.getLock();
        synchronized (object) {
            if (byArray != null && this.dataFileStorage.getOutputStream() != null) {
                Object object2 = this.listenerListLock;
                synchronized (object2) {
                    if (this.dataFileStorage.getLength() + (long)byArray.length > (long)this.preferences.getBackingFileSize()) {
                        this.marshaller.save();
                    }
                    if (!this.sourceHeaderRead) {
                        if (this.createHeaderData(byArray)) {
                            this.sourceHeaderRead = true;
                            this.dataFileStorage.getOutputStream().write(byArray, this.sizeOfHeader, byArray.length - this.sizeOfHeader);
                        }
                    } else {
                        this.dataFileStorage.getOutputStream().write(byArray, 0, byArray.length);
                    }
                    n = byArray.length;
                    this.dataFileStorage.getOutputStream().flush();
                }
            }
        }
        return n;
    }

    private void handleLostConnection(Throwable throwable) {
        ++this.connectionRetriesSoFar;
        if (this.connectionRetriesSoFar < 5 && !this.connectionData.hasConnectionBeenNotified()) {
            String string = Messages.getString("JMXSourceAdapter.connection.refused");
            String string2 = MessageFormat.format(Messages.getString("JmxSourceImpl.reported.exception.was"), throwable.getLocalizedMessage());
            ((RootDataImpl)this.marshaller.getData(null)).forceNotifyListeners();
            this.tellConnectionAboutError(string, string2, throwable);
            this.connectionData.setConnectionNotified(true);
        }
    }

    private Map<String, String> getSourceMetaData() {
        return this.sourceMetaData;
    }

    private void modify(String string, String ... stringArray) {
        final String string2 = string;
        final String[] stringArray2 = stringArray;
        Thread thread = new Thread(string){

            @Override
            public void run() {
                try {
                    if (!JmxSourceImpl.this.isShutdown) {
                        JmxSourceImpl.this.proxy.modify(JmxSourceImpl.this.sourceIndex, JmxSourceImpl.this.sessionId, string2, stringArray2);
                        JmxSourceImpl.this.refreshMetaData();
                    }
                }
                catch (HealthCenterClientConnectedException healthCenterClientConnectedException) {
                    JmxSourceImpl.this.handleHealthCenterConnectionException(healthCenterClientConnectedException);
                }
                catch (ProviderModificationException providerModificationException) {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (String string : stringArray2) {
                        stringBuffer.append(string + JmxSourceImpl.COMMA);
                    }
                    TRACE.warning(MessageFormat.format(Messages.getString("JMXSourceAdapter.modification.exception"), string2, stringBuffer.toString()));
                }
                catch (UndeclaredThrowableException undeclaredThrowableException) {
                    Throwable throwable = undeclaredThrowableException.getUndeclaredThrowable();
                    if (throwable instanceof IOException) {
                        JmxSourceImpl.this.handleLostConnection(throwable);
                    } else {
                        TRACE.log(Level.WARNING, throwable.toString(), throwable);
                    }
                }
                catch (Throwable throwable) {
                    TRACE.warning(MessageFormat.format(Messages.getString("JMXSourceAdapter.modification.exception"), throwable));
                }
            }
        };
        thread.start();
    }

    @Override
    public void request(String ... stringArray) {
        this.modify("request", stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tellNewSlicerAboutExistingData(SourceListener sourceListener) {
        try {
            File file = File.createTempFile(NEW_SLICER_FILE_PREFIX, NEW_SLICER_FILE_SUFFIX);
            file.deleteOnExit();
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            Object object = this.listenerListLock;
            synchronized (object) {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(this.getBackingStream());
                int n = bufferedInputStream.read();
                while (n >= 0) {
                    bufferedOutputStream.write(n);
                    n = bufferedInputStream.read();
                }
                bufferedOutputStream.close();
                bufferedInputStream.close();
            }
            sourceListener.notifySourceChanged(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            TRACE.warning(fileNotFoundException.toString());
        }
        catch (IOException iOException) {
            TRACE.warning(iOException.toString());
        }
    }

    @Override
    public InputStream getBackingStream() {
        return this.dataFileStorage.getBackingStream(this.headerInformation);
    }

    public Source spawnConfigurationSource() {
        return new JmxEnablementConfigurationSourceImpl(this.proxy, this.sourceIndex, this.connectionData, this.sessionId, this, this.getSourceMetaData());
    }

    public long getUpdateIntervalTime() {
        return this.updateIntervalInMilliseconds;
    }

    private class JMXSourceImmediateUpdateJob
    extends Thread {
        public JMXSourceImmediateUpdateJob() {
            super(Messages.getString("JmxSourceImpl.immediate.thread.name"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                byte[] byArray;
                long l = System.currentTimeMillis();
                if (TRACE.isLoggable(Level.FINE)) {
                    TRACE.fine(MessageFormat.format(REQUESTING_DATA, this.getName(), l));
                }
                if ((byArray = JmxSourceImpl.this.receiveJMXData()) != null) {
                    int n = byArray.length;
                    if (TRACE.isLoggable(Level.FINE)) {
                        TRACE.fine(MessageFormat.format(RECEIVED_DATA, this.getName(), n, JmxSourceImpl.this.expectedBytes));
                    }
                }
                Object object = JmxSourceImpl.this.listenerListLock;
                synchronized (object) {
                    for (SourceListener sourceListener : JmxSourceImpl.this.sourceListeners) {
                        if (byArray == null) continue;
                        sourceListener.notifySourceChanged(new ByteArrayInputStream(byArray));
                    }
                    JmxSourceImpl.this.writeDataToFile(byArray);
                }
            }
            catch (Throwable throwable) {
                String string = Messages.getString("JmxSourceAdapter.exception.in.update.thread");
                TRACE.log(Level.WARNING, string, throwable);
            }
        }
    }

    private class JMXSourceUpdateJob
    extends Thread {
        private int retryCount;

        public JMXSourceUpdateJob() {
            super(Messages.getString("JmxSourceImpl.thread.name"));
            this.retryCount = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean bl = true;
            while (bl) {
                long l;
                block16: {
                    l = 10L;
                    try {
                        long l2;
                        long l3;
                        byte[] byArray;
                        long l4 = System.currentTimeMillis();
                        if (TRACE.isLoggable(Level.FINE)) {
                            TRACE.fine(MessageFormat.format(REQUESTING_DATA, this.getName(), l4));
                        }
                        if ((byArray = JmxSourceImpl.this.receiveJMXData()) == null) {
                            ++this.retryCount;
                            l = 30000L;
                            break block16;
                        }
                        int n = byArray.length;
                        if (TRACE.isLoggable(Level.FINE)) {
                            TRACE.fine(MessageFormat.format(RECEIVED_DATA, this.getName(), n, JmxSourceImpl.this.expectedBytes));
                        }
                        this.retryCount = 0;
                        if ((n < JmxSourceImpl.this.expectedBytes || JmxSourceImpl.this.expectedBytes == -1) && (l3 = System.currentTimeMillis()) < (l2 = l4 + JmxSourceImpl.this.updateIntervalInMilliseconds)) {
                            l = l2 - l3;
                        }
                        if (n <= 0) break block16;
                        Object object = JmxSourceImpl.this.listenerListLock;
                        synchronized (object) {
                            for (SourceListener sourceListener : JmxSourceImpl.this.sourceListeners) {
                                if (byArray == null) continue;
                                sourceListener.notifySourceChanged(new ByteArrayInputStream(byArray));
                            }
                            JmxSourceImpl.this.writeDataToFile(byArray);
                        }
                    }
                    catch (Throwable throwable) {
                        String string = Messages.getString("JmxSourceAdapter.exception.in.update.thread");
                        TRACE.log(Level.WARNING, string, throwable);
                    }
                }
                if (this.retryCount >= 5) {
                    TRACE.warning(MessageFormat.format(Messages.getString("JMXSourceAdapter.stopping.trying"), JmxSourceImpl.this.sourceMetaData.get("name")));
                    bl = false;
                    continue;
                }
                if (!JmxSourceImpl.this.isShutdown) {
                    try {
                        if (TRACE.isLoggable(Level.FINE)) {
                            TRACE.fine(MessageFormat.format(SLEEPING, this.getName(), l));
                        }
                        Thread.sleep(l);
                        bl = true;
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    continue;
                }
                bl = false;
            }
        }
    }
}

