/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.impl.slicer;

import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.exceptions.JavaDiagnosticsException;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.extensions.parsers.LineParser;
import com.ibm.java.diagnostics.common.extensions.parsers.ProgressIndicator;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.impl.slicer.LineLimitReader;
import com.ibm.java.diagnostics.healthcenter.impl.slicer.SlicerImpl;
import com.ibm.java.diagnostics.healthcenter.marshalling.Marshaller;
import com.ibm.java.diagnostics.healthcenter.marshalling.util.Messages;
import com.ibm.java.diagnostics.healthcenter.sources.DynamicSource;
import com.ibm.java.diagnostics.healthcenter.sources.LineSlicer;
import com.ibm.java.diagnostics.healthcenter.sources.Source;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;
import java.util.logging.Logger;

public class LineSlicerImpl
extends SlicerImpl
implements LineSlicer {
    private static final int DEFAULT_SLICE_SIZE = 200;
    private static Logger TRACE = LogFactory.getTrace(LineSlicerImpl.class);
    private static final int MINIMUM_SENSIBLE_SLICE = 100;
    private static final int MAXIMUM_SENSIBLE_SLICE = 5000;
    private LineParser lineParser = null;
    private Object dataLock = new Object();
    private static final String[] STRING_TEMPLATE_ARRAY = new String[0];
    private final Queue<BufferedReader> readerQueue;
    private String[] dataToParse;

    public LineSlicerImpl(Source source, LineParser lineParser, Marshaller marshaller) throws JavaDiagnosticsException {
        super(source, lineParser, marshaller);
        this.lineParser = lineParser;
        this.readerQueue = new LinkedList<BufferedReader>();
    }

    @Override
    protected int getDefaultSliceSize() {
        return 200;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ProgressIndicator internalTriggerParse(DataBuilder dataBuilder, OutputProperties outputProperties) {
        ProgressIndicator progressIndicator = null;
        try {
            Object object = this.dataLock;
            synchronized (object) {
                String[] stringArray = this.getLineSlice();
                if (stringArray != null && stringArray.length > 0) {
                    DynamicSource dynamicSource = this.source instanceof DynamicSource ? (DynamicSource)this.source : null;
                    progressIndicator = this.lineParser.parse(dynamicSource, stringArray, dataBuilder, outputProperties);
                    int n = progressIndicator.getProgress();
                    if (n != -1 && n != -2) {
                        this.removeParsedData(n);
                        Thread.yield();
                    }
                    if (n > 100) {
                        this.setSliceSize(Math.min(5000, n));
                    }
                }
            }
        }
        catch (IOException iOException) {
            TRACE.fine(MessageFormat.format(Messages.getString("LineSlicerImpl.array.append"), iOException));
            this.disable();
        }
        return progressIndicator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeParsedData(int n) {
        if (n > 0) {
            Object object = this.dataLock;
            synchronized (object) {
                if (this.dataToParse != null) {
                    int n2 = this.dataToParse.length - n;
                    if (n2 == 0) {
                        this.dataToParse = new String[0];
                    } else if (n2 > 0) {
                        String[] stringArray = new String[n2];
                        System.arraycopy(this.dataToParse, n, stringArray, 0, n2);
                        this.dataToParse = stringArray;
                    } else {
                        String string = MessageFormat.format(Messages.getString("LineSlicerImpl.too.much.data.parsed"), n);
                        TRACE.fine(string);
                        this.dataToParse = new String[0];
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUnseenSourceAvailable() {
        Object object = this.dataLock;
        synchronized (object) {
            boolean bl = false;
            BufferedReader bufferedReader = this.readerQueue.peek();
            try {
                bl = bufferedReader != null && bufferedReader.ready();
            }
            catch (IOException iOException) {
                bl = false;
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAnySourceAvailable() {
        Object object = this.dataLock;
        synchronized (object) {
            boolean bl = this.dataToParse != null && this.dataToParse.length > 0;
            return bl || this.isUnseenSourceAvailable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifySourceChanged(InputStream inputStream) {
        if (this.isEnabled()) {
            try {
                Object object = this.dataLock;
                synchronized (object) {
                    this.readerQueue.add(new BufferedReader(new LineLimitReader(new InputStreamReader(inputStream, "UTF8"))));
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                TRACE.warning(MessageFormat.format(Messages.getString("LineSlicerImpl.encoding.exception"), unsupportedEncodingException));
                this.disable();
            }
            this.marshaller.addToQueue(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getLineSlice() throws IOException {
        Object object = this.dataLock;
        synchronized (object) {
            BufferedReader bufferedReader;
            String[] stringArray = null;
            int n = 0;
            if (this.dataToParse != null && this.dataToParse.length > 0) {
                stringArray = this.dataToParse;
                n = this.dataToParse.length;
            }
            if (n < this.sliceSize && (bufferedReader = this.readerQueue.peek()) != null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                if (stringArray != null) {
                    for (String string : stringArray) {
                        arrayList.add(string);
                    }
                }
                int n2 = 1;
                for (int i = n; n2 != 0 && i < this.sliceSize; ++i) {
                    String string = bufferedReader.readLine();
                    if (string != null) {
                        arrayList.add(string);
                        continue;
                    }
                    n2 = 0;
                }
                this.dataToParse = arrayList.toArray(STRING_TEMPLATE_ARRAY);
                if (!bufferedReader.ready()) {
                    bufferedReader.close();
                    this.readerQueue.remove();
                }
            }
        }
        return this.dataToParse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void clearBufferCaches() {
        Object object = this.dataLock;
        synchronized (object) {
            this.dataToParse = null;
            BufferedReader bufferedReader = this.readerQueue.poll();
            while (bufferedReader != null) {
                try {
                    bufferedReader.close();
                    bufferedReader = this.readerQueue.poll();
                }
                catch (IOException iOException) {
                    TRACE.warning(iOException.toString());
                }
            }
        }
    }
}

