/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.memory.parser;

import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.StringDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TwoDimensionalDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.axes.AxisPair;
import com.ibm.java.diagnostics.common.datamodel.data.axes.XDataAxis;
import com.ibm.java.diagnostics.common.datamodel.data.axes.YDataAxis;
import com.ibm.java.diagnostics.common.datamodel.factory.DataFactory;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.AxisUtil;
import com.ibm.java.diagnostics.common.datamodel.impl.progress.ProgressIndicatorImpl;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.extensions.parsers.LineParser;
import com.ibm.java.diagnostics.common.extensions.parsers.ProgressIndicator;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.JVMLabels;
import com.ibm.java.diagnostics.healthcenter.gc.parser.constants.GCAxes;
import com.ibm.java.diagnostics.healthcenter.memory.MemoryLabels;
import com.ibm.java.diagnostics.healthcenter.sources.DynamicSource;
import java.util.ArrayList;
import java.util.logging.Logger;

public class MemoryParser
implements LineParser {
    private static final String COMMA = ",";
    private static final String EQUALS = "=";
    private AxisPair memoryAxisPair;
    private AxisPair numberAxisPair;
    private static final Logger TRACE = LogFactory.getTrace(MemoryParser.class);
    public static final DataFactory factory = DataFactory.getFactory();
    private String nextEyeCatcher = null;
    private ArrayList<String> partialCounterInfo = new ArrayList();
    private int sequenceUID = 0;
    private static final String CLASSNAME = MemoryParser.class.getName();
    private static final String MEM_COUNTER_INFO = "memcounterinfo";

    @Override
    public ProgressIndicator parse(DynamicSource dynamicSource, String[] stringArray, DataBuilder dataBuilder, OutputProperties outputProperties) {
        YDataAxis yDataAxis;
        XDataAxis xDataAxis;
        TRACE.entering(CLASSNAME, "parse");
        if (this.memoryAxisPair == null) {
            xDataAxis = AxisUtil.prepareXAxis(outputProperties);
            yDataAxis = GCAxes.prepareHeapAxis(outputProperties);
            this.memoryAxisPair = factory.createAxisPair(xDataAxis, yDataAxis);
        }
        if (this.numberAxisPair == null) {
            xDataAxis = AxisUtil.prepareXAxis(outputProperties);
            yDataAxis = AxisUtil.prepareNumberAxis(outputProperties);
            this.numberAxisPair = factory.createAxisPair(xDataAxis, yDataAxis);
        }
        if (this.populateMemoryData(dataBuilder, stringArray)) {
            TRACE.exiting(CLASSNAME, "parse");
            return new ProgressIndicatorImpl(stringArray.length, stringArray.length);
        }
        if (this.checkMemCounterData(dataBuilder, stringArray)) {
            TRACE.exiting(CLASSNAME, "parse");
            return new ProgressIndicatorImpl(stringArray.length, stringArray.length);
        }
        TRACE.exiting(CLASSNAME, "parse");
        return ProgressIndicatorImpl.NOT_INTERESTED_PROGRESS;
    }

    private TwoDimensionalDataBuilder createTwoDimensional(DataBuilder dataBuilder, String string, String string2, String string3, AxisPair axisPair) {
        DataBuilder dataBuilder2;
        DataBuilder dataBuilder3 = dataBuilder.getTopLevelData(JVMLabels.MEMORY);
        if (dataBuilder3 == null) {
            dataBuilder3 = factory.createSubsystemData(JVMLabels.MEMORY, "com.ibm.java.diagnostics.healthcenter.memory.perspective.MemoryPerspective");
            dataBuilder.addData(dataBuilder3);
        }
        if ((dataBuilder2 = dataBuilder3.getData(MemoryLabels.MEMORY_COUNTERS_LABEL)) == null) {
            dataBuilder2 = factory.createStringData(MemoryLabels.MEMORY_COUNTERS_LABEL);
            dataBuilder3.addData(dataBuilder2);
        }
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = factory.createTwoDimensionalData(string2, axisPair);
        if (string.equals(MemoryLabels.BYTES_SHALLOW_LABEL)) {
            if (dataBuilder2.getData(MemoryLabels.BYTES_SHALLOW_LABEL) == null) {
                StringDataBuilder stringDataBuilder = factory.createStringData(MemoryLabels.BYTES_SHALLOW_LABEL);
                dataBuilder2.addData(stringDataBuilder);
            }
            if (dataBuilder2.getData(MemoryLabels.BYTES_SHALLOW_LABEL).getData(string2) == null) {
                if (string3 == null) {
                    dataBuilder2.getData(MemoryLabels.BYTES_SHALLOW_LABEL).addData(twoDimensionalDataBuilder);
                } else {
                    dataBuilder2.getData(MemoryLabels.BYTES_SHALLOW_LABEL).getData(string3).addData(twoDimensionalDataBuilder);
                }
            }
            return (TwoDimensionalDataBuilder)dataBuilder2.getData(MemoryLabels.BYTES_SHALLOW_LABEL).getData(string2);
        }
        if (string.equals(MemoryLabels.BYTES_DEEP_LABEL)) {
            if (dataBuilder2.getData(MemoryLabels.BYTES_DEEP_LABEL) == null) {
                StringDataBuilder stringDataBuilder = factory.createStringData(MemoryLabels.BYTES_DEEP_LABEL);
                dataBuilder2.addData(stringDataBuilder);
            }
            if (dataBuilder2.getData(MemoryLabels.BYTES_DEEP_LABEL).getData(string2) == null) {
                if (string3 == null) {
                    dataBuilder2.getData(MemoryLabels.BYTES_DEEP_LABEL).addData(twoDimensionalDataBuilder);
                } else {
                    dataBuilder2.getData(MemoryLabels.BYTES_DEEP_LABEL).getData(string3).addData(twoDimensionalDataBuilder);
                }
            }
            return (TwoDimensionalDataBuilder)dataBuilder2.getData(MemoryLabels.BYTES_DEEP_LABEL).getData(string2);
        }
        if (string.equals(MemoryLabels.ALLOCATION_SHALLOW_LABEL)) {
            if (dataBuilder2.getData(MemoryLabels.ALLOCATION_SHALLOW_LABEL) == null) {
                StringDataBuilder stringDataBuilder = factory.createStringData(MemoryLabels.ALLOCATION_SHALLOW_LABEL);
                dataBuilder2.addData(stringDataBuilder);
            }
            if (dataBuilder2.getData(MemoryLabels.ALLOCATION_SHALLOW_LABEL).getData(string2) == null) {
                if (string3 == null) {
                    dataBuilder2.getData(MemoryLabels.ALLOCATION_SHALLOW_LABEL).addData(twoDimensionalDataBuilder);
                } else {
                    dataBuilder2.getData(MemoryLabels.ALLOCATION_SHALLOW_LABEL).getData(string3).addData(twoDimensionalDataBuilder);
                }
            }
            return (TwoDimensionalDataBuilder)dataBuilder2.getData(MemoryLabels.ALLOCATION_SHALLOW_LABEL).getData(string2);
        }
        if (string.equals(MemoryLabels.ALLOCATION_DEEP_LABEL)) {
            if (dataBuilder2.getData(MemoryLabels.ALLOCATION_DEEP_LABEL) == null) {
                StringDataBuilder stringDataBuilder = factory.createStringData(MemoryLabels.ALLOCATION_DEEP_LABEL);
                dataBuilder2.addData(stringDataBuilder);
            }
            if (dataBuilder2.getData(MemoryLabels.ALLOCATION_DEEP_LABEL).getData(string2) == null) {
                if (string3 == null) {
                    dataBuilder2.getData(MemoryLabels.ALLOCATION_DEEP_LABEL).addData(twoDimensionalDataBuilder);
                } else {
                    dataBuilder2.getData(MemoryLabels.ALLOCATION_DEEP_LABEL).getData(string3).addData(twoDimensionalDataBuilder);
                }
            }
            return (TwoDimensionalDataBuilder)dataBuilder2.getData(MemoryLabels.ALLOCATION_DEEP_LABEL).getData(string2);
        }
        return null;
    }

    private TwoDimensionalDataBuilder createTwoDimensional(DataBuilder dataBuilder, String string, AxisPair axisPair) {
        DataBuilder dataBuilder2 = dataBuilder.getTopLevelData(JVMLabels.MEMORY);
        if (dataBuilder2 == null) {
            dataBuilder2 = factory.createSubsystemData(JVMLabels.MEMORY, "com.ibm.java.diagnostics.healthcenter.memory.perspective.MemoryPerspective");
            dataBuilder.addData(dataBuilder2);
        }
        if (dataBuilder2.getData(string) == null) {
            TwoDimensionalDataBuilder twoDimensionalDataBuilder = factory.createTwoDimensionalData(string, axisPair);
            dataBuilder2.addData(twoDimensionalDataBuilder);
        }
        return (TwoDimensionalDataBuilder)dataBuilder2.getData(string);
    }

    private boolean populateMemoryData(DataBuilder dataBuilder, String[] stringArray) {
        boolean bl = false;
        for (String string : stringArray) {
            if (!string.startsWith("MemorySource")) continue;
            bl = true;
            String[] stringArray2 = string.split(COMMA);
            if (stringArray2.length <= 2) continue;
            long l = Long.valueOf(stringArray2[1]);
            long l2 = 0L;
            for (int i = 2; i < stringArray2.length; ++i) {
                TwoDimensionalDataBuilder twoDimensionalDataBuilder;
                String string2 = stringArray2[i];
                l2 = MemoryParser.getMemoryValue(string2);
                if (l2 == -1L) continue;
                if (string2.startsWith("freephysicalmemory")) {
                    twoDimensionalDataBuilder = this.createTwoDimensional(dataBuilder, MemoryLabels.FREE_PYHSICAL_MEMORY_SIZE, this.memoryAxisPair);
                    twoDimensionalDataBuilder.addDataPoint(0, l, l2);
                    continue;
                }
                if (string2.startsWith("privatememory")) {
                    twoDimensionalDataBuilder = this.createTwoDimensional(dataBuilder, MemoryLabels.PRIVATE_MEMORY_SIZE, this.memoryAxisPair);
                    twoDimensionalDataBuilder.addDataPoint(0, l, l2);
                    continue;
                }
                if (string2.startsWith("virtualmemory")) {
                    twoDimensionalDataBuilder = this.createTwoDimensional(dataBuilder, MemoryLabels.VIRTUAL_MEMORY_SIZE, this.memoryAxisPair);
                    twoDimensionalDataBuilder.addDataPoint(0, l, l2);
                    continue;
                }
                if (string2.startsWith("physicalmemory")) {
                    twoDimensionalDataBuilder = this.createTwoDimensional(dataBuilder, MemoryLabels.PHYSICAL_MEMORY_SIZE, this.memoryAxisPair);
                    twoDimensionalDataBuilder.addDataPoint(0, l, l2);
                    continue;
                }
                if (!string2.startsWith("totalphysicalmemory")) continue;
                twoDimensionalDataBuilder = this.createTwoDimensional(dataBuilder, MemoryLabels.TOTAL_PHYSICAL_MEMORY_SIZE, this.memoryAxisPair);
                twoDimensionalDataBuilder.addDataPoint(0, l, l2);
            }
        }
        return bl;
    }

    private boolean checkMemCounterData(DataBuilder dataBuilder, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.nextEyeCatcher == null) {
                this.nextEyeCatcher = "smc";
            }
            if (stringArray[i].startsWith("smc")) {
                if (this.nextEyeCatcher.equals("smc")) {
                    this.nextEyeCatcher = "time stamp=";
                    continue;
                }
                this.partialCounterInfo.clear();
                this.nextEyeCatcher = "time stamp=";
                continue;
            }
            if (stringArray[i].startsWith("time stamp=")) {
                if (this.nextEyeCatcher.equals("time stamp=")) {
                    this.nextEyeCatcher = MEM_COUNTER_INFO;
                    this.partialCounterInfo.add(stringArray[i]);
                    continue;
                }
                this.partialCounterInfo.clear();
                this.nextEyeCatcher = "smc";
                continue;
            }
            if (stringArray[i].startsWith(MEM_COUNTER_INFO)) {
                if (this.nextEyeCatcher.equals(MEM_COUNTER_INFO)) {
                    this.partialCounterInfo.add(stringArray[i]);
                    continue;
                }
                this.partialCounterInfo.clear();
                this.nextEyeCatcher = "smc";
                continue;
            }
            if (stringArray[i].startsWith("emc")) {
                if (this.nextEyeCatcher.equals(MEM_COUNTER_INFO)) {
                    this.nextEyeCatcher = "smc";
                    this.addDataToModel(dataBuilder, this.partialCounterInfo);
                    this.partialCounterInfo.clear();
                    continue;
                }
                this.partialCounterInfo.clear();
                this.nextEyeCatcher = "smc";
                continue;
            }
            return false;
        }
        return true;
    }

    private void addDataToModel(DataBuilder dataBuilder, ArrayList<String> arrayList) {
        long l = -1L;
        int n = arrayList.get(0).indexOf(61) + 1;
        if (n == -1) {
            return;
        }
        Object object = arrayList.get(0).substring(n);
        l = Long.parseLong((String)object);
        object = new ArrayList();
        for (int i = 1; i < arrayList.size(); ++i) {
            String[] stringArray = arrayList.get(i).split(COMMA);
            ((ArrayList)object).add(i - 1, stringArray[1].trim());
            long l2 = Long.parseLong(stringArray[2].trim());
            long l3 = Long.parseLong(stringArray[3].trim());
            int n2 = Integer.parseInt(stringArray[4].trim());
            int n3 = Integer.parseInt(stringArray[5].trim());
            int n4 = Integer.parseInt(stringArray[8].trim());
            String string = null;
            if (n4 != -1) {
                string = (String)((ArrayList)object).get(n4);
            }
            TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.createTwoDimensional(dataBuilder, MemoryLabels.BYTES_SHALLOW_LABEL, (String)((ArrayList)object).get(i - 1), string, this.memoryAxisPair);
            twoDimensionalDataBuilder.addDataPoint(this.sequenceUID, l, l2);
            TwoDimensionalDataBuilder twoDimensionalDataBuilder2 = this.createTwoDimensional(dataBuilder, MemoryLabels.BYTES_DEEP_LABEL, (String)((ArrayList)object).get(i - 1), string, this.memoryAxisPair);
            twoDimensionalDataBuilder2.addDataPoint(this.sequenceUID, l, l3);
            TwoDimensionalDataBuilder twoDimensionalDataBuilder3 = this.createTwoDimensional(dataBuilder, MemoryLabels.ALLOCATION_SHALLOW_LABEL, (String)((ArrayList)object).get(i - 1), string, this.numberAxisPair);
            twoDimensionalDataBuilder3.addDataPoint(this.sequenceUID, l, n2);
            TwoDimensionalDataBuilder twoDimensionalDataBuilder4 = this.createTwoDimensional(dataBuilder, MemoryLabels.ALLOCATION_DEEP_LABEL, (String)((ArrayList)object).get(i - 1), string, this.numberAxisPair);
            twoDimensionalDataBuilder4.addDataPoint(this.sequenceUID, l, n3);
        }
        ++this.sequenceUID;
    }

    public static long getMemoryValue(String string) {
        long l = -1L;
        if (string == null) {
            return l;
        }
        String string2 = string.substring(string.lastIndexOf(EQUALS) + 1);
        try {
            l = Long.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return l;
        }
        return l;
    }
}

