/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.postprocessor;

import com.ibm.java.diagnostics.common.datamodel.data.Status;
import com.ibm.java.diagnostics.common.datamodel.data.StructuredStringDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.SubsystemDataBuilder;

public abstract class PostProcessorBase {
    public void setHighLevelMessage(SubsystemDataBuilder subsystemDataBuilder, StructuredStringDataBuilder structuredStringDataBuilder) {
        subsystemDataBuilder.clearValue();
        subsystemDataBuilder.setStatus(Status.UNKNOWN);
        String[] stringArray = structuredStringDataBuilder.getProblems();
        if (stringArray != null && stringArray.length > 0) {
            subsystemDataBuilder.setStatus(Status.PROBLEM);
            subsystemDataBuilder.addValue(stringArray[0]);
        } else {
            String[] stringArray2 = structuredStringDataBuilder.getWarnings();
            if (stringArray2 != null && stringArray2.length > 0) {
                subsystemDataBuilder.setStatus(Status.WARNING);
                subsystemDataBuilder.addValue(stringArray2[0]);
            } else {
                String[] stringArray3 = structuredStringDataBuilder.getGoodThings();
                if (stringArray3 != null && stringArray3.length > 0) {
                    subsystemDataBuilder.setStatus(Status.HEALTHY);
                    subsystemDataBuilder.addValue(stringArray3[0]);
                } else {
                    String[] stringArray4 = structuredStringDataBuilder.getInformations();
                    if (stringArray4 != null && stringArray4.length > 0) {
                        subsystemDataBuilder.setStatus(Status.INFORMATION);
                        subsystemDataBuilder.addValue(stringArray4[0]);
                    }
                }
            }
        }
    }

    public String[][] getAllMessages(StructuredStringDataBuilder structuredStringDataBuilder) {
        String[][] stringArray = new String[][]{structuredStringDataBuilder.getProblems(), structuredStringDataBuilder.getWarnings(), structuredStringDataBuilder.getInformations(), structuredStringDataBuilder.getGoodThings()};
        return stringArray;
    }

    public boolean hasNoRecommendation(StructuredStringDataBuilder structuredStringDataBuilder) {
        return structuredStringDataBuilder.getProblems() != null && structuredStringDataBuilder.getProblems().length < 1 && structuredStringDataBuilder.getWarnings() != null && structuredStringDataBuilder.getWarnings().length < 1 && structuredStringDataBuilder.getInformations() != null && structuredStringDataBuilder.getInformations().length < 1 && structuredStringDataBuilder.getGoodThings() != null && structuredStringDataBuilder.getGoodThings().length < 1;
    }
}

