/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.CORBA.channel.giop;

import com.ibm.CORBA.channel.giop.GIOPConnectionContext;
import com.ibm.CORBA.iiop.GIOPConnectionProfile;
import com.ibm.CORBA.ras.Trc;
import com.ibm.CORBA.transport.ConnectionKey;
import com.ibm.wsspi.channel.framework.ChannelFrameworkFactory;
import com.ibm.wsspi.channel.framework.VirtualConnectionFactory;
import com.ibm.wsspi.tcp.channel.TCPConnectRequestContext;
import java.net.InetSocketAddress;

public abstract class GIOPConnectionKey
implements TCPConnectRequestContext,
ConnectionKey {
    private static final String CLASS = GIOPConnectionKey.class.getName();
    private GIOPConnectionContext connectionContext;
    private InetSocketAddress remoteAddress;
    private InetSocketAddress localAddress = null;
    private VirtualConnectionFactory virtualConnectionFactory;
    private int connectTimeOut;
    private GIOPConnectionProfile connProfile;
    private String remoteHost;
    private int remotePort;
    private String localHost = null;

    protected GIOPConnectionKey() {
    }

    protected GIOPConnectionKey(String string, GIOPConnectionProfile gIOPConnectionProfile, int n) {
        this.init(string, gIOPConnectionProfile, null, n);
    }

    protected GIOPConnectionKey(String string, GIOPConnectionProfile gIOPConnectionProfile, String string2, int n) {
        this.init(string, gIOPConnectionProfile, string2, n);
    }

    protected void init(String string, GIOPConnectionProfile gIOPConnectionProfile, int n) {
        this.init(string, gIOPConnectionProfile, null, n);
    }

    protected void init(String string, GIOPConnectionProfile gIOPConnectionProfile, String string2, int n) {
        this.remoteAddress = null;
        this.lookupVirtualConnectionFactory(string);
        this.setTimeout(n);
        this.connProfile = gIOPConnectionProfile;
        this.remoteHost = gIOPConnectionProfile.getHost();
        this.remotePort = gIOPConnectionProfile.getPort();
        if (string2 != null && !string2.equals(this.localHost)) {
            this.localAddress = null;
            this.localHost = string2;
        }
    }

    private void setTimeout(int n) {
        this.connectTimeOut = n == 0 ? -1 : n;
    }

    private void lookupVirtualConnectionFactory(String string) {
        try {
            this.virtualConnectionFactory = ChannelFrameworkFactory.getChannelFramework().getOutboundVCFactory(string);
        }
        catch (Exception exception) {
            Trc.ffdc(exception, CLASS, "retrieveVirtualConenctionFactory:192");
        }
    }

    public InetSocketAddress getLocalAddress() {
        if (this.localHost != null && this.localAddress == null) {
            this.localAddress = new InetSocketAddress(this.localHost, 0);
        }
        return this.localAddress;
    }

    public InetSocketAddress getRemoteAddress() {
        if (this.remoteAddress == null) {
            if (this.remoteHost == null) {
                throw new IllegalStateException("Connection key is not initialized");
            }
            this.remoteAddress = new InetSocketAddress(this.remoteHost, this.remotePort);
        }
        return this.remoteAddress;
    }

    public VirtualConnectionFactory getVirtualConnectionFactory() {
        return this.virtualConnectionFactory;
    }

    public int getConnectTimeout() {
        return this.connectTimeOut;
    }

    public String toString() {
        return "[local host =" + this.localHost + " remote host=" + this.getRemoteHost() + " remote port=" + this.getRemotePort() + ", VirtualConnectionFactory=" + this.virtualConnectionFactory.getName() + "]";
    }

    public GIOPConnectionProfile getGIOPConnectionProfile() {
        return this.connProfile;
    }

    public GIOPConnectionContext getGIOPConnectionContext() {
        return this.connectionContext;
    }

    @Override
    public abstract boolean equals(Object var1);

    @Override
    public abstract int hashCode();

    public abstract void addConnection(GIOPConnectionContext var1);

    public abstract void removeConnection();

    public abstract Object getConnectionData();

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public abstract void recycle();
}

