/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.channel.giop;

import com.ibm.CORBA.channel.giop.CancelRequestException;
import com.ibm.CORBA.channel.giop.CloseConnectionMessageException;
import com.ibm.CORBA.channel.giop.GIOPChannelPlugin;
import com.ibm.CORBA.channel.giop.GIOPConnectionContext;
import com.ibm.CORBA.channel.giop.GIOPConnectionInfo;
import com.ibm.CORBA.channel.giop.GIOPMessageContext;
import com.ibm.CORBA.channel.giop.GIOPWriteCompletedCallback;
import com.ibm.CORBA.channel.orb.CallLink;
import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.ras.Trc;
import com.ibm.CORBA.transport.TransportConnection;
import com.ibm.jtc.orb.iiop.MessageHandler;
import com.ibm.jtc.orb.iiop.ServerRequestHandler;
import com.ibm.jtc.orb.nio.ByteBufferUtils;
import com.ibm.jtc.orb.nio.SimpleBufferHandler;
import com.ibm.rmi.CodeSetComponentInfo;
import com.ibm.rmi.ServiceContext;
import com.ibm.rmi.channel.giop.GIOPChannelConfig;
import com.ibm.rmi.channel.giop.GIOPEncoderInputHandler;
import com.ibm.rmi.channel.giop.GIOPServerChannel;
import com.ibm.rmi.channel.giop.GIOPServerLink;
import com.ibm.rmi.channel.giop.HeaderWalker;
import com.ibm.rmi.channel.giop.MessageReader;
import com.ibm.rmi.channel.giop.MessageWriter;
import com.ibm.rmi.channel.giop.ReplyStatusWalker;
import com.ibm.rmi.channel.giop.RequestDataStore;
import com.ibm.rmi.iiop.Connection;
import com.ibm.rmi.iiop.GIOPMessageContextBase;
import com.ibm.rmi.iiop.IIOPOutputStream;
import com.ibm.rmi.iiop.ORB;
import com.ibm.rmi.iiop.ReplyMessage;
import com.ibm.rmi.iiop.ServiceContextList;
import com.ibm.rmi.iiop.TransportService;
import com.ibm.rmi.util.PartnerVersionUtil;
import com.ibm.rmi.util.Utility;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferUtils;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.tcp.channel.SSLConnectionContext;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;
import com.ibm.wsspi.tcp.channel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPReadRequestContext;
import com.ibm.wsspi.tcp.channel.TCPWriteRequestContext;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Set;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;

public class GIOPConnection
extends RequestDataStore
implements GIOPConnectionContext {
    private static final String CLASS = GIOPConnection.class.getName();
    private static final boolean SERVER = true;
    private static final boolean CLIENT = false;
    private ORB orb;
    private final boolean isServer;
    private VirtualConnection virtualConnection;
    private String theParameterString;
    private MessageReader messageReader;
    private MessageWriter messageWriter;
    private Connection conn;
    private ConnectionLink connLink;
    private HeaderWalker walker = null;
    private GIOPChannelPlugin giopPlugin;
    private final Object WRITE_LOCK = new String("WRITE_LOCK");
    private boolean writeInProgress = false;
    private String serverChannelName;
    private InetAddress localAddress;
    private String localHost;
    private String localHostName;
    private int localPort;
    private InetAddress remoteAddress;
    private String remoteHost;
    private String remoteHostName;
    private int remotePort;
    private SSLConnectionContext sslContext;
    private Set nonBootstrapReq = new HashSet();
    private final boolean commTraceEnabled;
    private boolean enableClientCallback = false;
    private Set clientAsServerRep = new HashSet();
    private ReplyStatusWalker repStatWalker = null;
    private static final long serialVersionUID = 0L;

    public GIOPConnection(VirtualConnection virtualConnection, ConnectionLink connectionLink, Connection connection, TransportConnection transportConnection, GIOPChannelConfig gIOPChannelConfig, GIOPChannelPlugin gIOPChannelPlugin, TCPConnectionContext tCPConnectionContext) {
        this(virtualConnection, connectionLink, connection, transportConnection, gIOPChannelConfig, gIOPChannelPlugin, tCPConnectionContext, null, false);
        this.enableClientCallback = this.orb.getClientCallback();
    }

    public GIOPConnection(VirtualConnection virtualConnection, ConnectionLink connectionLink, Connection connection, TransportConnection transportConnection, GIOPChannelConfig gIOPChannelConfig, GIOPChannelPlugin gIOPChannelPlugin, TCPConnectionContext tCPConnectionContext, String string) {
        this(virtualConnection, connectionLink, connection, transportConnection, gIOPChannelConfig, gIOPChannelPlugin, tCPConnectionContext, string, true);
        GIOPServerChannel gIOPServerChannel = ((GIOPServerLink)connectionLink).getChannel();
        this.serverChannelName = gIOPServerChannel.getChannelName();
    }

    public GIOPConnection(VirtualConnection virtualConnection, ConnectionLink connectionLink, Connection connection, TransportConnection transportConnection, GIOPChannelConfig gIOPChannelConfig, GIOPChannelPlugin gIOPChannelPlugin, TCPConnectionContext tCPConnectionContext, String string, boolean bl) {
        this.virtualConnection = virtualConnection;
        this.connLink = connectionLink;
        this.conn = connection;
        this.giopPlugin = gIOPChannelPlugin;
        this.messageReader = new MessageReader(virtualConnection, transportConnection, tCPConnectionContext.getReadInterface(), this, gIOPChannelConfig, gIOPChannelPlugin, string, bl);
        this.messageWriter = new MessageWriter(virtualConnection, transportConnection, tCPConnectionContext.getWriteInterface(), this, gIOPChannelConfig, gIOPChannelPlugin);
        this.isServer = bl;
        this.orb = gIOPChannelConfig.getOrb();
        this.commTraceEnabled = ((TransportService)this.orb.getTransport()).isCommTraceEnabled();
        this.localAddress = tCPConnectionContext.getLocalAddress();
        this.localHost = this.localAddress.getHostAddress();
        this.localHostName = this.localAddress.getHostName();
        this.localPort = tCPConnectionContext.getLocalPort();
        this.remoteAddress = tCPConnectionContext.getRemoteAddress();
        this.remoteHost = this.remoteAddress.getHostAddress();
        this.remoteHostName = this.remoteAddress.getHostName();
        this.remotePort = tCPConnectionContext.getRemotePort();
        this.sslContext = tCPConnectionContext.getSSLContext();
    }

    @Deprecated
    protected void updateActivityIndicator() {
    }

    protected ConnectionLink getConnectionLink() {
        return this.connLink;
    }

    public VirtualConnection read(long l, TCPReadCompletedCallback tCPReadCompletedCallback, boolean bl, int n) {
        throw new UnsupportedOperationException("Async read should not be called directly");
    }

    public TCPReadRequestContext getReadInterface() {
        return this.messageReader;
    }

    public TCPWriteRequestContext getWriteInterface() {
        return this.messageWriter;
    }

    public InetAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public InetAddress getLocalAddress() {
        return this.localAddress;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public SSLConnectionContext getSSLContext() {
        return this.sslContext;
    }

    @Override
    public String getLocalHostName() {
        return this.localHostName;
    }

    @Override
    public String getLocalHost() {
        return this.localHost;
    }

    @Override
    public String getRemoteHost() {
        return this.remoteHost;
    }

    @Override
    public String getRemoteHostName() {
        return this.remoteHostName;
    }

    @Override
    public void writeMessage(CallLink callLink, GIOPMessageContext gIOPMessageContext, int n) throws CancelRequestException, CloseConnectionMessageException, IOException {
        this.messageWriter.writeMessage(callLink, gIOPMessageContext, n);
    }

    @Override
    public VirtualConnection writeMessage(CallLink callLink, GIOPMessageContext gIOPMessageContext, GIOPWriteCompletedCallback gIOPWriteCompletedCallback, boolean bl, int n) throws CancelRequestException, CloseConnectionMessageException, IOException {
        VirtualConnection virtualConnection = this.messageWriter.writeMessage(callLink, gIOPMessageContext, gIOPWriteCompletedCallback, bl, n);
        return virtualConnection;
    }

    @Override
    public GIOPConnectionInfo getGIOPConnectionInfo() {
        return this.conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection(Exception exception) {
        this.conn.abortConnection();
        this.connLink.close(this.virtualConnection, exception);
        try {
            TransportService transportService = (TransportService)this.orb.getTransport();
            try {
                transportService.getConnectionTable().removeConnection(this.conn);
            }
            catch (Exception exception2) {
                Trc.ffdc(exception2, CLASS, "closeConnection:467");
            }
        }
        catch (Exception exception3) {
            if (Trc.enabled(3)) {
                Trc.info(Trc.FINEST, exception.getMessage(), CLASS, "closeConnection:473");
            }
        }
        finally {
            this.giopPlugin.routeCloseConnection(this, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void obtainPermissionToWrite() throws IOException {
        boolean bl = false;
        do {
            Object object = this.WRITE_LOCK;
            synchronized (object) {
                if (this.virtualConnection.requestPermissionToWrite()) {
                    bl = true;
                    this.writeInProgress = true;
                }
            }
            if (bl) continue;
            if (this.isClosed()) {
                if (Trc.enabled(3)) {
                    Trc.info(Trc.FINEST, "Connection closed", CLASS, "obtainPermissionToWrite:501");
                }
                throw new IOException("Connection is closed");
            }
            object = this.WRITE_LOCK;
            synchronized (object) {
                try {
                    if (Trc.enabled(3)) {
                        Trc.info(Trc.FINEST, "Waiting ...", CLASS, "obtainPermissionToWrite:507");
                    }
                    this.WRITE_LOCK.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        } while (!bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void relinquishPermissionToWrite() {
        Object object = this.WRITE_LOCK;
        synchronized (object) {
            this.writeInProgress = false;
            this.virtualConnection.setWriteStateToDone();
            if (Trc.enabled(3)) {
                Trc.info(Trc.FINEST, "Relinquishing permission", CLASS, "relinquishPermissionToWrite:531");
            }
            this.WRITE_LOCK.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForPermissionToClose(Exception exception) {
        if (Trc.enabled(3)) {
            Trc.info(Trc.FINEST, this, CLASS, "waitForPermissionToClose:551");
        }
        if (!this.isClosed()) {
            Trc.ffdc("Connection is not marked as being closed!", CLASS, "waitForPermissionToClose:560");
        }
        Object object = this.WRITE_LOCK;
        synchronized (object) {
            if (Trc.enabled(3)) {
                Trc.info(Trc.FINEST, "Notifying all threads waiting to write", CLASS, "waitForPermissionToClose:569");
            }
            this.WRITE_LOCK.notifyAll();
            while (this.writeInProgress) {
                try {
                    if (Trc.enabled(3)) {
                        Trc.info(Trc.FINEST, "Waiting for write in progress", CLASS, "waitForPermissionToClose:576");
                    }
                    this.WRITE_LOCK.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (Trc.enabled(3)) {
                Trc.info(Trc.FINEST, "Requestiong close permission", CLASS, "waitForPermissionToClose:584");
            }
            boolean bl = this.virtualConnection.requestPermissionToClose(5000L);
            if (Trc.enabled(3)) {
                Trc.info(Trc.FINEST, "Close permission ", bl ? "granted" : "denied", CLASS, "waitForPermissionToClose:591");
            }
        }
    }

    @Override
    public String toString() {
        if (this.theParameterString == null) {
            String string = this.getClass().getName();
            int n = string.lastIndexOf(".");
            String string2 = string.substring(n + 1);
            this.theParameterString = string2 + "[remote host=" + this.remoteHost + " port=" + this.remotePort + ", local host=" + this.localHost + " port=" + this.localPort + "]";
        }
        return this.theParameterString;
    }

    private IIOPOutputStream prepareExceptionResponse(Exception exception, GIOPMessageContext gIOPMessageContext) throws IOException {
        final MessageHandler messageHandler = new MessageHandler(this.orb, this.conn, gIOPMessageContext);
        ServerRequestHandler serverRequestHandler = (ServerRequestHandler)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new ServerRequestHandler(messageHandler);
            }
        });
        UNKNOWN uNKNOWN = new UNKNOWN("proxy exception", 1229126404, CompletionStatus.COMPLETED_NO);
        IIOPOutputStream iIOPOutputStream = (IIOPOutputStream)((Object)serverRequestHandler.createSystemExceptionResponse((SystemException)uNKNOWN));
        if (Trc.enabled(3)) {
            Trc.info(Trc.FINEST, "prepare ", exception, " for msg ", gIOPMessageContext.getMessage(), " in ", iIOPOutputStream, CLASS, "prepareExceptionResponse:643");
        }
        return iIOPOutputStream;
    }

    @Override
    public VirtualConnection sendExceptionResponse(Exception exception, GIOPMessageContext gIOPMessageContext, GIOPWriteCompletedCallback gIOPWriteCompletedCallback, boolean bl, int n) throws CancelRequestException, IOException, UnsupportedOperationException {
        VirtualConnection virtualConnection;
        if (!this.isServerMode(gIOPMessageContext, false)) {
            throw new UnsupportedOperationException("sendExceptionResponse is not allowed for Client");
        }
        if (!gIOPMessageContext.isResponseExpected()) {
            throw new UnsupportedOperationException("Message is not expecting a response");
        }
        IIOPOutputStream iIOPOutputStream = this.prepareExceptionResponse(exception, gIOPMessageContext);
        GIOPMessageContextBase gIOPMessageContextBase = (GIOPMessageContextBase)gIOPMessageContext;
        gIOPMessageContextBase.setExceptionResponse(iIOPOutputStream);
        try {
            virtualConnection = iIOPOutputStream.writeAsyncExceptionResponse(this, gIOPWriteCompletedCallback, bl, n);
        }
        catch (Exception exception2) {
            throw new IOException(exception2.toString());
        }
        return virtualConnection;
    }

    @Override
    public void sendExceptionResponse(Exception exception, GIOPMessageContext gIOPMessageContext, int n) throws CancelRequestException, IOException, UnsupportedOperationException {
        if (!this.isServerMode(gIOPMessageContext, false)) {
            throw new UnsupportedOperationException("sendExceptionResponse is not allowed for Client");
        }
        if (!gIOPMessageContext.isResponseExpected()) {
            throw new UnsupportedOperationException("Message is not expecting a response");
        }
        IIOPOutputStream iIOPOutputStream = this.prepareExceptionResponse(exception, gIOPMessageContext);
        try {
            iIOPOutputStream.writeTo(null, this);
            iIOPOutputStream.releaseBuffer();
        }
        catch (Exception exception2) {
            throw new IOException(exception2.toString());
        }
    }

    @Override
    public VirtualConnection getVirtualConnection() {
        return this.virtualConnection;
    }

    @Override
    public WsByteBuffer[] getNextFragment(int n) throws CancelRequestException, CloseConnectionMessageException, IOException {
        return this.giopPlugin.getNextFragment(this, n);
    }

    @Override
    public void finishRequest(int n) {
        this.giopPlugin.finishRequest(this, n);
    }

    HeaderWalker getHeaderWalker() {
        if (this.walker == null) {
            this.walker = new HeaderWalker(this.conn);
        }
        return this.walker;
    }

    protected ReplyStatusWalker getReplyStatusWalker() {
        if (this.repStatWalker == null) {
            this.repStatWalker = new ReplyStatusWalker(this.conn);
        }
        return this.repStatWalker;
    }

    public Object writeReplace() throws ObjectStreamException {
        throw new NotSerializableException(this.getClass().getName());
    }

    protected boolean isServer() {
        return this.isServer;
    }

    @Override
    public void writeMessage(GIOPMessageContext gIOPMessageContext, int n) throws CancelRequestException, CloseConnectionMessageException, IOException {
        this.writeMessage(null, gIOPMessageContext, n);
    }

    @Override
    public VirtualConnection writeMessage(GIOPMessageContext gIOPMessageContext, GIOPWriteCompletedCallback gIOPWriteCompletedCallback, boolean bl, int n) throws CancelRequestException, CloseConnectionMessageException, IOException {
        return this.writeMessage(null, gIOPWriteCompletedCallback, bl, n);
    }

    public synchronized void consumeServiceContexts(GIOPMessageContext gIOPMessageContext) {
        SimpleBufferHandler simpleBufferHandler = new SimpleBufferHandler((org.omg.CORBA.ORB)this.orb, this.conn);
        GIOPEncoderInputHandler gIOPEncoderInputHandler = GIOPEncoderInputHandler.getHandler(simpleBufferHandler);
        ServiceContextList serviceContextList = (ServiceContextList)gIOPMessageContext.getServiceContexts();
        if (this.isServerMode(gIOPMessageContext, true)) {
            this.consumeForServer(gIOPEncoderInputHandler, simpleBufferHandler, serviceContextList);
        } else {
            this.consumeForClient(gIOPEncoderInputHandler, simpleBufferHandler, serviceContextList);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void consumeCodeSets(GIOPEncoderInputHandler gIOPEncoderInputHandler, SimpleBufferHandler simpleBufferHandler, com.ibm.CORBA.iiop.ServiceContext serviceContext) {
        CodeSetComponentInfo codeSetComponentInfo;
        ServiceContext serviceContext2 = (ServiceContext)serviceContext;
        simpleBufferHandler.setBuffers(serviceContext2.getContextBuffer());
        gIOPEncoderInputHandler.setDataHandler(simpleBufferHandler);
        gIOPEncoderInputHandler.consumeEndian();
        CodeSetComponentInfo.CodeSetContext codeSetContext = new CodeSetComponentInfo.CodeSetContext();
        codeSetContext.read(gIOPEncoderInputHandler);
        gIOPEncoderInputHandler.unsetDataHandler();
        int n = codeSetContext.getCharCodeSet();
        int n2 = codeSetContext.getWCharCodeSet();
        if (Trc.enabled(3)) {
            Trc.info(Trc.FINEST, "CODE_SETS ", "char_data=0x", Trc.hex(n), " wchar_data=0x", Trc.hex(n2), CLASS, "consumeCodeSets:852");
        }
        if (!(codeSetComponentInfo = (CodeSetComponentInfo)this.conn.getCodeSetComponentInfo()).validate(codeSetContext)) {
            if (n != 65537 || this.conn == null || this.conn.getCharCodeSet() != 0) throw new DATA_CONVERSION("CodeSetComponent 0x" + Utility.bytesToHexString(WsByteBufferUtils.asByteArray((WsByteBuffer[])simpleBufferHandler.getBuffers())) + " appears to be invalid.", 1229124488, CompletionStatus.COMPLETED_NO);
            if (!Trc.enabled(3)) return;
            Trc.info(Trc.FINEST, "Ignoring unexpected Latin-1 codeset", CLASS, "consumeCodeSets:866");
            return;
        } else {
            int n3 = this.conn.getCharCodeSet();
            int n4 = this.conn.getWCharCodeSet();
            if (n3 != 0 && n3 != n || n4 != 0 && n4 != n2) {
                throw new MARSHAL("Codeset has already been set.", 1229125859, CompletionStatus.COMPLETED_NO);
            }
            this.conn.setCodeSets(n, n2);
        }
    }

    private void consumeSendingContextRuntime(com.ibm.CORBA.iiop.ServiceContext serviceContext) {
        ServiceContext serviceContext2 = (ServiceContext)serviceContext;
        WsByteBuffer[] wsByteBufferArray = ByteBufferUtils.clone(serviceContext2.getContextBuffer(), false);
        this.conn.setCodeBaseRefBytes(wsByteBufferArray, true);
    }

    private void consumeIBMORBVersion(GIOPEncoderInputHandler gIOPEncoderInputHandler, SimpleBufferHandler simpleBufferHandler, com.ibm.CORBA.iiop.ServiceContext serviceContext) {
        ServiceContext serviceContext2 = (ServiceContext)serviceContext;
        simpleBufferHandler.setBuffers(serviceContext2.getContextBuffer());
        gIOPEncoderInputHandler.setDataHandler(simpleBufferHandler);
        gIOPEncoderInputHandler.consumeEndian();
        short s = gIOPEncoderInputHandler.read_ushort();
        int n = gIOPEncoderInputHandler.read_ulong();
        gIOPEncoderInputHandler.unsetDataHandler();
        short s2 = PartnerVersionUtil.unpackMajor(n);
        short s3 = PartnerVersionUtil.unpackMinor(n);
        if (Trc.enabled(3)) {
            Trc.info(Trc.FINEST, Trc.str(s2), " (0x", Trc.hex(s2), "):", Trc.str(s3), ":", Trc.str(s), CLASS, "consumeIBMORBVersion:928");
        }
        if (n == 0) {
            this.conn.setPartnerVersion(PartnerVersionUtil.getORB11(), (short)0, s);
        } else {
            this.conn.setPartnerVersion(s2, s3, s);
        }
    }

    private void consumeCustomMaxStreamFormat(GIOPEncoderInputHandler gIOPEncoderInputHandler, SimpleBufferHandler simpleBufferHandler, com.ibm.CORBA.iiop.ServiceContext serviceContext) {
        ServiceContext serviceContext2 = (ServiceContext)serviceContext;
        simpleBufferHandler.setBuffers(serviceContext2.getContextBuffer());
        gIOPEncoderInputHandler.setDataHandler(simpleBufferHandler);
        gIOPEncoderInputHandler.consumeEndian();
        this.conn.setStreamFormatVersion(gIOPEncoderInputHandler.read_octet());
        if (Trc.enabled(3)) {
            Trc.info(Trc.FINEST, "RMICustomMaxStreamFormat=", Trc.str(this.conn.getStreamFormatVersion()), CLASS, "consumeCustomMaxStreamFormat:956");
        }
        gIOPEncoderInputHandler.unsetDataHandler();
    }

    public final void consumeForServer(GIOPEncoderInputHandler gIOPEncoderInputHandler, SimpleBufferHandler simpleBufferHandler, ServiceContextList serviceContextList) {
        if (Trc.enabled(3)) {
            Trc.begin(Trc.FINEST, CLASS, "consumeForServer:973");
        }
        com.ibm.CORBA.iiop.ServiceContext[] serviceContextArray = serviceContextList.get();
        block6: for (int i = 0; i < serviceContextArray.length; ++i) {
            switch (serviceContextArray[i].getId()) {
                case 1: {
                    this.consumeCodeSets(gIOPEncoderInputHandler, simpleBufferHandler, serviceContextArray[i]);
                    continue block6;
                }
                case 6: {
                    this.consumeSendingContextRuntime(serviceContextArray[i]);
                    continue block6;
                }
                case 1229081874: {
                    this.consumeIBMORBVersion(gIOPEncoderInputHandler, simpleBufferHandler, serviceContextArray[i]);
                    continue block6;
                }
                case 17: {
                    this.consumeCustomMaxStreamFormat(gIOPEncoderInputHandler, simpleBufferHandler, serviceContextArray[i]);
                }
            }
        }
        if (Trc.enabled(3)) {
            Trc.complete(Trc.FINEST, CLASS, "consumeForServer:1000");
        }
    }

    public final void consumeForClient(GIOPEncoderInputHandler gIOPEncoderInputHandler, SimpleBufferHandler simpleBufferHandler, ServiceContextList serviceContextList) {
        if (Trc.enabled(3)) {
            Trc.begin(Trc.FINEST, CLASS, "consumeForClient:1016");
        }
        com.ibm.CORBA.iiop.ServiceContext[] serviceContextArray = serviceContextList.get();
        block5: for (int i = 0; i < serviceContextArray.length; ++i) {
            switch (serviceContextArray[i].getId()) {
                case 1: {
                    continue block5;
                }
                case 6: {
                    this.consumeSendingContextRuntime(serviceContextArray[i]);
                    continue block5;
                }
                case 1229081874: {
                    this.consumeIBMORBVersion(gIOPEncoderInputHandler, simpleBufferHandler, serviceContextArray[i]);
                }
            }
        }
        if (Trc.enabled(3)) {
            Trc.complete(Trc.FINEST, CLASS, "consumeForClient:1036");
        }
    }

    public WsByteBuffer[] getCodeBaseRefBytes() {
        return this.conn.getCodeBaseRefBytes();
    }

    protected com.ibm.CORBA.iiop.ServiceContext[] getReplyServiceContexts() {
        return this.conn.getServiceContextReplyList();
    }

    protected com.ibm.CORBA.iiop.ServiceContext[] getRequestServiceContexts(IOR iOR, byte by, byte by2) {
        return this.conn.getServiceContexts(iOR, by, by2);
    }

    protected boolean isPostInitialRequestContexts() {
        return this.conn.isPostInitialRequestContexts();
    }

    protected boolean isPostInitialReplyContexts() {
        return this.conn.isPostInitialReplyContexts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPostInitialRequestContexts(GIOPMessageContext gIOPMessageContext) {
        ReplyMessage replyMessage;
        if (this.removeNonBootstrapRequest(gIOPMessageContext.getRequestIdToken()) && (replyMessage = (ReplyMessage)gIOPMessageContext.getMessage()).getReplyStatus() != 3 && replyMessage.getReplyStatus() != 5 && (replyMessage.getReplyStatus() != 2 || replyMessage.getSystemException().completed == CompletionStatus.COMPLETED_YES)) {
            this.conn.setPostInitialRequestContexts();
            Set set = this.nonBootstrapReq;
            synchronized (set) {
                this.nonBootstrapReq.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeNonBootstrapRequest(Object object) {
        Set set = this.nonBootstrapReq;
        synchronized (set) {
            if (!this.isPostInitialRequestContexts()) {
                this.nonBootstrapReq.add(object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeNonBootstrapRequest(Object object) {
        Set set = this.nonBootstrapReq;
        synchronized (set) {
            return this.nonBootstrapReq.remove(object);
        }
    }

    protected void setPostInitialReplyContexts() {
        this.conn.setPostInitialReplyContexts();
    }

    public boolean isBusy() {
        return this.giopPlugin.isBusy(this);
    }

    public boolean isClosed() {
        return this.conn.isClosed();
    }

    protected String getServerChannelName() {
        return this.serverChannelName;
    }

    public Connection getConnection() {
        return this.conn;
    }

    public boolean isCommTraceEnabled() {
        return this.commTraceEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isServerMode(GIOPMessageContext gIOPMessageContext, boolean bl) {
        if (gIOPMessageContext.getType() == 0) {
            return bl;
        }
        if (gIOPMessageContext.getType() == 1) {
            if (this.enableClientCallback && !bl && gIOPMessageContext.isFragmentToFollow()) {
                Set set = this.clientAsServerRep;
                synchronized (set) {
                    this.clientAsServerRep.add(gIOPMessageContext.getRequestIdToken());
                }
            }
            return !bl;
        }
        if (this.enableClientCallback && !bl && gIOPMessageContext.getType() == 7) {
            boolean bl2 = false;
            Set set = this.clientAsServerRep;
            synchronized (set) {
                if (gIOPMessageContext.isFragmentToFollow()) {
                    if (this.clientAsServerRep.contains(gIOPMessageContext.getRequestIdToken())) {
                        bl2 = true;
                    }
                } else if (this.clientAsServerRep.remove(gIOPMessageContext.getRequestIdToken())) {
                    bl2 = true;
                }
            }
            return bl2;
        }
        return this.isServer;
    }

    public String getProtocol() {
        return "IIOP";
    }
}

