/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.channel.orb;

import com.ibm.CORBA.channel.giop.GIOPChannelHelper;
import com.ibm.CORBA.channel.giop.GIOPConnectionContext;
import com.ibm.CORBA.channel.giop.GIOPConnectionKey;
import com.ibm.CORBA.channel.giop.GIOPMessageContext;
import com.ibm.CORBA.ras.Trc;
import com.ibm.jtc.orb.iiop.ClientResponseHandler;
import com.ibm.jtc.orb.iiop.IIOPInputHandler;
import com.ibm.jtc.orb.iiop.MessageHandler;
import com.ibm.jtc.orb.iiop.ServerRequestHandler;
import com.ibm.rmi.iiop.Connection;
import com.ibm.rmi.iiop.EncoderInputStream;
import com.ibm.rmi.iiop.GIOPImpl;
import com.ibm.rmi.iiop.IIOPReader;
import com.ibm.rmi.iiop.ORB;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;

public class ORBChannelHelper {
    private static final String CLASS = ORBChannelHelper.class.getName();
    public static String ORB = "ORB";
    private ORB orb = null;
    private GIOPImpl giopImpl;

    protected ORBChannelHelper(Map map) {
        this.orb = (ORB)map.get(ORB);
    }

    protected int getTimeout(int n) {
        return n == 0 ? -1 : n;
    }

    protected ORB getOrb() {
        return this.orb;
    }

    private ORB getORBForJVM() {
        return GIOPChannelHelper.getOrb();
    }

    protected void setORBForChain(GIOPConnectionKey gIOPConnectionKey) {
        this.orb = this.getORBForJVM();
        if (this.orb == null) {
            this.orb = GIOPChannelHelper.getOrb(gIOPConnectionKey.getVirtualConnectionFactory().getName());
            if (this.orb == null) {
                if (Trc.enabled()) {
                    Trc.warn("ORB not set for ", gIOPConnectionKey.toString(), CLASS, "setORBForChain:137");
                }
                return;
            }
        } else if (Trc.enabled(2)) {
            Trc.info(Trc.FINEST, "ORB for JVM ", gIOPConnectionKey.toString(), CLASS, "setORBForChain:143");
        }
    }

    protected void processCall(Connection connection, GIOPConnectionContext gIOPConnectionContext, GIOPMessageContext gIOPMessageContext) throws Exception {
        if (Trc.enabled(2)) {
            Trc.info(Trc.FINEST, "connCtx=", gIOPConnectionContext, " msgCtx=", gIOPMessageContext, " conn=", connection, CLASS, "processCall:164");
        }
        final MessageHandler messageHandler = new MessageHandler(this.orb, connection, gIOPMessageContext);
        IIOPReader iIOPReader = null;
        switch (gIOPMessageContext.getType()) {
            case 0: {
                iIOPReader = (IIOPReader)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return new ServerRequestHandler(messageHandler);
                    }
                });
                break;
            }
            case 1: {
                iIOPReader = (IIOPReader)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return new ClientResponseHandler(messageHandler);
                    }
                });
                break;
            }
            default: {
                iIOPReader = (IIOPReader)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return new IIOPInputHandler(messageHandler);
                    }
                });
            }
        }
        try {
            ((EncoderInputStream)((Object)iIOPReader)).setCodeBaseRefBytes(gIOPMessageContext.getSendingContextBytes());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        connection.processInput(iIOPReader);
    }
}

