/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.corba;

import com.ibm.CORBA.iiop.INSUtil;
import com.ibm.CORBA.iiop.ObjectKey;
import com.ibm.CORBA.iiop.ObjectURL;
import com.ibm.CORBA.ras.Trc;
import com.ibm.org.omg.CORBA._ObjectStub;
import com.ibm.rmi.IOR;
import com.ibm.rmi.SubcontractRegistry;
import com.ibm.rmi.corba.ClientDelegate;
import com.ibm.rmi.corba.ClientSubcontract;
import com.ibm.rmi.corba.IIOPAddrImpl;
import com.ibm.rmi.corba.ORB;
import com.ibm.rmi.corba.ProtAddrImpl;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.portable.Delegate;

public class Corbaloc
implements ObjectURL {
    private static final String CLASS = Corbaloc.class.getName();
    private String keyString = "NameService";
    private ObjectKey objectKey;
    private boolean isRir = false;
    private ArrayList protList = null;
    private static final String encoding = "ISO-8859-1";

    protected Corbaloc() {
    }

    public Corbaloc(String string) {
        if (Trc.enabled(1)) {
            Trc.begin1(Trc.FINEST, string, CLASS, "<init>:102");
        }
        if (string == null || string.length() == 0) {
            throw new BAD_PARAM("string is null or empty", 1330446343, CompletionStatus.COMPLETED_NO);
        }
        if (!string.toLowerCase().startsWith("corbaloc:")) {
            throw new BAD_PARAM("string does not start with corbaloc:", 1330446343, CompletionStatus.COMPLETED_NO);
        }
        this.parseCorbaloc(string.substring("corbaloc:".length()));
        if (Trc.enabled(1)) {
            Trc.complete(Trc.FINEST, this.toString(), CLASS, "<init>:120");
        }
    }

    protected void parseCorbaloc(String string) {
        byte[] byArray;
        int n = string.indexOf(47);
        if (n == -1) {
            this.parseObjAddrList(string);
        } else {
            this.parseObjAddrList(string.substring(0, n));
            if (n + 1 < string.length()) {
                this.keyString = INSUtil.decode2936(string.substring(n + 1));
            }
        }
        try {
            byArray = this.keyString.getBytes(encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Trc.ffdc(unsupportedEncodingException, CLASS, "parseCorbaloc:151");
            byArray = this.keyString.getBytes();
        }
        this.objectKey = new ObjectKey(byArray);
    }

    private void parseObjAddrList(String string) {
        if (string == null || string.length() == 0) {
            throw new BAD_PARAM("string has no address scheme", 1330446344, CompletionStatus.COMPLETED_NO);
        }
        while (string != null) {
            int n = string.indexOf(44);
            if (n == -1) {
                this.parseObjAddr(string);
                string = null;
                continue;
            }
            this.parseObjAddr(string.substring(0, n));
            if (n + 1 <= string.length()) {
                string = string.substring(n + 1);
                continue;
            }
            string = null;
        }
        if (this.isRir && this.protList != null) {
            throw new BAD_PARAM("rir: cannot be used with any other protocol", 1330446344, CompletionStatus.COMPLETED_NO);
        }
    }

    private void parseObjAddr(String string) {
        if (string == null || string.length() == 0) {
            throw new BAD_PARAM("empty obj_addr", 1330446344, CompletionStatus.COMPLETED_NO);
        }
        int n = string.indexOf(58);
        if (n == -1) {
            throw new BAD_PARAM("missing prot_addr " + string, 1330446344, CompletionStatus.COMPLETED_NO);
        }
        if (string.startsWith("rir:")) {
            if (n + 1 < string.length()) {
                throw new BAD_PARAM("invalid obj_addr " + string, 1330446345, CompletionStatus.COMPLETED_NO);
            }
            this.isRir = true;
        } else if (n == 0 || string.startsWith("iiop:")) {
            this.addToProtList(new IIOPAddrImpl(string.substring(n + 1)));
        } else {
            this.addToProtList(new ProtAddrImpl(string.substring(0, n), string.substring(n + 1)));
        }
    }

    private void addToProtList(ObjectURL.ProtAddr protAddr) {
        if (protAddr == null) {
            return;
        }
        if (this.protList == null) {
            this.protList = new ArrayList();
        }
        this.protList.add(protAddr);
    }

    @Override
    public String toString() {
        return "corbaloc:" + this.corbalocToString();
    }

    protected String corbalocToString() {
        String string = "";
        if (this.isRir) {
            string = string + "rir:";
        } else {
            for (int i = 0; i < this.protList.size(); ++i) {
                if (i > 0) {
                    string = string + ',';
                }
                string = string + this.protList.get(i).toString();
            }
        }
        return string + '/' + this.getKeyString();
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                System.out.println(stringArray[i] + " -> " + new Corbaloc(stringArray[i]));
                continue;
            }
            catch (Exception exception) {
                System.out.println(stringArray[i] + " -> " + exception.toString());
            }
        }
    }

    private Object locateUsingINS(ORB oRB, ObjectURL.IIOPAddr iIOPAddr) {
        com.ibm.CORBA.iiop.ORB cfr_ignored_0 = (com.ibm.CORBA.iiop.ORB)oRB;
        IOR iOR = (IOR)com.ibm.CORBA.iiop.ORB.createBootstrapIOR((com.ibm.CORBA.iiop.ORB)oRB, iIOPAddr.getHost(), iIOPAddr.getPort(), this.objectKey);
        iOR.getProfile().setMinor(iIOPAddr.getMinor());
        SubcontractRegistry subcontractRegistry = (SubcontractRegistry)oRB.getSubcontractRegistry();
        ClientSubcontract clientSubcontract = subcontractRegistry.getClientSubcontract(iOR);
        _ObjectStub _ObjectStub2 = new _ObjectStub();
        _ObjectStub2._set_delegate((Delegate)clientSubcontract);
        iOR = (IOR)((com.ibm.rmi.iiop.ORB)oRB).getClientGIOP().locate(iOR, (ClientDelegate)clientSubcontract);
        return oRB.IORToObject(iOR);
    }

    private Object locateUsingBootstrap(ORB oRB, ObjectURL.IIOPAddr iIOPAddr) throws InvalidName {
        return oRB.initialReferenceClient.resolve_initial_references(this.keyString, iIOPAddr.getHost(), iIOPAddr.getPort());
    }

    private Object locateUsingRir(ORB oRB) {
        try {
            return oRB.resolve_initial_references(this.keyString);
        }
        catch (InvalidName invalidName) {
            if (Trc.enabled()) {
                Trc.warn(invalidName.toString(), CLASS, "locateUsingRir:319");
            }
            throw new BAD_PARAM("could not locate rir object " + this.keyString + ": " + invalidName.toString(), 1330446346, CompletionStatus.COMPLETED_NO);
        }
    }

    protected Object lookupName(Object object) {
        return object;
    }

    public Object resolve(ORB oRB) {
        FirstException firstException = new FirstException();
        if (this.isRir) {
            try {
                return this.lookupName(this.locateUsingRir(oRB));
            }
            catch (Exception exception) {
                firstException.set(exception, null);
            }
        } else {
            ObjectURL.ProtAddr protAddr;
            int n;
            boolean[] blArray = new boolean[this.protList.size()];
            for (n = 0; n < this.protList.size(); ++n) {
                protAddr = (ObjectURL.ProtAddr)this.protList.get(n);
                if (protAddr instanceof ObjectURL.IIOPAddr) {
                    blArray[n] = false;
                    try {
                        return this.lookupName(this.locateUsingINS(oRB, (ObjectURL.IIOPAddr)protAddr));
                    }
                    catch (Exception exception) {
                        firstException.set(exception, protAddr);
                        if (!(exception instanceof COMM_FAILURE) && !(exception instanceof TRANSIENT)) continue;
                        blArray[n] = true;
                        continue;
                    }
                }
                blArray[n] = true;
                firstException.set((Exception)((java.lang.Object)new BAD_PARAM("invalid protocol " + protAddr.getProtToken(), 1330446344, CompletionStatus.COMPLETED_NO)), protAddr);
            }
            if (oRB.isSINOClient()) {
                for (n = 0; n < this.protList.size(); ++n) {
                    if (blArray[n]) continue;
                    protAddr = (ObjectURL.IIOPAddr)this.protList.get(n);
                    try {
                        return this.lookupName(this.locateUsingBootstrap(oRB, (ObjectURL.IIOPAddr)protAddr));
                    }
                    catch (Exception exception) {
                        if (!Trc.enabled()) continue;
                        Trc.warn(exception.toString(), CLASS, "resolve:405");
                    }
                }
            }
        }
        throw firstException.get();
    }

    @Override
    public boolean isCorbaloc() {
        return true;
    }

    @Override
    public boolean isCorbaname() {
        return false;
    }

    @Override
    public boolean isIOR() {
        return false;
    }

    @Override
    public boolean isRir() {
        return this.isRir;
    }

    @Override
    public Iterator getProtList() {
        return this.getIIOPList();
    }

    @Override
    public Iterator getIIOPList() {
        if (this.protList != null) {
            return this.protList.iterator();
        }
        return null;
    }

    @Override
    public ObjectKey getObjectKey() {
        return this.objectKey;
    }

    @Override
    public String getKeyString() {
        return INSUtil.encode2936(this.keyString);
    }

    @Override
    public String getStringName() {
        return null;
    }

    private static class FirstException {
        private Exception e = null;
        private ObjectURL.ProtAddr protAddr = null;

        private FirstException() {
        }

        public void set(Exception exception, ObjectURL.ProtAddr protAddr) {
            if (this.e == null || this.e instanceof SystemException && !(exception instanceof SystemException)) {
                this.e = exception;
                this.protAddr = protAddr;
            }
            if (Trc.enabled()) {
                Trc.warn(exception.toString(), CLASS, "set:439");
            }
        }

        public SystemException get() {
            if (this.e == null) {
                return new BAD_PARAM("could not locate object", 1330446346, CompletionStatus.COMPLETED_NO);
            }
            if (this.e instanceof SystemException) {
                return (SystemException)((java.lang.Object)this.e);
            }
            return new BAD_PARAM(this.e.toString() + (this.protAddr == null ? "" : " with " + this.protAddr.toString()), 1330446346, CompletionStatus.COMPLETED_NO);
        }
    }
}

