/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.corba;

import com.ibm.CORBA.iiop.ClientRequest;
import com.ibm.CORBA.iiop.ClientResponse;
import com.ibm.CORBA.iiop.ObjectKey;
import com.ibm.CORBA.ras.Trc;
import com.ibm.org.omg.CORBA._ObjectStub;
import com.ibm.rmi.IOR;
import com.ibm.rmi.SubcontractRegistry;
import com.ibm.rmi.corba.ClientSubcontract;
import com.ibm.rmi.corba.ORB;
import com.ibm.rmi.iiop.EncoderOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Properties;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.RemarshalException;

public class InitialNamingClient {
    private static final String CLASS = InitialNamingClient.class.getName();
    private URL servicesURL = null;
    private String[] listOfInitialServices;
    private Properties resolvedInitialReferences = null;
    protected ORB orb;
    private static final ObjectKey initialKey = ObjectKey.getSINOKey();

    protected InitialNamingClient(ORB oRB) {
        this.orb = oRB;
    }

    void setServicesURL(URL uRL) {
        if (this.orb.isSINOClient()) {
            this.servicesURL = uRL;
        }
    }

    URL getServicesURL() {
        return this.servicesURL;
    }

    String[] list_initial_services() {
        if (this.orb.isSINOClient()) {
            return this.cachedServices();
        }
        return null;
    }

    private synchronized Properties getInitialReferenceCache() {
        if (this.resolvedInitialReferences == null) {
            Properties properties = new Properties();
            if (this.servicesURL != null) {
                try {
                    URLConnection uRLConnection = this.servicesURL.openConnection();
                    InputStream inputStream = uRLConnection.getInputStream();
                    properties.load(inputStream);
                    inputStream.close();
                }
                catch (IOException iOException) {
                    Trc.ffdc(iOException, CLASS, "getInitialReferenceCache:146");
                    throw new COMM_FAILURE(iOException.toString(), 1229124376, CompletionStatus.COMPLETED_NO);
                }
            }
            this.resolvedInitialReferences = properties;
        }
        return this.resolvedInitialReferences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] cachedServices() {
        if (this.listOfInitialServices == null) {
            String[] stringArray = null;
            if (this.listOfInitialServices == null && this.servicesURL != null) {
                Properties properties;
                Properties properties2 = properties = this.getInitialReferenceCache();
                synchronized (properties2) {
                    stringArray = new String[properties.size()];
                    Enumeration<java.lang.Object> enumeration = properties.keys();
                    int n = 0;
                    while (enumeration.hasMoreElements()) {
                        stringArray[n] = (String)enumeration.nextElement();
                        ++n;
                    }
                }
            } else {
                stringArray = this.getInitialServices(this.orb.getORBInitialHost(), this.orb.getORBInitialPort());
            }
            this.listOfInitialServices = stringArray;
        }
        return this.listOfInitialServices;
    }

    private String[] getInitialServices(String string, int n) {
        ClientSubcontract clientSubcontract = this.getInitialRep(string, n);
        _ObjectStub _ObjectStub2 = new _ObjectStub();
        _ObjectStub2._set_delegate((Delegate)clientSubcontract);
        ClientRequest clientRequest = clientSubcontract.createRequest((Object)_ObjectStub2, "list", false);
        try {
            ClientResponse clientResponse = clientSubcontract.invoke(clientRequest);
            if (clientResponse.isSystemException()) {
                throw clientResponse.getSystemException();
            }
            int n2 = clientResponse.read_long();
            String[] stringArray = new String[n2];
            for (int i = 0; i < n2; ++i) {
                stringArray[i] = clientResponse.read_string();
            }
            return stringArray;
        }
        catch (RemarshalException remarshalException) {
            return this.getInitialServices(string, n);
        }
    }

    private ClientSubcontract getInitialRep(String string, int n) {
        com.ibm.CORBA.iiop.ORB cfr_ignored_0 = (com.ibm.CORBA.iiop.ORB)this.orb;
        IOR iOR = (IOR)com.ibm.CORBA.iiop.ORB.createBootstrapIOR((com.ibm.CORBA.iiop.ORB)this.orb, string, n, initialKey);
        iOR.getProfile().setMinor((byte)0);
        SubcontractRegistry subcontractRegistry = (SubcontractRegistry)this.orb.getSubcontractRegistry();
        ClientSubcontract clientSubcontract = subcontractRegistry.getClientSubcontract(iOR);
        return clientSubcontract;
    }

    Object resolve_initial_references(String string) throws InvalidName {
        if (this.orb.isSINOClient()) {
            return this.cachedInitialReferences(string);
        }
        throw new InvalidName(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object resolve(String string, String string2, int n) {
        ClientSubcontract clientSubcontract = this.getInitialRep(string2, n);
        _ObjectStub _ObjectStub2 = new _ObjectStub();
        _ObjectStub2._set_delegate((Delegate)clientSubcontract);
        while (true) {
            ClientRequest clientRequest = clientSubcontract.createRequest((Object)_ObjectStub2, "get", false);
            byte by = ((EncoderOutputStream)((java.lang.Object)clientRequest)).getMode();
            if (Trc.enabled()) {
                Trc.info(Trc.FINEST, "Current mode:", by == 1 ? "CDR" : "IDR", CLASS, "resolve");
            }
            try {
                ((EncoderOutputStream)((java.lang.Object)clientRequest)).setMode((byte)1);
                clientRequest.write_string(string);
            }
            finally {
                ((EncoderOutputStream)((java.lang.Object)clientRequest)).setMode(by);
            }
            try {
                ClientResponse clientResponse = clientSubcontract.invoke(clientRequest);
                if (clientResponse.isSystemException()) {
                    throw clientResponse.getSystemException();
                }
                return clientResponse.read_Object();
            }
            catch (RemarshalException remarshalException) {
                continue;
            }
            break;
        }
    }

    private Object resolve_initial_references(String string, String string2) throws InvalidName {
        int n = string2.indexOf(":");
        if (n <= 0) {
            throw new DATA_CONVERSION("BAD_MODIFIER (1) ':' missing from modifier", 1229124485, CompletionStatus.COMPLETED_NO);
        }
        try {
            String string3 = string2.substring(0, n);
            int n2 = Integer.parseInt(string2.substring(n + 1, string2.length()));
            return this.resolve_initial_references(string, string3, n2);
        }
        catch (Exception exception) {
            Trc.ffdc(exception, CLASS, "resolve_initial_references:321");
            throw new DATA_CONVERSION("BAD_MODIFIER (2)", 1229124486, CompletionStatus.COMPLETED_NO);
        }
    }

    protected Object resolve_initial_references(String string, String string2, int n) throws InvalidName {
        if (!this.orb.isSINOClient()) {
            throw new InvalidName(string2 + ":" + n + "/" + string);
        }
        Object object = this.resolve(string, string2, n);
        if (object == null) {
            throw new InvalidName("Unable to resolve initial references (1)");
        }
        return object;
    }

    private Object cachedInitialReferences(String string) throws InvalidName {
        Object object = null;
        String string2 = null;
        Properties properties = this.getInitialReferenceCache();
        string2 = properties.getProperty(string);
        if (string2 == null && this.servicesURL == null && (object = this.resolve(string, this.orb.getORBInitialHost(), this.orb.getORBInitialPort())) != null) {
            string2 = this.orb.object_to_string(object);
            properties.put(string, string2);
        }
        if (string2 == null || string2.length() == 0) {
            throw new InvalidName("Unable to resolve initial reference");
        }
        if (object == null) {
            object = this.orb.string_to_object(string2);
        }
        return object;
    }

    Object resolve_initial_references_remote(String string, String[] stringArray) throws InvalidName {
        String string2 = null;
        Object object = null;
        Throwable throwable = null;
        if (!this.orb.isSINOClient()) {
            if (Trc.enabled()) {
                Trc.warn("this ORB is not a SINO client,therefore resolve_initial_references_remote is not supported", CLASS, "resolve_initial_references_remote:415");
            }
            throw new InvalidName(string);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = null;
            int n = 0;
            try {
                String string4 = stringArray[i].substring(0, 7).toLowerCase();
                if (!string4.equals("iiop://")) {
                    throwable = new BAD_PARAM("resolve_initial_references_remote() - Syntax of modifierList - Only iiop is currently supported", 1229124128, CompletionStatus.COMPLETED_NO);
                    continue;
                }
                string2 = stringArray[i].substring(7);
                int n2 = string2.indexOf(":");
                if (n2 < 0) {
                    string3 = string2;
                    n = this.orb.getBootstrapPort();
                } else if (n2 == 0) {
                    string3 = this.orb.getBootstrapHost();
                    n = Integer.parseInt(string2.substring(1));
                } else {
                    string3 = string2.substring(0, n2);
                    n = Integer.parseInt(string2.substring(n2 + 1));
                }
                object = this.resolve_initial_references(string, string3, n);
                if (object == null) continue;
                break;
            }
            catch (Exception exception) {
                Trc.ffdc(exception, CLASS, "resolve_initial_references_remote:468");
                throwable = exception;
            }
        }
        if (object != null) {
            return object;
        }
        if (throwable == null) {
            return null;
        }
        if (throwable instanceof InvalidName) {
            throw (InvalidName)throwable;
        }
        if (throwable instanceof SystemException) {
            throw (SystemException)throwable;
        }
        return null;
    }

    String[] list_initial_services_remote(String[] stringArray) {
        String string = null;
        String[] stringArray2 = null;
        Throwable throwable = null;
        if (!this.orb.isSINOClient()) {
            if (Trc.enabled()) {
                Trc.warn("this ORB is not a SINO client,  therefore list_initial_services_remote is not supported", CLASS, "list_initial_services_remote:515");
            }
            return null;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = null;
            int n = 0;
            try {
                String string3 = stringArray[i].substring(0, 7).toLowerCase();
                if (!string3.equals("iiop://")) {
                    throwable = new BAD_PARAM("list_initial_services_remote() - Syntax of modifierList - Only iiop is currently supported", 1229126547, CompletionStatus.COMPLETED_NO);
                    continue;
                }
                string = stringArray[i].substring(7);
                int n2 = string.indexOf(":");
                if (n2 < 0) {
                    string2 = string;
                    n = this.orb.getBootstrapPort();
                } else if (n2 == 0) {
                    string2 = this.orb.getBootstrapHost();
                    n = Integer.parseInt(string.substring(1));
                } else {
                    string2 = string.substring(0, n2);
                    n = Integer.parseInt(string.substring(n2 + 1));
                }
                stringArray2 = this.getInitialServices(string2, n);
                if (stringArray2 == null) continue;
                break;
            }
            catch (Exception exception) {
                Trc.ffdc(exception, CLASS, "list_initial_services_remote:569");
                throwable = exception;
            }
        }
        if (stringArray2 != null) {
            return stringArray2;
        }
        if (throwable instanceof SystemException) {
            throw (SystemException)throwable;
        }
        return null;
    }
}

