/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.iiop.CharToTcsAscii;
import com.ibm.rmi.iiop.CharToTcsLatin1;
import com.ibm.rmi.iiop.CharToTcsUnicode;
import com.ibm.rmi.iiop.CodeSetMapping;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.DATA_CONVERSION;

public class CharToTcsConverter {
    private static final String CLASS = CharToTcsConverter.class.getName();
    protected boolean byteOriented;
    protected int osfId;
    protected CharsetEncoder encoder;

    public CharToTcsConverter(int n) {
        this.osfId = n;
        this.byteOriented = true;
        this.encoder = null;
    }

    public boolean isByteOriented() {
        return this.byteOriented;
    }

    public byte[] convertToByte(char[] cArray) {
        if (this.encoder == null) {
            this.getEncoder();
        }
        try {
            CharBuffer charBuffer = CharBuffer.wrap(cArray);
            ByteBuffer byteBuffer = this.encoder.encode(charBuffer);
            if (byteBuffer.hasArray()) {
                if (byteBuffer.position() == 0 && byteBuffer.limit() == byteBuffer.capacity()) {
                    return byteBuffer.array();
                }
                byte[] byArray = new byte[byteBuffer.limit() - byteBuffer.position()];
                System.arraycopy(byteBuffer.array(), byteBuffer.position(), byArray, 0, byArray.length);
                return byArray;
            }
            byte[] byArray = new byte[byteBuffer.limit() - byteBuffer.position()];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = byteBuffer.get();
            }
            return byArray;
        }
        catch (CharacterCodingException characterCodingException) {
            Trc.ffdc(characterCodingException, CLASS, "convertToByte119");
            throw new DATA_CONVERSION("character not mapped to negotiated transimission code set (7)", 1330446337, CompletionStatus.COMPLETED_NO);
        }
    }

    public char[] convertToChar(char[] cArray, boolean bl) {
        return null;
    }

    private synchronized void getEncoder() {
        if (this.encoder == null) {
            final String string = CodeSetMapping.mapToJavaEncoding(this.osfId);
            this.encoder = (CharsetEncoder)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Charset.forName(string).newEncoder();
                }
            });
        }
    }

    public static CharToTcsConverter getConverter(int n) {
        CharToTcsConverter charToTcsConverter;
        switch (n) {
            case 65537: 
            case 65568: {
                charToTcsConverter = new CharToTcsLatin1(n);
                break;
            }
            case 65551: 
            case 268567780: {
                charToTcsConverter = new CharToTcsAscii(n, '\u007f');
                break;
            }
            case 65792: 
            case 65801: {
                charToTcsConverter = new CharToTcsUnicode(n);
                break;
            }
            default: {
                charToTcsConverter = new CharToTcsConverter(n);
            }
        }
        return charToTcsConverter;
    }

    protected int getMaxBytesPerChar() {
        if (this.encoder == null) {
            this.getEncoder();
        }
        return new Float(this.encoder.maxBytesPerChar()).intValue();
    }

    public boolean needToSwap(boolean bl) {
        return bl && this.osfId != 65801;
    }
}

