/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.CORBA.channel.giop.GIOPMessageContext;
import com.ibm.CORBA.iiop.ObjectKey;
import com.ibm.CORBA.ras.Trc;
import com.ibm.jtc.orb.nio.ByteBufferUtils;
import com.ibm.rmi.IOR;
import com.ibm.rmi.ServiceContext;
import com.ibm.rmi.iiop.GIOPMessageContextBase;
import com.ibm.rmi.iiop.Message;
import com.ibm.rmi.iiop.RequestMessage;
import com.ibm.rmi.iiop.ServiceContextList;
import com.ibm.rmi.util.buffer.ByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.tcp.channel.TCPWriteCompletedCallback;
import java.io.IOException;
import java.io.ObjectInput;

public final class GIOPRequestContext
extends GIOPMessageContextBase
implements GIOPMessageContext,
TCPWriteCompletedCallback {
    private static final String CLASS = GIOPRequestContext.class.getName();
    private RequestMessage reqMsg;
    private WsByteBuffer[] sendingContextBytes = null;

    public GIOPRequestContext(RequestMessage requestMessage, ByteBuffer byteBuffer) throws Exception {
        super((Message)requestMessage, byteBuffer);
        this.reqMsg = requestMessage;
        this.initialIOR = requestMessage.getInitialIOR();
        this.currentIOR = this.targetIOR = requestMessage.getIOR();
        this.initialObjectKey = this.initialIOR.getProfile().getObjectKeyObject();
        this.targetObjectKey = this.targetIOR.getProfile().getObjectKeyObject();
        this.initSendingContextBytes();
    }

    public GIOPRequestContext(RequestMessage requestMessage, WsByteBuffer[] wsByteBufferArray, int n) {
        super(requestMessage, wsByteBufferArray, n);
        this.reqMsg = requestMessage;
        this.targetIOR = this.initialIOR = requestMessage.getInitialIOR();
        this.targetObjectKey = this.initialObjectKey = requestMessage.getObjectKeyObject();
        this.initSendingContextBytes();
    }

    public GIOPRequestContext() {
    }

    private void initSendingContextBytes() {
        com.ibm.CORBA.iiop.ServiceContext serviceContext = this.reqMsg.getServiceContext(6);
        if (serviceContext != null) {
            if (serviceContext instanceof ServiceContext) {
                this.sendingContextBytes = ((ServiceContext)serviceContext).getContextBuffer();
            } else {
                byte[] byArray = serviceContext.getContextData();
                this.sendingContextBytes = new WsByteBuffer[]{ByteBufferUtils.fastWrap(byArray, 0, byArray.length, true)};
            }
        }
    }

    @Override
    public boolean isRequest() {
        return true;
    }

    @Override
    public boolean isResponseExpected() {
        return this.reqMsg.isResponseExpected();
    }

    @Override
    public com.ibm.CORBA.iiop.Message getMessage() {
        if (Trc.enabled(2)) {
            Trc.info(Trc.FINEST, "msg = " + this.reqMsg, CLASS, "getMessage:145");
        }
        return this.reqMsg;
    }

    @Override
    public ObjectKey getInitialObjectKeyObject() {
        return this.initialObjectKey;
    }

    @Override
    public ObjectKey getObjectKeyObject() {
        return this.targetObjectKey;
    }

    @Override
    public void setObjectKeyObject(ObjectKey objectKey) throws UnsupportedOperationException {
        if (Trc.enabled()) {
            Trc.warn("ObjectKey changed from " + this.targetObjectKey + " to  " + objectKey, CLASS, "setObjectKeyObject:175");
        }
        this.reqMsg.setObjectKey(objectKey);
        this.targetObjectKey = objectKey;
    }

    @Override
    public com.ibm.CORBA.iiop.IOR getInitialIOR() {
        return this.initialIOR;
    }

    @Override
    public com.ibm.CORBA.iiop.IOR getTargetIOR() {
        return this.targetIOR;
    }

    @Override
    public com.ibm.CORBA.iiop.IOR getCurrentIOR() {
        return this.currentIOR;
    }

    @Override
    public void setCurrentIOR(com.ibm.CORBA.iiop.IOR iOR) throws UnsupportedOperationException {
        if (this.targetIOR != null) {
            if (Trc.enabled()) {
                Trc.warn("currentIOR changed from " + this.currentIOR + " to " + iOR, CLASS, "setCurrentIOR:217");
            }
        } else {
            throw new UnsupportedOperationException("IOR cannot be set for Target Discrimination" + this.reqMsg.getAddressingDisposition());
        }
        this.currentIOR = iOR;
        this.reqMsg.setIOR((IOR)iOR);
    }

    @Override
    public com.ibm.CORBA.iiop.ServiceContextList getServiceContexts() throws UnsupportedOperationException {
        return this.reqMsg.getServiceContexts();
    }

    @Override
    public void setServiceContexts(com.ibm.CORBA.iiop.ServiceContextList serviceContextList) throws UnsupportedOperationException {
        this.reqMsg.setServiceContexts((ServiceContextList)serviceContextList);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.reqMsg = (RequestMessage)super.getMessage();
    }

    @Override
    public WsByteBuffer[] getSendingContextBytes() throws UnsupportedOperationException {
        return this.sendingContextBytes;
    }

    @Override
    public void setSendingContextBytes(WsByteBuffer[] wsByteBufferArray) {
        this.sendingContextBytes = wsByteBufferArray;
    }
}

