/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.iiop.CDROutputStream;
import com.ibm.rmi.iiop.CharToTcsConverter;
import com.ibm.rmi.iiop.EncoderInputStream;
import com.ibm.rmi.iiop.EncoderOutputStream;
import com.ibm.rmi.iiop.IDRWriter;
import com.ibm.rmi.util.Utility;
import com.ibm.rmi.util.buffer.ByteBuffer;
import com.ibm.rmi.util.buffer.SequentialByteBuffer;
import com.ibm.rmi.util.buffer.SimpleByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.ORB;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.InputStream;

public class IDROutputStream
extends IDRWriter {
    private static final String CLASS = IDROutputStream.class.getName();
    protected ByteBuffer byteBuf;
    private ByteBuffer.Position blockSizePosition = null;
    private ByteBuffer.Position endFlagPosition = null;
    private byte[] tempData = new byte[8];
    private byte[] copyData = new byte[8];
    private byte[] varIntBuf = new byte[5];
    private byte writeMode = 0;
    private static String _id = "IDL:omg.org/CORBA/DataOutputStream:1.0";
    private static String[] _ids = new String[]{_id};
    private static final long serialVersionUID = 0L;

    public IDROutputStream(ORB oRB, boolean bl, int n, EncoderOutputStream encoderOutputStream) {
        super(oRB, bl, n, encoderOutputStream);
    }

    public IDROutputStream(EncoderOutputStream encoderOutputStream, EncoderOutputStream encoderOutputStream2) {
        super(encoderOutputStream, encoderOutputStream2);
    }

    public IDROutputStream(CDROutputStream cDROutputStream, EncoderOutputStream encoderOutputStream) {
        super(cDROutputStream.orb, cDROutputStream.littleEndian, cDROutputStream.requestedBufLen, encoderOutputStream);
        this.typeMap = cDROutputStream.typeMap;
        this.initialOffset = cDROutputStream.initialOffset;
        this.tcsChar = cDROutputStream.tcsChar;
        this.tcsWChar = cDROutputStream.tcsWChar;
        this.tcsCConverter = cDROutputStream.tcsCConverter;
        this.tcsWConverter = cDROutputStream.tcsWConverter;
    }

    @Override
    public void releaseBuffer() {
        if (this.byteBuf != null) {
            this.byteBuf.reset();
        }
    }

    @Override
    public byte[] toByteArray() {
        byte[] byArray = this.byteBuf == null ? ByteBuffer.ZERO_BYTE_ARRAY : this.byteBuf.toByteArray();
        return byArray;
    }

    @Override
    public WsByteBuffer[] toByteBuffer() {
        throw new INTERNAL("WsByteBuffer[] format is not supported in IDROutputStream");
    }

    @Override
    protected void pad(int n) {
        for (int i = 0; i < n; ++i) {
            this.byteBuf.write((byte)-67);
        }
    }

    @Override
    protected final void align(int n) {
        if (n > 1) {
            if (this.byteBuf == null) {
                this.allocateBuffer();
            } else {
                int n2 = this.byteBuf.getWriteOffset() & n - 1;
                if (n2 != 0) {
                    n2 = n - n2;
                    this.pad(n2);
                }
            }
        }
    }

    @Override
    protected final int alignAndReserve(int n, int n2) {
        int n3 = 0;
        if (this.byteBuf != null) {
            this.align(n);
        } else {
            this.allocateBuffer();
        }
        n3 = this.byteBuf.getAvailableSpace();
        if (n > n3) {
            this.completeFragment(n2);
            n3 = this.byteBuf.getAvailableSpace();
        }
        n3 = Math.min(n2, n3);
        return n3 / n;
    }

    @Override
    protected final void rememberBlockSizePosition() {
        this.blockSizePosition = this.byteBuf.getWritePosition();
    }

    @Override
    protected final void forgetBlockSizePosition() {
        this.blockSizePosition = null;
    }

    @Override
    protected final void writeBlockSizeHere(int n) {
        if (this.byteBuf.getAvailableSpace() == 0) {
            this.completeFragment(4, true);
        }
        this.rememberBlockSizePosition();
        if (this.littleEndian) {
            for (int i = 0; i < 4; ++i) {
                this.byteBuf.write((byte)(n & 0xFF));
                n >>>= 8;
            }
        } else {
            this.writeNumberInBE(n, 4);
        }
    }

    @Override
    protected final void rewriteBlockSize(int n, int n2) {
        int n3 = this.blockSizePosition.getOffset() + 4;
        int n4 = n + this.byteBuf.getWriteOffset() + n2;
        int n5 = n4 - n3;
        this.writeNumber(n5 & 0xFFFFFFFF, 4, this.littleEndian ? 1 : -1, this.blockSizePosition);
        if (Trc.enabled(2)) {
            Trc.info(Trc.FINEST, "block length: ", Trc.hex(n5), CLASS, "rewriteBlockSize:234");
        }
    }

    @Override
    protected final void clearEndFlagMarker() {
        this.endFlagPosition = null;
    }

    @Override
    protected void allocateBuffer() {
        this.byteBuf = this.fragmenting() ? new SimpleByteBuffer(this.bufferSize()) : new SequentialByteBuffer(this.bufferSize());
    }

    @Override
    public InputStream create_input_stream() {
        final byte[] byArray = this.toByteArray();
        return (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new EncoderInputStream(IDROutputStream.this.encoderStream, byArray, byArray.length);
            }
        });
    }

    @Override
    public void write_octet(byte by) {
        this.write_octet(by, false);
    }

    @Override
    public final Object writePlaceHolderOctet(byte by) {
        return this.write_octet(by, true);
    }

    @Override
    public final void rewriteOctet(byte by, Object object) {
        this.byteBuf.write(by, (ByteBuffer.Position)object, 0);
    }

    ByteBuffer.Position write_octet(byte by, boolean bl) {
        this.checkPadding();
        ByteBuffer.Position position = null;
        if (this.byteBuf.getAvailableSpace() == 0) {
            this.completeFragment(1, true);
        }
        if (bl) {
            position = this.byteBuf.getWritePosition();
        }
        this.byteBuf.write(by);
        return position;
    }

    @Override
    protected final void writeBoolean(boolean bl) {
        this.checkPadding();
        if (this.byteBuf.getAvailableSpace() == 0) {
            this.completeFragment(1, true);
        }
        this.byteBuf.write(IDROutputStream.booleanToByte(bl));
    }

    @Override
    public final Object writePlaceHolderBoolean(boolean bl) {
        this.checkPadding();
        if (this.byteBuf.getAvailableSpace() == 0) {
            this.completeFragment(1, true);
        }
        ByteBuffer.Position position = this.byteBuf.getWritePosition();
        this.byteBuf.write(IDROutputStream.booleanToByte(bl));
        return position;
    }

    @Override
    public final void rewriteBoolean(boolean bl, Object object) {
        this.byteBuf.write(IDROutputStream.booleanToByte(bl), (ByteBuffer.Position)object, 0);
    }

    private final void writeNumberInBE(long l, int n) {
        int n2 = -1;
        for (int i = n - 1; i != n2; --i) {
            this.tempData[i] = (byte)(l & 0xFFL);
            l >>>= 8;
        }
        if (this.byteBuf.getAvailableSpace() < n) {
            System.arraycopy(this.tempData, 0, this.copyData, 0, n);
            this.write_octet_array(this.copyData, 0, n, false);
        } else {
            this.write_octet_array(this.tempData, 0, n, false);
        }
    }

    @Override
    public final void write_longInVarint(int n) {
        this.checkPadding();
        int n2 = this.byteBuf.getAvailableSpace();
        int n3 = n & 0xFFFFFFFF;
        int n4 = n3 << 1 ^ n3 >> 31;
        byte by = 0;
        do {
            by = (byte)(n4 & 0x7F);
            if ((n4 >>>= 7) != 0) {
                by = (byte)(by | 0x80);
            }
            if (n2 == 0) {
                this.completeFragment(1, true);
            }
            this.byteBuf.write(by);
            --n2;
        } while (n4 != 0);
    }

    @Override
    protected final void writeShort(int n, boolean bl) {
        this.checkPadding();
        if (this.writeMode == 1) {
            this.alignAndReserve(2, 2);
        }
        if (bl) {
            int n2 = n;
            int n3 = this.byteBuf.getAvailableSpace();
            for (int i = 0; i < 2; ++i) {
                if (n3 == 0) {
                    this.completeFragment(2 - i, true);
                }
                this.byteBuf.write((byte)(n2 & 0xFF));
                n2 >>>= 8;
                --n3;
            }
        } else {
            this.writeNumberInBE(n, 2);
        }
    }

    @Override
    protected final void writeLong(int n, boolean bl) {
        this.checkPadding();
        if (bl) {
            int n2 = n;
            int n3 = this.byteBuf.getAvailableSpace();
            for (int i = 0; i < 4; ++i) {
                if (n3 == 0) {
                    this.completeFragment(4 - i, true);
                }
                this.byteBuf.write((byte)(n2 & 0xFF));
                n2 >>>= 8;
                --n3;
            }
        } else {
            this.writeNumberInBE(n, 4);
        }
    }

    private final void writeNumber(long l, int n, int n2, ByteBuffer.Position position) {
        int n3;
        int n4;
        if (n2 == 1) {
            n4 = 0;
            n3 = n;
        } else {
            n4 = n - 1;
            n3 = -1;
        }
        while (n4 != n3) {
            this.tempData[n4] = (byte)(l & 0xFFL);
            l >>>= 8;
            n4 += n2;
        }
        this.byteBuf.write(this.tempData, 0, n, position, 0);
    }

    @Override
    protected final void writeLongLong(long l, boolean bl) {
        this.checkPadding();
        if (bl) {
            long l2 = l;
            int n = this.byteBuf.getAvailableSpace();
            for (int i = 0; i < 8; ++i) {
                if (n == 0) {
                    this.completeFragment(8 - i, true);
                }
                this.byteBuf.write((byte)(l2 & 0xFFL));
                l2 >>>= 8;
                --n;
            }
        } else {
            this.writeNumberInBE(l, 8);
        }
    }

    public void write_wchar(char c) {
        CharToTcsConverter charToTcsConverter = this.getTcsWConverter();
        char[] cArray = charToTcsConverter.convertToChar(new char[]{c}, this.littleEndian);
        boolean bl = charToTcsConverter.needToSwap(this.littleEndian);
        this.checkPadding();
        int n = cArray.length;
        int n2 = n * 2;
        int n3 = this.byteBuf.getAvailableSpace();
        if (this.isPreGiop12()) {
            if (n > 1) {
                throw new DATA_CONVERSION("Character doesn't map to negotiated transmission char set - (wchar) single IDL char > 1 byte when encoded in TCS", 1330446337, CompletionStatus.COMPLETED_NO);
            }
        } else {
            if (n3-- == 0) {
                this.completeFragment(n2 + 1, true);
                n3 = this.byteBuf.getAvailableSpace();
            }
            this.byteBuf.write((byte)n2);
        }
        int[] nArray = IDROutputStream.getByteShifts(2, bl);
        int n4 = 0;
        do {
            if (n3-- == 0) {
                this.completeFragment(n2 - n4, true);
                n3 = this.byteBuf.getAvailableSpace();
            }
            this.byteBuf.write((byte)(cArray[n4 / 2] >>> nArray[n4 % 2] & 0xFF));
        } while (++n4 < n2);
    }

    @Override
    public void write_short(short s) {
        this.writeShort(s, this.littleEndian);
    }

    @Override
    public void write_ushort(short s) {
        this.write_short(s);
    }

    public void write_long(int n) {
        this.write_long(n, true);
    }

    @Override
    public final void write_long(int n, boolean bl) {
        this.write_long(n, bl, false);
    }

    @Override
    public final void rewriteLong(int n, Object object) {
        this.writeNumber(n & 0xFFFFFFFF, 4, this.littleEndian ? 1 : -1, (ByteBuffer.Position)object);
    }

    @Override
    public final Object writePlaceHolderLong(int n) {
        return this.write_long(n, false, true);
    }

    ByteBuffer.Position write_long(int n, boolean bl, boolean bl2) {
        this.checkPadding();
        if (this.writeMode == 1) {
            this.alignAndReserve(4, 4);
        }
        ByteBuffer.Position position = null;
        if (bl2) {
            if (this.byteBuf.getAvailableSpace() == 0) {
                this.completeFragment(4, true);
            }
            position = this.byteBuf.getWritePosition();
        }
        this.writeLong(n, this.littleEndian);
        return position;
    }

    public void write_ulong(int n) {
        this.encoderStream.write_long(n);
    }

    @Override
    public void write_longlong(long l) {
        this.writeLongLong(l, this.littleEndian);
    }

    @Override
    final void write_longlongInVarint(long l) {
        this.checkPadding();
        int n = this.byteBuf.getAvailableSpace();
        long l2 = l & 0xFFFFFFFFFFFFFFFFL;
        long l3 = l2 << 1 ^ l2 >> 63;
        byte by = 0;
        do {
            by = (byte)(l3 & 0x7FL);
            if ((l3 >>>= 7) != 0L) {
                by = (byte)(by | 0x80);
            }
            if (n == 0) {
                this.completeFragment(1, true);
            }
            this.byteBuf.write(by);
            --n;
        } while (l3 != 0L);
    }

    final void reserveAndWriteLongInvarint(int n) {
        int n2 = n & 0xFFFFFFFF;
        int n3 = this.byteBuf.getAvailableSpace();
        this.checkPadding();
        int n4 = 0;
        int n5 = n2 << 1 ^ n2 >> 31;
        while (true) {
            this.varIntBuf[n4] = (byte)(n5 & 0x7F);
            if ((n5 >>>= 7) == 0) break;
            this.varIntBuf[n4] = (byte)(this.varIntBuf[n4] | 0x80);
            n4 = (byte)(n4 + 1);
        }
        n4 = (byte)(n4 + 1);
        this.rewriteBlockSize(n4 + n, 0);
        if (n3 >= n4) {
            this.byteBuf.write(this.varIntBuf, 0, n4);
        } else {
            this.byteBuf.write(this.varIntBuf, 0, n3);
            this.completeFragment(n4 + n - n3, false);
            this.byteBuf.write(this.varIntBuf, n3, n4 - n3);
        }
    }

    public void write_string(String string) {
        if (string == null) {
            throw new BAD_PARAM("Null Param (2) - string", 1229124098, CompletionStatus.COMPLETED_MAYBE);
        }
        CharToTcsConverter charToTcsConverter = this.getTcsCConverter();
        byte[] byArray = charToTcsConverter.convertToByte(string.toCharArray());
        int n = byArray.length;
        this.checkPadding();
        if (this.writeMode == 1) {
            this.alignAndReserve(4, 4 + n + 1);
            this.writeLong(n + 1, this.littleEndian);
        } else if (this.inBlock) {
            this.reserveAndWriteLongInvarint(n + 1);
        } else {
            this.write_longInVarint(n + 1);
        }
        this.bupdateBlockRequired = false;
        this.write_octet_array(byArray, 0, n, false);
        this.write_octet((byte)0);
        this.bupdateBlockRequired = true;
    }

    public void write_wstringInCDR(String string) {
        int n;
        CharToTcsConverter charToTcsConverter = this.getTcsWConverter();
        char[] cArray = charToTcsConverter.convertToChar(string.toCharArray(), this.littleEndian);
        boolean bl = charToTcsConverter.needToSwap(this.littleEndian);
        int n2 = cArray.length;
        if (this.isPreGiop12()) {
            this.encoderStream.write_long(n2 + 1);
        } else {
            n = n2 * 2;
            this.checkPadding();
            this.checkChunkStart();
            this.alignAndReserve(4, 4 + n);
            this.writeLong(n, this.littleEndian);
        }
        n = 0;
        int n3 = 0;
        byte[] byArray = ByteBuffer.ZERO_BYTE_ARRAY;
        for (int i = 0; i < n2; i += n) {
            int n4;
            n = this.alignAndReserve(2, (n2 - i) * 2);
            n3 = n * 2;
            if (byArray.length < n3) {
                byArray = new byte[n3];
            }
            int n5 = 0;
            for (n4 = 0; n4 < n; ++n4) {
                char c = cArray[i + n4];
                byArray[n5] = (byte)(c >>> 8 & 0xFF);
                byArray[++n5] = (byte)(c & 0xFF);
                ++n5;
            }
            if (bl) {
                for (n5 = 0; n5 < n3; n5 += 2) {
                    int n6 = n5 + 1;
                    n4 = byArray[n5];
                    byArray[n5] = byArray[n6];
                    byArray[n6] = n4;
                }
            }
            this.byteBuf.write(byArray, 0, n3);
        }
        if (this.isPreGiop12()) {
            this.encoderStream.write_short((short)0);
        }
    }

    public void write_wstring(String string) {
        if (null == string) {
            throw new BAD_PARAM("Null Param (3) - wstring", 1229124099, CompletionStatus.COMPLETED_MAYBE);
        }
        if (this.writeMode == 1) {
            this.write_wstringInCDR(string);
            return;
        }
        CharToTcsConverter charToTcsConverter = this.getTcsWConverter();
        char[] cArray = charToTcsConverter.convertToChar(string.toCharArray(), this.littleEndian);
        boolean bl = charToTcsConverter.needToSwap(this.littleEndian);
        int n = cArray.length;
        int n2 = 0;
        n2 = this.isPreGiop12() ? n + 1 : n * 2;
        if (this.inBlock) {
            this.reserveAndWriteLongInvarint(n2);
        } else {
            this.write_longInVarint(n2);
        }
        int n3 = 0;
        boolean bl2 = false;
        byte[] byArray = ByteBuffer.ZERO_BYTE_ARRAY;
        for (int i = 0; i < n; i += n3) {
            char c;
            int n4 = this.byteBuf.getAvailableSpace();
            if (n4 == 0) {
                this.completeFragment(1, false);
                n3 = 0;
                continue;
            }
            if (n4 == 1) {
                c = cArray[i];
                if (bl) {
                    this.byteBuf.write((byte)(c & 0xFF));
                    this.completeFragment(1, false);
                    this.byteBuf.write((byte)(c >>> 8 & 0xFF));
                } else {
                    this.byteBuf.write((byte)(c >>> 8 & 0xFF));
                    this.completeFragment(1, false);
                    this.byteBuf.write((byte)(c & 0xFF));
                }
                n3 = 1;
                continue;
            }
            n3 = Math.min(n4 /= 2, n - i);
            for (int j = 0; j < n3; ++j) {
                c = cArray[i + j];
                if (bl) {
                    this.byteBuf.write((byte)(c & 0xFF));
                    this.byteBuf.write((byte)(c >>> 8 & 0xFF));
                    continue;
                }
                this.byteBuf.write((byte)(c >>> 8 & 0xFF));
                this.byteBuf.write((byte)(c & 0xFF));
            }
        }
        if (this.isPreGiop12()) {
            this.write_short((short)0);
        }
    }

    public void write_octet_array(byte[] byArray, int n, int n2) {
        this.write_octet_array(byArray, n, n2, true);
    }

    @Override
    public void write_octet_array(byte[] byArray, int n, int n2, boolean bl) {
        this.writeOctetArrayPiece(byArray, n, n2, true, n2);
    }

    @Override
    public final void writeOctetArrayPiece(byte[] byArray, int n, int n2, boolean bl, int n3) {
        if (byArray == null) {
            throw new BAD_PARAM("Null Param (4) - octet array", 1229124100, CompletionStatus.COMPLETED_MAYBE);
        }
        if (n2 > 0) {
            int n4;
            this.checkPadding();
            for (int i = 0; i < n2; i += n4) {
                n4 = this.alignAndReserve(1, n3 - i);
                n4 = Math.min(n4, n2 - i);
                this.byteBuf.write(byArray, n + i, n4);
            }
        }
    }

    @Override
    public int get_offset(boolean bl) {
        int n = this.initialOffset;
        if (this.byteBuf != null) {
            if (bl) {
                this.checkChunkStart();
            }
            n += this.byteBuf.getWriteOffset();
        }
        return n;
    }

    private CharToTcsConverter getTcsCConverter() {
        if (this.tcsCConverter == null) {
            int n = this.getTcsC();
            if (n == 0) {
                n = 65537;
            }
            this.tcsCConverter = CharToTcsConverter.getConverter(n);
            if (!this.tcsCConverter.isByteOriented()) {
                throw new INTERNAL("non-byte-oriented char code set specified", 1229125042, CompletionStatus.COMPLETED_NO);
            }
        }
        return this.tcsCConverter;
    }

    private CharToTcsConverter getTcsWConverter() {
        if (this.tcsWConverter == null) {
            int n = this.getTcsW();
            if (n == 0) {
                throw new INV_OBJREF("wchar code set support not specified", 1330446338, CompletionStatus.COMPLETED_NO);
            }
            this.tcsWConverter = CharToTcsConverter.getConverter(n);
            if (this.tcsWConverter.isByteOriented()) {
                throw new INTERNAL("byte-oriented wchar code set specified", 1229125044, CompletionStatus.COMPLETED_NO);
            }
        }
        return this.tcsWConverter;
    }

    public void write_char(char c) {
        CharToTcsConverter charToTcsConverter = this.getTcsCConverter();
        byte[] byArray = charToTcsConverter.convertToByte(new char[]{c});
        if (byArray.length > 1) {
            throw new DATA_CONVERSION("Character doesn't map to negotiated transmission char set - (char) single IDL char > 1 byte when encoded in TCS", 1330446337, CompletionStatus.COMPLETED_NO);
        }
        this.encoderStream.write_octet(byArray[0]);
    }

    public void write_char_array(char[] cArray, int n, int n2) {
        byte[] byArray;
        if (cArray == null) {
            throw new BAD_PARAM("Null Param (8) - char array", 1229124104, CompletionStatus.COMPLETED_MAYBE);
        }
        CharToTcsConverter charToTcsConverter = this.getTcsCConverter();
        if (n == 0 && n2 == cArray.length) {
            byArray = charToTcsConverter.convertToByte(cArray);
        } else {
            char[] cArray2 = new char[n2];
            System.arraycopy(cArray, n, cArray2, 0, n2);
            byArray = charToTcsConverter.convertToByte(cArray2);
        }
        if (byArray.length > n2) {
            throw new DATA_CONVERSION("Character doesn't map to negotiated transmission char set", 1330446337, CompletionStatus.COMPLETED_NO);
        }
        if (n2 > 0) {
            int n3;
            for (int i = 0; i < n2; i += n3) {
                n3 = this.alignAndReserve(1, n2 - i);
                this.byteBuf.write(byArray, i, n3);
            }
        }
    }

    public void write_wchar_array(char[] cArray, int n, int n2) {
        if (cArray == null) {
            throw new BAD_PARAM("Null Param (9) - wchar array", 1229124105, CompletionStatus.COMPLETED_MAYBE);
        }
        if (n2 > 0) {
            CharToTcsConverter charToTcsConverter = this.getTcsWConverter();
            boolean bl = charToTcsConverter.needToSwap(this.littleEndian);
            if (this.isPreGiop12()) {
                Object[] objectArray;
                char[] cArray2;
                if (n == 0 && cArray.length == n2) {
                    cArray2 = charToTcsConverter.convertToChar(cArray, this.littleEndian);
                } else {
                    objectArray = new char[n2];
                    System.arraycopy(cArray, n, objectArray, 0, n2);
                    cArray2 = charToTcsConverter.convertToChar((char[])objectArray, this.littleEndian);
                }
                if (cArray2.length > n2) {
                    throw new DATA_CONVERSION("Character doesn't map to negotiated transmission char set - wchar array", 1330446337, CompletionStatus.COMPLETED_NO);
                }
                objectArray = IDROutputStream.getByteShifts(2, bl);
                int n3 = n2;
                int n4 = 0;
                int n5 = 0;
                do {
                    n5 += this.alignAndReserve(2, (n3 - n4) * 2);
                    do {
                        this.byteBuf.write((byte)(cArray2[n4] >>> objectArray[0] & 0xFF));
                        this.byteBuf.write((byte)(cArray2[n4] >>> objectArray[1] & 0xFF));
                    } while (++n4 < n5);
                } while (n4 < n3);
            } else {
                int[] nArray = IDROutputStream.getByteShifts(2, bl);
                byte[] byArray = new byte[n2 * 3];
                int n6 = 0;
                for (int i = 0; i < n2; ++i) {
                    char[] cArray3 = charToTcsConverter.convertToChar(new char[]{cArray[n + i]}, this.littleEndian);
                    if (n6 + (cArray3.length * 2 + 1) > byArray.length) {
                        byte[] byArray2 = byArray;
                        byArray = new byte[byArray2.length * 2];
                        System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
                    }
                    byArray[n6++] = (byte)(cArray3.length * 2);
                    for (int j = 0; j < cArray3.length; ++j) {
                        byArray[n6++] = (byte)(cArray3[j] >>> nArray[0] & 0xFF);
                        byArray[n6++] = (byte)(cArray3[j] >>> nArray[1] & 0xFF);
                    }
                }
                this.encoderStream.write_octet_array(byArray, 0, n6);
            }
        }
    }

    @Override
    protected final boolean resetBufferData() {
        if (this.byteBuf != null) {
            this.initialOffset += this.byteBuf.getWriteOffset();
            this.byteBuf.reset();
            this.endFlagPosition = null;
            return true;
        }
        return false;
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        if (this.byteBuf != null) {
            this.byteBuf.flushTo(outputStream);
        }
    }

    @Override
    public void writeOctetSequenceTo(org.omg.CORBA.portable.OutputStream outputStream) {
        if (this.byteBuf != null) {
            this.byteBuf.flushTo(outputStream);
        }
    }

    @Override
    public int getSize() {
        int n = this.byteBuf == null ? 0 : this.byteBuf.getSize();
        return n;
    }

    @Override
    protected byte[] getBuffer() {
        return this.toByteArray();
    }

    @Override
    public ByteBuffer getByteBuffer() {
        return this.byteBuf;
    }

    @Override
    protected void setByteBuffer(ByteBuffer byteBuffer) {
        this.byteBuf = byteBuffer;
    }

    @Override
    protected byte[] convertStringToTcsBytes(String string) {
        CharToTcsConverter charToTcsConverter = this.getTcsCConverter();
        byte[] byArray = charToTcsConverter.convertToByte(string.toCharArray());
        byte[] byArray2 = new byte[byArray.length + 1];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byArray2[byArray2.length - 1] = 0;
        return byArray2;
    }

    protected final void writeEndTag(int n) {
    }

    public void writeSystemException(SystemException systemException) {
        Utility.writeSystemException(systemException, (org.omg.CORBA.portable.OutputStream)this.encoderStream);
    }

    @Override
    public void write_Abstract(Object object) {
        this.encoderStream.write_abstract_interface(object);
    }

    @Override
    public void write_Value(Serializable serializable) {
        this.encoderStream.write_value(serializable);
    }

    @Override
    public String[] _truncatable_ids() {
        return _ids;
    }

    @Override
    public final void printBuffer() {
        if (this.byteBuf != null) {
            System.out.println(this.byteBuf.toString());
        }
    }

    @Override
    public void setMode(byte by) {
        this.writeMode = by;
        if (Trc.enabled(2)) {
            Trc.info(Trc.FINEST, "setting write mode to " + (by == 1 ? "CDR" : "IDR"), CLASS, "setMode:1195");
        }
    }

    @Override
    protected final byte getMode() {
        if (Trc.enabled(2)) {
            Trc.info(Trc.FINEST, "getting the write mode: " + (this.writeMode == 1 ? "CDR" : "IDR"), CLASS, "getMode:1201");
        }
        return this.writeMode;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        NotSerializableException notSerializableException = new NotSerializableException(this.getClass().getName());
        Trc.ffdc(notSerializableException, CLASS, "writeObject:1210");
        throw notSerializableException;
    }
}

