/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.io;

import com.ibm.rmi.iiop.EncoderInputStream;
import com.ibm.rmi.iiop.EncoderOutputStream;
import com.ibm.rmi.io.ObjectSerializer;
import com.ibm.rmi.io.ObjectStreamClass;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.omg.CORBA.NO_IMPLEMENT;

public class LinkedHashMapSerializer
extends ObjectSerializer {
    private static final LinkedHashMapSerializer instance = new LinkedHashMapSerializer();
    private static final ObjectStreamClass lhmOSC = ObjectStreamClass.lookup(LinkedHashMap.class);
    private static final long fieldOffset = lhmOSC.getField("accessOrder").getReflectField().getFieldOffset();

    private LinkedHashMapSerializer() {
        this.vTag = (byte)79;
    }

    public static final LinkedHashMapSerializer getInstance() {
        return instance;
    }

    @Override
    public final Object write(EncoderOutputStream encoderOutputStream, Object object, ObjectStreamClass objectStreamClass) throws IOException {
        LinkedHashMap linkedHashMap = (LinkedHashMap)object;
        boolean bl = unsafe.getBoolean(linkedHashMap, fieldOffset);
        encoderOutputStream.write_longInVarint(linkedHashMap.size());
        encoderOutputStream.write_boolean(bl);
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            Object k = entry.getKey();
            Object v = entry.getValue();
            this.writeToLoop(encoderOutputStream, k);
            this.writeToLoop(encoderOutputStream, v);
        }
        return null;
    }

    @Override
    public final Object read(EncoderInputStream encoderInputStream, Object linkedHashMap, ObjectStreamClass objectStreamClass) throws IOException {
        int n = encoderInputStream.read_longInVarint();
        if (linkedHashMap == null) {
            linkedHashMap = new LinkedHashMap<Object, Object>();
            encoderInputStream.addToValueCache(linkedHashMap);
        }
        boolean bl = encoderInputStream.read_boolean();
        unsafe.putBoolean(linkedHashMap, fieldOffset, bl);
        LinkedHashMap<Object, Object> linkedHashMap2 = linkedHashMap;
        for (int i = 0; i < n; ++i) {
            Object object = this.readFromLoop(encoderInputStream);
            Object object2 = this.readFromLoop(encoderInputStream);
            linkedHashMap2.put(object, object2);
        }
        return linkedHashMap2;
    }

    @Override
    public final Object writeFields(EncoderOutputStream encoderOutputStream, Object object, ObjectStreamClass objectStreamClass) throws IOException {
        throw new NO_IMPLEMENT("Not implemented for " + this.getClass().getName() + "Serializer");
    }

    @Override
    public final Object readFields(EncoderInputStream encoderInputStream, Object object, ObjectStreamClass objectStreamClass) throws IOException {
        throw new NO_IMPLEMENT("Not implemented for " + this.getClass().getName() + "Serializer");
    }

    @Override
    public final Object writeReferenceFields(EncoderOutputStream encoderOutputStream, Object object, ObjectStreamClass objectStreamClass, int n) {
        throw new NO_IMPLEMENT("Not implemented for " + this.getClass().getName() + "Serializer");
    }

    @Override
    public final Object readReferenceFields(EncoderInputStream encoderInputStream, Object object, ObjectStreamClass objectStreamClass, int n) {
        throw new NO_IMPLEMENT("Not implemented for " + this.getClass().getName() + "Serializer");
    }

    @Override
    public final Object writeFn(EncoderOutputStream encoderOutputStream, Object object, ObjectStreamClass objectStreamClass) throws IOException {
        throw new NO_IMPLEMENT("Not implemented for " + this.getClass().getName() + "Serializer");
    }

    @Override
    public final Object readFn(EncoderInputStream encoderInputStream, Object object, ObjectStreamClass objectStreamClass) throws IOException {
        throw new NO_IMPLEMENT("Not implemented for " + this.getClass().getName() + "Serializer");
    }
}

