/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.javax.rmi.CORBA;

import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.corba.DisconnectedDelegate;
import com.ibm.rmi.util.Utility;
import com.ibm.rmi.util.Validator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.RemoteException;
import javax.rmi.CORBA.Stub;
import javax.rmi.CORBA.StubDelegate;
import javax.rmi.CORBA.Tie;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA_2_3.portable.ObjectImpl;
import org.omg.PortableServer.Servant;

public class StubDelegateImpl
implements StubDelegate {
    private static final String CLASS = StubDelegateImpl.class.getName();
    private transient int hashCode = 0;
    private transient int typeLength;
    private transient byte[] typeData;
    private transient int numProfiles = 0;
    private transient int[] profileTags;
    private transient byte[][] profileData;

    private void init(Stub stub) {
        if (this.numProfiles == 0) {
            try {
                OutputStream outputStream = stub._orb().create_output_stream();
                outputStream.write_Object((Object)stub);
                InputStream inputStream = outputStream.create_input_stream();
                this.typeLength = inputStream.read_long();
                this.typeData = new byte[this.typeLength];
                inputStream.read_octet_array(this.typeData, 0, this.typeLength);
                this.numProfiles = inputStream.read_long();
                this.profileTags = new int[this.numProfiles];
                this.profileData = new byte[this.numProfiles][];
                for (int i = 0; i < this.numProfiles; ++i) {
                    this.profileTags[i] = inputStream.read_long();
                    int n = inputStream.read_long();
                    this.profileData[i] = new byte[n];
                    inputStream.read_octet_array(this.profileData[i], 0, n);
                }
            }
            catch (BAD_OPERATION bAD_OPERATION) {
                Trc.ffdc(bAD_OPERATION, CLASS, "init:109");
            }
        }
    }

    public int hashCode(Stub stub) {
        if (Trc.enabled(1) || Trc.enabled(2)) {
            Trc.begin1(Trc.FINEST, stub == null ? null : stub.getClass(), CLASS, "hashCode:126");
        }
        this.init(stub);
        if (this.hashCode == 0) {
            int n;
            for (n = 0; n < this.typeLength; ++n) {
                this.hashCode = this.hashCode * 37 + this.typeData[n];
            }
            for (n = 0; n < this.numProfiles; ++n) {
                this.hashCode = this.hashCode * 37 + this.profileTags[n];
                for (int i = 0; i < this.profileData[n].length; ++i) {
                    this.hashCode = this.hashCode * 37 + this.profileData[n][i];
                }
            }
        }
        if (Trc.enabled(1) || Trc.enabled(2)) {
            Trc.complete(Trc.FINEST, "hashCode=" + this.hashCode, CLASS, "hashCode:145");
        }
        return this.hashCode;
    }

    public boolean equals(Stub stub, java.lang.Object object) {
        if (Trc.enabled(1) || Trc.enabled(2)) {
            Trc.begin2(Trc.FINEST, stub == null ? null : stub.getClass(), object == null ? null : object.getClass(), CLASS, "equals:162");
        }
        if (object == null) {
            return false;
        }
        this.init(stub);
        if (object instanceof StubDelegateImpl) {
            int n;
            StubDelegateImpl stubDelegateImpl = (StubDelegateImpl)object;
            if (this.hashCode != 0 && stubDelegateImpl.hashCode != 0 && this.hashCode != stubDelegateImpl.hashCode) {
                return false;
            }
            if (this.typeLength != stubDelegateImpl.typeLength) {
                return false;
            }
            for (n = 0; n < this.typeLength; ++n) {
                if (this.typeData[n] == stubDelegateImpl.typeData[n]) continue;
                return false;
            }
            if (this.numProfiles != stubDelegateImpl.numProfiles) {
                return false;
            }
            for (n = 0; n < this.numProfiles; ++n) {
                if (this.profileTags[n] != stubDelegateImpl.profileTags[n]) {
                    return false;
                }
                if (this.profileData[n].length != stubDelegateImpl.profileData[n].length) {
                    return false;
                }
                for (int i = 0; i < this.profileData[n].length; ++i) {
                    if (this.profileData[n][i] == stubDelegateImpl.profileData[n][i]) continue;
                    return false;
                }
            }
            return true;
        }
        return object.equals(this);
    }

    public String toString(Stub stub) {
        if (Trc.enabled(1) || Trc.enabled(2)) {
            Trc.begin1(Trc.FINEST, stub == null ? null : stub.getClass(), CLASS, "toString:220");
        }
        try {
            return stub._orb().object_to_string((Object)stub);
        }
        catch (BAD_OPERATION bAD_OPERATION) {
            Trc.ffdc(bAD_OPERATION, CLASS, "toString:228");
            return null;
        }
    }

    public void connect(Stub stub, ORB oRB) throws RemoteException {
        boolean bl;
        block24: {
            if (Trc.enabled(1) || Trc.enabled(2)) {
                Trc.begin2(Trc.FINEST, stub == null ? null : stub.getClass(), oRB == null ? null : oRB.getClass(), CLASS, "connect:249");
            }
            bl = false;
            try {
                Delegate delegate = stub._get_delegate();
                if (delegate instanceof DisconnectedDelegate) {
                    throw new BAD_OPERATION("The stub has been previously disconnected", 1229123999, CompletionStatus.COMPLETED_NO);
                }
                if (delegate.orb((Object)stub) != oRB) {
                    if (Trc.enabled()) {
                        Trc.warn("error - different orbs", CLASS, "connect:274");
                    }
                    bl = true;
                }
            }
            catch (BAD_OPERATION bAD_OPERATION) {
                if (Trc.enabled()) {
                    Trc.warn(bAD_OPERATION.toString(), CLASS, "connect:283");
                }
                if (this.numProfiles == 0) {
                    Tie tie = Utility.getAndForgetTie(stub);
                    if (tie == null) {
                        if (Trc.enabled()) {
                            Trc.warn("error - tie is null", CLASS, "connect:299");
                        }
                        bl = true;
                    }
                    try {
                        ORB oRB2 = tie.orb();
                        if (null == oRB2) {
                            throw new BAD_OPERATION("The tie has been previously disconnected", 1229124000, CompletionStatus.COMPLETED_NO);
                        }
                        if (oRB2 != oRB) {
                            if (Trc.enabled()) {
                                Trc.warn("error - tie connected to different orb", CLASS, "connect:323");
                            }
                            bl = true;
                        }
                    }
                    catch (BAD_OPERATION bAD_OPERATION2) {
                        if (Trc.enabled()) {
                            Trc.warn(bAD_OPERATION2.toString(), CLASS, "connect:332");
                        }
                        tie.orb(oRB);
                        stub._set_delegate(((ObjectImpl)tie)._get_delegate());
                        break block24;
                    }
                    catch (BAD_INV_ORDER bAD_INV_ORDER) {
                        if (tie instanceof Servant) {
                            if (Trc.enabled()) {
                                Trc.warn("Caught BAD_INV_ORDER,  treating tie as Servant (See OMG issue 2514)", CLASS, "connect:347");
                            }
                            Servant servant = (Servant)tie;
                            servant._this_object(oRB);
                            stub._set_delegate(((ObjectImpl)servant._this_object())._get_delegate());
                            break block24;
                        }
                        throw bAD_INV_ORDER;
                    }
                }
                try {
                    OutputStream outputStream = oRB.create_output_stream();
                    outputStream.write_long(this.typeLength);
                    outputStream.write_octet_array(this.typeData, 0, this.typeLength);
                    outputStream.write_long(this.numProfiles);
                    for (int i = 0; i < this.numProfiles; ++i) {
                        outputStream.write_long(this.profileTags[i]);
                        outputStream.write_long(this.profileData[i].length);
                        outputStream.write_octet_array(this.profileData[i], 0, this.profileData[i].length);
                    }
                    ObjectImpl objectImpl = (ObjectImpl)outputStream.create_input_stream().read_Object();
                    stub._set_delegate(objectImpl._get_delegate());
                }
                catch (Exception exception) {
                    Trc.ffdc(exception, CLASS, "connect:386");
                    bl = true;
                }
            }
        }
        if (bl) {
            throw new RemoteException("CORBA BAD_OPERATION 0 connecting " + stub == null ? "<null>" : stub.getClass().getName());
        }
        if (Trc.enabled(1) || Trc.enabled(2)) {
            Trc.complete(Trc.FINEST, CLASS, "connect:398");
        }
    }

    public void readObject(Stub stub, ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (Trc.enabled(1) || Trc.enabled(2)) {
            Trc.begin2(Trc.FINEST, stub == null ? null : stub.getClass(), objectInputStream == null ? null : objectInputStream.getClass(), CLASS, "readObject:410");
        }
        this.typeLength = objectInputStream.readInt();
        this.typeData = new byte[this.typeLength];
        objectInputStream.readFully(this.typeData);
        this.numProfiles = objectInputStream.readInt();
        this.profileTags = new int[this.numProfiles];
        this.profileData = new byte[this.numProfiles][];
        for (int i = 0; i < this.numProfiles; ++i) {
            this.profileTags[i] = objectInputStream.readInt();
            int n = objectInputStream.readInt();
            boolean bl = Validator.isValidPostiveInteger(n);
            if (!bl) {
                throw new IOException("Invalid ProfileData length " + n);
            }
            this.profileData[i] = new byte[n];
            objectInputStream.readFully(this.profileData[i]);
        }
        if (Trc.enabled(1) || Trc.enabled(2)) {
            Trc.complete(Trc.FINEST, CLASS, "readObject:431");
        }
    }

    public void writeObject(Stub stub, ObjectOutputStream objectOutputStream) throws IOException {
        if (Trc.enabled(1) || Trc.enabled(2)) {
            Trc.begin2(Trc.FINEST, stub == null ? null : stub.getClass(), objectOutputStream == null ? null : objectOutputStream.getClass(), CLASS, "writeObject:447");
        }
        this.init(stub);
        objectOutputStream.writeInt(this.typeLength);
        objectOutputStream.write(this.typeData);
        objectOutputStream.writeInt(this.numProfiles);
        for (int i = 0; i < this.numProfiles; ++i) {
            objectOutputStream.writeInt(this.profileTags[i]);
            objectOutputStream.writeInt(this.profileData[i].length);
            objectOutputStream.write(this.profileData[i]);
        }
        if (Trc.enabled(1) || Trc.enabled(2)) {
            Trc.complete(Trc.FINEST, CLASS, "writeObject:462");
        }
    }
}

