/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.transport;

import com.ibm.CORBA.iiop.ORBConnection;
import com.ibm.CORBA.ras.Trc;
import com.ibm.CORBA.transport.ConnectionKey;
import com.ibm.CORBA.transport.ConnectionTable;
import com.ibm.CORBA.transport.Transport;
import com.ibm.rmi.iiop.Connection;
import com.ibm.rmi.iiop.ORB;
import com.ibm.rmi.util.LimitedMultiMap;
import com.ibm.rmi.util.ListInterface;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;

public class ConnectionTableImpl
implements ConnectionTable {
    private static final String CLASS = ConnectionTableImpl.class.getName();
    private final int lowWaterMark;
    private final int highWaterMark;
    private final LimitedMultiMap multimap;
    private ORB orb;
    private static final int NCLEAN = 5;

    public ConnectionTableImpl(ORB oRB, Transport transport) {
        this.orb = oRB;
        this.highWaterMark = oRB.getHighWaterMark();
        this.lowWaterMark = oRB.getLowWaterMark();
        int n = oRB.getConnectionMultiplicity();
        this.multimap = new LimitedMultiMap(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (Trc.enabled(3)) {
            Trc.begin(Trc.FINEST, CLASS, "shutdown:110");
        }
        while (true) {
            ConnectionTableImpl connectionTableImpl = this;
            synchronized (connectionTableImpl) {
                this.multimap.performScheduledRemovals();
                Iterator iterator = this.multimap.valueIterator();
                while (iterator.hasNext()) {
                    ORBConnection oRBConnection = (ORBConnection)iterator.next();
                    if (oRBConnection.isBusy()) continue;
                    try {
                        oRBConnection.cleanUp();
                    }
                    catch (Exception exception) {
                        Trc.fail(exception, Trc.stackTrace(exception), CLASS, "shutdown:123");
                    }
                    iterator.remove();
                }
                if (this.multimap.isEmpty()) {
                    this.multimap.performScheduledRemovals();
                    break;
                }
            }
            Thread.yield();
        }
        if (Trc.enabled(3)) {
            Trc.complete(Trc.FINEST, CLASS, "shutdown:142");
        }
    }

    private boolean cleanUpConnection(ORBConnection oRBConnection) {
        if (Trc.enabled(3)) {
            Trc.info(Trc.FINEST, "Cleaning up: ", oRBConnection, CLASS, "cleanUpConnection:152");
        }
        try {
            oRBConnection.cleanUp();
            return true;
        }
        catch (Exception exception) {
            Trc.ffdc(exception, CLASS, "cleanUpConnection:157");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cleanUp() {
        int n;
        boolean bl;
        int n2;
        int n3;
        int n4 = this.orb.getState();
        if (n4 != 1 && n4 != 2) {
            this.shutdown();
            return true;
        }
        if (Trc.enabled(3)) {
            Trc.begin1(Trc.FINEST, "lowWaterMark=" + this.lowWaterMark + ", highWaterMark=" + this.highWaterMark, CLASS, "cleanUp:181");
        }
        ConnectionTableImpl connectionTableImpl = this;
        synchronized (connectionTableImpl) {
            n2 = n3 = this.multimap.size();
            bl = this.multimap.performScheduledRemovals();
            n = this.multimap.size();
            n2 -= n;
            if (this.multimap.size() > this.lowWaterMark) {
                this.removeStaleConnections();
                bl = true;
            }
            n -= this.multimap.size();
        }
        if (Trc.enabled(3)) {
            Trc.complete(Trc.FINEST, "size was " + n3 + ", removed: " + n2 + ", cleaned: " + n, CLASS, "cleanUp:198");
        }
        return bl;
    }

    private void removeStaleConnections() {
        ORBConnection oRBConnection2;
        ConnectionKey connectionKey;
        Object[] objectArray = new ORBConnection[5];
        Object[] objectArray2 = new ConnectionKey[5];
        Iterator iterator = this.multimap.keyIterator();
        while (iterator.hasNext()) {
            connectionKey = (ConnectionKey)iterator.next();
            for (ORBConnection oRBConnection2 : this.multimap.get(connectionKey)) {
                Comparator comparator;
                int n;
                if (oRBConnection2.isBusy() || (n = Arrays.binarySearch(objectArray, oRBConnection2, comparator = ORBConnection.MOST_STALE_FIRST)) >= 0 || (n = -n - 1) >= 5) continue;
                ConnectionTableImpl.insert(oRBConnection2, objectArray, n);
                ConnectionTableImpl.insert(connectionKey, objectArray2, n);
            }
        }
        for (int i = 0; i < 5 && (oRBConnection2 = objectArray[i]) != null; ++i) {
            if (!oRBConnection2.checkAndGrab()) continue;
            oRBConnection2.getFreeList().remove(oRBConnection2);
            connectionKey = objectArray2[i];
            boolean bl = this.cleanUpConnection(objectArray[i]);
            if (!bl) continue;
            this.multimap.remove(connectionKey, oRBConnection2);
        }
    }

    private static final void insert(Object object, Object[] objectArray, int n) {
        int n2 = n + 1;
        System.arraycopy(objectArray, n, objectArray, n2, objectArray.length - n2);
        objectArray[n] = object;
    }

    @Override
    public void checkConnectionTable() {
        if (this.multimap.size() > this.highWaterMark) {
            this.cleanUp();
        }
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append(" size=").append(this.multimap.size());
        Iterator iterator = this.multimap.valueIterator();
        while (iterator.hasNext()) {
            stringBuffer.append("\n").append(iterator.next());
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnection(ConnectionKey connectionKey, ORBConnection oRBConnection) {
        LimitedMultiMap.Handle handle;
        if (!oRBConnection.isServer() && this.multimap.multiplicity != 1) {
            oRBConnection.incrementUseCount();
        }
        if (Trc.enabled(3)) {
            Trc.begin2(Trc.FINE, connectionKey, oRBConnection, CLASS, "addConnection:306");
        }
        ConnectionTableImpl connectionTableImpl = this;
        synchronized (connectionTableImpl) {
            this.multimap.performScheduledRemovals();
            handle = this.multimap.put(connectionKey, oRBConnection);
        }
        oRBConnection.setRemoveToken(handle.getToken());
        oRBConnection.setFreeList(handle.getFreeList());
        if (Trc.enabled(3)) {
            Trc.complete(Trc.FINE, "size=" + this.multimap.size(), CLASS, "addConnection:317");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConnection(ConnectionKey connectionKey) {
        if (Trc.enabled(3)) {
            Trc.begin1(Trc.FINEST, connectionKey, CLASS, "removeConnection(key):327");
        }
        if (this.multimap.multiplicity != 1) {
            throw new UnsupportedOperationException("The WAS pluggable transport does not support multiple connections");
        }
        ConnectionTableImpl connectionTableImpl = this;
        synchronized (connectionTableImpl) {
            Iterator iterator = this.multimap.get(connectionKey).iterator();
            if (iterator.hasNext()) {
                this.multimap.scheduleRemoval(connectionKey, iterator.next());
            }
        }
        if (Trc.enabled(3)) {
            Trc.complete(Trc.FINEST, "size=" + this.multimap.size(), CLASS, "removeConnection(key):340");
        }
    }

    @Override
    public void removeConnection(ORBConnection oRBConnection) {
        LimitedMultiMap.RemoveToken removeToken;
        if (Trc.enabled(3)) {
            Trc.begin1(Trc.FINEST, oRBConnection, CLASS, "removeConnection:352");
        }
        if ((removeToken = (LimitedMultiMap.RemoveToken)oRBConnection.getRemoveToken()) != null) {
            this.multimap.scheduleRemoval(removeToken);
        }
        if (Trc.enabled(3)) {
            Trc.complete(Trc.FINEST, "size=" + this.multimap.size(), CLASS, "removeConnection:360");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ORBConnection getConnection(ConnectionKey connectionKey) {
        int n;
        Collection collection;
        if (Trc.enabled(3)) {
            Trc.begin1(Trc.FINE, connectionKey, CLASS, "getConnection:367");
        }
        ORBConnection oRBConnection = null;
        int n2 = Integer.MAX_VALUE;
        ORBConnection oRBConnection2 = null;
        long l = Long.MAX_VALUE;
        Collection collection2 = null;
        Object object = this;
        synchronized (object) {
            this.multimap.performScheduledRemovals();
            collection = this.multimap.get(connectionKey);
            if (this.multimap.multiplicity == 1) {
                Iterator iterator = collection.iterator();
                if (iterator.hasNext()) {
                    oRBConnection = (ORBConnection)iterator.next();
                    if (Trc.enabled(3)) {
                        Trc.complete(Trc.FINE, this, oRBConnection, CLASS, "getConnection:386");
                    }
                    return oRBConnection;
                }
                return null;
            }
        }
        collection2 = ((ListInterface)((Object)collection)).getFreeList();
        if (null != collection2) {
            object = collection2.iterator();
            while (object.hasNext()) {
                ORBConnection oRBConnection3 = (ORBConnection)object.next();
                if (!oRBConnection3.checkAndGrab()) continue;
                oRBConnection3.incrementUseCount();
                object.remove();
                if (Trc.enabled(3)) {
                    Trc.complete(Trc.FINE, this, oRBConnection3, CLASS, "getConnection:404");
                }
                return oRBConnection3;
            }
        }
        object = this;
        synchronized (object) {
            n = collection.size();
            for (ORBConnection oRBConnection4 : collection) {
                int n3 = oRBConnection4.getUsage();
                if (n3 == 0) {
                    oRBConnection = oRBConnection4;
                    break;
                }
                if (n3 >= n2) continue;
                n2 = n3;
                oRBConnection2 = oRBConnection4;
            }
            if (oRBConnection == null && n == this.multimap.multiplicity) {
                oRBConnection = oRBConnection2;
            }
            if (null != oRBConnection) {
                oRBConnection.incrementUseCount();
            }
        }
        if (Trc.enabled(3)) {
            Trc.info(Trc.FINE, "number of connections = " + n, CLASS, "getConnection:435");
            Trc.complete(Trc.FINE, oRBConnection, CLASS, "getConnection:436");
        }
        return oRBConnection;
    }

    protected void setHook(LimitedMultiMap.Hook hook) {
        this.multimap.setHook(hook);
    }

    LimitedMultiMap getMultiMap() {
        return this.multimap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionsStuckInWrite() {
        ConnectionTableImpl connectionTableImpl = this;
        synchronized (connectionTableImpl) {
            Iterator iterator = this.multimap.keyIterator();
            while (iterator.hasNext()) {
                ConnectionKey connectionKey = (ConnectionKey)iterator.next();
                for (Connection connection : this.multimap.get(connectionKey)) {
                    if (!connection.inWriteBlock) continue;
                    if (connection.stuckInWriteBlock) {
                        if (Trc.enabled(3)) {
                            Trc.info(Trc.FINEST, connection, CLASS, "removeConnectionsStuckInWrite:474");
                        }
                        connection.writeTimeoutOccured = true;
                        connection.purge_calls();
                        continue;
                    }
                    connection.stuckInWriteBlock = true;
                }
            }
        }
    }
}

