/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.util;

import com.ibm.CORBA.ras.Trc;
import com.ibm.jtc.orb.map.Cache;
import com.ibm.jtc.orb.map.CacheFactories;
import com.ibm.jtc.orb.map.ConcurrentCache;
import com.ibm.jtc.orb.map.MapFactories;
import com.ibm.jtc.orb.map.ObjectFactory;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.rmi.server.RMIClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;

public final class ClassCache
implements Cache {
    private static final ClassCache INSTANCE = new ClassCache();
    private static final Object MISS = CacheMiss.INSTANCE;
    private static final String CLASS = ClassCache.class.getName();
    private static final ReferenceQueue queue = new ReferenceQueue();
    private final ConcurrentCache nullCache = PlainCacheFactory.INSTANCE.create();
    private final ConcurrentCache cacheCache = CacheFactories.CONCURRENT_SOFT.create(MapFactories.CONCURRENT_HASH, PlainCacheFactory.INSTANCE);

    private void clearQueue() {
        ClassCacheKey classCacheKey = (ClassCacheKey)queue.poll();
        while (null != classCacheKey) {
            this.cacheCache.remove(classCacheKey);
            classCacheKey = (ClassCacheKey)queue.poll();
        }
    }

    private static void checkAccess(String string) {
        int n;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (n = string.lastIndexOf(46)) != -1) {
            securityManager.checkPackageAccess(string.substring(0, n));
        }
    }

    public static Class get(String string, ClassLoader classLoader) {
        if (classLoader == null) {
            ClassCache.checkAccess(string);
        }
        return INSTANCE.getClass(string, classLoader);
    }

    static Class _get(String string, ClassLoader classLoader) {
        return INSTANCE.getClass(string, classLoader);
    }

    public static Class get(String string, String string2) {
        ClassCache.checkAccess(string);
        return INSTANCE.getClass(string, string2);
    }

    private ClassCache() {
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object get(Object object) {
        Object[] objectArray = (Object[])object;
        if (objectArray[1] instanceof String) {
            return this.getClass((String)objectArray[0], (String)objectArray[1]);
        }
        return this.getClass((String)objectArray[0], (ClassLoader)objectArray[1]);
    }

    @Override
    public boolean isEmpty() {
        return this.cacheCache.isEmpty() && this.nullCache.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Class getClass(String string, ClassLoader classLoader) {
        ConcurrentCache concurrentCache = this.getLoaderCache(classLoader);
        Object object = concurrentCache.get(string);
        if (object instanceof Cache.FutureEntry) {
            Cache.FutureEntry futureEntry;
            Cache.FutureEntry futureEntry2 = futureEntry = (Cache.FutureEntry)object;
            synchronized (futureEntry2) {
                object = futureEntry.get();
                if (null == object) {
                    object = futureEntry.get(this.loadClass(string, classLoader));
                    if (null != classLoader) {
                        if (MISS == object) {
                            this.addMiss(string, classLoader.getParent());
                        } else {
                            ClassLoader classLoader2 = ((Class)object).getClassLoader();
                            if (classLoader2 != classLoader) {
                                this.addHit(string, object, classLoader2, classLoader.getParent());
                            }
                        }
                    }
                }
            }
        }
        if (MISS == object) {
            object = null;
        }
        return (Class)object;
    }

    final Class getClass(final String string, final String string2) {
        Object var4_3 = null;
        Class clazz = (Class)AccessController.doPrivileged(new PrivilegedAction(){
            Class cl = null;

            public Object run() {
                block4: {
                    try {
                        this.cl = RMIClassLoader.loadClass(string2, string);
                    }
                    catch (MalformedURLException malformedURLException) {
                        Trc.ffdc(malformedURLException, CLASS, "getClass:205");
                    }
                    catch (NullPointerException nullPointerException) {
                        Trc.ffdc(nullPointerException, CLASS, "getClass:207");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (!Trc.enabled(4)) break block4;
                        Trc.info(Trc.FINEST, CLASS, "ClassNotFoundException in RMIClassLoader.loadClass");
                    }
                }
                return this.cl;
            }
        });
        return clazz;
    }

    private Object loadClass(String string, ClassLoader classLoader) {
        Class<?> clazz = MISS;
        try {
            clazz = Class.forName(string, false, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NullPointerException nullPointerException) {
            if (Trc.enabled(4)) {
                Trc.info(Trc.FINEST, string, "cannot be found", CLASS, "loadClass:232");
            }
        }
        catch (LinkageError linkageError) {
            String string2 = linkageError.toString();
            Trc.ffdc(string2, CLASS, "loadClass:236");
        }
        return clazz;
    }

    private ConcurrentCache getLoaderCache(ClassLoader classLoader) {
        return null == classLoader ? this.nullCache : (ConcurrentCache)this.cacheCache.get(new ClassCacheKey(classLoader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMiss(String string, ClassLoader classLoader) {
        ConcurrentCache concurrentCache = this.getLoaderCache(classLoader);
        Object object = concurrentCache.get(string);
        if (object instanceof Cache.FutureEntry) {
            Cache.FutureEntry futureEntry;
            Cache.FutureEntry futureEntry2 = futureEntry = (Cache.FutureEntry)object;
            synchronized (futureEntry2) {
                object = futureEntry.get();
                if (null == object) {
                    object = futureEntry.get(MISS);
                    if (null != classLoader) {
                        this.addMiss(string, classLoader.getParent());
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHit(String string, Object object, ClassLoader classLoader, ClassLoader classLoader2) {
        ConcurrentCache concurrentCache = this.getLoaderCache(classLoader2);
        Object object2 = concurrentCache.get(string);
        if (object2 instanceof Cache.FutureEntry) {
            Cache.FutureEntry futureEntry;
            Cache.FutureEntry futureEntry2 = futureEntry = (Cache.FutureEntry)object2;
            synchronized (futureEntry2) {
                object2 = futureEntry.get();
                if (null == object2) {
                    object2 = futureEntry.get(object);
                    if (classLoader != classLoader2 && null != classLoader2) {
                        this.addHit(string, object, classLoader, classLoader2.getParent());
                    }
                }
            }
        }
    }

    private static final class PlainCacheFactory
    implements ObjectFactory {
        public static final PlainCacheFactory INSTANCE = new PlainCacheFactory();

        private PlainCacheFactory() {
        }

        @Override
        public final ConcurrentCache create() {
            return CacheFactories.CONCURRENT_PLAIN.create(MapFactories.CONCURRENT_HASH);
        }
    }

    private static final class ClassCacheKey
    extends WeakReference {
        private final String classLoaderName;
        private int hashCode;

        ClassCacheKey(ClassLoader classLoader) {
            super(classLoader, queue);
            this.classLoaderName = classLoader.getClass().getName();
            this.hashCode = System.identityHashCode(classLoader) + this.classLoaderName.hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            ClassLoader classLoader = (ClassLoader)this.get();
            ClassLoader classLoader2 = (ClassLoader)((ClassCacheKey)object).get();
            return classLoader != null && classLoader2 != null && classLoader == classLoader2;
        }
    }

    private static final class CacheMiss {
        static final Object INSTANCE = new CacheMiss();

        private CacheMiss() {
        }
    }
}

