/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.util;

import com.ibm.rmi.util.IdentityHashtableEntry;
import com.ibm.rmi.util.IdentityHashtableEnumerator;
import java.util.Dictionary;
import java.util.Enumeration;

public final class IdentityHashtable
extends Dictionary {
    private transient IdentityHashtableEntry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;
    protected Thread ownerThread = null;
    private int counter = 0;

    public IdentityHashtable(int n, float f) {
        if (n <= 0 || (double)f <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = f;
        this.table = new IdentityHashtableEntry[n];
        this.threshold = (int)((float)n * f);
    }

    public IdentityHashtable(int n) {
        this(n, 0.75f);
    }

    public IdentityHashtable() {
        this(101, 0.75f);
    }

    public synchronized void lock() {
        while (!this.acquire()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private synchronized boolean acquire() {
        Thread thread = Thread.currentThread();
        if (this.ownerThread == null) {
            this.ownerThread = thread;
            this.counter = 1;
            return true;
        }
        if (this.ownerThread == thread) {
            ++this.counter;
            return true;
        }
        return false;
    }

    public synchronized void unlock() {
        Thread thread = Thread.currentThread();
        if (this.ownerThread == thread) {
            --this.counter;
            if (this.counter == 0) {
                this.ownerThread = null;
                this.notify();
            }
        }
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    public Enumeration keys() {
        return new IdentityHashtableEnumerator(this.table, true);
    }

    public Enumeration elements() {
        return new IdentityHashtableEnumerator(this.table, false);
    }

    public boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        IdentityHashtableEntry[] identityHashtableEntryArray = this.table;
        int n = identityHashtableEntryArray.length;
        while (n-- > 0) {
            IdentityHashtableEntry identityHashtableEntry = identityHashtableEntryArray[n];
            while (identityHashtableEntry != null) {
                if (identityHashtableEntry.value == object) {
                    return true;
                }
                identityHashtableEntry = identityHashtableEntry.next;
            }
        }
        return false;
    }

    public boolean containsKey(Object object) {
        IdentityHashtableEntry[] identityHashtableEntryArray = this.table;
        int n = System.identityHashCode(object);
        int n2 = (n & Integer.MAX_VALUE) % identityHashtableEntryArray.length;
        IdentityHashtableEntry identityHashtableEntry = identityHashtableEntryArray[n2];
        while (identityHashtableEntry != null) {
            if (identityHashtableEntry.hash == n && identityHashtableEntry.key == object) {
                return true;
            }
            identityHashtableEntry = identityHashtableEntry.next;
        }
        return false;
    }

    public Object get(Object object) {
        IdentityHashtableEntry[] identityHashtableEntryArray = this.table;
        int n = System.identityHashCode(object);
        int n2 = (n & Integer.MAX_VALUE) % identityHashtableEntryArray.length;
        IdentityHashtableEntry identityHashtableEntry = identityHashtableEntryArray[n2];
        while (identityHashtableEntry != null) {
            if (identityHashtableEntry.hash == n && identityHashtableEntry.key == object) {
                return identityHashtableEntry.value;
            }
            identityHashtableEntry = identityHashtableEntry.next;
        }
        return null;
    }

    protected void rehash() {
        int n = this.table.length;
        IdentityHashtableEntry[] identityHashtableEntryArray = this.table;
        int n2 = n * 2 + 1;
        IdentityHashtableEntry[] identityHashtableEntryArray2 = new IdentityHashtableEntry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = identityHashtableEntryArray2;
        int n3 = n;
        while (n3-- > 0) {
            IdentityHashtableEntry identityHashtableEntry = identityHashtableEntryArray[n3];
            while (identityHashtableEntry != null) {
                IdentityHashtableEntry identityHashtableEntry2 = identityHashtableEntry;
                identityHashtableEntry = identityHashtableEntry.next;
                int n4 = (identityHashtableEntry2.hash & Integer.MAX_VALUE) % n2;
                identityHashtableEntry2.next = identityHashtableEntryArray2[n4];
                identityHashtableEntryArray2[n4] = identityHashtableEntry2;
            }
        }
    }

    public Object put(Object object, Object object2) {
        if (object2 == null) {
            throw new NullPointerException();
        }
        IdentityHashtableEntry[] identityHashtableEntryArray = this.table;
        int n = System.identityHashCode(object);
        int n2 = (n & Integer.MAX_VALUE) % identityHashtableEntryArray.length;
        IdentityHashtableEntry identityHashtableEntry = identityHashtableEntryArray[n2];
        while (identityHashtableEntry != null) {
            if (identityHashtableEntry.hash == n && identityHashtableEntry.key == object) {
                Object object3 = identityHashtableEntry.value;
                identityHashtableEntry.value = object2;
                return object3;
            }
            identityHashtableEntry = identityHashtableEntry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(object, object2);
        }
        identityHashtableEntryArray[n2] = identityHashtableEntry = new IdentityHashtableEntry(n, object, object2, identityHashtableEntryArray[n2]);
        ++this.count;
        return null;
    }

    public Object remove(Object object) {
        IdentityHashtableEntry[] identityHashtableEntryArray = this.table;
        int n = System.identityHashCode(object);
        int n2 = (n & Integer.MAX_VALUE) % identityHashtableEntryArray.length;
        IdentityHashtableEntry identityHashtableEntry = identityHashtableEntryArray[n2];
        IdentityHashtableEntry identityHashtableEntry2 = null;
        while (identityHashtableEntry != null) {
            if (identityHashtableEntry.hash == n && identityHashtableEntry.key == object) {
                if (identityHashtableEntry2 != null) {
                    identityHashtableEntry2.next = identityHashtableEntry.next;
                } else {
                    identityHashtableEntryArray[n2] = identityHashtableEntry.next;
                }
                --this.count;
                Object object2 = identityHashtableEntry.value;
                identityHashtableEntry.key = null;
                identityHashtableEntry.value = null;
                return object2;
            }
            identityHashtableEntry2 = identityHashtableEntry;
            identityHashtableEntry = identityHashtableEntry.next;
        }
        return null;
    }

    public void clear() {
        IdentityHashtableEntry[] identityHashtableEntryArray = this.table;
        int n = identityHashtableEntryArray.length;
        while (--n >= 0) {
            IdentityHashtableEntry identityHashtableEntry = identityHashtableEntryArray[n];
            while (identityHashtableEntry != null) {
                IdentityHashtableEntry identityHashtableEntry2 = identityHashtableEntry.next;
                identityHashtableEntry.hash = 0;
                identityHashtableEntry.key = null;
                identityHashtableEntry.value = null;
                identityHashtableEntry.next = null;
                identityHashtableEntry = identityHashtableEntry2;
            }
            identityHashtableEntryArray[n] = null;
        }
        this.count = 0;
    }

    public String toString() {
        int n = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.keys();
        Enumeration enumeration2 = this.elements();
        stringBuffer.append("{");
        for (int i = 0; i <= n; ++i) {
            String string = enumeration.nextElement().toString();
            String string2 = enumeration2.nextElement().toString();
            stringBuffer.append(string + "=" + string2);
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

