/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.util;

import com.ibm.CORBA.iiop.PartnerVersion;
import com.ibm.CORBA.ras.Trc;
import com.ibm.jtc.orb.map.Cache;
import com.ibm.jtc.orb.map.CacheFactories;
import com.ibm.jtc.orb.map.ConcurrentCache;
import com.ibm.jtc.orb.map.MapFactories;
import com.ibm.rmi.io.ObjectStreamClass;
import com.ibm.rmi.util.IdentityHashtable;
import com.ibm.rmi.util.JDKBridge;
import com.ibm.rmi.util.PartnerVersionUtil;
import com.ibm.rmi.util.Utility;
import com.ibm.rmi.util.Version;
import java.io.Externalizable;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.rmi.CORBA.ClassDesc;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.ValueBase;

public class RepositoryId {
    private static final String CLASS = RepositoryId.class.getName();
    private static final int[] charConversion = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private static final String IDL_IDENTIFIER_CHARS = ".0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ\\_abcdefghijklmnopqrstuvwxyz";
    private static final boolean[] IS_VALID_IDL_IDENTIFIER_CHAR = new boolean[128];
    private static final Pattern UNICODE_ESCAPES_WITHOUT_DOLLAR;
    private static final long serialVersionUID = 123456789L;
    private static final String defaultServerURL;
    private static final ConcurrentCache CLASS_IDL_TO_REP_STR_CACHE;
    private static IdentityHashtable repStrToByteArray;
    private static final Cache REP_STR_TO_CLASS_CACHE;
    private String repId = null;
    private boolean isSupportedFormat = true;
    private String typeString = null;
    private String versionString = null;
    private boolean isSequence = false;
    private boolean isRMIValueType = false;
    private boolean isIDLType = false;
    private boolean isProxy = false;
    private String completeClassName = null;
    private volatile String unqualifiedName = null;
    private volatile String definedInId = null;
    private WriteLock writeLock = new WriteLock();
    private Class clazz = null;
    private String suid = null;
    private String rmiHashCode = null;
    public static final byte IDR_STRING = 112;
    public static final byte IDR_NULL = 113;
    public static final byte IDR_OBJECT = 114;
    public static final byte IDR_ARRAY = 115;
    public static final byte IDR_IDL = 116;
    public static final byte IDR_ANY = 117;
    public static final byte IDR_CLASS = 118;
    public static final byte IDR_CORBA = 119;
    public static final byte IDR_BLOCKDATA = 120;
    public static final byte IDR_ENDBLOCKDATA = 121;
    public static final byte IDR_INDIRECTION = -1;
    public static final byte IDR_BYTE = 64;
    public static final byte IDR_SHORT = 65;
    public static final byte IDR_CHARACTER = 66;
    public static final byte IDR_INTEGER = 67;
    public static final byte IDR_FLOAT = 68;
    public static final byte IDR_DOUBLE = 69;
    public static final byte IDR_LONG = 70;
    public static final byte IDR_ARRAYLIST = 71;
    public static final byte IDR_VECTOR = 72;
    public static final byte IDR_HASHMAP = 73;
    public static final byte IDR_DATE = 74;
    public static final byte IDR_GREGORIANCALENDAR = 75;
    public static final byte IDR_STACK = 76;
    public static final byte IDR_HASHSET = 77;
    public static final byte IDR_LINKEDLIST = 78;
    public static final byte IDR_LINKEDHASHMAP = 79;
    public static final byte IDR_BIGINTEGER = 80;
    public static final byte IDR_BIGDECIMAL = 81;
    public static final byte IDR_ENUM = 82;
    public static final byte IDR_IDENTITYHASHMAP = 83;
    public static final byte IDR_HASHTABLE = 84;
    public static final byte IDR_TREEMAP = 85;
    public static final byte IDR_LINKEDHASHSET = 86;
    public static final byte IDR_TREESET = 87;
    public static final byte IDR_LOCALE = 88;
    public static final byte IDR_BOOLEAN = 89;
    public static final byte IDR_TIMEZONE = 90;
    public static final byte IDR_BYTEARRAY = 91;
    public static final byte IDR_PREVIOUS = 48;
    public static final byte IDR_CHARARRAY = 92;
    public static final byte IDR_DOUBLEARRAY = 93;
    public static final byte IDR_FLOATARRAY = 94;
    public static final byte IDR_INTARRAY = 95;
    public static final byte IDR_BOOLARRAY = 96;
    public static final byte IDR_JLBYTEARRAY = 97;
    public static final byte IDR_JLCHARARRAY = 98;
    public static final byte IDR_JLDOUBLEARRAY = 99;
    public static final byte IDR_JLFLOATARRAY = 100;
    public static final byte IDR_JLBOOLEANARRAY = 101;
    public static final byte IDR_JLLONGARRAY = 102;
    public static final byte IDR_JLSHORTARRAY = 103;
    public static final byte IDR_LONGARRAY = 104;
    public static final byte IDR_SHORTARRAY = 105;
    public static final byte IDR_STRINGARRAY = 106;
    public static final byte IDR_JLINTARRAY = 107;
    public static final byte IDR_RANDOM = 108;
    public static final byte IDR_RANDOMARRAY = 109;
    public static final byte IDR_VALUETYPE = 110;
    public static final byte IDR_ABSTRACT_INTERFACE = 111;
    public static final byte IDR_SIMPLEPKDOBJ = -128;
    public static final byte IDR_MIXEDPKDOBJ = -127;
    public static final byte IDR_OBJECTARRAY = -126;
    public static final byte IDR_2DOBJECTARRAY = -125;
    private static final String kSequenceKeyword = "seq";
    private static final String kValuePrefix = "RMI:";
    public static final String kSimplePackedObjectPrefix = "SPO:2.0";
    public static final String kMixedPackedObjectPrefix = "MPO:2.0";
    private static final String kIDLPrefix = "IDL:";
    private static final String kIDLNamePrefix = "omg.org/";
    private static final String kIDLClassnamePrefix = "org.omg.";
    private static final String kSequencePrefix = "[";
    private static final String kCORBAPrefix = "CORBA/";
    private static final String kArrayPrefix = "RMI:[CORBA/";
    private static final String kCustomRMIPrefix = "RMI:org.omg.customRMI.";
    private static final int kValuePrefixLength;
    private static final int kIDLPrefixLength;
    private static final int kSequencePrefixLength;
    private static final String kInterfaceHashCode = ":0000000000000000";
    private static final String kInterfaceOnlyHashStr = "0000000000000000";
    private static final String kExternalizableHashStr = "0000000000000001";
    public static final int kInitialValueTag = 0x7FFFFF00;
    public static final int kNoTypeInfo = 0;
    public static final int kSingleRepTypeInfo = 2;
    public static final int kPartialListTypeInfo = 6;
    public static final int kChunkedMask = 8;
    public static final int kPreComputed_StandardRMIUnchunked;
    public static final int kPreComputed_CodeBaseRMIUnchunked;
    public static final int kPreComputed_StandardRMIChunked;
    public static final int kPreComputed_CodeBaseRMIChunked;
    public static final int kPreComputed_StandardRMIUnchunked_NoRep;
    public static final int kPreComputed_CodeBaseRMIUnchunked_NoRep;
    public static final int kPreComputed_StandardRMIChunked_NoRep;
    public static final int kPreComputed_CodeBaseRMIChunked_NoRep;
    public static final String kWStringValueVersion = "1.0";
    public static final String kWStringValueHash = ":1.0";
    public static final String kWStringStubValue = "WStringValue";
    public static final String kWStringTypeStr = "omg.org/CORBA/WStringValue";
    public static final String kWStringValueRepID = "IDL:omg.org/CORBA/WStringValue:1.0";
    public static final String kAnyRepID = "IDL:omg.org/CORBA/Any";
    public static final String kClassDescValueHash;
    public static final String kClassDescStubValue = "ClassDesc";
    public static final String kClassDescTypeStr = "javax.rmi.CORBA.ClassDesc";
    public static final String kClassDescValueRepID;
    public static final String kObjectValueHash = ":1.0";
    public static final String kObjectStubValue = "Object";
    public static final String kSequenceValueHash = ":1.0";
    public static final String kPrimitiveSequenceValueHash = ":0000000000000000";
    public static final String kSerializableValueHash = ":1.0";
    public static final String kSerializableStubValue = "Serializable";
    public static final String kExternalizableValueHash = ":1.0";
    public static final String kExternalizableStubValue = "Externalizable";
    public static final String kRemoteValueHash = "";
    public static final String kRemoteStubValue = "";
    public static final String kRemoteTypeStr = "";
    public static final String kRemoteValueRepID = "";
    public static final Hashtable kSpecialCasesClasses;
    private static final byte[] ASCII_HEX;
    private static final ConcurrentCache CACHE;
    public static final String kjava_rmi_Remote;
    public static final String korg_omg_CORBA_Object;
    private static final Class[] kNoParamTypes;
    private static final java.lang.Object[] kNoArgs;
    private static final boolean preJDK50;
    private static final HashMap primeClasses;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RepositoryId get(String string) {
        java.lang.Object object = CACHE.get(string);
        if (object instanceof Cache.FutureEntry) {
            Cache.FutureEntry futureEntry;
            Cache.FutureEntry futureEntry2 = futureEntry = (Cache.FutureEntry)object;
            synchronized (futureEntry2) {
                object = futureEntry.get();
                if (object == null) {
                    object = futureEntry.get(new RepositoryId(string));
                }
            }
        }
        return (RepositoryId)object;
    }

    RepositoryId() {
    }

    RepositoryId(String string) {
        this.init(string);
    }

    private void init(String string) {
        if (string.endsWith("PROXY$CLASS")) {
            string = string.replace("PROXY$CLASS", "");
            this.isProxy = true;
        }
        this.repId = string;
        if (Trc.enabled(2)) {
            Trc.info(Trc.FINEST, Trc.str(string), CLASS, "init:463");
        }
        if (string.length() == 0) {
            this.clazz = Remote.class;
            this.typeString = "";
            this.isRMIValueType = true;
            this.suid = kInterfaceOnlyHashStr;
        } else if (string.equals(kWStringValueRepID)) {
            this.clazz = String.class;
            this.typeString = kWStringTypeStr;
            this.isIDLType = true;
            this.completeClassName = "java.lang.String";
            this.versionString = ":1.0";
        } else {
            String string2 = RepositoryId.convertFromISOLatin1(string);
            this.versionString = string2.substring(string2.indexOf(58, string2.indexOf(58) + 1));
            if (string2.startsWith(kIDLPrefix)) {
                this.typeString = string2.substring(kIDLPrefixLength, string2.indexOf(58, kIDLPrefixLength));
                this.isIDLType = true;
                this.completeClassName = this.typeString.startsWith(kIDLNamePrefix) ? kIDLClassnamePrefix + this.typeString.substring(kIDLNamePrefix.length()).replace('/', '.') : this.typeString.replace('/', '.');
                this.clazz = (Class)kSpecialCasesClasses.get(this.completeClassName);
            } else if (string2.startsWith(kValuePrefix)) {
                this.typeString = string2.substring(kValuePrefixLength, string2.indexOf(58, kValuePrefixLength));
                if (this.typeString.startsWith("$Proxy")) {
                    this.isProxy = true;
                }
                this.isRMIValueType = true;
                this.clazz = (Class)kSpecialCasesClasses.get(this.typeString);
                if (this.versionString.indexOf(46) == -1) {
                    this.suid = this.rmiHashCode = this.versionString.substring(1);
                    if (this.rmiHashCode.indexOf(58) != -1) {
                        int n = this.rmiHashCode.indexOf(58) + 1;
                        this.suid = this.rmiHashCode.substring(n);
                        this.rmiHashCode = this.rmiHashCode.substring(0, n - 1);
                    }
                    if (this.suid.length() < 16 && Trc.enabled(2)) {
                        Trc.info(Trc.FINEST, "Non-compliant RepId, SUID is not 16 digits", " long, hence padding it with 0", CLASS, "init:524");
                    }
                    while (this.suid.length() < 16) {
                        this.suid = "0" + this.suid;
                    }
                }
            } else {
                this.isSupportedFormat = false;
            }
            if (this.typeString.startsWith(kSequencePrefix)) {
                this.isSequence = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getUnqualifiedName() {
        if (this.unqualifiedName == null) {
            String string;
            String string2;
            String string3 = this.getClassName();
            int n = string3.lastIndexOf(46);
            if (n == -1) {
                string2 = "IDL::1.0";
                string = string3;
            } else {
                string2 = kIDLPrefix + string3.substring(0, n).replace('.', '/') + ":1.0";
                string = string3.substring(n);
            }
            WriteLock writeLock = this.writeLock;
            synchronized (writeLock) {
                if (this.unqualifiedName == null) {
                    this.definedInId = string2;
                    this.unqualifiedName = string;
                }
            }
        }
        return this.unqualifiedName;
    }

    public final String getDefinedInId() {
        if (this.definedInId == null) {
            this.getUnqualifiedName();
        }
        return this.definedInId;
    }

    public final String getTypeString() {
        return this.typeString;
    }

    public final String getVersionString() {
        return this.versionString;
    }

    public final String getSerialVersionUID() {
        return this.suid;
    }

    public final boolean isRMIValueType() {
        return this.isRMIValueType;
    }

    public final boolean isIDLType() {
        return this.isIDLType;
    }

    public final boolean isProxy() {
        return this.isProxy;
    }

    public final String getRepositoryId() {
        return this.repId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getByteArray(String string) {
        IdentityHashtable identityHashtable = repStrToByteArray;
        synchronized (identityHashtable) {
            return (byte[])repStrToByteArray.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setByteArray(String string, byte[] byArray) {
        IdentityHashtable identityHashtable = repStrToByteArray;
        synchronized (identityHashtable) {
            repStrToByteArray.put(string, byArray);
        }
    }

    public final boolean isSequence() {
        return this.isSequence;
    }

    public final boolean isSupportedFormat() {
        return this.isSupportedFormat;
    }

    public final String getClassName() {
        if (this.isRMIValueType) {
            return this.typeString;
        }
        if (this.isIDLType) {
            return this.completeClassName;
        }
        return null;
    }

    public final Class getClassFromRepId(short s, short s2) throws ClassNotFoundException {
        if (this.clazz != null) {
            return this.clazz;
        }
        java.lang.Object object = REP_STR_TO_CLASS_CACHE.get(this.repId);
        if (object != null && object instanceof Class) {
            return (Class)object;
        }
        Class clazz = this.getClassFromType();
        if (Trc.enabled(2)) {
            Trc.info(Trc.FINEST, clazz, "RepositoryID", "getClassFromRepID:669");
        }
        String string = RepositoryId.createForJavaType(clazz, false, s, s2);
        if (Trc.enabled(2)) {
            Trc.info(Trc.FINEST, clazz, string, "RepositoryID", "getClassFromRepID:678");
        }
        if (!this.repId.equals(string)) {
            throw new ClassNotFoundException("Unknown repId " + this.repId);
        }
        return clazz;
    }

    public final Class getClassFromType() throws ClassNotFoundException {
        if (this.clazz != null) {
            return this.clazz;
        }
        return this.checkClassCache(defaultServerURL, null);
    }

    public final Class getClassFromType(Class clazz, String string, ClassLoader classLoader) throws ClassNotFoundException {
        PartnerVersion partnerVersion = PartnerVersion.UNKNOWN;
        return this.getClassFromType(clazz, string, classLoader, partnerVersion.getPartnerMajor(), partnerVersion.getPartnerMinor());
    }

    public final Class getClassFromType(Class clazz, String string, ClassLoader classLoader, short s, short s2) throws ClassNotFoundException {
        if (this.clazz != null && (clazz == null || clazz.isAssignableFrom(this.clazz))) {
            return this.clazz;
        }
        Class clazz2 = this.checkClassCache(string, classLoader);
        if (clazz != null && clazz2 != null && !clazz.isAssignableFrom(clazz2)) {
            ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(clazz2, s, s2);
            if (Trc.enabled()) {
                Trc.warn(clazz2.getName() + " hasReadResolve=" + objectStreamClass.hasReadResolve() + ",  CL:" + clazz2.getClassLoader() + " and is not assignable to:" + clazz.getName() + ",  CL:" + clazz.getClassLoader(), CLASS, "getClassFromType:723");
            }
            if (!objectStreamClass.hasReadResolve()) {
                throw new ClassNotFoundException(clazz2.getName() + " has no readResolve and is not assignable to:" + clazz.getName());
            }
        }
        return clazz2;
    }

    public final Class getClassFromType(String string, ClassLoader classLoader) throws ClassNotFoundException {
        return this.checkClassCache(string, classLoader);
    }

    private Class checkClassCache(String string, ClassLoader classLoader) throws ClassNotFoundException {
        String string2 = this.getClassName();
        Class clazz = (Class)primeClasses.get(string2);
        if (clazz == null) {
            clazz = this.loadClass(string, classLoader);
        }
        return clazz;
    }

    private Class loadClass(final String string, final ClassLoader classLoader) throws ClassNotFoundException {
        Class clazz = null;
        final String string2 = this.getClassName();
        clazz = preJDK50 ? (Class)AccessController.doPrivileged(new PrivilegedAction(){

            public java.lang.Object run() {
                return Utility.loadClassOfType(string2, string, null, null, classLoader);
            }
        }) : Utility.loadClassOfType(string2, string, null, null, classLoader);
        if (null == clazz) {
            ClassNotFoundException classNotFoundException = new ClassNotFoundException(string2);
            throw classNotFoundException;
        }
        return clazz;
    }

    public final String toString() {
        return this.repId;
    }

    public static boolean useFullValueDescription(Class clazz, String string, boolean bl, short s, short s2) throws IOException {
        String string2 = RepositoryId.createForAnyType(clazz, bl, s, s2);
        if (string2.equals(string)) {
            return false;
        }
        RepositoryId repositoryId = RepositoryId.get(string);
        RepositoryId repositoryId2 = bl ? new RepositoryId(string2) : RepositoryId.get(string2);
        if (repositoryId.isRMIValueType() && repositoryId2.isRMIValueType()) {
            if (!repositoryId.getSerialVersionUID().equals(repositoryId2.getSerialVersionUID())) {
                if (repositoryId2.isProxy() || repositoryId.isProxy()) {
                    return false;
                }
                throw new IOException("Mismatched serialization UIDs : Source (RepId " + repositoryId2 + ") = " + repositoryId2.getSerialVersionUID() + " whereas Target (RepId " + string + ") = " + repositoryId.getSerialVersionUID());
            }
            return true;
        }
        throw new IOException("The RepId is not of an RMI value type (Expected RepId = " + string2 + "; Received RepId = " + string + ")");
    }

    private static String createHashString(Class clazz, boolean bl) {
        PartnerVersion partnerVersion = PartnerVersion.UNKNOWN;
        return RepositoryId.createHashString(clazz, bl, partnerVersion.getPartnerMajor(), partnerVersion.getPartnerMinor());
    }

    private static String createHashString(Class clazz, boolean bl, short s, short s2) {
        if (clazz.isInterface() || !Serializable.class.isAssignableFrom(clazz)) {
            return ":0000000000000000";
        }
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(clazz, s, s2);
        long l = objectStreamClass.getRMIHashCode(bl);
        String string = null;
        string = l == 0L ? kInterfaceOnlyHashStr : (l == 1L ? kExternalizableHashStr : Long.toHexString(l).toUpperCase());
        while (string.length() < 16) {
            string = "0" + string;
        }
        long l2 = objectStreamClass.getSerialVersionUID(bl);
        String string2 = null;
        string2 = l2 == 0L ? kInterfaceOnlyHashStr : (l2 == 1L ? kExternalizableHashStr : Long.toHexString(l2).toUpperCase());
        while (string2.length() < 16) {
            string2 = "0" + string2;
        }
        return ":" + string + ":" + string2;
    }

    public static String createSequenceRepID(java.lang.Object object) {
        return RepositoryId.createSequenceRepID(object.getClass(), false);
    }

    public static String createSequenceRepID(java.lang.Object object, boolean bl) {
        return RepositoryId.createSequenceRepID(object.getClass(), bl);
    }

    public static String createSequenceRepID(Class clazz) {
        return RepositoryId.createSequenceRepID(clazz, false);
    }

    public static String createSequenceRepID(Class clazz, boolean bl) {
        PartnerVersion partnerVersion = PartnerVersion.UNKNOWN;
        return RepositoryId.createSequenceRepID(clazz, bl, partnerVersion.getPartnerMajor(), partnerVersion.getPartnerMinor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createSequenceRepID(Class clazz, boolean bl, short s, short s2) {
        ClassToRepositoryStringCaches classToRepositoryStringCaches = ClassToRepositoryStringCaches.getCaches(clazz, s, s2);
        ConcurrentCache concurrentCache = classToRepositoryStringCaches.SEQUENCE;
        java.lang.Object object = concurrentCache.get(clazz);
        if (object instanceof Cache.FutureEntry) {
            Cache.FutureEntry futureEntry;
            Cache.FutureEntry futureEntry2 = futureEntry = (Cache.FutureEntry)object;
            synchronized (futureEntry2) {
                object = futureEntry.get();
                if (null == object) {
                    Class<?> clazz2 = clazz;
                    int n = 0;
                    java.lang.Object object2 = clazz.getComponentType();
                    while (null != object2) {
                        ++n;
                        clazz = object2;
                        object2 = clazz.getComponentType();
                    }
                    object2 = null;
                    if (clazz.isPrimitive()) {
                        object2 = kValuePrefix + clazz2.getName() + ":0000000000000000";
                    } else {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append(kValuePrefix);
                        while (n-- > 0) {
                            stringBuilder.append(kSequencePrefix);
                        }
                        stringBuilder.append("L");
                        stringBuilder.append(RepositoryId.convertToISOLatin1(clazz.getName()));
                        stringBuilder.append(";");
                        stringBuilder.append(RepositoryId.createHashString(clazz, bl, s, s2));
                        object2 = stringBuilder.toString();
                    }
                    object = futureEntry.get(object2);
                }
            }
        }
        return (String)object;
    }

    public static String createForSpecialCase(Class clazz) {
        if (clazz.equals(String.class)) {
            return kWStringValueRepID;
        }
        if (clazz.equals(Class.class)) {
            return kClassDescValueRepID;
        }
        if (clazz.equals(Remote.class)) {
            return "";
        }
        if (clazz.isArray()) {
            return RepositoryId.createSequenceRepID(clazz);
        }
        return null;
    }

    public static String createForSpecialCase(Serializable serializable) {
        return RepositoryId.createForSpecialCase(serializable.getClass());
    }

    public static String createForJavaType(Serializable serializable) {
        return RepositoryId.createForJavaType(serializable, false);
    }

    public static String createForJavaType(Serializable serializable, boolean bl) {
        return RepositoryId.createForJavaType(serializable.getClass(), bl);
    }

    public static String createForJavaType(Class clazz) {
        return RepositoryId.createForJavaType(clazz, false);
    }

    public static String createForJavaType(Class clazz, boolean bl) {
        PartnerVersion partnerVersion = PartnerVersion.UNKNOWN;
        return RepositoryId.createForJavaType(clazz, bl, partnerVersion.getPartnerMajor(), partnerVersion.getPartnerMinor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createForJavaType(Class object, boolean bl, short s, short s2) {
        java.lang.Object object2;
        java.lang.Object object3;
        java.lang.Object object4;
        if (Enum.class.isAssignableFrom((Class<?>)object)) {
            object4 = ((Class)object).getSuperclass();
            object3 = ((Class)object4).getName() + "$";
            if (((Class)object).getName().indexOf((String)object3) == 0) {
                object = object4;
            }
        }
        object4 = ClassToRepositoryStringCaches.getCaches((Class)object, s, s2);
        object3 = bl ? ((ClassToRepositoryStringCaches)object4).OLD : ((ClassToRepositoryStringCaches)object4).CLASS;
        java.lang.Object object5 = object3.get(object);
        if (object5.getClass() != RepIdForClass.class) {
            object2 = (Cache.FutureEntry)object5;
            Cache.FutureEntry futureEntry = object2;
            synchronized (futureEntry) {
                object5 = object2.get();
                if (null == object5) {
                    java.lang.Object object6;
                    String string = RepositoryId.createForSpecialCase((Class)object);
                    if (null == string) {
                        object6 = ((Class)object).getName();
                        string = kValuePrefix + RepositoryId.convertToISOLatin1((String)object6) + RepositoryId.createHashString((Class)object, bl, s, s2);
                    }
                    object5 = new RepIdForClass(string, Proxy.isProxyClass(object));
                    object2.get(object5);
                    object6 = REP_STR_TO_CLASS_CACHE.get(((RepIdForClass)object5).repId);
                    if (object6 instanceof Cache.FutureEntry) {
                        ((Cache.FutureEntry)object6).get(object);
                    }
                }
            }
        }
        object2 = ((RepIdForClass)object5).repId;
        if (PartnerVersionUtil.isCompliantWithProxyFix(s, s2) && ((RepIdForClass)object5).isProxy) {
            object2 = (String)object2 + "PROXY$CLASS";
        }
        return object2;
    }

    public static String createForCustomJavaType(Class clazz) {
        PartnerVersion partnerVersion = PartnerVersion.UNKNOWN;
        return RepositoryId.createForCustomJavaType(clazz, partnerVersion.getPartnerMajor(), partnerVersion.getPartnerMinor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createForCustomJavaType(Class clazz, short s, short s2) {
        ClassToRepositoryStringCaches classToRepositoryStringCaches = ClassToRepositoryStringCaches.getCaches(clazz, s, s2);
        ConcurrentCache concurrentCache = classToRepositoryStringCaches.CUSTOM;
        java.lang.Object object = concurrentCache.get(clazz);
        if (object instanceof Cache.FutureEntry) {
            Cache.FutureEntry futureEntry;
            Cache.FutureEntry futureEntry2 = futureEntry = (Cache.FutureEntry)object;
            synchronized (futureEntry2) {
                object = futureEntry.get();
                if (null == object) {
                    String string = RepositoryId.createForJavaType(clazz, false, s, s2);
                    String string2 = kCustomRMIPrefix + string.substring(4);
                    object = futureEntry.get(string2);
                }
            }
        }
        return (String)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createForIDLType(Class clazz, int n, int n2) {
        java.lang.Object object = CLASS_IDL_TO_REP_STR_CACHE.get(clazz);
        if (object instanceof Cache.FutureEntry) {
            Cache.FutureEntry futureEntry;
            Cache.FutureEntry futureEntry2 = futureEntry = (Cache.FutureEntry)object;
            synchronized (futureEntry2) {
                object = futureEntry.get();
                if (null == object) {
                    String string = kIDLPrefix + RepositoryId.convertToISOLatin1(clazz.getName()).replace('.', '/') + ":" + n + "." + n2;
                    object = futureEntry.get(string);
                }
            }
        }
        return (String)object;
    }

    private static String getIdFromHelper(Class clazz) {
        try {
            final Class clazz2 = Utility.loadClassForClass(clazz.getName() + "Helper", null, clazz.getClassLoader(), clazz, clazz.getClassLoader());
            Method method = (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public java.lang.Object run() throws NoSuchMethodException {
                    return clazz2.getMethod("id", kNoParamTypes);
                }
            });
            return (String)method.invoke(null, kNoArgs);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (Trc.enabled()) {
                Trc.warn(clazz.getName() + "Helper:" + classNotFoundException.toString(), CLASS, "getIdFromHelper:1147");
            }
            return null;
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            Trc.ffdc(exception, CLASS, "getIdFromHelper:1154");
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            if (throwable instanceof Exception) {
                Trc.ffdc((Exception)throwable, CLASS, "getIdFromHelper:1161");
            } else if (Trc.enabled()) {
                Trc.warn(clazz.getName() + "Helper.id:", throwable, CLASS, "getIdFromHelper:1164");
            }
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            Trc.ffdc(illegalAccessException, CLASS, "getIdFromHelper:1168");
            return null;
        }
    }

    public static String createForAnyType(Class clazz) {
        return RepositoryId.createForAnyType(clazz, false);
    }

    public static String createForAnyType(Class clazz, boolean bl) {
        PartnerVersion partnerVersion = PartnerVersion.UNKNOWN;
        return RepositoryId.createForAnyType(clazz, bl, partnerVersion.getPartnerMajor(), partnerVersion.getPartnerMinor());
    }

    public static String createForAnyType(Class clazz, boolean bl, short s, short s2) {
        if (clazz == null) {
            throw new MARSHAL("Unidentified type information in the stream . Possible incompatibility between sender and receiver");
        }
        if (clazz.isArray()) {
            return RepositoryId.createSequenceRepID(clazz, bl, s, s2);
        }
        if (IDLEntity.class.isAssignableFrom(clazz)) {
            block8: {
                try {
                    String string = RepositoryId.getIdFromHelper(clazz);
                    if (string != null) {
                        return string;
                    }
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Exception exception) {
                    Trc.ffdc(exception, CLASS, "createForAnyType:1212");
                }
                catch (Error error) {
                    if (!Trc.enabled()) break block8;
                    Trc.warn(clazz.getName(), error, CLASS, "createForAnyType:1215");
                }
            }
            return RepositoryId.createForIDLType(clazz, 1, 0);
        }
        return RepositoryId.createForJavaType(clazz, bl, s, s2);
    }

    public static boolean isAbstractBase(Class clazz) {
        return clazz.isInterface() && IDLEntity.class.isAssignableFrom(clazz) && !ValueBase.class.isAssignableFrom(clazz) && !Object.class.isAssignableFrom(clazz);
    }

    public static boolean isAnyRequired(Class clazz) {
        return clazz == java.lang.Object.class || clazz == Serializable.class || clazz == Externalizable.class;
    }

    public static long fromHex(String string) {
        if (string.startsWith("0x")) {
            return Long.valueOf(string.substring(2), 16);
        }
        return Long.valueOf(string, 16);
    }

    public static String escape(String string) {
        if (string.startsWith(kValuePrefix)) {
            int n = string.indexOf(58, 4);
            String string2 = string.substring(4, n);
            String string3 = string.substring(n);
            string2 = RepositoryId.convertToISOLatin1(string2);
            return kValuePrefix + string2 + string3;
        }
        return string;
    }

    public static String unescape(String string) {
        Matcher matcher = UNICODE_ESCAPES_WITHOUT_DOLLAR.matcher(string);
        StringWriter stringWriter = new StringWriter();
        String string2 = "";
        int n = 0;
        while (matcher.find()) {
            stringWriter.write(string, n, matcher.start() - n);
            string2 = matcher.group(1);
            String string3 = string2.substring(2);
            char c = (char)Integer.parseInt(string3, 16);
            stringWriter.append(c);
            n = matcher.end();
        }
        if (n < string.length()) {
            stringWriter.write(string, n, string.length() - n);
        }
        return stringWriter.toString();
    }

    private static String convertToISOLatin1(String string) {
        int n = string.length();
        if (n == 0) {
            return string;
        }
        StringBuilder stringBuilder = null;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c > '\u007f' || !IS_VALID_IDL_IDENTIFIER_CHAR[c]) {
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(string.substring(0, i));
                }
                stringBuilder.append("\\U" + (char)ASCII_HEX[(c & 0xF000) >>> 12] + (char)ASCII_HEX[(c & 0xF00) >>> 8] + (char)ASCII_HEX[(c & 0xF0) >>> 4] + (char)ASCII_HEX[c & 0xF]);
                continue;
            }
            if (stringBuilder == null) continue;
            stringBuilder.append(c);
        }
        if (stringBuilder != null) {
            string = stringBuilder.toString();
        }
        return string;
    }

    private static String convertFromISOLatin1(String string) {
        int n = -1;
        StringBuilder stringBuilder = new StringBuilder(string);
        while ((n = stringBuilder.toString().indexOf("\\U")) != -1) {
            int n2;
            String string2 = "0000" + stringBuilder.toString().substring(n + 2, n + 6);
            byte[] byArray = new byte[(string2.length() - 4) / 2];
            int n3 = 0;
            for (n2 = 4; n2 < string2.length(); n2 += 2) {
                byArray[n3] = (byte)(RepositoryId.hexOf(string2.charAt(n2)) << 4 & 0xF0);
                int n4 = n3++;
                byArray[n4] = (byte)(byArray[n4] | (byte)(RepositoryId.hexOf(string2.charAt(n2 + 1)) << 0 & 0xF));
            }
            stringBuilder = new StringBuilder(RepositoryId.delete(stringBuilder.toString(), n, n + 6));
            n2 = (char)(byArray[0] << 8 | byArray[1] & 0xFF);
            stringBuilder.insert(n, (char)n2);
        }
        return stringBuilder.toString();
    }

    private static int hexOf(char c) {
        int n = charConversion[c];
        if (n < 0) {
            throw new Error("Bad hex digit: 0x" + Integer.toHexString(c));
        }
        return n;
    }

    private static String delete(String string, int n, int n2) {
        return string.substring(0, n) + string.substring(n2, string.length());
    }

    public static int computeValueTag(boolean bl, int n, boolean bl2) {
        int n2 = 0x7FFFFF00;
        if (bl) {
            n2 |= 1;
        }
        n2 |= n;
        if (bl2) {
            n2 |= 8;
        }
        return n2;
    }

    public static boolean isCodeBasePresent(int n) {
        return (n & 1) == 1;
    }

    public static int getTypeInfo(int n) {
        return n & 6;
    }

    public static boolean isChunkedEncoding(int n) {
        return (n & 8) != 0;
    }

    public static String getServerURL() {
        return defaultServerURL;
    }

    static void clearCaches() {
        Trc.ffdc("This should only be called from ORB implementation white box tests.", CLASS, "clearCaches:1409");
        CLASS_IDL_TO_REP_STR_CACHE.clear();
        ClassToRepositoryStringCaches.clear();
        REP_STR_TO_CLASS_CACHE.clear();
        repStrToByteArray.clear();
    }

    public static String getKValuePrefix() {
        return kValuePrefix;
    }

    static {
        char[] cArray = IDL_IDENTIFIER_CHARS.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            RepositoryId.IS_VALID_IDL_IDENTIFIER_CHAR[cArray[i]] = true;
        }
        UNICODE_ESCAPES_WITHOUT_DOLLAR = Pattern.compile("(\\\\U[0-9A-Fa-f]{4}(?<!\\\\U0024))");
        CLASS_IDL_TO_REP_STR_CACHE = CacheFactories.CONCURRENT_PLAIN.create(MapFactories.CONCURRENT_WEAK);
        repStrToByteArray = new IdentityHashtable();
        REP_STR_TO_CLASS_CACHE = CacheFactories.SOFT.create(MapFactories.WEAK);
        kValuePrefixLength = kValuePrefix.length();
        kIDLPrefixLength = kIDLPrefix.length();
        kSequencePrefixLength = kSequencePrefix.length();
        kPreComputed_StandardRMIUnchunked = RepositoryId.computeValueTag(false, 2, false);
        kPreComputed_CodeBaseRMIUnchunked = RepositoryId.computeValueTag(true, 2, false);
        kPreComputed_StandardRMIChunked = RepositoryId.computeValueTag(false, 2, true);
        kPreComputed_CodeBaseRMIChunked = RepositoryId.computeValueTag(true, 2, true);
        kPreComputed_StandardRMIUnchunked_NoRep = RepositoryId.computeValueTag(false, 0, false);
        kPreComputed_CodeBaseRMIUnchunked_NoRep = RepositoryId.computeValueTag(true, 0, false);
        kPreComputed_StandardRMIChunked_NoRep = RepositoryId.computeValueTag(false, 0, true);
        kPreComputed_CodeBaseRMIChunked_NoRep = RepositoryId.computeValueTag(true, 0, true);
        kClassDescValueHash = RepositoryId.createHashString(ClassDesc.class, false);
        kClassDescValueRepID = "RMI:javax.rmi.CORBA.ClassDesc" + kClassDescValueHash;
        kSpecialCasesClasses = new Hashtable();
        ASCII_HEX = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
        CACHE = CacheFactories.CONCURRENT_PLAIN.create(MapFactories.CONCURRENT_HASH);
        kNoParamTypes = new Class[0];
        kNoArgs = new java.lang.Object[0];
        preJDK50 = Version.sdkVersionLowerThan(1, 5, 0);
        primeClasses = new HashMap(9, 1.0f);
        defaultServerURL = JDKBridge.getLocalCodebase();
        kSpecialCasesClasses.put(kWStringTypeStr, String.class);
        kSpecialCasesClasses.put(kClassDescTypeStr, Class.class);
        kSpecialCasesClasses.put("", Remote.class);
        kSpecialCasesClasses.put("java.lang.String", String.class);
        primeClasses.put("boolean", Boolean.TYPE);
        primeClasses.put("byte", Byte.TYPE);
        primeClasses.put("char", Character.TYPE);
        primeClasses.put("short", Short.TYPE);
        primeClasses.put("int", Integer.TYPE);
        primeClasses.put("float", Float.TYPE);
        primeClasses.put("long", Long.TYPE);
        primeClasses.put("double", Double.TYPE);
        primeClasses.put("void", Void.TYPE);
        kjava_rmi_Remote = RepositoryId.createForAnyType(Remote.class);
        korg_omg_CORBA_Object = RepositoryId.createForAnyType(Object.class);
    }

    private static class RepIdForClass {
        String repId;
        boolean isProxy;

        public RepIdForClass(String string, boolean bl) {
            this.repId = string;
            this.isProxy = bl;
        }
    }

    private static class WriteLock {
        private WriteLock() {
        }
    }

    private static final class ClassToRepositoryStringCaches {
        static final ClassToRepositoryStringCaches COMPLIANT = new ClassToRepositoryStringCaches();
        static final ClassToRepositoryStringCaches NONCOMPLIANT = new ClassToRepositoryStringCaches();
        final ConcurrentCache CLASS = CacheFactories.CONCURRENT_PLAIN.create(MapFactories.CONCURRENT_WEAK);
        final ConcurrentCache OLD = CacheFactories.CONCURRENT_PLAIN.create(MapFactories.CONCURRENT_WEAK);
        final ConcurrentCache SEQUENCE = CacheFactories.CONCURRENT_PLAIN.create(MapFactories.CONCURRENT_WEAK);
        final ConcurrentCache CUSTOM = CacheFactories.CONCURRENT_PLAIN.create(MapFactories.CONCURRENT_WEAK);

        private ClassToRepositoryStringCaches() {
        }

        static ClassToRepositoryStringCaches getCaches(Class clazz, short s, short s2) {
            ClassToRepositoryStringCaches classToRepositoryStringCaches = NONCOMPLIANT;
            if (PartnerVersionUtil.isCompliantWithIssue10336(s, s2) && Enum.class.isAssignableFrom(clazz)) {
                classToRepositoryStringCaches = COMPLIANT;
            }
            return classToRepositoryStringCaches;
        }

        private void clearCaches() {
            this.CLASS.clear();
            this.OLD.clear();
            this.SEQUENCE.clear();
            this.CUSTOM.clear();
        }

        static void clear() {
            COMPLIANT.clearCaches();
            NONCOMPLIANT.clearCaches();
        }
    }
}

