/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.virtualization.management;

import com.ibm.lang.management.ManagementUtils;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.InvalidKeyException;

public class GuestOSMemoryUsage {
    private long memUsed;
    private long timestamp;
    private long maxMemLimit;
    private String TOSTRING_VALUE = null;

    public GuestOSMemoryUsage() {
    }

    private GuestOSMemoryUsage(long memUsed, long timestamp, long maxMemLimit) throws IllegalArgumentException {
        if (memUsed < 0L && memUsed != -1L || maxMemLimit < 0L && maxMemLimit != -1L || memUsed >= 0L && maxMemLimit >= 0L && memUsed > maxMemLimit || timestamp < 0L) {
            throw new IllegalArgumentException();
        }
        this.memUsed = memUsed;
        this.timestamp = timestamp;
        this.maxMemLimit = maxMemLimit;
    }

    public long getMemUsed() {
        return this.memUsed;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getMaxMemLimit() {
        return this.maxMemLimit;
    }

    void updateValues(long used, long timestamp, long limit) {
        this.memUsed = used;
        this.timestamp = timestamp;
        this.maxMemLimit = limit;
    }

    public static GuestOSMemoryUsage from(CompositeData cd) {
        GuestOSMemoryUsage result = null;
        if (null != cd) {
            long maxMemLimit;
            long timestamp;
            long memUsed;
            if (!ManagementUtils.getGuestOSMemoryUsageCompositeType().isValue(cd)) {
                throw new IllegalArgumentException("CompositeData is not of the expected type.");
            }
            try {
                memUsed = (Long)cd.get("memUsed");
                timestamp = (Long)cd.get("timestamp");
                maxMemLimit = (Long)cd.get("maxMemLimit");
            }
            catch (InvalidKeyException e) {
                throw new IllegalArgumentException("CompositeData object does not contain expected key.");
            }
            result = new GuestOSMemoryUsage(memUsed, timestamp, maxMemLimit);
        }
        return result;
    }

    public String toString() {
        if (null == this.TOSTRING_VALUE) {
            StringBuilder sb = new StringBuilder();
            sb.append("memUsed = ");
            sb.append(this.memUsed);
            sb.append("timestamp = ");
            sb.append(this.timestamp);
            sb.append("maxMemLimit = ");
            sb.append(this.maxMemLimit);
        }
        return this.TOSTRING_VALUE;
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (!(obj instanceof GuestOSMemoryUsage)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        GuestOSMemoryUsage gmu = (GuestOSMemoryUsage)obj;
        if (gmu.getMemUsed() != this.getMemUsed()) {
            return false;
        }
        if (gmu.getTimestamp() != this.getTimestamp()) {
            return false;
        }
        return gmu.getMaxMemLimit() == this.getMaxMemLimit();
    }

    public int hashCode() {
        return new String(Long.toString(this.getMemUsed()) + Long.toString(this.getTimestamp()) + Long.toString(this.getMaxMemLimit())).hashCode();
    }
}

