/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.Comparator;
import java.lang.invoke.FoldNonvoidHandle;
import java.lang.invoke.FoldVoidHandle;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.PassThroughHandle;
import java.lang.invoke.ThunkKey;
import java.lang.invoke.ThunkKeyWithObject;
import java.lang.invoke.ThunkTuple;

abstract class FoldHandle
extends PassThroughHandle {
    protected final MethodHandle next;
    protected final MethodHandle combiner;

    protected FoldHandle(MethodHandle next, MethodHandle combiner, MethodHandle equivalent, String name) {
        super(equivalent, name, combiner.type());
        this.next = next;
        this.combiner = combiner;
    }

    FoldHandle(FoldHandle originalHandle, MethodType newType) {
        super(originalHandle, newType);
        this.next = originalHandle.next;
        this.combiner = originalHandle.combiner;
    }

    public static FoldHandle get(MethodHandle next, MethodHandle combiner, MethodHandle equivalent) {
        if (combiner.type().returnType() == Void.TYPE) {
            return new FoldVoidHandle(next, combiner, equivalent);
        }
        return new FoldNonvoidHandle(next, combiner, equivalent);
    }

    @Override
    protected final ThunkTuple computeThunks(Object combinerType) {
        return this.thunkTable().get(new ThunkKeyWithObject(ThunkKey.computeThunkableType(this.type()), combinerType));
    }

    @Override
    final void compareWith(MethodHandle right, Comparator c) {
        if (right instanceof FoldHandle) {
            ((FoldHandle)right).compareWithFold(this, c);
        } else {
            c.fail();
        }
    }

    final void compareWithFold(FoldHandle left, Comparator c) {
        c.compareChildHandle(left.next, this.next);
        c.compareChildHandle(left.combiner, this.combiner);
    }
}

